/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.model.component;

import afu.net.fortuna.ical4j.model.Component;
import afu.net.fortuna.ical4j.model.ComponentList;
import afu.net.fortuna.ical4j.model.Date;
import afu.net.fortuna.ical4j.model.PropertyList;
import afu.net.fortuna.ical4j.model.ValidationException;
import afu.net.fortuna.ical4j.model.Validator;
import afu.net.fortuna.ical4j.model.component.CalendarComponent;
import afu.net.fortuna.ical4j.model.component.Observance;
import afu.net.fortuna.ical4j.model.property.LastModified;
import afu.net.fortuna.ical4j.model.property.Method;
import afu.net.fortuna.ical4j.model.property.TzId;
import afu.net.fortuna.ical4j.model.property.TzUrl;
import afu.net.fortuna.ical4j.util.PropertyValidator;
import afu.org.apache.commons.lang.ObjectUtils;
import afu.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;

public class VTimeZone
extends CalendarComponent {
    private static final long serialVersionUID = 5629679741050917815L;
    private final Validator itipValidator = new ITIPValidator();
    private ComponentList observances;

    public VTimeZone() {
        super("VTIMEZONE");
        this.observances = new ComponentList();
    }

    public VTimeZone(PropertyList properties) {
        super("VTIMEZONE", properties);
        this.observances = new ComponentList();
    }

    public VTimeZone(ComponentList observances) {
        super("VTIMEZONE");
        this.observances = observances;
    }

    public VTimeZone(PropertyList properties, ComponentList observances) {
        super("VTIMEZONE", properties);
        this.observances = observances;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.observances);
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("TZID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TZURL", this.getProperties());
        if (this.getObservances().getComponent("STANDARD") == null && this.getObservances().getComponent("DAYLIGHT") == null) {
            throw new ValidationException("Sub-components [STANDARD,DAYLIGHT] must be specified at least once");
        }
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).validate(recurse);
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return this.itipValidator;
    }

    public final ComponentList getObservances() {
        return this.observances;
    }

    public final Observance getApplicableObservance(Date date) {
        Observance latestObservance = null;
        Date latestOnset = null;
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            Observance observance = (Observance)i.next();
            Date onset = observance.getLatestOnset(date);
            if (latestOnset != null && (onset == null || !onset.after(latestOnset))) continue;
            latestOnset = onset;
            latestObservance = observance;
        }
        return latestObservance;
    }

    public final TzId getTimeZoneId() {
        return (TzId)this.getProperty("TZID");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final TzUrl getTimeZoneUrl() {
        return (TzUrl)this.getProperty("TZURL");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VTimeZone) {
            return super.equals(arg0) && ObjectUtils.equals(this.observances, ((VTimeZone)arg0).getObservances());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getProperties()).append(this.getObservances()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VTimeZone copy = (VTimeZone)super.copy();
        copy.observances = new ComponentList(this.observances);
        return copy;
    }

    private class ITIPValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ITIPValidator() {
        }

        public void validate() throws ValidationException {
            Iterator i = VTimeZone.this.getObservances().iterator();
            while (i.hasNext()) {
                Observance observance = (Observance)i.next();
                PropertyValidator.getInstance().assertOne("DTSTART", observance.getProperties());
                PropertyValidator.getInstance().assertOne("TZOFFSETFROM", observance.getProperties());
                PropertyValidator.getInstance().assertOne("TZOFFSETTO", observance.getProperties());
                PropertyValidator.getInstance().assertOneOrLess("TZNAME", observance.getProperties());
            }
        }
    }
}

