/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.model.component;

import afu.net.fortuna.ical4j.model.Component;
import afu.net.fortuna.ical4j.model.ComponentList;
import afu.net.fortuna.ical4j.model.PropertyList;
import afu.net.fortuna.ical4j.model.ValidationException;
import afu.net.fortuna.ical4j.model.Validator;
import afu.net.fortuna.ical4j.model.component.Available;
import afu.net.fortuna.ical4j.model.component.CalendarComponent;
import afu.net.fortuna.ical4j.model.parameter.Value;
import afu.net.fortuna.ical4j.model.property.DtEnd;
import afu.net.fortuna.ical4j.model.property.DtStamp;
import afu.net.fortuna.ical4j.model.property.DtStart;
import afu.net.fortuna.ical4j.model.property.Method;
import afu.net.fortuna.ical4j.util.PropertyValidator;
import java.util.Iterator;

public class VAvailability
extends CalendarComponent {
    private static final long serialVersionUID = -3001603309266267258L;
    private ComponentList available;

    public VAvailability() {
        super("VAVAILABILITY");
        this.available = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VAvailability(PropertyList properties) {
        super("VAVAILABILITY", properties);
        this.available = new ComponentList();
    }

    public VAvailability(PropertyList properties, ComponentList available) {
        super("VEVENT", properties);
        this.available = available;
    }

    public final ComponentList getAvailable() {
        return this.available;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.getAvailable());
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAvailable().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component instanceof Available) continue;
            throw new ValidationException("Component [" + component.getName() + "] may not occur in VAVAILABILITY");
        }
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        DtStart start = (DtStart)this.getProperty("DTSTART");
        if (Value.DATE.equals(start.getParameter("VALUE"))) {
            throw new ValidationException("Property [DTSTART] must be a " + Value.DATE_TIME);
        }
        if (this.getProperty("DTEND") != null) {
            PropertyValidator.getInstance().assertOne("DTEND", this.getProperties());
            DtEnd end = (DtEnd)this.getProperty("DTEND");
            if (Value.DATE.equals(end.getParameter("VALUE"))) {
                throw new ValidationException("Property [DTEND] must be a " + Value.DATE_TIME);
            }
            if (this.getProperty("DURATION") != null) {
                throw new ValidationException("Only one of Property [DTEND] or [DURATION must appear a VAVAILABILITY");
            }
        }
        PropertyValidator.getInstance().assertOneOrLess("BUSYTYPE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return null;
    }
}

