/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.line;

import afu.de.regnis.q.sequence.line.QSequenceLine;
import afu.de.regnis.q.sequence.line.QSequenceLineCache;
import afu.de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegments;
import afu.de.regnis.q.sequence.line.QSequenceLineRAData;
import afu.de.regnis.q.sequence.line.QSequenceLineReader;
import afu.de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import java.io.IOException;
import java.io.InputStream;

final class QSequenceLineFileSystemCache
implements QSequenceLineCache {
    private final QSequenceLineRAData data;
    private final QSequenceLineSimplifier simplifier;
    private final QSequenceLineFileSystemCacheSegments segments;
    private int lineCount;

    public static QSequenceLineFileSystemCache create(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize, QSequenceLineSimplifier simplifier) throws IOException {
        QSequenceLineFileSystemCache cache = new QSequenceLineFileSystemCache(data, tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize, simplifier);
        QSequenceLineReader reader = new QSequenceLineReader();
        InputStream stream = data.read(0L, data.length());
        reader.read(stream, cache, simplifier);
        stream.close();
        return cache;
    }

    private QSequenceLineFileSystemCache(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize, QSequenceLineSimplifier simplifier) {
        this.data = data;
        this.simplifier = simplifier;
        this.segments = new QSequenceLineFileSystemCacheSegments(tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize);
    }

    public void close() throws IOException {
        this.segments.close();
    }

    public void addLine(QSequenceLine line) throws IOException {
        if (this.lineCount >= Integer.MAX_VALUE) {
            throw new IOException("Too many lines.");
        }
        this.segments.setFromLengthHash(this.lineCount, line.getFrom(), line.getContentLength(), line.getCompareHash());
        ++this.lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public QSequenceLine getLine(int index) throws IOException {
        long from = this.segments.getFrom(index);
        int length = this.segments.getLength(index);
        byte[] bytes = new byte[length];
        this.data.get(bytes, from, length);
        return new QSequenceLine(from, bytes, this.simplifier);
    }

    public int getLineHash(int index) throws IOException {
        return this.segments.getHash(index);
    }
}

