/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.line;

import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;

public final class QSequenceLine {
    private final long from;
    private final byte[] contentBytes;
    private final byte[] compareBytes;

    public QSequenceLine(long from, byte[] contentBytes, QSequenceLineSimplifier simplifier) {
        this.from = from;
        this.contentBytes = contentBytes;
        this.compareBytes = simplifier.simplify(contentBytes);
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.from + (long)this.contentBytes.length - 1L;
    }

    public int getContentLength() {
        return this.contentBytes.length;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public byte[] getBytes() {
        return this.getContentBytes();
    }

    public int getCompareHash() {
        return new String(this.compareBytes).hashCode();
    }

    public boolean equals(Object obj) {
        byte[] otherBytes = ((QSequenceLine)obj).compareBytes;
        if (this.compareBytes.length != otherBytes.length) {
            return false;
        }
        for (int index = 0; index < this.compareBytes.length; ++index) {
            if (this.compareBytes[index] == otherBytes[index]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int index = 0; index < this.compareBytes.length; ++index) {
            hashCode = 31 * hashCode + this.compareBytes[index];
        }
        return hashCode;
    }

    public String toString() {
        return new String(this.contentBytes);
    }
}

