/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence;

import afu.de.regnis.q.sequence.QSequenceCommonBlockFactory;
import afu.de.regnis.q.sequence.core.QSequenceAssert;
import java.util.ArrayList;
import java.util.List;

public class QSequenceCommonBlocks {
    public static List createBlocks(boolean[] leftCommonPoints, boolean[] rightCommonPoints, QSequenceCommonBlockFactory factory) {
        ArrayList<Object> blocks = new ArrayList<Object>();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftCommonPoints.length || rightIndex < rightCommonPoints.length) {
            Object block;
            int leftStart = leftIndex;
            int rightStart = rightIndex;
            while (leftIndex < leftCommonPoints.length && rightIndex < rightCommonPoints.length && leftCommonPoints[leftIndex] && rightCommonPoints[rightIndex]) {
                ++leftIndex;
                ++rightIndex;
            }
            if (leftIndex > leftStart && rightIndex > rightStart && (block = factory.createCommonBlock(leftStart, leftIndex - 1, rightStart, rightIndex - 1)) != null) {
                blocks.add(block);
            }
            leftStart = leftIndex;
            rightStart = rightIndex;
            while (leftIndex < leftCommonPoints.length && !leftCommonPoints[leftIndex] || rightIndex < rightCommonPoints.length && !rightCommonPoints[rightIndex]) {
                if (leftIndex < leftCommonPoints.length && !leftCommonPoints[leftIndex]) {
                    ++leftIndex;
                }
                if (rightIndex >= rightCommonPoints.length || rightCommonPoints[rightIndex]) continue;
                ++rightIndex;
            }
            if ((leftIndex > leftStart || rightIndex > rightStart) && (block = factory.createDistinctBlock(leftStart, leftIndex - 1, rightStart, rightIndex - 1)) != null) {
                blocks.add(block);
            }
            QSequenceAssert.assertTrue(leftIndex >= leftCommonPoints.length && rightIndex >= rightCommonPoints.length || leftCommonPoints[leftIndex] && rightCommonPoints[rightIndex]);
        }
        return blocks;
    }
}

