/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base.format;

import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.DefaultAnnotatedTypeFormatter;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import org.checkerframework.qualframework.base.format.QualFormatter;
import org.checkerframework.qualframework.base.format.QualifiedTypeFormatter;

public class DefaultQualifiedTypeFormatter<Q, QUAL_FORMATTER extends QualFormatter<Q>>
implements QualifiedTypeFormatter<Q> {
    protected final TypeMirrorConverter<Q> converter;
    protected final QUAL_FORMATTER qualFormatter;
    protected final boolean defaultPrintInvisibleQualifiers;
    protected final AnnotatedTypeFormatter adapter;
    protected final AnnotationFormatter annoAdapter;
    protected final boolean useOldFormat;

    public DefaultQualifiedTypeFormatter(QUAL_FORMATTER qualFormatter, TypeMirrorConverter<Q> converter, boolean useOldFormat, boolean defaultPrintInvisibleQualifiers) {
        this.converter = converter;
        this.useOldFormat = useOldFormat;
        this.defaultPrintInvisibleQualifiers = defaultPrintInvisibleQualifiers;
        this.qualFormatter = qualFormatter;
        this.annoAdapter = this.createAnnotationFormatter();
        this.adapter = this.createAnnotatedTypeFormatter(this.annoAdapter);
    }

    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter(AnnotationFormatter annotationFormatter) {
        return new DefaultAnnotatedTypeFormatter(annotationFormatter, this.useOldFormat, this.defaultPrintInvisibleQualifiers);
    }

    @Override
    public String format(QualifiedTypeMirror<Q> qtm) {
        return this.adapter.format(this.converter.getAnnotatedType(qtm));
    }

    @Override
    public String format(QualifiedTypeMirror<Q> qtm, boolean printInvisibles) {
        return this.adapter.format(this.converter.getAnnotatedType(qtm), printInvisibles);
    }

    public QUAL_FORMATTER getQualFormatter() {
        return this.qualFormatter;
    }

    protected AnnotationFormatter createAnnotationFormatter() {
        return new AnnoToQualFormatter();
    }

    protected class AnnoToQualFormatter
    extends DefaultAnnotationFormatter {
        protected AnnoToQualFormatter() {
        }

        @Override
        @SideEffectFree
        public String formatAnnotationString(Collection<? extends AnnotationMirror> annos, boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            for (AnnotationMirror annotationMirror : annos) {
                if (annotationMirror == null) {
                    ErrorReporter.errorAbort("Found unexpected null AnnotationMirror when formatting annotation mirror: " + annos);
                }
                if (!AnnotationUtils.areSameByClass(annotationMirror, TypeMirrorConverter.Key.class)) {
                    ErrorReporter.errorAbort("Tried to format something other than an @Key annotation: " + annotationMirror);
                    continue;
                }
                Object qual = DefaultQualifiedTypeFormatter.this.converter.getQualifier(annotationMirror);
                String result = DefaultQualifiedTypeFormatter.this.qualFormatter.format(qual, printInvisible);
                if (result == null) continue;
                sb.append(result);
                sb.append(" ");
            }
            return sb.toString();
        }

        @Override
        protected void formatAnnotationMirror(AnnotationMirror am, StringBuilder sb) {
            if (!AnnotationUtils.areSameByClass(am, TypeMirrorConverter.Key.class)) {
                ErrorReporter.errorAbort("Tried to format something other than an @Key annotation: " + am);
            } else {
                Object qual = DefaultQualifiedTypeFormatter.this.converter.getQualifier(am);
                String result = DefaultQualifiedTypeFormatter.this.qualFormatter.format(qual);
                if (result != null) {
                    sb.append(result);
                }
            }
        }
    }
}

