/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.visitor;

import java.util.HashSet;
import java.util.Set;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class VisitHistory {
    private final Set<Visit> visited = new HashSet<Visit>();

    public void add(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        this.visited.add(new Visit(type1, type2));
    }

    public boolean contains(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return this.visited.contains(new Visit(type1, type2));
    }

    public String toString() {
        return "VisitHistory( " + PluginUtil.join(", ", this.visited) + " )";
    }

    private class Visit {
        public final AnnotatedTypeMirror type1;
        public final AnnotatedTypeMirror type2;

        private Visit(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        public int hashCode() {
            return (this.type1 != null ? 31 * this.type1.hashCode() : 0) + (this.type2 != null ? 31 * this.type2.hashCode() : 1);
        }

        public boolean equals(Object oThat) {
            if (oThat == null || !oThat.getClass().equals(this.getClass())) {
                return false;
            }
            Visit that = (Visit)oThat;
            return this.equalityCompare(this.type1, that.type1) && this.equalityCompare(this.type2, that.type2);
        }

        private boolean equalityCompare(AnnotatedTypeMirror thisType, AnnotatedTypeMirror thatType) {
            if (thisType == null) {
                return thatType == null;
            }
            if (thatType == null) {
                return false;
            }
            if (!thisType.getClass().equals(thatType.getClass())) {
                return false;
            }
            if (thisType.getClass().equals(AnnotatedTypeMirror.AnnotatedWildcardType.class)) {
                if (thisType.getUnderlyingType().equals(thatType.getUnderlyingType())) {
                    return true;
                }
                if (!AnnotationUtils.areSame(thisType.getAnnotations(), thatType.getAnnotations())) {
                    return false;
                }
                AnnotatedTypeMirror.AnnotatedWildcardType thisWc = (AnnotatedTypeMirror.AnnotatedWildcardType)thisType;
                AnnotatedTypeMirror.AnnotatedWildcardType thatWc = (AnnotatedTypeMirror.AnnotatedWildcardType)thatType;
                return this.equalityCompare(thisWc.getExtendsBound(), thatWc.getExtendsBound()) && this.equalityCompare(thisWc.getSuperBound(), thatWc.getSuperBound());
            }
            return thisType.equals(thatType);
        }

        public String toString() {
            return "( " + this.type1 + " => " + this.type2 + " )";
        }
    }
}

