/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import org.checkerframework.framework.test.diagnostics.DiagnosticKind;

public class TestDiagnostic {
    private final long lineNumber;
    private final DiagnosticKind kind;
    private final boolean isFixable;
    private final String message;
    private final boolean omitParentheses;

    public TestDiagnostic(long lineNumber, DiagnosticKind kind, String message, boolean isFixable, boolean omitParentheses) {
        this.lineNumber = lineNumber;
        this.kind = kind;
        this.message = message;
        this.isFixable = isFixable;
        this.omitParentheses = omitParentheses;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public DiagnosticKind getKind() {
        return this.kind;
    }

    public boolean isFixable() {
        return this.isFixable;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean shouldOmitParentheses() {
        return this.omitParentheses;
    }

    public String asSourceString() {
        if (this.omitParentheses) {
            return this.kind.parseString + " " + this.message;
        }
        return this.kind.parseString + " (" + this.message + ")";
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null || !otherObj.getClass().equals(TestDiagnostic.class)) {
            return false;
        }
        TestDiagnostic other = (TestDiagnostic)otherObj;
        return other.lineNumber == this.lineNumber && other.kind == this.kind && other.message.equals(this.message);
    }

    public int hashCode() {
        return 331 * (int)this.lineNumber * this.kind.hashCode() * this.message.hashCode();
    }

    public String toString() {
        if (this.omitParentheses) {
            return ":" + this.lineNumber + ": " + this.kind.parseString + ": " + this.message;
        }
        return ":" + this.lineNumber + ": " + this.kind.parseString + ": (" + this.message + ")";
    }
}

