/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.checkerframework.common.subtyping.SubtypingChecker;
import org.checkerframework.framework.util.ExecUtil;
import org.checkerframework.framework.util.PluginUtil;

public class CheckerMain {
    protected final File jdkJar;
    protected final File javacJar;
    protected final File checkersJar;
    private final List<String> compilationBootclasspath;
    private final List<String> runtimeBootClasspath;
    private final List<String> jvmOpts;
    private final List<String> cpOpts;
    private final List<String> toolOpts;
    private final List<File> argListFiles;
    protected static final Pattern BOOT_CLASS_PATH_REGEX = Pattern.compile("^(?:-J){0,1}-Xbootclasspath/p:(.*)$");
    protected static final Pattern JVM_OPTS_REGEX = Pattern.compile("^(?:-J)(.*)$");
    protected static final String CHECKER_BASE_PACKAGE = "org.checkerframework.checker";
    protected static final String CHECKER_BASE_DIR_NAME = "org.checkerframework.checker".replace(".", File.separator);
    protected static final String FULLY_QUALIFIED_SUBTYPING_CHECKER = SubtypingChecker.class.getCanonicalName();
    protected static final String SUBTYPING_CHECKER_NAME = SubtypingChecker.class.getSimpleName();

    public static void main(String[] args) {
        File pathToThisJar = new File(CheckerMain.findPathTo(CheckerMain.class, false));
        CheckerMain program = new CheckerMain(pathToThisJar, args);
        int exitStatus = program.invokeCompiler();
        System.exit(exitStatus);
    }

    public CheckerMain(File checkersJar, String[] args) {
        File searchPath = checkersJar.getParentFile();
        this.checkersJar = checkersJar;
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        this.replaceShorthandProcessor(argsList);
        this.argListFiles = this.collectArgLists(argsList);
        this.javacJar = CheckerMain.extractFileArg("-javacJar", new File(searchPath, "javac.jar"), argsList);
        String jdkJarName = PluginUtil.getJdkJarName();
        this.jdkJar = CheckerMain.extractFileArg("-jdkJar", new File(searchPath, jdkJarName), argsList);
        this.compilationBootclasspath = this.createCompilationBootclasspath(argsList);
        this.runtimeBootClasspath = this.createRuntimeBootclasspath(argsList);
        this.jvmOpts = CheckerMain.extractJvmOpts(argsList);
        this.cpOpts = this.createCpOpts(argsList);
        this.toolOpts = argsList;
        this.assertValidState();
    }

    protected void assertValidState() {
        CheckerMain.assertFilesExist(Arrays.asList(this.javacJar, this.jdkJar, this.checkersJar));
    }

    protected void replaceShorthandProcessor(List<String> args) {
        for (int i = 0; i < args.size(); ++i) {
            int nextIndex = i + 1;
            if (args.size() <= nextIndex || !args.get(i).equals("-processor")) continue;
            String replacement = CheckerMain.asCheckerFrameworkProcessors(args.get(nextIndex), this.getCheckerClassNames(), false);
            args.remove(nextIndex);
            args.add(nextIndex, replacement);
        }
    }

    public void addToClasspath(List<String> cpOpts) {
        this.cpOpts.addAll(cpOpts);
    }

    public void addToRuntimeBootclasspath(List<String> runtimeBootClasspathOpts) {
        this.runtimeBootClasspath.addAll(runtimeBootClasspathOpts);
    }

    protected List<String> createRuntimeBootclasspath(List<String> argsList) {
        return new ArrayList<String>(Arrays.asList(this.javacJar.getAbsolutePath()));
    }

    protected List<String> createCompilationBootclasspath(List<String> argsList) {
        List<String> extractedBcp = CheckerMain.extractBootClassPath(argsList);
        extractedBcp.add(0, this.jdkJar.getAbsolutePath());
        return extractedBcp;
    }

    protected List<String> createCpOpts(List<String> argsList) {
        List<String> extractedOps = CheckerMain.extractCpOpts(argsList);
        extractedOps.add(0, this.checkersJar.getAbsolutePath());
        return extractedOps;
    }

    protected List<File> collectArgLists(List<String> args) {
        ArrayList<File> argListFiles = new ArrayList<File>();
        for (String arg : args) {
            if (!arg.startsWith("@")) continue;
            argListFiles.add(new File(arg.substring(1)));
        }
        return argListFiles;
    }

    protected static String extractArg(String argumentName, String alternative, List<String> args) {
        for (int i = 0; i < args.size(); ++i) {
            if (!args.get(i).trim().equals(argumentName)) continue;
            if (i == args.size() - 1) {
                throw new RuntimeException("Argument " + argumentName + " specified but given no value!");
            }
            args.remove(i);
            return args.remove(i);
        }
        return alternative;
    }

    protected static File extractFileArg(String argumentName, File alternative, List<String> args) {
        String filePath = CheckerMain.extractArg(argumentName, null, args);
        if (filePath == null) {
            return alternative;
        }
        return new File(filePath);
    }

    protected static String prepFilePath(String previous, File ... files) {
        if (files == null || files.length == 0) {
            throw new RuntimeException("Prepending empty or null array to file path! files == " + (files == null ? " null" : " Empty"));
        }
        String path = files[0].getAbsolutePath();
        for (int i = 1; i < files.length; ++i) {
            path = path + File.pathSeparator + files[i].getAbsolutePath();
        }
        if (previous == null || previous.isEmpty()) {
            return path;
        }
        return path + File.pathSeparator + previous;
    }

    protected static List<String> extractOptWPattern(Pattern pattern, boolean allowEmpties, List<String> args) {
        ArrayList<String> matchedArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.size()) {
            Matcher matcher = pattern.matcher(args.get(i));
            if (matcher.matches()) {
                String arg = matcher.group(1).trim();
                if (!arg.isEmpty() || allowEmpties) {
                    matchedArgs.add(arg);
                }
                args.remove(i);
                continue;
            }
            ++i;
        }
        return matchedArgs;
    }

    protected static List<String> extractBootClassPath(List<String> args) {
        return CheckerMain.extractOptWPattern(BOOT_CLASS_PATH_REGEX, false, args);
    }

    protected static List<String> extractJvmOpts(List<String> args) {
        return CheckerMain.extractOptWPattern(JVM_OPTS_REGEX, false, args);
    }

    protected static List<String> extractCpOpts(List<String> args) {
        ArrayList<String> actualArgs = new ArrayList<String>();
        String path = null;
        int i = 0;
        while (i < args.size()) {
            if (args.get(i).equals("-cp") || args.get(i).equals("-classpath")) {
                if (args.size() <= i) continue;
                args.remove(i);
                path = args.remove(i);
                continue;
            }
            ++i;
        }
        if (path == null) {
            String systemClassPath = System.getenv("CLASSPATH");
            if (systemClassPath != null && !systemClassPath.trim().isEmpty()) {
                actualArgs.add(System.getenv("CLASSPATH"));
            }
            actualArgs.add(".");
        } else {
            actualArgs.add(path);
        }
        return actualArgs;
    }

    protected void addMainArgs(List<String> args) {
        args.add("com.sun.tools.javac.Main");
    }

    public List<String> getExecArguments() {
        ArrayList<String> args = new ArrayList<String>(this.jvmOpts.size() + this.cpOpts.size() + this.toolOpts.size() + 5);
        String java = PluginUtil.getJavaCommand(System.getProperty("java.home"), System.out);
        args.add(java);
        args.add("-Xbootclasspath/p:" + PluginUtil.join(File.pathSeparator, this.runtimeBootClasspath));
        args.add("-ea");
        args.add("-ea:com.sun.tools...");
        args.addAll(this.jvmOpts);
        this.addMainArgs(args);
        args.add("-Xbootclasspath/p:" + PluginUtil.join(File.pathSeparator, this.compilationBootclasspath));
        if (!CheckerMain.argsListHasClassPath(this.argListFiles)) {
            args.add("-classpath");
            args.add(CheckerMain.quote(PluginUtil.join(File.pathSeparator, this.cpOpts)));
        }
        args.addAll(this.toolOpts);
        return args;
    }

    public int invokeCompiler() {
        List<String> args = this.getExecArguments();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.startsWith("-AoutputArgsToFile=")) continue;
            String fileName = arg.substring(19);
            args.remove(i);
            CheckerMain.outputArgumentsToFile(fileName, args);
            break;
        }
        return ExecUtil.execute(args.toArray(new String[args.size()]), System.out, System.err);
    }

    private static void outputArgumentsToFile(String outputFilename, List<String> args) {
        if (outputFilename != null) {
            String errorMessage = null;
            try {
                PrintWriter writer = new PrintWriter(outputFilename, "UTF-8");
                for (int i = 0; i < args.size(); ++i) {
                    String arg = args.get(i);
                    if (arg.startsWith("@")) {
                        String line;
                        String inputFilename = arg.substring(1);
                        BufferedReader br = new BufferedReader(new FileReader(inputFilename));
                        while ((line = br.readLine()) != null) {
                            writer.print(line);
                            writer.print(" ");
                        }
                        br.close();
                        continue;
                    }
                    writer.print(arg);
                    writer.print(" ");
                }
                writer.close();
            }
            catch (IOException e) {
                errorMessage = e.toString();
            }
            if (errorMessage != null) {
                System.err.println("Failed to output command-line arguments to file " + outputFilename + " due to exception: " + errorMessage);
            }
        }
    }

    private static boolean argsListHasClassPath(List<File> argListFiles) {
        for (String arg : CheckerMain.expandArgs(argListFiles)) {
            if (!arg.contains("-classpath ") && !arg.contains("-cp ")) continue;
            return true;
        }
        return false;
    }

    protected static List<String> expandArgs(List<File> args) {
        ArrayList<String> actualArgs = new ArrayList<String>();
        for (File latest : args) {
            try {
                actualArgs.addAll(PluginUtil.readArgFile(latest));
            }
            catch (IOException exc) {
                throw new RuntimeException("Could not open file: " + latest.getAbsolutePath(), exc);
            }
        }
        return actualArgs;
    }

    public static String findPathTo(Class<?> context, boolean directory) throws IllegalStateException {
        String rawName;
        int idx;
        String classFileName;
        String uri;
        if (context == null) {
            context = CheckerMain.class;
        }
        if ((uri = context.getResource(classFileName = ((idx = (rawName = context.getName()).lastIndexOf(46)) == -1 ? rawName : rawName.substring(idx + 1)) + ".class").toString()).startsWith("file:")) {
            if (directory) {
                return uri;
            }
            throw new IllegalStateException("This class has been loaded from a directory and not from a jar file.");
        }
        if (!uri.startsWith("jar:file:")) {
            int idx2 = uri.indexOf(58);
            String protocol = idx2 == -1 ? "(unknown)" : uri.substring(0, idx2);
            throw new IllegalStateException("This class has been loaded remotely via the " + protocol + " protocol. Only loading from a jar on the local file system is supported.");
        }
        int idx3 = uri.indexOf(33);
        if (idx3 == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring("jar:file:".length(), idx3), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }

    private static void assertFilesExist(List<File> expectedFiles) {
        ArrayList<File> missingFiles = new ArrayList<File>();
        for (File file : expectedFiles) {
            if (file != null && file.exists()) continue;
            missingFiles.add(file);
        }
        if (!missingFiles.isEmpty()) {
            File firstMissing = (File)missingFiles.remove(0);
            String message = "The following files could not be located: " + firstMissing.getAbsolutePath();
            for (File missing : missingFiles) {
                message = message + ", " + missing.getAbsolutePath();
            }
            throw new RuntimeException(message);
        }
    }

    private static String quote(String str) {
        if (str.contains(" ")) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static boolean matchesCheckerOrSubcheckerFromList(String processorString, List<String> fullyQualifiedCheckerNames) {
        if (processorString.contains(",")) {
            return false;
        }
        return fullyQualifiedCheckerNames.contains(CheckerMain.asCheckerFrameworkProcessors(processorString, fullyQualifiedCheckerNames, true));
    }

    private List<String> getCheckerClassNames() {
        ArrayList<String> checkerClassNames = new ArrayList<String>();
        try {
            ZipEntry entry;
            JarInputStream checkerJarIs = new JarInputStream(new FileInputStream(this.checkersJar));
            while ((entry = checkerJarIs.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith(CHECKER_BASE_DIR_NAME) || !name.endsWith("Checker.class")) continue;
                checkerClassNames.add(PluginUtil.join(".", name.substring(0, name.length() - ".class".length()).split(File.separator)));
            }
            checkerJarIs.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read checker.jar", e);
        }
        return checkerClassNames;
    }

    protected static String asCheckerFrameworkProcessors(String processorsString, List<String> fullyQualifiedCheckerNames, boolean allowSubcheckers) {
        String[] processors = processorsString.split(",");
        for (int i = 0; i < processors.length; ++i) {
            if (processors[i].equals(SUBTYPING_CHECKER_NAME)) {
                processors[i] = FULLY_QUALIFIED_SUBTYPING_CHECKER;
                continue;
            }
            if (processors[i].contains(".")) continue;
            processors[i] = CheckerMain.fullyQualifyProcessor(processors[i], fullyQualifiedCheckerNames, allowSubcheckers);
        }
        return PluginUtil.join(",", processors);
    }

    private static String fullyQualifyProcessor(String processor, List<String> fullyQualifiedCheckerNames, boolean allowSubcheckers) {
        for (String name : fullyQualifiedCheckerNames) {
            boolean tryMatch = false;
            String[] checkerPath = name.substring(0, name.length() - "Checker".length()).split("\\.");
            String checkerNameShort = checkerPath[checkerPath.length - 1];
            String checkerName = checkerNameShort + "Checker";
            if (name.endsWith("Checker")) {
                checkerPath = name.substring(0, name.length() - "Checker".length()).split("\\.");
                checkerNameShort = checkerPath[checkerPath.length - 1];
                checkerName = checkerNameShort + "Checker";
                tryMatch = true;
            } else if (allowSubcheckers && name.endsWith("Subchecker")) {
                checkerPath = name.substring(0, name.length() - "Subchecker".length()).split("\\.");
                checkerNameShort = checkerPath[checkerPath.length - 1];
                checkerName = checkerNameShort + "Subchecker";
                tryMatch = true;
            }
            if (!tryMatch || !processor.equalsIgnoreCase(checkerName) && !processor.equalsIgnoreCase(checkerNameShort)) continue;
            return name;
        }
        return processor;
    }

    public static boolean matchesFullyQualifiedProcessor(String processor, List<String> fullyQualifiedCheckerNames, boolean allowSubcheckers) {
        for (String name : fullyQualifiedCheckerNames) {
            boolean tryMatch = false;
            String[] checkerPath = name.substring(0, name.length() - "Checker".length()).split("\\.");
            String checkerNameShort = checkerPath[checkerPath.length - 1];
            String checkerName = checkerNameShort + "Checker";
            if (name.endsWith("Checker")) {
                checkerPath = name.substring(0, name.length() - "Checker".length()).split("\\.");
                checkerNameShort = checkerPath[checkerPath.length - 1];
                checkerName = checkerNameShort + "Checker";
                tryMatch = true;
            } else if (allowSubcheckers && name.endsWith("Subchecker")) {
                checkerPath = name.substring(0, name.length() - "Subchecker".length()).split("\\.");
                checkerNameShort = checkerPath[checkerPath.length - 1];
                checkerName = checkerNameShort + "Subchecker";
                tryMatch = true;
            }
            if (!tryMatch || !processor.equalsIgnoreCase(checkerName) && !processor.equalsIgnoreCase(checkerNameShort)) continue;
            return true;
        }
        return false;
    }
}

