/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.typeinference.GlbUtil;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.framework.util.typeinference.solver.InferenceResult;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;
import org.checkerframework.framework.util.typeinference.solver.TargetConstraints;

public class SubtypesSolver {
    public InferenceResult solveFromSubtypes(Set<TypeVariable> remainingTargets, ConstraintMap constraints, AnnotatedTypeFactory typeFactory) {
        return this.glbSubtypes(remainingTargets, constraints, typeFactory);
    }

    public InferenceResult glbSubtypes(Set<TypeVariable> remainingTargets, ConstraintMap constraints, AnnotatedTypeFactory typeFactory) {
        InferenceResult inferenceResult = new InferenceResult();
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        final Types types = typeFactory.getProcessingEnv().getTypeUtils();
        ArrayList<TypeVariable> targetsSubtypesLast = new ArrayList<TypeVariable>(remainingTargets);
        Collections.sort(targetsSubtypesLast, new Comparator<TypeVariable>(){

            @Override
            public int compare(TypeVariable o1, TypeVariable o2) {
                if (types.isSubtype(o1, o2)) {
                    return 1;
                }
                if (types.isSubtype(o2, o1)) {
                    return -1;
                }
                return 0;
            }
        });
        for (TypeVariable target : targetsSubtypesLast) {
            TargetConstraints.Subtypes subtypes = constraints.getConstraints((TypeVariable)target).subtypes;
            if (subtypes.types.isEmpty()) continue;
            SubtypesSolver.propagatePreviousGlbs(subtypes, inferenceResult, subtypes.types);
            Map<AnnotationMirror, Set<AnnotationMirror>> primaries = subtypes.primaries;
            if (subtypes.types.size() == 1) {
                Map.Entry<AnnotatedTypeMirror, Set<AnnotationMirror>> entry = subtypes.types.entrySet().iterator().next();
                AnnotatedTypeMirror supertype = entry.getKey().deepCopy();
                for (AnnotationMirror annotationMirror : entry.getValue()) {
                    Set<AnnotationMirror> superAnnos = primaries.get(annotationMirror);
                    if (superAnnos == null) continue;
                    AnnotationMirror supertypeAnno = supertype.getAnnotationInHierarchy(annotationMirror);
                    superAnnos.add(supertypeAnno);
                }
                if (!primaries.isEmpty()) {
                    for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
                        AnnotationMirror glb = this.greatestLowerBound((Iterable<? extends AnnotationMirror>)subtypes.primaries.get(annotationMirror), qualifierHierarchy);
                        supertype.replaceAnnotation(glb);
                    }
                }
                inferenceResult.put(target, new InferredValue.InferredType(supertype));
                continue;
            }
            AnnotatedTypeMirror glbType = GlbUtil.glbAll(subtypes.types, typeFactory);
            if (glbType == null) continue;
            if (!primaries.isEmpty()) {
                for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
                    AnnotationMirror annotationMirror2 = this.greatestLowerBound((Iterable<? extends AnnotationMirror>)subtypes.primaries.get(annotationMirror), qualifierHierarchy);
                    AnnotationMirror currentAnno = glbType.getAnnotationInHierarchy(annotationMirror);
                    if (currentAnno == null) {
                        glbType.addAnnotation(annotationMirror2);
                        continue;
                    }
                    if (annotationMirror2 == null) continue;
                    glbType.replaceAnnotation(qualifierHierarchy.greatestLowerBound(annotationMirror2, currentAnno));
                }
            }
            inferenceResult.put(target, new InferredValue.InferredType(glbType));
        }
        return inferenceResult;
    }

    protected static void propagatePreviousGlbs(TargetConstraints.Subtypes targetSubtypes, InferenceResult solution, Map<AnnotatedTypeMirror, Set<AnnotationMirror>> subtypesOfTarget) {
        for (Map.Entry<TypeVariable, Set<AnnotationMirror>> subtypeTarget : targetSubtypes.targets.entrySet()) {
            InferredValue subtargetInferredGlb = (InferredValue)solution.get(subtypeTarget.getKey());
            if (subtargetInferredGlb == null) continue;
            AnnotatedTypeMirror subtargetGlbType = ((InferredValue.InferredType)subtargetInferredGlb).type;
            Set<AnnotationMirror> subtargetAnnos = subtypesOfTarget.get(subtargetGlbType);
            if (subtargetAnnos != null) {
                subtargetAnnos.addAll((Collection<AnnotationMirror>)subtypeTarget.getValue());
                continue;
            }
            subtypesOfTarget.put(subtargetGlbType, subtypeTarget.getValue());
        }
    }

    private final AnnotationMirror greatestLowerBound(Iterable<? extends AnnotationMirror> annos, QualifierHierarchy qualifierHierarchy) {
        Iterator<? extends AnnotationMirror> annoIter = annos.iterator();
        AnnotationMirror glb = annoIter.next();
        while (annoIter.hasNext()) {
            glb = qualifierHierarchy.greatestLowerBound(glb, annoIter.next());
        }
        return glb;
    }
}

