/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.framework.flow.CFTreeBuilder;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class CFCFGBuilder
extends CFGBuilder {
    protected final BaseTypeChecker checker;
    protected final AnnotatedTypeFactory factory;

    public CFCFGBuilder(BaseTypeChecker checker, AnnotatedTypeFactory factory) {
        super(checker.hasOption("assumeAssertionsAreEnabled"), checker.hasOption("assumeAssertionsAreDisabled"));
        if (this.assumeAssertionsEnabled && this.assumeAssertionsDisabled) {
            ErrorReporter.errorAbort("Assertions cannot be assumed to be enabled and disabled at the same time.");
        }
        this.checker = checker;
        this.factory = factory;
    }

    @Override
    public ControlFlowGraph run(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST) {
        this.declaredClasses.clear();
        this.declaredLambdas.clear();
        CFTreeBuilder builder = new CFTreeBuilder(env);
        CFGBuilder.PhaseOneResult phase1result = new CFCFGTranslationPhaseOne().process(root, env, underlyingAST, this.exceptionalExitLabel, (TreeBuilder)builder, (AnnotationProvider)this.factory);
        ControlFlowGraph phase2result = new CFGBuilder.CFGTranslationPhaseTwo().process(phase1result);
        ControlFlowGraph phase3result = CFGBuilder.CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public static boolean assumeAssertionsActivatedForAssertTree(SourceChecker checker, AssertTree tree) {
        ExpressionTree detail = tree.getDetail();
        if (detail != null) {
            String msg = detail.toString();
            Collection<String> warningKeys = checker.getSuppressWarningsKeys();
            for (String warningKey : warningKeys) {
                String key = "@AssumeAssertion(" + warningKey + ")";
                if (!msg.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    public class CFCFGTranslationPhaseOne
    extends CFGBuilder.CFGTranslationPhaseOne {
        @Override
        protected boolean assumeAssertionsEnabledFor(AssertTree tree) {
            if (CFCFGBuilder.assumeAssertionsActivatedForAssertTree(CFCFGBuilder.this.checker, tree)) {
                return true;
            }
            return super.assumeAssertionsEnabledFor(tree);
        }

        @Override
        public void handleArtificialTree(Tree tree) {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
            if (enclosingMethod != null) {
                ExecutableElement methodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
                CFCFGBuilder.this.factory.setPathHack(tree, methodElement);
            } else {
                ClassTree enclosingClass = TreeUtils.enclosingClass(this.getCurrentPath());
                if (enclosingClass != null) {
                    TypeElement classElement = TreeUtils.elementFromDeclaration(enclosingClass);
                    CFCFGBuilder.this.factory.setPathHack(tree, classElement);
                }
            }
        }

        @Override
        protected VariableTree createEnhancedForLoopIteratorVariable(MethodInvocationTree iteratorCall, VariableElement variableElement) {
            boolean oldShouldCache = CFCFGBuilder.this.factory.shouldCache;
            CFCFGBuilder.this.factory.shouldCache = false;
            AnnotatedTypeMirror annotatedIteratorType = CFCFGBuilder.this.factory.getAnnotatedType(iteratorCall);
            CFCFGBuilder.this.factory.shouldCache = oldShouldCache;
            Tree annotatedIteratorTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedIteratorType);
            this.handleArtificialTree(annotatedIteratorTypeTree);
            VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(annotatedIteratorTypeTree, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
            return iteratorVariable;
        }

        @Override
        protected VariableTree createEnhancedForLoopArrayVariable(ExpressionTree expression, VariableElement variableElement) {
            boolean oldShouldCache = CFCFGBuilder.this.factory.shouldCache;
            CFCFGBuilder.this.factory.shouldCache = false;
            AnnotatedTypeMirror annotatedArrayType = CFCFGBuilder.this.factory.getAnnotatedType(expression);
            CFCFGBuilder.this.factory.shouldCache = oldShouldCache;
            assert (annotatedArrayType instanceof AnnotatedTypeMirror.AnnotatedArrayType) : "ArrayType must be represented by AnnotatedArrayType";
            Tree annotatedArrayTypeTree = ((CFTreeBuilder)this.treeBuilder).buildAnnotatedType(annotatedArrayType);
            this.handleArtificialTree(annotatedArrayTypeTree);
            VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(annotatedArrayTypeTree, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
            return arrayVariable;
        }
    }
}

