/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base.dataflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.dataflow.cfg.node.MarkerNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NullChkNode;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.ShortLiteralNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualStore;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;

public class QualTransferAdapter<Q>
extends CFTransfer {
    private final QualTransfer<Q> underlying;
    private final QualAnalysis<Q> qualAnalysis;

    public QualTransferAdapter(QualTransfer<Q> underlying, CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis, QualAnalysis<Q> qualAnalysis) {
        super(analysis);
        underlying.setAdapter(this);
        this.underlying = underlying;
        this.qualAnalysis = qualAnalysis;
    }

    public TransferInput<QualValue<Q>, QualStore<Q>> convertCfToQualInput(TransferInput<CFValue, CFStore> transferInput) {
        if (transferInput.containsTwoStores()) {
            return new TransferInput<QualValue<Q>, QualStore<Q>>(transferInput.getNode(), this.qualAnalysis, new QualStore<Q>(this.qualAnalysis, transferInput.getThenStore()), new QualStore<Q>(this.qualAnalysis, transferInput.getElseStore()));
        }
        return new TransferInput<QualValue<Q>, QualStore<Q>>(transferInput.getNode(), this.qualAnalysis, new QualStore<Q>(this.qualAnalysis, transferInput.getThenStore()));
    }

    public TransferInput<CFValue, CFStore> convertQualToCfInput(TransferInput<QualValue<Q>, QualStore<Q>> transferInput) {
        if (transferInput.containsTwoStores()) {
            return new TransferInput<CFValue, CFStore>(transferInput.getNode(), this.analysis, transferInput.getThenStore().getUnderlyingStore(), transferInput.getElseStore().getUnderlyingStore());
        }
        return new TransferInput<CFValue, CFStore>(transferInput.getNode(), this.analysis, transferInput.getRegularStore().getUnderlyingStore());
    }

    public TransferResult<CFValue, CFStore> convertQualToCfResult(TransferResult<QualValue<Q>, QualStore<Q>> transferResult) {
        Map<TypeMirror, QualStore<Q>> exeStores = transferResult.getExceptionalStores();
        HashMap<TypeMirror, CFStore> convertedExeStores = new HashMap<TypeMirror, CFStore>();
        if (exeStores != null) {
            for (Map.Entry<TypeMirror, QualStore<Q>> entry : exeStores.entrySet()) {
                convertedExeStores.put(entry.getKey(), entry.getValue().getUnderlyingStore());
            }
        }
        CFValue resultValue = null;
        if (transferResult.getResultValue() != null) {
            resultValue = (CFValue)this.analysis.createAbstractValue(this.qualAnalysis.getConverter().getAnnotatedType(transferResult.getResultValue().getType()));
        }
        if (transferResult.containsTwoStores()) {
            return new ConditionalTransferResult<CFValue, CFStore>(resultValue, transferResult.getThenStore().getUnderlyingStore(), transferResult.getElseStore().getUnderlyingStore(), convertedExeStores, transferResult.storeChanged());
        }
        return new RegularTransferResult<CFValue, CFStore>(resultValue, transferResult.getRegularStore().getUnderlyingStore(), convertedExeStores, transferResult.storeChanged());
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> convertCfToQualResult(TransferResult<CFValue, CFStore> transferResult) {
        Map<TypeMirror, CFStore> exeStores = transferResult.getExceptionalStores();
        HashMap<TypeMirror, QualStore<Q>> convertedExeStores = new HashMap<TypeMirror, QualStore<Q>>();
        if (exeStores != null) {
            for (Map.Entry<TypeMirror, CFStore> entry : exeStores.entrySet()) {
                convertedExeStores.put(entry.getKey(), new QualStore<Q>(this.qualAnalysis, entry.getValue()));
            }
        }
        QualValue<Q> resultValue = null;
        if (transferResult.getResultValue() != null) {
            resultValue = this.qualAnalysis.createAbstractValue(this.qualAnalysis.getConverter().getQualifiedType(transferResult.getResultValue().getType()));
        }
        if (transferResult.containsTwoStores()) {
            return new ConditionalTransferResult<QualValue<Q>, QualStore<Q>>(resultValue, new QualStore<Q>(this.qualAnalysis, transferResult.getThenStore()), new QualStore<Q>(this.qualAnalysis, transferResult.getElseStore()), convertedExeStores, transferResult.storeChanged());
        }
        return new RegularTransferResult<QualValue<Q>, QualStore<Q>>(resultValue, new QualStore<Q>(this.qualAnalysis, transferResult.getRegularStore()), convertedExeStores, transferResult.storeChanged());
    }

    public QualStore<Q> superInitialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        CFStore initialStore = (CFStore)super.initialStore(underlyingAST, (List)parameters);
        return new QualStore<Q>(this.qualAnalysis, initialStore);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitShortLiteral(ShortLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitShortLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitShortLiteral(ShortLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitShortLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerLiteral(IntegerLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitIntegerLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitIntegerLiteral(IntegerLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitIntegerLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLongLiteral(LongLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitLongLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitLongLiteral(LongLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitLongLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatLiteral(FloatLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitFloatLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitFloatLiteral(FloatLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitFloatLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitDoubleLiteral(DoubleLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitDoubleLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitDoubleLiteral(DoubleLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitDoubleLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBooleanLiteral(BooleanLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitBooleanLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitBooleanLiteral(BooleanLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitBooleanLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitCharacterLiteral(CharacterLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitCharacterLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitCharacterLiteral(CharacterLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitCharacterLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringLiteral(StringLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitStringLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitStringLiteral(StringLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitStringLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNullLiteral(NullLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNullLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNullLiteral(NullLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNullLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMinus(NumericalMinusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNumericalMinus(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNumericalMinus(NumericalMinusNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNumericalMinus(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalPlus(NumericalPlusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNumericalPlus(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNumericalPlus(NumericalPlusNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNumericalPlus(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseComplement(BitwiseComplementNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitBitwiseComplement(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitBitwiseComplement(BitwiseComplementNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitBitwiseComplement(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNullChk(NullChkNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNullChk(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNullChk(NullChkNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNullChk(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConcatenate(StringConcatenateNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitStringConcatenate(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitStringConcatenate(StringConcatenateNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitStringConcatenate(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNumericalAddition(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNumericalAddition(NumericalAdditionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNumericalAddition(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNumericalSubtraction(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNumericalSubtraction(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMultiplication(NumericalMultiplicationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNumericalMultiplication(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNumericalMultiplication(NumericalMultiplicationNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitNumericalMultiplication(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerDivision(IntegerDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitIntegerDivision(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitIntegerDivision(IntegerDivisionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitIntegerDivision(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingDivision(FloatingDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitFloatingDivision(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitFloatingDivision(FloatingDivisionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitFloatingDivision(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerRemainder(IntegerRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitIntegerRemainder(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitIntegerRemainder(IntegerRemainderNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitIntegerRemainder(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingRemainder(FloatingRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitFloatingRemainder(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitFloatingRemainder(FloatingRemainderNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitFloatingRemainder(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLeftShift(LeftShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitLeftShift(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitLeftShift(LeftShiftNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitLeftShift(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSignedRightShift(SignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitSignedRightShift(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitSignedRightShift(SignedRightShiftNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitSignedRightShift(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitUnsignedRightShift(UnsignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitUnsignedRightShift(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitUnsignedRightShift(UnsignedRightShiftNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitUnsignedRightShift(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseAnd(BitwiseAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitBitwiseAnd(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitBitwiseAnd(BitwiseAndNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitBitwiseAnd(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseOr(BitwiseOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitBitwiseOr(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitBitwiseOr(BitwiseOrNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitBitwiseOr(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseXor(BitwiseXorNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitBitwiseXor(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitBitwiseXor(BitwiseXorNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitBitwiseXor(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitStringConcatenateAssignment(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitStringConcatenateAssignment(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThan(LessThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitLessThan(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitLessThan(LessThanNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitLessThan(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitLessThanOrEqual(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitLessThanOrEqual(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThan(GreaterThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitGreaterThan(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitGreaterThan(GreaterThanNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitGreaterThan(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitGreaterThanOrEqual(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitGreaterThanOrEqual(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitEqualTo(EqualToNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitEqualTo(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitEqualTo(EqualToNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitEqualTo(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNotEqual(NotEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNotEqual(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNotEqual(NotEqualNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitNotEqual(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalAnd(ConditionalAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitConditionalAnd(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitConditionalAnd(ConditionalAndNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitConditionalAnd(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalOr(ConditionalOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitConditionalOr(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitConditionalOr(ConditionalOrNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitConditionalOr(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalNot(ConditionalNotNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitConditionalNot(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitConditionalNot(ConditionalNotNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitConditionalNot(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitTernaryExpression(TernaryExpressionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitTernaryExpression(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitTernaryExpression(TernaryExpressionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitTernaryExpression(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitAssignment(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitAssignment(AssignmentNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitAssignment(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLocalVariable(LocalVariableNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitLocalVariable(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitLocalVariable(LocalVariableNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitLocalVariable(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitVariableDeclaration(VariableDeclarationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitVariableDeclaration(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitVariableDeclaration(VariableDeclarationNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitVariableDeclaration(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFieldAccess(FieldAccessNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitFieldAccess(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitFieldAccess(FieldAccessNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitFieldAccess(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodAccess(MethodAccessNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitMethodAccess(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitMethodAccess(MethodAccessNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitMethodAccess(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitArrayAccess(ArrayAccessNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitArrayAccess(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitArrayAccess(ArrayAccessNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitArrayAccess(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitImplicitThisLiteral(ImplicitThisLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitImplicitThisLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitImplicitThisLiteral(ImplicitThisLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitImplicitThisLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitExplicitThisLiteral(ExplicitThisLiteralNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitExplicitThisLiteral(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitExplicitThisLiteral(ExplicitThisLiteralNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitExplicitThisLiteral(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSuper(SuperNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitSuper(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitSuper(SuperNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitSuper(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitReturn(ReturnNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitReturn(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitReturn(ReturnNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitReturn(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConversion(StringConversionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitStringConversion(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitStringConversion(StringConversionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitStringConversion(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNarrowingConversion(NarrowingConversionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitNarrowingConversion(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitNarrowingConversion(NarrowingConversionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitNarrowingConversion(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitWideningConversion(WideningConversionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitWideningConversion(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitWideningConversion(WideningConversionNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitWideningConversion(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitInstanceOf(InstanceOfNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitInstanceOf(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitInstanceOf(InstanceOfNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitInstanceOf(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitTypeCast(TypeCastNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitTypeCast(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitTypeCast(TypeCastNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitTypeCast(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssertionError(AssertionErrorNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitAssertionError(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitAssertionError(AssertionErrorNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitAssertionError(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSynchronized(SynchronizedNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitSynchronized(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitSynchronized(SynchronizedNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitSynchronized(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitThrow(ThrowNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitThrow(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitThrow(ThrowNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitThrow(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitCase(CaseNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitCase(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitCase(CaseNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitCase(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitMethodInvocation(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitMethodInvocation(MethodInvocationNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitObjectCreation(ObjectCreationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitObjectCreation(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitObjectCreation(ObjectCreationNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitObjectCreation(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMemberReference(FunctionalInterfaceNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitMemberReference(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitMemberReference(FunctionalInterfaceNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitMemberReference(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitArrayCreation(ArrayCreationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitArrayCreation(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitArrayCreation(ArrayCreationNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitArrayCreation(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitArrayType(ArrayTypeNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitArrayType(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitArrayType(ArrayTypeNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitArrayType(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitPrimitiveType(PrimitiveTypeNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitPrimitiveType(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitPrimitiveType(PrimitiveTypeNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitPrimitiveType(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitClassName(ClassNameNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitClassName(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitClassName(ClassNameNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult<CFValue, CFStore> result = super.visitClassName(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitPackageName(PackageNameNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitPackageName(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitPackageName(PackageNameNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitPackageName(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitParameterizedType(ParameterizedTypeNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitParameterizedType(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitParameterizedType(ParameterizedTypeNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitParameterizedType(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMarker(MarkerNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<QualValue<Q>, QualStore<Q>> result = this.underlying.visitMarker(n, this.convertCfToQualInput(p));
        return this.convertQualToCfResult(result);
    }

    public TransferResult<QualValue<Q>, QualStore<Q>> superVisitMarker(MarkerNode n, TransferInput<QualValue<Q>, QualStore<Q>> p) {
        TransferResult result = (TransferResult)super.visitMarker(n, this.convertQualToCfInput(p));
        return this.convertCfToQualResult(result);
    }
}

