/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.reflection;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.reflection.ClassValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.ClassValChecker;
import org.checkerframework.common.reflection.DefaultReflectionResolver;
import org.checkerframework.common.reflection.MethodSignature;
import org.checkerframework.common.reflection.qual.ClassBound;
import org.checkerframework.common.reflection.qual.ClassVal;
import org.checkerframework.common.reflection.qual.MethodVal;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

@TypeQualifiers(value={MethodVal.class, MethodValBottom.class, UnknownMethod.class})
public class MethodValAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror METHODVAL_BOTTOM;
    private final AnnotationMirror UNKNOWN_METHOD;
    private final ExecutableElement[] getMethod;
    private final ExecutableElement[] getConstructor;
    private static final int UNKNOWN_PARAM_LENGTH = -1;

    public MethodValAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.METHODVAL_BOTTOM = AnnotationUtils.fromClass(this.elements, MethodValBottom.class);
        this.UNKNOWN_METHOD = AnnotationUtils.fromClass(this.elements, UnknownMethod.class);
        this.getMethod = new ExecutableElement[]{TreeUtils.getMethod("java.lang.Class", "getMethod", 2, this.processingEnv), TreeUtils.getMethod("java.lang.Class", "getDeclaredMethod", 2, this.processingEnv)};
        this.getConstructor = new ExecutableElement[]{TreeUtils.getMethod("java.lang.Class", "getConstructor", 1, this.processingEnv)};
        if (this.getClass().equals(MethodValAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    @Override
    protected void initilizeReflectionResolution() {
        boolean debug = "debug".equals(this.checker.getOption("resolveReflection"));
        this.reflectionResolver = new DefaultReflectionResolver(this.checker, this, debug);
    }

    static List<MethodSignature> getListOfMethodSignatures(AnnotationMirror anno) {
        ArrayList<MethodSignature> list = new ArrayList<MethodSignature>();
        List<String> methodNames = AnnotationUtils.getElementValueArray(anno, "methodName", String.class, true);
        List<String> classNames = AnnotationUtils.getElementValueArray(anno, "className", String.class, true);
        List<Integer> params = AnnotationUtils.getElementValueArray(anno, "params", Integer.class, true);
        for (int i = 0; i < methodNames.size(); ++i) {
            list.add(new MethodSignature(classNames.get(i), methodNames.get(i), params.get(i)));
        }
        return list;
    }

    private AnnotationMirror createMethodVal(Set<MethodSignature> sigs) {
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<String> methodNames = new ArrayList<String>();
        ArrayList<Integer> params = new ArrayList<Integer>();
        for (MethodSignature sig : sigs) {
            classNames.add(sig.className);
            methodNames.add(sig.methodName);
            params.add(sig.params);
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MethodVal.class.getCanonicalName());
        builder.setValue((CharSequence)"className", classNames);
        builder.setValue((CharSequence)"methodName", methodNames);
        builder.setValue((CharSequence)"params", params);
        return builder.build();
    }

    private List<String> getClassNamesFromClassValChecker(ExpressionTree tree, boolean mustBeExact) {
        ClassValAnnotatedTypeFactory classValATF = (ClassValAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ClassValChecker.class);
        AnnotatedTypeMirror classAnno = classValATF.getAnnotatedType(tree);
        List<String> classNames = new ArrayList<String>();
        AnnotationMirror annotation = classAnno.getAnnotation(ClassVal.class);
        if (annotation != null) {
            classNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
        } else if (!mustBeExact && (annotation = classAnno.getAnnotation(ClassBound.class)) != null) {
            classNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
        }
        return classNames;
    }

    private List<String> getMethodNamesFromStringArg(ExpressionTree arg) {
        List<String> methodNames = new ArrayList<String>();
        ValueAnnotatedTypeFactory valueATF = (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
        AnnotatedTypeMirror valueAnno = valueATF.getAnnotatedType(arg);
        AnnotationMirror annotation = valueAnno.getAnnotation(StringVal.class);
        if (annotation != null) {
            methodNames = AnnotationUtils.getElementValueArray(annotation, "value", String.class, true);
        }
        return methodNames;
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new MethodValQualifierHierarchy(factory, this.METHODVAL_BOTTOM);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new MethodValTreeAnnotator(this), super.createTreeAnnotator());
    }

    protected class MethodValTreeAnnotator
    extends TreeAnnotator {
        protected MethodValTreeAnnotator(MethodValAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            List classNames;
            List<Integer> params;
            List methodNames;
            if (this.isGetConstructorMethodInovaction(tree)) {
                methodNames = Arrays.asList("<init>");
                params = this.getConstructorParamsLen(tree.getArguments());
                classNames = MethodValAnnotatedTypeFactory.this.getClassNamesFromClassValChecker(TreeUtils.getReceiverTree(tree), true);
            } else if (this.isGetMethodMethodInovaction(tree)) {
                ExpressionTree methodNameArg = tree.getArguments().get(0);
                methodNames = MethodValAnnotatedTypeFactory.this.getMethodNamesFromStringArg(methodNameArg);
                params = this.getMethodParamsLen(tree.getArguments());
                classNames = MethodValAnnotatedTypeFactory.this.getClassNamesFromClassValChecker(TreeUtils.getReceiverTree(tree), false);
            } else {
                return null;
            }
            if (methodNames.isEmpty() || classNames.isEmpty()) {
                type.replaceAnnotation(MethodValAnnotatedTypeFactory.this.UNKNOWN_METHOD);
                return null;
            }
            HashSet<MethodSignature> methodSigs = new HashSet<MethodSignature>();
            for (String methodName : methodNames) {
                for (String className : classNames) {
                    for (Integer param : params) {
                        methodSigs.add(new MethodSignature(className, methodName, param));
                    }
                }
            }
            AnnotationMirror newQual = MethodValAnnotatedTypeFactory.this.createMethodVal(methodSigs);
            type.replaceAnnotation(newQual);
            return null;
        }

        private boolean isGetConstructorMethodInovaction(MethodInvocationTree tree) {
            for (ExecutableElement method : MethodValAnnotatedTypeFactory.this.getConstructor) {
                if (!TreeUtils.isMethodInvocation(tree, method, MethodValAnnotatedTypeFactory.this.processingEnv)) continue;
                return true;
            }
            return false;
        }

        private boolean isGetMethodMethodInovaction(MethodInvocationTree tree) {
            for (ExecutableElement method : MethodValAnnotatedTypeFactory.this.getMethod) {
                if (!TreeUtils.isMethodInvocation(tree, method, MethodValAnnotatedTypeFactory.this.processingEnv)) continue;
                return true;
            }
            return false;
        }

        private List<Integer> getMethodParamsLen(List<? extends ExpressionTree> args) {
            assert (args.size() > 0) : "getMethod must have at least one parameter";
            int numParams = args.size() - 1;
            if (numParams == 1) {
                return this.getNumberOfParameterOneArg(args.get(1));
            }
            return Collections.singletonList(numParams);
        }

        private List<Integer> getConstructorParamsLen(List<? extends ExpressionTree> args) {
            int numParams = args.size();
            if (numParams == 1) {
                return this.getNumberOfParameterOneArg(args.get(0));
            }
            return Collections.singletonList(numParams);
        }

        private List<Integer> getNumberOfParameterOneArg(ExpressionTree argument) {
            AnnotatedTypeMirror atm = this.atypeFactory.getAnnotatedType(argument);
            switch (atm.getKind()) {
                case ARRAY: {
                    ValueAnnotatedTypeFactory valueATF = (ValueAnnotatedTypeFactory)MethodValAnnotatedTypeFactory.this.getTypeFactoryOfSubchecker(ValueChecker.class);
                    AnnotatedTypeMirror valueAnno = valueATF.getAnnotatedType(argument);
                    if (valueAnno.getAnnotation(ArrayLen.class) != null) {
                        AnnotationMirror annotation = valueAnno.getAnnotation(ArrayLen.class);
                        return AnnotationUtils.getElementValueArray(annotation, "value", Integer.class, true);
                    }
                    if (valueAnno.getAnnotation(BottomVal.class) != null) {
                        return Collections.singletonList(0);
                    }
                    return Collections.singletonList(-1);
                }
                case NULL: {
                    return Collections.singletonList(0);
                }
            }
            return Collections.singletonList(1);
        }
    }

    protected class MethodValQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        protected MethodValQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory, AnnotationMirror bottom) {
            super(factory, bottom);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<MethodSignature> a1Sigs = MethodValAnnotatedTypeFactory.getListOfMethodSignatures(a1);
                List<MethodSignature> a2Sigs = MethodValAnnotatedTypeFactory.getListOfMethodSignatures(a2);
                HashSet<MethodSignature> lubSigs = new HashSet<MethodSignature>(a1Sigs);
                lubSigs.addAll(a2Sigs);
                AnnotationMirror result = MethodValAnnotatedTypeFactory.this.createMethodVal(lubSigs);
                return result;
            }
            return null;
        }

        @Override
        public boolean isSubtype(AnnotationMirror sub, AnnotationMirror sup) {
            if (AnnotationUtils.areSame(sub, sup) || AnnotationUtils.areSameByClass(sup, UnknownMethod.class) || AnnotationUtils.areSameByClass(sub, MethodValBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(sub, UnknownMethod.class) || AnnotationUtils.areSameByClass(sup, MethodValBottom.class)) {
                return false;
            }
            assert (AnnotationUtils.areSameByClass(sub, MethodVal.class) && AnnotationUtils.areSameByClass(sup, MethodVal.class)) : "Unexpected annotation in MethodVal";
            List<MethodSignature> subSignatures = MethodValAnnotatedTypeFactory.getListOfMethodSignatures(sub);
            List<MethodSignature> superSignatures = MethodValAnnotatedTypeFactory.getListOfMethodSignatures(sup);
            for (MethodSignature sig : subSignatures) {
                if (superSignatures.contains(sig)) continue;
                return false;
            }
            return true;
        }
    }
}

