/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.poly.CombiningOperation;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterAnnotationConverter;
import org.checkerframework.qualframework.poly.qual.Wildcard;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;

public abstract class SimpleQualifierParameterAnnotationConverter<Q>
implements QualifierParameterAnnotationConverter<Q> {
    public static final String PRIMARY_TARGET = "_primary";
    public static final String TARGET_PARAM_NAME = "param";
    public static final String POLY_NAME = "_poly";
    protected static final String SOURCE_VALUE_NAME = "arg";
    protected static final String WILDCARD_NAME = "wildcard";
    protected final String MULTI_ANNO_NAME_PREFIX;
    protected final CombiningOperation<Q> lubOp;
    protected final Q BOTTOM;
    protected final Q TOP;
    protected final Q DEFAULT_QUAL;
    private final Class<? extends Annotation> classAnno;
    private final Class<? extends Annotation> methodAnno;
    private final Class<? extends Annotation> polyAnno;
    private final Class<? extends Annotation> varAnno;
    private final Class<? extends Annotation> wildAnno;
    private final Set<String> supportedAnnotationNames;
    private final Set<String> specialCaseAnnotations;

    public SimpleQualifierParameterAnnotationConverter(CombiningOperation<Q> lubOp, String multiAnnoNamePrefix, Set<String> supportedAnnotationNames, Set<String> specialCaseAnnotations, Class<? extends Annotation> classAnno, Class<? extends Annotation> methodAnno, Class<? extends Annotation> polyAnno, Class<? extends Annotation> varAnno, Class<? extends Annotation> wildAnno, Q top, Q bottom, Q defaultQual) {
        this.MULTI_ANNO_NAME_PREFIX = multiAnnoNamePrefix;
        if (supportedAnnotationNames == null || supportedAnnotationNames.isEmpty()) {
            ErrorReporter.errorAbort("supportedAnnotationNames must be a list of type system qualifiers.");
        }
        this.supportedAnnotationNames = supportedAnnotationNames;
        this.specialCaseAnnotations = specialCaseAnnotations == null ? new HashSet<String>() : specialCaseAnnotations;
        this.lubOp = lubOp;
        this.classAnno = classAnno;
        this.methodAnno = methodAnno;
        this.polyAnno = polyAnno;
        this.varAnno = varAnno;
        this.wildAnno = wildAnno;
        this.TOP = top;
        this.BOTTOM = bottom;
        this.DEFAULT_QUAL = defaultQual;
    }

    public abstract Q getQualifier(AnnotationMirror var1);

    protected QualParams<Q> specialCaseHandle(AnnotationMirror anno) {
        return null;
    }

    @Override
    public QualParams<Q> fromAnnotations(Collection<? extends AnnotationMirror> annos) {
        HashMap params = new HashMap();
        PolyQual primary = null;
        for (AnnotationMirror annotationMirror : annos) {
            PolyQual<Q> newPrimary;
            Map<String, org.checkerframework.qualframework.poly.Wildcard<Q>> qualMap;
            if (this.specialCaseAnnotations.contains(AnnotationUtils.annotationName(annotationMirror))) {
                QualParams<Q> result = this.specialCaseHandle(annotationMirror);
                qualMap = result;
                newPrimary = result.getPrimary();
            } else {
                qualMap = this.getQualifierMap(annotationMirror);
                newPrimary = this.getPrimaryAnnotation(annotationMirror);
            }
            this.mergeParams(params, qualMap);
            if (primary != null && newPrimary != null) {
                primary = primary.combineWith(newPrimary, this.lubOp);
                continue;
            }
            primary = newPrimary;
        }
        if (primary == null) {
            primary = new PolyQual.GroundQual<Q>(this.DEFAULT_QUAL);
        }
        return new QualParams(params, primary);
    }

    private void mergeParams(Map<String, org.checkerframework.qualframework.poly.Wildcard<Q>> params, Map<String, org.checkerframework.qualframework.poly.Wildcard<Q>> newParams) {
        if (newParams == null) {
            return;
        }
        for (String name : newParams.keySet()) {
            if (!params.containsKey(name)) {
                params.put(name, newParams.get(name));
                continue;
            }
            org.checkerframework.qualframework.poly.Wildcard<Q> oldWild = params.get(name);
            org.checkerframework.qualframework.poly.Wildcard<Q> newWild = newParams.get(name);
            org.checkerframework.qualframework.poly.Wildcard<Q> combinedWild = oldWild.combineWith(newWild, this.lubOp, this.lubOp);
            params.put(name, combinedWild);
        }
    }

    private Map<String, org.checkerframework.qualframework.poly.Wildcard<Q>> getQualifierMap(AnnotationMirror anno) {
        String name = AnnotationUtils.annotationName(anno);
        Map<String, org.checkerframework.qualframework.poly.Wildcard<Object>> result = null;
        if (name.startsWith(this.MULTI_ANNO_NAME_PREFIX)) {
            AnnotationMirror[] subAnnos;
            result = new HashMap<String, org.checkerframework.qualframework.poly.Wildcard<Q>>();
            for (AnnotationMirror subAnno : subAnnos = AnnotationUtils.getElementValue(anno, "value", AnnotationMirror[].class, true)) {
                this.mergeParams(result, this.getQualifierMap(subAnno));
            }
        } else if (this.supportedAnnotationNames.contains(name)) {
            Q qual = this.getQualifier(anno);
            String target = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            if (!PRIMARY_TARGET.equals(target)) {
                result = Collections.singletonMap(target, this.handleWildcard(anno, new org.checkerframework.qualframework.poly.Wildcard<Q>(qual)));
            }
        } else if (name.equals(this.varAnno.getName())) {
            String target = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            String value = AnnotationUtils.getElementValue(anno, SOURCE_VALUE_NAME, String.class, true);
            if (!PRIMARY_TARGET.equals(target)) {
                org.checkerframework.qualframework.poly.Wildcard<PolyQual.QualVar<Q>> valueWild = this.handleWildcard(anno, new org.checkerframework.qualframework.poly.Wildcard<PolyQual.QualVar<Q>>(new PolyQual.QualVar<Q>(value, this.BOTTOM, this.TOP)));
                result = Collections.singletonMap(target, valueWild);
            }
        } else if (name.equals(this.polyAnno.getName())) {
            String target = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            if (!PRIMARY_TARGET.equals(target)) {
                org.checkerframework.qualframework.poly.Wildcard<PolyQual.QualVar<Q>> polyWild = new org.checkerframework.qualframework.poly.Wildcard<PolyQual.QualVar<Q>>(new PolyQual.QualVar<Q>(POLY_NAME, this.BOTTOM, this.TOP));
                result = Collections.singletonMap(target, polyWild);
            }
        } else if (name.equals(this.wildAnno.getName())) {
            String target = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            result = Collections.singletonMap(target, new org.checkerframework.qualframework.poly.Wildcard<Q>(this.BOTTOM, this.TOP));
        }
        return result;
    }

    private org.checkerframework.qualframework.poly.Wildcard<Q> handleWildcard(AnnotationMirror anno, org.checkerframework.qualframework.poly.Wildcard<Q> current) {
        Wildcard wildcard = AnnotationUtils.getElementValueEnum(anno, WILDCARD_NAME, Wildcard.class, true);
        switch (wildcard) {
            case SUPER: {
                return new org.checkerframework.qualframework.poly.Wildcard<PolyQual.GroundQual<Q>>(current.getLowerBound(), new PolyQual.GroundQual<Q>(this.TOP));
            }
            case EXTENDS: {
                return new org.checkerframework.qualframework.poly.Wildcard<PolyQual<Q>>(new PolyQual.GroundQual<Q>(this.BOTTOM), current.getUpperBound());
            }
        }
        return current;
    }

    private PolyQual<Q> getPrimaryAnnotation(AnnotationMirror anno) {
        String target;
        String name = AnnotationUtils.annotationName(anno);
        PolyQual newQual = null;
        if (this.supportedAnnotationNames.contains(name)) {
            Q qual = this.getQualifier(anno);
            String target2 = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            if (PRIMARY_TARGET.equals(target2)) {
                newQual = new PolyQual.GroundQual<Q>(qual);
            }
        } else if (name.equals(this.varAnno.getName())) {
            String target3 = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true);
            String value = AnnotationUtils.getElementValue(anno, SOURCE_VALUE_NAME, String.class, true);
            if (PRIMARY_TARGET.equals(target3)) {
                newQual = new PolyQual.QualVar<Q>(value, this.BOTTOM, this.TOP);
            }
        } else if (name.equals(this.polyAnno.getName()) && PRIMARY_TARGET.equals(target = AnnotationUtils.getElementValue(anno, TARGET_PARAM_NAME, String.class, true))) {
            newQual = new PolyQual.QualVar<Q>(POLY_NAME, this.BOTTOM, this.TOP);
        }
        return newQual;
    }

    @Override
    public boolean isAnnotationSupported(AnnotationMirror anno) {
        String name = AnnotationUtils.annotationName(anno);
        return name.startsWith(this.MULTI_ANNO_NAME_PREFIX) || this.specialCaseAnnotations.contains(name) || this.getQualifierMap(anno) != null || this.getPrimaryAnnotation(anno) != null;
    }

    @Override
    public Set<String> getDeclaredParameters(Element elt, ExtendedTypeMirror type) {
        HashSet<String> result = new HashSet<String>();
        try {
            for (Annotation a : elt.getAnnotationsByType(this.methodAnno)) {
                result.add((String)this.methodAnno.cast(a).getClass().getMethod("value", new Class[0]).invoke((Object)a, new Object[0]));
            }
            for (Annotation a : elt.getAnnotationsByType(this.classAnno)) {
                result.add((String)this.classAnno.cast(a).getClass().getMethod("value", new Class[0]).invoke((Object)a, new Object[0]));
            }
        }
        catch (Exception e) {
            ErrorReporter.errorAbort("AnnotationConverter not configured correctly. Error looking up 'value' field.");
        }
        switch (elt.getKind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                if (!this.hasPolyAnnotation((ExtendedExecutableType)type)) break;
                result.add(POLY_NAME);
                break;
            }
        }
        return result;
    }

    private boolean hasPolyAnnotation(ExtendedExecutableType type) {
        if (this.hasPolyAnnotationCheck(type.getReturnType())) {
            return true;
        }
        if (this.hasPolyAnnotationCheck(type.getReceiverType())) {
            return true;
        }
        for (ExtendedTypeMirror extendedTypeMirror : type.getParameterTypes()) {
            if (!this.hasPolyAnnotationCheck(extendedTypeMirror)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPolyAnnotationCheck(ExtendedTypeMirror type) {
        if (type == null) {
            return false;
        }
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!AnnotationUtils.annotationName(annotationMirror).equals(this.polyAnno.getName())) continue;
            return true;
        }
        return false;
    }
}

