/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.qualframework.base.AnnotationConverter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.TypeAnnotatorAdapter;
import org.checkerframework.qualframework.util.ExtendedArrayType;
import org.checkerframework.qualframework.util.ExtendedDeclaredType;
import org.checkerframework.qualframework.util.ExtendedErrorType;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedIntersectionType;
import org.checkerframework.qualframework.util.ExtendedNoType;
import org.checkerframework.qualframework.util.ExtendedNullType;
import org.checkerframework.qualframework.util.ExtendedParameterDeclaration;
import org.checkerframework.qualframework.util.ExtendedPrimitiveType;
import org.checkerframework.qualframework.util.ExtendedTypeDeclaration;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.ExtendedTypeVariable;
import org.checkerframework.qualframework.util.ExtendedTypeVisitor;
import org.checkerframework.qualframework.util.ExtendedUnionType;
import org.checkerframework.qualframework.util.ExtendedWildcardType;
import org.checkerframework.qualframework.util.QualifierContext;

public class TypeAnnotator<Q>
implements ExtendedTypeVisitor<QualifiedTypeMirror<Q>, Void> {
    private AnnotationConverter<Q> annotationConverter;
    private Q defaultQual;
    private TypeAnnotatorAdapter<Q> adapter;
    protected QualifierContext<Q> qualContext;

    public TypeAnnotator(QualifierContext<Q> qualContext, AnnotationConverter<Q> annotationConverter, Q defaultQual) {
        this.annotationConverter = annotationConverter;
        this.defaultQual = defaultQual;
        this.qualContext = qualContext;
    }

    void setAdapter(TypeAnnotatorAdapter<Q> adapter) {
        this.adapter = adapter;
    }

    public AnnotationConverter<Q> getAnnotationConverter() {
        return this.annotationConverter;
    }

    public QualifiedTypeMirror<Q> visit(ExtendedTypeMirror type, Void p) {
        if (type == null) {
            return null;
        }
        return (QualifiedTypeMirror)type.accept(this, null);
    }

    private List<QualifiedTypeMirror<Q>> mapVisit(List<? extends ExtendedTypeMirror> types, Void p) {
        ArrayList<QualifiedTypeMirror<Q>> result = new ArrayList<QualifiedTypeMirror<Q>>();
        for (ExtendedTypeMirror extendedTypeMirror : types) {
            result.add(this.visit(extendedTypeMirror, null));
        }
        return result;
    }

    protected Q getQualifier(ExtendedTypeMirror type) {
        Q qual = this.adapter.getExistingQualifier(type);
        if (qual == null) {
            qual = this.annotationConverter.fromAnnotations(type.getAnnotationMirrors());
        }
        if (qual == null) {
            qual = this.defaultQual;
        }
        return qual;
    }

    @Override
    public QualifiedTypeMirror<Q> visitArray(ExtendedArrayType type, Void p) {
        return new QualifiedTypeMirror.QualifiedArrayType<Q>((ExtendedTypeMirror)type, this.getQualifier(type), this.visit(type.getComponentType(), null));
    }

    @Override
    public QualifiedTypeMirror<Q> visitDeclared(ExtendedDeclaredType type, Void p) {
        QualifiedTypeMirror.QualifiedDeclaredType<Q> result = new QualifiedTypeMirror.QualifiedDeclaredType<Q>((ExtendedTypeMirror)type, this.getQualifier(type), this.mapVisit(type.getTypeArguments(), null));
        return result;
    }

    @Override
    public QualifiedTypeMirror<Q> visitError(ExtendedErrorType type, Void p) {
        throw new UnsupportedOperationException("saw unexpected ExtendedErrorType");
    }

    @Override
    public QualifiedTypeMirror<Q> visitExecutable(ExtendedExecutableType type, Void p) {
        ArrayList<QualifiedTypeMirror.QualifiedParameterDeclaration> qualifiedParameters = new ArrayList<QualifiedTypeMirror.QualifiedParameterDeclaration>();
        for (ExtendedParameterDeclaration extendedParameterDeclaration : type.getTypeParameters()) {
            QualifiedTypeMirror.QualifiedParameterDeclaration qualifiedParam = (QualifiedTypeMirror.QualifiedParameterDeclaration)this.visit(extendedParameterDeclaration, null);
            qualifiedParameters.add(qualifiedParam);
        }
        return new QualifiedTypeMirror.QualifiedExecutableType<Q>(type, this.mapVisit(type.getParameterTypes(), null), this.visit(type.getReceiverType(), null), this.visit(type.getReturnType(), null), this.mapVisit(type.getThrownTypes(), null), qualifiedParameters);
    }

    @Override
    public QualifiedTypeMirror<Q> visitIntersection(ExtendedIntersectionType type, Void p) {
        return new QualifiedTypeMirror.QualifiedIntersectionType<Q>((ExtendedTypeMirror)type, this.getQualifier(type), this.mapVisit(type.getBounds(), null));
    }

    @Override
    public QualifiedTypeMirror<Q> visitNoType(ExtendedNoType type, Void p) {
        return new QualifiedTypeMirror.QualifiedNoType<Q>((ExtendedTypeMirror)type, this.getQualifier(type));
    }

    @Override
    public QualifiedTypeMirror<Q> visitNull(ExtendedNullType type, Void p) {
        return new QualifiedTypeMirror.QualifiedNullType<Q>((ExtendedTypeMirror)type, this.getQualifier(type));
    }

    @Override
    public QualifiedTypeMirror<Q> visitPrimitive(ExtendedPrimitiveType type, Void p) {
        return new QualifiedTypeMirror.QualifiedPrimitiveType<Q>((ExtendedTypeMirror)type, this.getQualifier(type));
    }

    @Override
    public QualifiedTypeMirror<Q> visitTypeVariable(ExtendedTypeVariable type, Void p) {
        return new QualifiedTypeMirror.QualifiedTypeVariable<Q>((ExtendedTypeMirror)type, this.getQualifier(type));
    }

    @Override
    public QualifiedTypeMirror<Q> visitUnion(ExtendedUnionType type, Void p) {
        return new QualifiedTypeMirror.QualifiedUnionType<Q>((ExtendedTypeMirror)type, this.getQualifier(type), this.mapVisit(type.getAlternatives(), null));
    }

    @Override
    public QualifiedTypeMirror<Q> visitWildcard(ExtendedWildcardType type, Void p) {
        return new QualifiedTypeMirror.QualifiedWildcardType<Q>((ExtendedTypeMirror)type, this.visit(type.getExtendsBound(), null), this.visit(type.getSuperBound(), null));
    }

    @Override
    public QualifiedTypeMirror<Q> visitParameterDeclaration(ExtendedParameterDeclaration type, Void p) {
        return new QualifiedTypeMirror.QualifiedParameterDeclaration(type);
    }

    @Override
    public QualifiedTypeMirror<Q> visitTypeDeclaration(ExtendedTypeDeclaration type, Void p) {
        List<QualifiedTypeMirror<Q>> params = this.mapVisit(type.getTypeParameters(), null);
        QualifiedTypeMirror.QualifiedTypeDeclaration<Q> result = new QualifiedTypeMirror.QualifiedTypeDeclaration<Q>((ExtendedTypeMirror)type, this.getQualifier(type), params);
        return result;
    }
}

