/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.TypeFromElement;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.ConstructorReturnUtil;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

abstract class TypeFromTree
extends SimpleTreeVisitor<AnnotatedTypeMirror, AnnotatedTypeFactory> {
    public static final TypeFromExpression TypeFromExpressionINSTANCE = new TypeFromExpression();
    public static final TypeFromMember TypeFromMemberINSTANCE = new TypeFromMember();
    public static final TypeFromClass TypeFromClassINSTANCE = new TypeFromClass();
    public static final TypeFromTypeTree TypeFromTypeTreeINSTANCE = new TypeFromTypeTree();

    TypeFromTree() {
    }

    @Override
    public AnnotatedTypeMirror defaultAction(Tree node, AnnotatedTypeFactory f) {
        if (node == null) {
            ErrorReporter.errorAbort("TypeFromTree.defaultAction: null tree");
            return null;
        }
        ErrorReporter.errorAbort("TypeFromTree.defaultAction: conversion undefined for tree type " + (Object)((Object)node.getKind()));
        return null;
    }

    private static void inferLambdaParamAnnotations(AnnotatedTypeFactory f, AnnotatedTypeMirror result, Element paramElement) {
        if (f.declarationFromElement(paramElement) == null || f.getPath(f.declarationFromElement(paramElement)) == null || f.getPath(f.declarationFromElement(paramElement)).getParentPath() == null) {
            return;
        }
        Tree declaredInTree = f.getPath(f.declarationFromElement(paramElement)).getParentPath().getLeaf();
        if (declaredInTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            LambdaExpressionTree lambdaDecl = (LambdaExpressionTree)declaredInTree;
            int index = lambdaDecl.getParameters().indexOf(f.declarationFromElement(paramElement));
            Pair<AnnotatedTypeMirror.AnnotatedDeclaredType, AnnotatedTypeMirror.AnnotatedExecutableType> res = f.getFnInterfaceFromTree(lambdaDecl);
            AnnotatedTypeMirror.AnnotatedExecutableType fnMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)res.second;
            AnnotatedTypeMirror declaredParam = fnMethod.getParameterTypes().get(index);
            result.addMissingAnnotations(declaredParam.getAnnotations());
        }
    }

    private static class TypeFromTypeTree
    extends TypeFromTree {
        private final Map<Tree, AnnotatedTypeMirror> visitedBounds = new HashMap<Tree, AnnotatedTypeMirror>();

        private TypeFromTypeTree() {
        }

        @Override
        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = (AnnotatedTypeMirror)this.visit(node.getUnderlyingType(), f);
            if (type == null) {
                type = f.toAnnotatedType(f.types.getNoType(TypeKind.NONE), false);
            }
            assert (AnnotatedTypeFactory.validAnnotatedType(type));
            List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromTree(node);
            type.addAnnotations(annos);
            if (type.getKind() == TypeKind.TYPEVAR) {
                ((AnnotatedTypeMirror.AnnotatedTypeVariable)type).getUpperBound().addMissingAnnotations(annos);
            }
            if (type.getKind() == TypeKind.WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)type).getExtendsBound().addMissingAnnotations(annos);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror component = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            ((AnnotatedTypeMirror.AnnotatedArrayType)result).setComponentType(component);
            return result;
        }

        @Override
        public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
            LinkedList args = new LinkedList();
            for (Tree tree : node.getTypeArguments()) {
                args.add(this.visit(tree, f));
            }
            AnnotatedTypeMirror result = f.type(node);
            AnnotatedTypeMirror annotatedTypeMirror = (AnnotatedTypeMirror)this.visit(node.getType(), f);
            result.addAnnotations(annotatedTypeMirror.getAnnotations());
            if (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) {
                assert (result instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : node + " --> " + result;
                ((AnnotatedTypeMirror.AnnotatedDeclaredType)result).setTypeArguments(args);
            }
            return result;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitTypeParameter(TypeParameterTree node, AnnotatedTypeFactory f) {
            LinkedList<AnnotatedTypeMirror> bounds = new LinkedList<AnnotatedTypeMirror>();
            for (Tree tree : node.getBounds()) {
                AnnotatedTypeMirror bound;
                if (this.visitedBounds.containsKey(tree) && f == this.visitedBounds.get((Object)tree).atypeFactory) {
                    bound = this.visitedBounds.get(tree);
                } else {
                    this.visitedBounds.put(tree, f.type(tree));
                    bound = (AnnotatedTypeMirror)this.visit(tree, f);
                    this.visitedBounds.remove(tree);
                }
                bounds.add(bound);
            }
            AnnotatedTypeMirror.AnnotatedTypeVariable result = (AnnotatedTypeMirror.AnnotatedTypeVariable)f.type(node);
            List<? extends AnnotationMirror> list = InternalUtils.annotationsFromTree(node);
            result.addAnnotations(list);
            result.getUpperBound().addAnnotations(list);
            switch (bounds.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    result.setUpperBound((AnnotatedTypeMirror)bounds.get(0));
                    break;
                }
                default: {
                    AnnotatedTypeMirror.AnnotatedIntersectionType upperBound = (AnnotatedTypeMirror.AnnotatedIntersectionType)result.getUpperBound();
                    ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> superBounds = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>(bounds.size());
                    for (AnnotatedTypeMirror b : bounds) {
                        superBounds.add((AnnotatedTypeMirror.AnnotatedDeclaredType)b);
                    }
                    upperBound.setDirectSuperTypes(superBounds);
                }
            }
            return result;
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setExtendsBound(bound);
            }
            return result;
        }

        private AnnotatedTypeMirror forTypeVariable(AnnotatedTypeMirror type, AnnotatedTypeFactory f) {
            if (type.getKind() != TypeKind.TYPEVAR) {
                ErrorReporter.errorAbort("TypeFromTree.forTypeVariable: should only be called on type variables");
                return null;
            }
            TypeVariable typeVar = (TypeVariable)type.getUnderlyingType();
            TypeParameterElement tpe = (TypeParameterElement)typeVar.asElement();
            Element elt = tpe.getGenericElement();
            if (elt instanceof TypeElement) {
                TypeElement typeElt = (TypeElement)elt;
                int idx = typeElt.getTypeParameters().indexOf(tpe);
                ClassTree cls = (ClassTree)f.declarationFromElement(typeElt);
                if (cls != null) {
                    AnnotatedTypeMirror result = ((AnnotatedTypeMirror)this.visit(cls.getTypeParameters().get(idx), f)).getCopy(true);
                    ((AnnotatedTypeMirror.AnnotatedTypeVariable)result).setDeclaration(false);
                    return result;
                }
                return type;
            }
            if (elt instanceof ExecutableElement) {
                ExecutableElement exElt = (ExecutableElement)elt;
                int idx = exElt.getTypeParameters().indexOf(tpe);
                MethodTree meth = (MethodTree)f.declarationFromElement(exElt);
                if (meth != null) {
                    AnnotatedTypeMirror result = ((AnnotatedTypeMirror)this.visit(meth.getTypeParameters().get(idx), f)).getCopy(true);
                    ((AnnotatedTypeMirror.AnnotatedTypeVariable)result).setDeclaration(false);
                    return result;
                }
                return type;
            }
            if (InternalUtils.isCaptured(typeVar)) {
                return type;
            }
            ErrorReporter.errorAbort("TypeFromTree.forTypeVariable: not a supported element: " + elt);
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.type(node);
            if (type.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type, f);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.type(node);
            if (type.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type, f);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitUnionType(UnionTypeTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror type = f.type(node);
            if (type.getKind() == TypeKind.TYPEVAR) {
                return this.forTypeVariable(type, f);
            }
            return type;
        }
    }

    private static class TypeFromClass
    extends TypeFromTree {
        private TypeFromClass() {
        }

        @Override
        public AnnotatedTypeMirror visitClass(ClassTree node, AnnotatedTypeFactory f) {
            TypeElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror result = f.toAnnotatedType(elt.asType(), true);
            TypeFromElement.annotate(result, elt);
            return result;
        }
    }

    private static class TypeFromMember
    extends TypeFromTree {
        private TypeFromMember() {
        }

        @Override
        public AnnotatedTypeMirror visitVariable(VariableTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror result = f.fromTypeTree(node.getType());
            result.clearAnnotations();
            VariableElement elt = TreeUtils.elementFromDeclaration(node);
            TypeFromElement.annotate(result, elt);
            TypeFromTree.inferLambdaParamAnnotations(f, result, elt);
            return result;
        }

        @Override
        public AnnotatedTypeMirror visitMethod(MethodTree node, AnnotatedTypeFactory f) {
            ExecutableElement elt = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType result = (AnnotatedTypeMirror.AnnotatedExecutableType)f.toAnnotatedType(elt.asType(), false);
            result.setElement(elt);
            TypeFromElement.annotate((AnnotatedTypeMirror)result, elt);
            return result;
        }
    }

    private static class TypeFromExpression
    extends TypeFromTree {
        private TypeFromExpression() {
        }

        @Override
        public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AnnotatedTypeMirror visitArrayAccess(ArrayAccessTree node, AnnotatedTypeFactory f) {
            Pair<Tree, AnnotatedTypeMirror> preAssCtxt = f.visitorState.getAssignmentContext();
            try {
                f.visitorState.setAssignmentContext(null);
                AnnotatedTypeMirror type = f.getAnnotatedType(node.getExpression());
                assert (type instanceof AnnotatedTypeMirror.AnnotatedArrayType);
                AnnotatedTypeMirror annotatedTypeMirror = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
                return annotatedTypeMirror;
            }
            finally {
                f.visitorState.setAssignmentContext(preAssCtxt);
            }
        }

        @Override
        public AnnotatedTypeMirror visitAssignment(AssignmentTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
        }

        @Override
        public AnnotatedTypeMirror visitBinary(BinaryTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror res = f.type(node);
            res.clearAnnotations();
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror res = (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
            res.clearAnnotations();
            return res;
        }

        @Override
        public AnnotatedTypeMirror visitConditionalExpression(ConditionalExpressionTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror falseType;
            AnnotatedTypeMirror trueType = f.getAnnotatedType(node.getTrueExpression());
            if (trueType.equals(falseType = f.getAnnotatedType(node.getFalseExpression()))) {
                return trueType;
            }
            AnnotatedTypeMirror alub = f.type(node);
            AnnotatedTypeMirror assuper = AnnotatedTypes.asSuper(f.types, f, trueType, alub);
            if (assuper != null) {
                trueType = assuper;
            }
            if ((assuper = AnnotatedTypes.asSuper(f.types, f, falseType, alub)) != null) {
                falseType = assuper;
            }
            if (trueType != null && trueType.equals(falseType)) {
                return trueType;
            }
            ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
            types.add(trueType);
            types.add(falseType);
            AnnotatedTypes.annotateAsLub(f.processingEnv, f, alub, types);
            return alub;
        }

        @Override
        public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
            if (node.getName().contentEquals("this") || node.getName().contentEquals("super")) {
                AnnotatedTypeMirror.AnnotatedDeclaredType res = f.getSelfType(node);
                return res;
            }
            Element elt = TreeUtils.elementFromUse(node);
            AnnotatedTypeMirror.AnnotatedDeclaredType selfType = f.getImplicitReceiverType(node);
            if (selfType != null) {
                return AnnotatedTypes.asMemberOf(f.types, f, (AnnotatedTypeMirror)selfType, elt).asUse();
            }
            return f.getAnnotatedType(elt);
        }

        @Override
        public AnnotatedTypeMirror visitInstanceOf(InstanceOfTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitLiteral(LiteralTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
            Element elt = TreeUtils.elementFromUse(node);
            if (elt.getKind().isClass() || elt.getKind().isInterface()) {
                return f.fromElement(elt);
            }
            if (!(node.getExpression() instanceof PrimitiveTypeTree)) {
                if (node.getIdentifier().contentEquals("this")) {
                    return f.getEnclosingType((TypeElement)InternalUtils.symbol(node.getExpression()), node);
                }
                AnnotatedTypeMirror t = f.getAnnotatedType(node.getExpression());
                if (t instanceof AnnotatedTypeMirror.AnnotatedDeclaredType || t instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
                    return AnnotatedTypes.asMemberOf(f.types, f, t, elt).asUse();
                }
            }
            return f.fromElement(elt);
        }

        @Override
        public AnnotatedTypeMirror visitMethodInvocation(MethodInvocationTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.methodFromUse((MethodInvocationTree)node).first;
            return ex.getReturnType().asUse();
        }

        @Override
        public AnnotatedTypeMirror visitNewArray(NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedArrayType result = (AnnotatedTypeMirror.AnnotatedArrayType)f.type(node);
            if (node.getType() == null) {
                return result;
            }
            this.annotateArrayAsArray(result, node, f);
            return result;
        }

        private AnnotatedTypeMirror descendBy(AnnotatedTypeMirror type, int depth) {
            AnnotatedTypeMirror result = type;
            while (depth > 0) {
                result = ((AnnotatedTypeMirror.AnnotatedArrayType)result).getComponentType();
                --depth;
            }
            return result;
        }

        private void annotateArrayAsArray(AnnotatedTypeMirror.AnnotatedArrayType result, NewArrayTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror treeElem = f.fromTypeTree(node.getType());
            boolean hasInit = node.getInitializers() != null;
            AnnotatedTypeMirror typeElem = this.descendBy(result, hasInit ? 1 : node.getDimensions().size());
            while (true) {
                typeElem.addAnnotations(treeElem.getAnnotations());
                if (!(treeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType)) break;
                assert (typeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType);
                treeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)treeElem).getComponentType();
                typeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)typeElem).getComponentType();
            }
            int idx = 0;
            AnnotatedTypeMirror level = result;
            while (level.getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType array = level;
                List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromArrayCreation(node, idx++);
                array.addAnnotations(annos);
                level = array.getComponentType();
            }
            result.addAnnotations(InternalUtils.annotationsFromArrayCreation(node, -1));
        }

        @Override
        public AnnotatedTypeMirror visitNewClass(NewClassTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedDeclaredType type = f.fromNewClass(node);
            if (this.isNewEnum(type)) {
                return type;
            }
            AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.constructorFromUse((NewClassTree)node).first;
            ConstructorReturnUtil.keepOnlyExplicitConstructorAnnotations(f, type, ex);
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitMemberReference(MemberReferenceTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)f.toAnnotatedType(InternalUtils.typeOf(node), false);
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitLambdaExpression(LambdaExpressionTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)f.toAnnotatedType(InternalUtils.typeOf(node), false);
            return type;
        }

        private boolean isNewEnum(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
            return type.getUnderlyingType().asElement().getKind() == ElementKind.ENUM;
        }

        @Override
        public AnnotatedTypeMirror visitParenthesized(ParenthesizedTree node, AnnotatedTypeFactory f) {
            return (AnnotatedTypeMirror)this.visit(node.getExpression(), f);
        }

        @Override
        public AnnotatedTypeMirror visitTypeCast(TypeCastTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node.getType());
        }

        @Override
        public AnnotatedTypeMirror visitUnary(UnaryTree node, AnnotatedTypeFactory f) {
            return f.type(node);
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
            AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
            AnnotatedTypeMirror result = f.type(node);
            assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
            if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setSuperBound(bound);
            } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
                ((AnnotatedTypeMirror.AnnotatedWildcardType)result).setExtendsBound(bound);
            }
            return result;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        @Override
        public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }

        @Override
        public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
            return f.fromTypeTree(node);
        }
    }
}

