/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.regex_qual_poly;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.checker.experimental.regex_qual.RegexQualifierHierarchy;
import org.checkerframework.checker.experimental.regex_qual_poly.RegexAnnotationConverter;
import org.checkerframework.checker.experimental.regex_qual_poly.RegexQualifiedTransfer;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.SetQualifierVisitor;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.poly.CombiningOperation;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterTreeAnnotator;
import org.checkerframework.qualframework.poly.QualifierParameterTypeFactory;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class RegexQualifiedTypeFactory
extends QualifierParameterTypeFactory<Regex> {
    private CombiningOperation<Regex> lubOp = new CombiningOperation.Lub<Regex>(new RegexQualifierHierarchy());
    private final ExecutableElement patternCompile = TreeUtils.getMethod("java.util.regex.Pattern", "compile", 1, this.getContext().getProcessingEnvironment());

    public RegexQualifiedTypeFactory(QualifierContext<QualParams<Regex>> checker) {
        super(checker);
    }

    @Override
    protected QualifierHierarchy<Regex> createGroundQualifierHierarchy() {
        return new RegexQualifierHierarchy();
    }

    @Override
    protected RegexAnnotationConverter createAnnotationConverter() {
        return new RegexAnnotationConverter();
    }

    @Override
    protected QualifierParameterTreeAnnotator<Regex> createTreeAnnotator() {
        return new QualifierParameterTreeAnnotator<Regex>((QualifierParameterTypeFactory)this){

            @Override
            public QualifiedTypeMirror<QualParams<Regex>> visitLiteral(LiteralTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Object> result = super.visitLiteral(tree, type);
                if (tree.getKind() == Tree.Kind.NULL_LITERAL) {
                    return SetQualifierVisitor.apply(result, QualParams.getBottom());
                }
                String regexStr = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    regexStr = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    regexStr = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (regexStr != null) {
                    Regex regexQual;
                    if (RegexQualifiedTypeFactory.isRegex(regexStr)) {
                        int groupCount = RegexQualifiedTypeFactory.getGroupCount(regexStr);
                        regexQual = new Regex.RegexVal(groupCount);
                    } else {
                        regexQual = new Regex.PartialRegex(regexStr);
                    }
                    Object clone = result.getQualifier().clone();
                    ((QualParams)clone).setPrimary(new PolyQual.GroundQual<Regex.PartialRegex>((Regex.PartialRegex)regexQual));
                    result = SetQualifierVisitor.apply(result, clone);
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<QualParams<Regex>> visitCompoundAssignment(CompoundAssignmentTree tree, ExtendedTypeMirror type) {
                QualParams rRegex;
                QualParams lRegex;
                QualifiedTypeMirror<QualParams<Regex>> result;
                if ((TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation(tree)) && (result = this.handleBinaryOperation(tree, lRegex = (QualParams)RegexQualifiedTypeFactory.this.getQualifiedType(tree.getExpression()).getQualifier(), rRegex = (QualParams)RegexQualifiedTypeFactory.this.getQualifiedType(tree.getVariable()).getQualifier(), type)) != null) {
                    return result;
                }
                return super.visitCompoundAssignment(tree, type);
            }

            @Override
            public QualifiedTypeMirror<QualParams<Regex>> visitMethodInvocation(MethodInvocationTree tree, ExtendedTypeMirror type) {
                QualifiedTypeMirror<Object> result = super.visitMethodInvocation(tree, type);
                if (TreeUtils.isMethodInvocation(tree, RegexQualifiedTypeFactory.this.patternCompile, RegexQualifiedTypeFactory.this.getContext().getProcessingEnvironment())) {
                    ExpressionTree arg0 = tree.getArguments().get(0);
                    if (RegexQualifiedTypeFactory.this.getQualifiedType(arg0).getQualifier() == QualParams.getBottom()) {
                        result = SetQualifierVisitor.apply(result, QualParams.getBottom());
                    } else {
                        Regex qual = (Regex)((QualParams)RegexQualifiedTypeFactory.this.getQualifiedType(arg0).getQualifier()).getPrimary().getMaximum();
                        Object clone = result.getQualifier().clone();
                        ((QualParams)clone).setPrimary(new PolyQual.GroundQual<Regex>(qual));
                        result = SetQualifierVisitor.apply(result, clone);
                    }
                }
                return result;
            }

            @Override
            public QualifiedTypeMirror<QualParams<Regex>> visitBinary(BinaryTree tree, ExtendedTypeMirror type) {
                QualParams rRegex;
                QualParams lRegex;
                QualifiedTypeMirror<QualParams<Regex>> result;
                if ((TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation((CompoundAssignmentTree)((Object)tree))) && (result = this.handleBinaryOperation(tree, lRegex = (QualParams)RegexQualifiedTypeFactory.this.getQualifiedType(tree.getLeftOperand()).getQualifier(), rRegex = (QualParams)RegexQualifiedTypeFactory.this.getQualifiedType(tree.getRightOperand()).getQualifier(), type)) != null) {
                    return result;
                }
                return super.visitBinary(tree, type);
            }

            private QualifiedTypeMirror<QualParams<Regex>> handleBinaryOperation(Tree tree, QualParams<Regex> lRegexParam, QualParams<Regex> rRegexParam, ExtendedTypeMirror type) {
                if (TreeUtils.isStringConcatenation(tree) || tree instanceof CompoundAssignmentTree && TreeUtils.isStringCompoundConcatenation((CompoundAssignmentTree)tree)) {
                    Regex lRegex;
                    PolyQual<Regex> resultQual = null;
                    PolyQual<Regex> rPrimary = rRegexParam.getPrimary();
                    PolyQual<Regex> lPrimary = lRegexParam.getPrimary();
                    Regex rRegex = RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom() == rRegexParam ? new Regex.RegexVal(0) : rPrimary.getMaximum();
                    Regex regex = lRegex = RegexQualifiedTypeFactory.this.getQualifierHierarchy().getBottom() == lRegexParam ? new Regex.RegexVal(0) : lPrimary.getMaximum();
                    if (RegexQualifiedTypeFactory.this.isPolyRegex(rPrimary) && RegexQualifiedTypeFactory.this.isPolyRegex(lPrimary)) {
                        resultQual = rPrimary;
                    } else if (RegexQualifiedTypeFactory.this.isPolyPlusRegex(rPrimary, lRegex)) {
                        resultQual = rPrimary;
                    } else if (RegexQualifiedTypeFactory.this.isPolyPlusRegex(lPrimary, rRegex)) {
                        resultQual = lPrimary;
                    } else if (lRegex.isRegexVal() && rRegex.isRegexVal()) {
                        int resultCount = ((Regex.RegexVal)lRegex).getCount() + ((Regex.RegexVal)rRegex).getCount();
                        resultQual = new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(resultCount));
                    } else if (lRegex.isPartialRegex() && rRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + ((Regex.PartialRegex)rRegex).getPartialValue();
                        if (RegexQualifiedTypeFactory.isRegex(concat)) {
                            int groupCount = RegexQualifiedTypeFactory.getGroupCount(concat);
                            resultQual = new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(groupCount));
                        } else {
                            resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                        }
                    } else if (lRegex.isRegexVal() && rRegex.isPartialRegex()) {
                        String concat = "e" + ((Regex.PartialRegex)rRegex).getPartialValue();
                        resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                    } else if (rRegex.isRegexVal() && lRegex.isPartialRegex()) {
                        String concat = ((Regex.PartialRegex)lRegex).getPartialValue() + "e";
                        resultQual = new PolyQual.GroundQual<Regex.PartialRegex>(new Regex.PartialRegex(concat));
                    } else if (rRegex == Regex.TOP || lRegex == Regex.TOP) {
                        resultQual = new PolyQual.GroundQual<Regex>(Regex.TOP);
                    } else if (rRegex == Regex.BOTTOM && lRegex == Regex.BOTTOM) {
                        resultQual = new PolyQual.GroundQual<Regex>(Regex.BOTTOM);
                    }
                    if (resultQual != null) {
                        return new QualifiedTypeMirror.QualifiedDeclaredType<QualParams<Regex>>(type, new QualParams<Regex>(resultQual), new ArrayList());
                    }
                }
                return null;
            }
        };
    }

    private boolean isPolyPlusRegex(PolyQual<Regex> possiblePoly, Regex other) {
        return this.isPolyRegex(possiblePoly) && other.isRegexVal();
    }

    private boolean isPolyRegex(PolyQual<Regex> possiblePoly) {
        return possiblePoly instanceof PolyQual.QualVar && ((PolyQual.QualVar)possiblePoly).getName().equals("_poly");
    }

    public static int getGroupCount(@org.checkerframework.checker.experimental.regex_qual_poly.qual.Regex String regex) {
        return Pattern.compile(regex).matcher("").groupCount();
    }

    @Pure
    private static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public QualAnalysis<QualParams<Regex>> createFlowAnalysis(List<Pair<VariableElement, QualValue<QualParams<Regex>>>> fieldValues) {
        return new QualAnalysis<QualParams<Regex>>(this.getContext()){

            @Override
            public QualTransfer<QualParams<Regex>> createTransferFunction() {
                return new RegexQualifiedTransfer(this);
            }
        };
    }

    @Override
    protected Wildcard<Regex> combineForSubstitution(Wildcard<Regex> a, Wildcard<Regex> b) {
        return a.combineWith(b, this.lubOp, this.lubOp);
    }

    @Override
    protected PolyQual<Regex> combineForSubstitution(PolyQual<Regex> a, PolyQual<Regex> b) {
        return a.combineWith(b, this.lubOp);
    }
}

