/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.regex_qual_poly;

import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualStore;
import org.checkerframework.qualframework.base.dataflow.QualTransfer;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;

public class RegexQualifiedTransfer
extends QualTransfer<QualParams<Regex>> {
    private static final String IS_REGEX_METHOD_NAME = "isRegex";
    private static final String AS_REGEX_METHOD_NAME = "asRegex";

    public RegexQualifiedTransfer(QualAnalysis<QualParams<Regex>> analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> visitMethodInvocation(MethodInvocationNode n, TransferInput<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> in) {
        TransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>> result = super.visitMethodInvocation(n, in);
        MethodAccessNode target = n.getTarget();
        ExecutableElement method = target.getMethod();
        Node receiver = target.getReceiver();
        if (!(receiver instanceof ClassNameNode)) {
            return result;
        }
        ClassNameNode cn = (ClassNameNode)receiver;
        String receiverName = cn.getElement().toString();
        if (this.isRegexUtil(receiverName)) {
            if (ElementUtils.matchesElement(method, IS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
                ConditionalTransferResult<QualValue<QualParams<Regex>>, Store> newResult;
                block10: {
                    QualStore<QualParams<Regex>> thenStore = result.getRegularStore();
                    Store elseStore = thenStore.copy();
                    newResult = new ConditionalTransferResult<QualValue<QualParams<Regex>>, Store>(result.getResultValue(), thenStore, elseStore);
                    FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.buildFlowExprContextForUse(n, this.analysis.getContext());
                    try {
                        FlowExpressions.Receiver firstParam = FlowExpressionParseUtil.parse("#1", context, this.analysis.getContext().getTypeFactory().getPath(n.getTree()));
                        Node count = n.getArgument(1);
                        if (count instanceof IntegerLiteralNode) {
                            IntegerLiteralNode iln = (IntegerLiteralNode)count;
                            Integer groupCount = iln.getValue();
                            Regex.RegexVal regex = new Regex.RegexVal(groupCount);
                            thenStore.insertValue(firstParam, new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(regex)));
                        } else {
                            thenStore.insertValue(firstParam, new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(0))));
                        }
                    }
                    catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError();
                    }
                }
                return newResult;
            }
            if (ElementUtils.matchesElement(method, AS_REGEX_METHOD_NAME, String.class, Integer.TYPE)) {
                QualParams<Regex.RegexVal> regex;
                Node count = n.getArgument(1);
                if (count instanceof IntegerLiteralNode) {
                    IntegerLiteralNode iln = (IntegerLiteralNode)count;
                    Integer groupCount = iln.getValue();
                    regex = new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(groupCount)));
                } else {
                    regex = new QualParams<Regex.RegexVal>(new PolyQual.GroundQual<Regex.RegexVal>(new Regex.RegexVal(0)));
                }
                QualValue<QualParams<Regex.RegexVal>> newResultValue = this.analysis.createSingleAnnotationValue(regex, result.getResultValue().getType().getUnderlyingType().getOriginalType());
                return new RegularTransferResult<QualValue<QualParams<Regex>>, QualStore<QualParams<Regex>>>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }

    private boolean isRegexUtil(String receiver) {
        return receiver.equals("RegexUtil") || receiver.endsWith(".RegexUtil");
    }
}

