/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.qualframework.poly.Wildcard;

public class QualParams<Q>
implements Map<String, Wildcard<Q>> {
    private Map<String, Wildcard<Q>> map;
    private static final QualParams BOTTOM = new QualParams("__BOTTOM__", (Wildcard)null);
    private static final QualParams TOP = new QualParams("__TOP__", (Wildcard)null);

    public QualParams() {
        this.map = new HashMap<String, Wildcard<Q>>();
    }

    public QualParams(String name, Q qual) {
        this(name, new Wildcard<Q>(qual));
    }

    public QualParams(String name, Wildcard<Q> qual) {
        this();
        this.map.put(name, qual);
    }

    public QualParams(Map<String, Wildcard<Q>> map) {
        this.map = new HashMap<String, Wildcard<Q>>(map);
    }

    public static <Q> QualParams<Q> getBottom() {
        return BOTTOM;
    }

    public static <Q> QualParams<Q> getTop() {
        return TOP;
    }

    public QualParams<Q> substitute(String name, Wildcard<Q> substValue) {
        HashMap<String, Wildcard<Q>> subst = new HashMap<String, Wildcard<Q>>();
        subst.put(name, substValue);
        return this.substituteAll(subst);
    }

    public QualParams<Q> substituteAll(Map<String, Wildcard<Q>> substs) {
        if (this == QualParams.getTop() || this == QualParams.getBottom()) {
            return this;
        }
        HashMap<String, Wildcard<Q>> newMap = new HashMap<String, Wildcard<Q>>();
        for (String k : this.map.keySet()) {
            Wildcard<Q> newValue = this.map.get(k).substitute(substs);
            newMap.put(k, newValue);
        }
        return new QualParams<Q>(newMap);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Wildcard<Q>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(QualParams.class)) {
            return false;
        }
        QualParams other = (QualParams)o;
        return this.map.equals(other.map);
    }

    @Override
    public Wildcard<Q> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Wildcard<Q> put(String key, Wildcard<Q> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Wildcard<Q>> m3) {
        this.map.putAll(m3);
    }

    @Override
    public Wildcard<Q> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<Wildcard<Q>> values() {
        return this.map.values();
    }
}

