/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;

public class AnnotatedTypeScanner<R, P>
implements AnnotatedTypeVisitor<R, P> {
    protected final Map<AnnotatedTypeMirror, R> visitedNodes = new IdentityHashMap<AnnotatedTypeMirror, R>();

    public void reset() {
        this.visitedNodes.clear();
    }

    @Override
    public final R visit(AnnotatedTypeMirror t) {
        return this.visit(t, null);
    }

    @Override
    public final R visit(AnnotatedTypeMirror type, P p) {
        this.reset();
        return this.scan(type, p);
    }

    protected R scan(AnnotatedTypeMirror type, P p) {
        return type == null ? null : (R)type.accept(this, p);
    }

    protected R scan(Iterable<? extends AnnotatedTypeMirror> types, P p) {
        if (types == null) {
            return null;
        }
        R r = null;
        boolean first = true;
        for (AnnotatedTypeMirror annotatedTypeMirror : types) {
            r = (R)(first ? this.scan(annotatedTypeMirror, p) : this.scanAndReduce(annotatedTypeMirror, p, r));
            first = false;
        }
        return r;
    }

    protected R scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types, P p, R r) {
        return this.reduce(this.scan(types, p), r);
    }

    public R scanAndReduce(AnnotatedTypeMirror type, P p, R r) {
        return this.reduce(this.scan(type, p), r);
    }

    protected R reduce(R r1, R r2) {
        if (r1 == null) {
            return r2;
        }
        return r1;
    }

    @Override
    public R visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        this.visitedNodes.put(type, null);
        R r = this.scan(type.getTypeArguments(), p);
        return r;
    }

    @Override
    public R visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        this.visitedNodes.put(type, null);
        R r = this.scan(type.directSuperTypes(), p);
        return r;
    }

    @Override
    public R visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        this.visitedNodes.put(type, null);
        R r = this.scan(type.getAlternatives(), p);
        return r;
    }

    @Override
    public R visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, P p) {
        R r = this.scan(type.getComponentType(), p);
        return r;
    }

    @Override
    public R visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, P p) {
        R r = this.scan(type.getReturnType(), p);
        r = this.scanAndReduce(type.getReceiverType(), p, r);
        r = this.scanAndReduce(type.getParameterTypes(), p, r);
        r = this.scanAndReduce(type.getThrownTypes(), p, r);
        r = this.scanAndReduce(type.getTypeVariables(), p, r);
        return r;
    }

    @Override
    public R visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        this.visitedNodes.put(type, null);
        R r = this.scan(type.getLowerBoundField(), p);
        this.visitedNodes.put(type, r);
        r = this.scanAndReduce(type.getUpperBoundField(), p, r);
        this.visitedNodes.put(type, r);
        return r;
    }

    @Override
    public R visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, P p) {
        return null;
    }

    @Override
    public R visitNull(AnnotatedTypeMirror.AnnotatedNullType type, P p) {
        return null;
    }

    @Override
    public R visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, P p) {
        return null;
    }

    @Override
    public R visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, P p) {
        if (this.visitedNodes.containsKey(type)) {
            return this.visitedNodes.get(type);
        }
        this.visitedNodes.put(type, null);
        R r = this.scan(type.getExtendsBoundField(), p);
        this.visitedNodes.put(type, r);
        r = this.scanAndReduce(type.getSuperBoundField(), p, r);
        this.visitedNodes.put(type, r);
        return r;
    }
}

