/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.SetQualifierVisitor;
import org.checkerframework.qualframework.base.TreeAnnotator;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterTypeFactory;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;

public class QualifierParameterTreeAnnotator<Q>
extends TreeAnnotator<QualParams<Q>> {
    private QualifierParameterTypeFactory<Q> factory;

    public QualifierParameterTreeAnnotator(QualifierParameterTypeFactory<Q> factory) {
        this.factory = factory;
    }

    @Override
    public QualifiedTypeMirror<QualParams<Q>> visitCompoundAssignment(CompoundAssignmentTree node, ExtendedTypeMirror type) {
        QualifiedTypeMirror<QualParams<Q>> result = super.visitCompoundAssignment(node, type);
        return this.filterParams(result);
    }

    @Override
    public QualifiedTypeMirror<QualParams<Q>> visitBinary(BinaryTree node, ExtendedTypeMirror type) {
        QualifiedTypeMirror<QualParams<Q>> result = super.visitBinary(node, type);
        return this.filterParams(result);
    }

    @Override
    public QualifiedTypeMirror<QualParams<Q>> visitUnary(UnaryTree node, ExtendedTypeMirror type) {
        QualifiedTypeMirror<QualParams<Q>> result = super.visitUnary(node, type);
        return this.filterParams(result);
    }

    @Override
    public QualifiedTypeMirror<QualParams<Q>> visitConditionalExpression(ConditionalExpressionTree node, ExtendedTypeMirror type) {
        QualifiedTypeMirror<QualParams<Q>> result = super.visitConditionalExpression(node, type);
        return this.filterParams(result);
    }

    @Override
    public QualifiedTypeMirror<QualParams<Q>> visitTypeCast(TypeCastTree node, ExtendedTypeMirror type) {
        QualifiedTypeMirror<QualParams<Q>> result = super.visitTypeCast(node, type);
        return this.filterParams(result);
    }

    private QualifiedTypeMirror<QualParams<Q>> filterParams(QualifiedTypeMirror<QualParams<Q>> type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return type;
        }
        QualifiedTypeMirror.QualifiedDeclaredType declType = (QualifiedTypeMirror.QualifiedDeclaredType)type;
        Set<String> validParams = this.factory.getAnnotationConverter().getDeclaredParameters(declType.getUnderlyingType().asElement());
        if (validParams.equals(type.getQualifier().keySet())) {
            return type;
        }
        HashMap params = new HashMap(type.getQualifier());
        params.keySet().retainAll(validParams);
        return SetQualifierVisitor.apply(type, new QualParams(params));
    }
}

