/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Resolver;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class FlowExpressionParseUtil {
    protected static final String identifierRegex = "[a-zA-Z_$][a-zA-Z_$0-9]*";
    protected static final Pattern parameterPattern = Pattern.compile("^#([1-9]+[0-9]*)$");
    protected static final Pattern parametersPattern = Pattern.compile("#([1-9]+[0-9]*)");
    protected static final Pattern selfPattern = Pattern.compile("^(this)$");
    protected static final Pattern itselfPattern = Pattern.compile("^(itself)$");
    protected static final Pattern superPattern = Pattern.compile("^(super)$");
    protected static final Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    protected static final Pattern methodPattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z_$0-9]*)\\((.*)\\)$");
    protected static final Pattern arrayPattern = Pattern.compile("^(.*)\\[(.*)\\]$");
    protected static final Pattern dotPattern = Pattern.compile("^([^.]+)\\.(.+)$");
    protected static final Pattern intPattern = Pattern.compile("^([1-9][0-9]*)$");
    protected static final Pattern longPattern = Pattern.compile("^([1-9][0-9]*L)$");
    protected static final Pattern stringPattern = Pattern.compile("^(\"([^\"\\\\]|\\\\.)*\")$");
    protected static final Pattern nullPattern = Pattern.compile("^(null)$");

    public static @Nullable FlowExpressions.Receiver parse(String s2, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
        return FlowExpressionParseUtil.parse(s2, context, path, false);
    }

    private static @Nullable FlowExpressions.Receiver parse(String s2, FlowExpressionContext context, TreePath path, boolean recursiveCall) throws FlowExpressionParseException {
        FlowExpressions.Receiver result = FlowExpressionParseUtil.parse(s2, context, path, true, true, true, true, true, true, true, recursiveCall);
        return result;
    }

    private static @Nullable FlowExpressions.Receiver parse(String s2, FlowExpressionContext context, TreePath path, boolean allowSelf, boolean allowIdentifier, boolean allowParameter, boolean allowDot, boolean allowMethods, boolean allowArrays, boolean allowLiterals, boolean recursiveCall) throws FlowExpressionParseException {
        Matcher selfMatcher = selfPattern.matcher(s2 = s2.trim());
        if (selfMatcher.matches() && allowSelf && !recursiveCall) {
            s2 = context.receiver.toString();
            selfMatcher = selfPattern.matcher(s2);
        }
        Matcher itselfMatcher = itselfPattern.matcher(s2);
        if (recursiveCall && itselfMatcher.matches()) {
            s2 = path.getLeaf().toString();
        }
        Matcher identifierMatcher = identifierPattern.matcher(s2);
        Matcher superMatcher = superPattern.matcher(s2);
        Matcher parameterMatcher = parameterPattern.matcher(s2);
        Matcher methodMatcher = methodPattern.matcher(s2);
        Matcher arraymatcher = arrayPattern.matcher(s2);
        Matcher dotMatcher = dotPattern.matcher(s2);
        Matcher intMatcher = intPattern.matcher(s2);
        Matcher longMatcher = longPattern.matcher(s2);
        Matcher stringMatcher = stringPattern.matcher(s2);
        Matcher nullMatcher = nullPattern.matcher(s2);
        ProcessingEnvironment env = context.atypeFactory.getProcessingEnv();
        Types types = env.getTypeUtils();
        if (intMatcher.matches() && allowLiterals) {
            int val = Integer.parseInt(s2);
            return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.INT), val);
        }
        if (nullMatcher.matches() && allowLiterals) {
            return new FlowExpressions.ValueLiteral((TypeMirror)types.getNullType(), (Object)null);
        }
        if (longMatcher.matches() && allowLiterals) {
            long val = Long.parseLong(s2.substring(0, s2.length() - 1));
            return new FlowExpressions.ValueLiteral((TypeMirror)types.getPrimitiveType(TypeKind.LONG), val);
        }
        if (stringMatcher.matches() && allowLiterals) {
            TypeElement stringTypeElem = env.getElementUtils().getTypeElement("java.lang.String");
            return new FlowExpressions.ValueLiteral((TypeMirror)types.getDeclaredType(stringTypeElem, new TypeMirror[0]), s2.substring(1, s2.length() - 1));
        }
        if (selfMatcher.matches() && allowSelf) {
            return new FlowExpressions.ThisReference(context.receiver.getType());
        }
        if (superMatcher.matches() && allowSelf) {
            List<? extends TypeMirror> superTypes = types.directSupertypes(context.receiver.getType());
            TypeMirror superType = null;
            for (TypeMirror typeMirror : superTypes) {
                Type.ClassType tt;
                if (!(typeMirror instanceof Type.ClassType) || (tt = (Type.ClassType)typeMirror).isInterface()) continue;
                superType = typeMirror;
                break;
            }
            if (superType == null) {
                throw FlowExpressionParseUtil.constructParserException(s2);
            }
            return new FlowExpressions.ThisReference(superType);
        }
        if (identifierMatcher.matches() && allowIdentifier) {
            Resolver resolver = new Resolver(env);
            try {
                TypeMirror receiverType = context.receiver.getType();
                VariableElement fieldElem = null;
                while (receiverType.getKind() == TypeKind.DECLARED && (fieldElem = resolver.findField(s2, receiverType, path)) == null) {
                    receiverType = ((DeclaredType)receiverType).getEnclosingType();
                }
                if (fieldElem == null) {
                    Element element = context.atypeFactory.getTreeUtils().getElement(TreeUtils.pathTillClass(path));
                    receiverType = ElementUtils.getType(element);
                    while (receiverType.getKind() == TypeKind.DECLARED && (fieldElem = resolver.findField(s2, receiverType, path)) == null) {
                        receiverType = ((DeclaredType)receiverType).getEnclosingType();
                    }
                }
                if (fieldElem == null || fieldElem.getKind() != ElementKind.FIELD) {
                    throw FlowExpressionParseUtil.constructParserException(s2);
                }
                TypeMirror typeMirror = ElementUtils.getType(fieldElem);
                if (ElementUtils.isStatic(fieldElem)) {
                    Element classElem = fieldElem.getEnclosingElement();
                    FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
                    return new FlowExpressions.FieldAccess(staticClassReceiver, typeMirror, fieldElem);
                }
                return new FlowExpressions.FieldAccess(context.receiver, typeMirror, fieldElem);
            }
            catch (Throwable t) {
                try {
                    Element classElem = resolver.findClass(s2, path);
                    TypeMirror typeMirror = ElementUtils.getType(classElem);
                    if (typeMirror == null) {
                        throw FlowExpressionParseUtil.constructParserException(s2);
                    }
                    return new FlowExpressions.ClassName(typeMirror);
                }
                catch (Throwable t2) {
                    if (!recursiveCall && itselfMatcher.matches()) {
                        return FlowExpressionParseUtil.parse(s2, context, path, allowSelf, allowIdentifier, allowParameter, allowDot, allowMethods, allowArrays, allowLiterals, true);
                    }
                    throw FlowExpressionParseUtil.constructParserException(s2);
                }
            }
        }
        if (parameterMatcher.matches() && allowParameter && context.arguments != null) {
            int idx;
            block38: {
                idx = -1;
                try {
                    idx = Integer.parseInt(parameterMatcher.group(1));
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block38;
                    throw new AssertionError();
                }
            }
            if (idx > context.arguments.size()) {
                throw new FlowExpressionParseException(Result.failure("flowexpr.parse.index.too.big", Integer.toString(idx)));
            }
            return context.arguments.get(idx - 1);
        }
        if (arraymatcher.matches() && allowArrays) {
            String receiverStr = arraymatcher.group(1);
            String indexStr = arraymatcher.group(2);
            FlowExpressions.Receiver receiver = FlowExpressionParseUtil.parse(receiverStr, context, path);
            FlowExpressions.Receiver receiver2 = FlowExpressionParseUtil.parse(indexStr, context, path);
            TypeMirror receiverType = receiver.getType();
            if (!(receiverType instanceof ArrayType)) {
                throw FlowExpressionParseUtil.constructParserException(s2);
            }
            TypeMirror componentType = ((ArrayType)receiverType).getComponentType();
            FlowExpressions.ArrayAccess result = new FlowExpressions.ArrayAccess(componentType, receiver, receiver2);
            return result;
        }
        if (methodMatcher.matches() && allowMethods) {
            String methodName = methodMatcher.group(1);
            String parameterList = methodMatcher.group(2);
            List parameters = ParameterListParser.parseParameterList(parameterList, true, context.useOuterReceiver(), path);
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
            for (FlowExpressions.Receiver p : parameters) {
                arrayList.add(p.getType());
            }
            Element methodElement = null;
            try {
                Resolver resolver = new Resolver(env);
                TypeMirror receiverType = context.receiver.getType();
                while (receiverType.getKind() == TypeKind.DECLARED && (methodElement = resolver.findMethod(methodName, receiverType, path, arrayList)).getKind() != ElementKind.METHOD) {
                    receiverType = ((DeclaredType)receiverType).getEnclosingType();
                }
                if (methodElement == null || methodElement.getKind() != ElementKind.METHOD) {
                    throw FlowExpressionParseUtil.constructParserException(s2);
                }
                ExecutableElement mElem = (ExecutableElement)methodElement;
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement formal = mElem.getParameters().get(i);
                    TypeMirror formalType = formal.asType();
                    FlowExpressions.Receiver actual = (FlowExpressions.Receiver)parameters.get(i);
                    TypeMirror actualType = actual.getType();
                    if (!TypesUtils.isBoxedPrimitive(formalType) || !TypesUtils.isPrimitive(actualType)) continue;
                    Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(env, formalType);
                    ArrayList<FlowExpressions.Receiver> p = new ArrayList<FlowExpressions.Receiver>();
                    p.add(actual);
                    FlowExpressions.PureMethodCall boxedParam = new FlowExpressions.PureMethodCall(formalType, valueOfMethod, new FlowExpressions.ClassName(formalType), p);
                    parameters.set(i, boxedParam);
                }
            }
            catch (Throwable t) {
                throw FlowExpressionParseUtil.constructParserException(s2);
            }
            assert (methodElement != null);
            if (ElementUtils.isStatic(methodElement)) {
                Element classElem = methodElement.getEnclosingElement();
                FlowExpressions.ClassName staticClassReceiver = new FlowExpressions.ClassName(ElementUtils.getType(classElem));
                return new FlowExpressions.PureMethodCall(ElementUtils.getType(methodElement), methodElement, staticClassReceiver, parameters);
            }
            TypeMirror methodType = InternalUtils.substituteMethodReturnType(ElementUtils.getType(methodElement), context.receiver.getType());
            return new FlowExpressions.PureMethodCall(methodType, methodElement, context.receiver, parameters);
        }
        if (dotMatcher.matches() && allowDot) {
            String receiverString = dotMatcher.group(1);
            String remainingString = dotMatcher.group(2);
            FlowExpressions.Receiver receiver = FlowExpressionParseUtil.parse(receiverString, context, path, true);
            FlowExpressionContext flowExpressionContext = context.changeReceiver(receiver);
            return FlowExpressionParseUtil.parse(remainingString, flowExpressionContext, path, false, true, false, true, true, false, false, true);
        }
        throw FlowExpressionParseUtil.constructParserException(s2);
    }

    private static FlowExpressionParseException constructParserException(String s2) {
        return new FlowExpressionParseException(Result.failure("flowexpr.parse.error", s2));
    }

    public static List<Integer> parameterIndices(String s2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = parametersPattern.matcher(s2);
        while (matcher.find()) {
            int idx = Integer.parseInt(matcher.group(1));
            result.add(idx);
        }
        return result;
    }

    public static FlowExpressionContext buildFlowExprContextForDeclaration(MethodTree node, Tree classTree, AnnotatedTypeFactory factory) {
        ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(InternalUtils.typeOf(classTree));
        FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(factory, receiver);
        ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
        for (VariableTree variableTree : node.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(factory, new LocalVariableNode(variableTree, receiver)));
        }
        FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, factory);
        return flowExprContext;
    }

    public static FlowExpressionContext buildFlowExprContextForDeclaration(MethodTree node, TypeMirror classType, AnnotatedTypeFactory factory) {
        ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(classType);
        FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(factory, receiver);
        ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
        for (VariableTree variableTree : node.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(factory, new LocalVariableNode(variableTree, receiver)));
        }
        FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, factory);
        return flowExprContext;
    }

    public static FlowExpressionContext buildFlowExprContextForDeclaration(MethodTree node, TreePath currentPath, AnnotatedTypeFactory factory) {
        ClassTree classTree = TreeUtils.enclosingClass(currentPath);
        return FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, classTree, factory);
    }

    public static FlowExpressionContext buildFlowExprContextForUse(MethodInvocationNode n, AnnotatedTypeFactory factory) {
        Node receiver = n.getTarget().getReceiver();
        FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(factory, receiver);
        ArrayList<FlowExpressions.Receiver> internalArguments = new ArrayList<FlowExpressions.Receiver>();
        for (Node arg : n.getArguments()) {
            internalArguments.add(FlowExpressions.internalReprOf(factory, arg));
        }
        FlowExpressionContext flowExprContext = new FlowExpressionContext(internalReceiver, internalArguments, factory);
        return flowExprContext;
    }

    public static class FlowExpressionParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        protected final Result result;

        public FlowExpressionParseException(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }
    }

    public static class FlowExpressionContext {
        public final FlowExpressions.Receiver receiver;
        public final List<FlowExpressions.Receiver> arguments;
        public final AnnotatedTypeFactory atypeFactory;
        public final FlowExpressions.Receiver outerReceiver;

        public FlowExpressionContext(FlowExpressions.Receiver receiver, List<FlowExpressions.Receiver> arguments, AnnotatedTypeFactory factory) {
            assert (factory != null);
            this.receiver = receiver;
            this.arguments = arguments;
            this.atypeFactory = factory;
            this.outerReceiver = receiver;
        }

        public FlowExpressionContext(FlowExpressions.Receiver receiver, FlowExpressions.Receiver outerReceiver, List<FlowExpressions.Receiver> arguments, AnnotatedTypeFactory factory) {
            assert (factory != null);
            this.receiver = receiver;
            this.arguments = arguments;
            this.atypeFactory = factory;
            this.outerReceiver = outerReceiver;
        }

        public FlowExpressionContext changeReceiver(FlowExpressions.Receiver receiver) {
            return new FlowExpressionContext(receiver, this.outerReceiver, this.arguments, this.atypeFactory);
        }

        public FlowExpressionContext useOuterReceiver() {
            return new FlowExpressionContext(this.outerReceiver, this.outerReceiver, this.arguments, this.atypeFactory);
        }
    }

    private static class ParameterListParser {
        private ParameterListParser() {
        }

        private static List<FlowExpressions.Receiver> parseParameterList(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path) throws FlowExpressionParseException {
            ArrayList<FlowExpressions.Receiver> result = new ArrayList<FlowExpressions.Receiver>();
            int idx = 0;
            int callLevel = 0;
            boolean inString = false;
            block6: while (true) {
                if (idx == parameterString.length()) {
                    if (inString || callLevel > 0) {
                        throw FlowExpressionParseUtil.constructParserException(parameterString);
                    }
                    ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx);
                    return result;
                }
                char next = parameterString.charAt(idx);
                ++idx;
                switch (next) {
                    case ',': {
                        if (inString || callLevel != 0) continue block6;
                        ParameterListParser.finishParam(parameterString, allowEmptyList, context, path, result, idx - 1);
                        List<FlowExpressions.Receiver> rest = ParameterListParser.parseParameterList(parameterString.substring(idx), false, context, path);
                        result.addAll(rest);
                        return result;
                    }
                    case '\"': {
                        inString = !inString;
                        break;
                    }
                    case '(': {
                        if (inString) continue block6;
                        ++callLevel;
                        break;
                    }
                    case ')': {
                        if (inString) continue block6;
                        if (callLevel == 0) {
                            throw FlowExpressionParseUtil.constructParserException(parameterString);
                        }
                        --callLevel;
                        break;
                    }
                }
            }
        }

        private static void finishParam(String parameterString, boolean allowEmptyList, FlowExpressionContext context, TreePath path, ArrayList<FlowExpressions.Receiver> result, int idx) throws FlowExpressionParseException {
            if (idx == 0) {
                if (allowEmptyList) {
                    return;
                }
                throw FlowExpressionParseUtil.constructParserException(parameterString);
            }
            result.add(FlowExpressionParseUtil.parse(parameterString.substring(0, idx), context, path));
        }
    }
}

