/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.InvisibleQualifier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeFromElement;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public abstract class AnnotatedTypeMirror {
    protected final AnnotatedTypeFactory atypeFactory;
    protected final TypeMirror actualType;
    protected final Set<AnnotationMirror> annotations = AnnotationUtils.createAnnotationSet();
    private static SuperTypeFinder superTypeFinder;
    private static Replacer replacer;

    public static AnnotatedTypeMirror createType(TypeMirror type, AnnotatedTypeFactory atypeFactory, boolean isDeclaration) {
        AnnotatedTypeMirror result;
        if (type == null) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: input type must not be null!");
            return null;
        }
        switch (type.getKind()) {
            case ARRAY: {
                result = new AnnotatedArrayType((ArrayType)type, atypeFactory);
                break;
            }
            case DECLARED: {
                result = new AnnotatedDeclaredType((DeclaredType)type, atypeFactory, isDeclaration);
                break;
            }
            case ERROR: {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: input should type-check already! Found error type: " + type);
                return null;
            }
            case EXECUTABLE: {
                result = new AnnotatedExecutableType((ExecutableType)type, atypeFactory);
                break;
            }
            case VOID: 
            case PACKAGE: 
            case NONE: {
                result = new AnnotatedNoType((NoType)type, atypeFactory);
                break;
            }
            case NULL: {
                result = new AnnotatedNullType((NullType)type, atypeFactory);
                break;
            }
            case TYPEVAR: {
                result = new AnnotatedTypeVariable((TypeVariable)type, atypeFactory, isDeclaration);
                break;
            }
            case WILDCARD: {
                result = new AnnotatedWildcardType((WildcardType)type, atypeFactory);
                break;
            }
            case INTERSECTION: {
                result = new AnnotatedIntersectionType((IntersectionType)type, atypeFactory);
                break;
            }
            case UNION: {
                result = new AnnotatedUnionType((UnionType)type, atypeFactory);
                break;
            }
            default: {
                if (type.getKind().isPrimitive()) {
                    result = new AnnotatedPrimitiveType((PrimitiveType)type, atypeFactory);
                    break;
                }
                ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: unidentified type " + type + " (" + (Object)((Object)type.getKind()) + ")");
                return null;
            }
        }
        return result;
    }

    private AnnotatedTypeMirror(TypeMirror type, AnnotatedTypeFactory atypeFactory) {
        this.actualType = type;
        assert (atypeFactory != null);
        this.atypeFactory = atypeFactory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotatedTypeMirror)) {
            return false;
        }
        AnnotatedTypeMirror t = (AnnotatedTypeMirror)o;
        return this.atypeFactory.types.isSameType(this.actualType, t.actualType) && AnnotationUtils.areSame(this.getAnnotations(), t.getAnnotations());
    }

    @Pure
    public int hashCode() {
        return this.annotations.toString().hashCode() * 17 + this.actualType.toString().hashCode() * 13;
    }

    public abstract <R, P> R accept(AnnotatedTypeVisitor<R, P> var1, P var2);

    public TypeKind getKind() {
        return this.actualType.getKind();
    }

    public TypeMirror getUnderlyingType() {
        return this.actualType;
    }

    public boolean isDeclaration() {
        return false;
    }

    public AnnotatedTypeMirror asUse() {
        return this;
    }

    public boolean isAnnotatedInHierarchy(AnnotationMirror p) {
        return this.getAnnotationInHierarchy(p) != null;
    }

    public AnnotationMirror getAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.annotations)) != null) {
            return anno;
        }
        return null;
    }

    public AnnotationMirror getEffectiveAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.getEffectiveAnnotations())) != null) {
            return anno;
        }
        return null;
    }

    public Set<AnnotationMirror> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public Set<AnnotationMirror> getEffectiveAnnotations() {
        Set<AnnotationMirror> effectiveAnnotations = this.getErased().getAnnotations();
        return effectiveAnnotations;
    }

    public AnnotationMirror getAnnotation(Name annotationName) {
        assert (annotationName != null) : "Null annotationName in getAnnotation";
        return this.getAnnotation(annotationName.toString().intern());
    }

    public AnnotationMirror getAnnotation(@Interned String annotationStr) {
        assert (annotationStr != null) : "Null annotationName in getAnnotation";
        for (AnnotationMirror anno : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByName(anno, annotationStr)) continue;
            return anno;
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> annoClass) {
        for (AnnotationMirror annoMirror : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByClass(annoMirror, annoClass)) continue;
            return annoMirror;
        }
        return null;
    }

    public Set<AnnotationMirror> getExplicitAnnotations() {
        Set<AnnotationMirror> explicitAnnotations = AnnotationUtils.createAnnotationSet();
        List<? extends AnnotationMirror> typeAnnotations = this.getUnderlyingType().getAnnotationMirrors();
        Set<? extends AnnotationMirror> validAnnotations = this.atypeFactory.getQualifierHierarchy().getTypeQualifiers();
        for (AnnotationMirror annotationMirror : typeAnnotations) {
            for (AnnotationMirror annotationMirror2 : validAnnotations) {
                if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, annotationMirror2)) continue;
                explicitAnnotations.add(annotationMirror);
            }
        }
        return explicitAnnotations;
    }

    public boolean hasAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getAnnotations(), a);
    }

    public boolean hasAnnotation(Name a) {
        return this.getAnnotation(a) != null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public boolean hasEffectiveAnnotation(Class<? extends Annotation> a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getEffectiveAnnotations(), AnnotationUtils.fromClass(this.atypeFactory.elements, a));
    }

    public boolean hasEffectiveAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getExplicitAnnotations(), a);
    }

    public boolean hasAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getAnnotations(), a);
    }

    public boolean hasEffectiveAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(Class<? extends Annotation> a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), this.getAnnotation(a));
    }

    public void addAnnotation(AnnotationMirror a) {
        if (a == null) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.addAnnotation: null is not a valid annotation.");
        }
        if (this.atypeFactory.isSupportedQualifier(a)) {
            this.annotations.add(a);
        } else {
            AnnotationMirror aliased = this.atypeFactory.aliasedAnnotation(a);
            if (this.atypeFactory.isSupportedQualifier(aliased)) {
                this.addAnnotation(aliased);
            }
        }
    }

    public void replaceAnnotation(AnnotationMirror a) {
        this.removeAnnotationInHierarchy(a);
        this.addAnnotation(a);
    }

    public void addAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        this.addAnnotation(anno);
    }

    public void addAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            this.addAnnotation(annotationMirror);
        }
    }

    public void addMissingAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (this.isAnnotatedInHierarchy(annotationMirror)) continue;
            this.addAnnotation(annotationMirror);
        }
    }

    public void replaceAnnotations(Iterable<? extends AnnotationMirror> replAnnos) {
        for (AnnotationMirror annotationMirror : replAnnos) {
            this.removeAnnotationInHierarchy(annotationMirror);
            this.addAnnotation(annotationMirror);
        }
    }

    public boolean removeAnnotation(AnnotationMirror a) {
        AnnotationMirror anno = this.getAnnotation(AnnotationUtils.annotationName(a));
        if (anno != null) {
            return this.annotations.remove(anno);
        }
        return false;
    }

    public boolean removeAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        if (anno == null || !this.atypeFactory.isSupportedQualifier(anno)) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.removeAnnotation called with un-supported class: " + a);
        }
        return this.removeAnnotation(anno);
    }

    public boolean removeAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        if (prev != null) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeNonTopAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        QualifierHierarchy qualHier = this.atypeFactory.getQualifierHierarchy();
        if (prev != null && !prev.equals(qualHier.getTopAnnotation(a))) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        boolean changed = false;
        for (AnnotationMirror annotationMirror : annotations) {
            changed |= this.removeAnnotation(annotationMirror);
        }
        return changed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    private static boolean isInvisibleQualified(AnnotationMirror anno) {
        return ((TypeElement)anno.getAnnotationType().asElement()).getAnnotation(InvisibleQualifier.class) != null;
    }

    @SideEffectFree
    protected static final String formatAnnotationString(Collection<? extends AnnotationMirror> lst, boolean printInvisible) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationMirror annotationMirror : lst) {
            if (annotationMirror == null) {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.formatAnnotationString: found null AnnotationMirror!");
            }
            if (AnnotatedTypeMirror.isInvisibleQualified(annotationMirror) && !printInvisible) continue;
            AnnotatedTypeMirror.formatAnnotationMirror(annotationMirror, sb);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static final void formatAnnotationMirror(AnnotationMirror am, StringBuilder sb) {
        sb.append("@");
        sb.append(am.getAnnotationType().asElement().getSimpleName());
        Map<? extends ExecutableElement, ? extends AnnotationValue> args = am.getElementValues();
        if (!args.isEmpty()) {
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> first;
            sb.append("(");
            boolean oneValue = false;
            if (args.size() == 1 && (first = args.entrySet().iterator().next()).getKey().getSimpleName().contentEquals("value")) {
                AnnotatedTypeMirror.formatAnnotationMirrorArg(first.getValue(), sb);
                oneValue = true;
            }
            if (!oneValue) {
                boolean notfirst = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> arg : args.entrySet()) {
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    sb.append(arg.getKey().getSimpleName() + "=");
                    AnnotatedTypeMirror.formatAnnotationMirrorArg(arg.getValue(), sb);
                }
            }
            sb.append(")");
        }
    }

    public static final String formatAnnotationMirror(AnnotationMirror am) {
        StringBuilder sb = new StringBuilder();
        AnnotatedTypeMirror.formatAnnotationMirror(am, sb);
        return sb.toString();
    }

    protected static final void formatAnnotationMirrorArg(AnnotationValue av, StringBuilder sb) {
        Object val = av.getValue();
        if (List.class.isAssignableFrom(val.getClass())) {
            List vallist = (List)val;
            if (vallist.size() == 1) {
                AnnotatedTypeMirror.formatAnnotationMirrorArg((AnnotationValue)vallist.get(0), sb);
            } else {
                sb.append('{');
                boolean notfirst = false;
                for (AnnotationValue nav : vallist) {
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    AnnotatedTypeMirror.formatAnnotationMirrorArg(nav, sb);
                }
                sb.append('}');
            }
        } else if (VariableElement.class.isAssignableFrom(val.getClass())) {
            VariableElement ve = (VariableElement)val;
            sb.append(ve.getEnclosingElement().getSimpleName() + "." + ve.getSimpleName());
        } else {
            sb.append(av.toString());
        }
    }

    @SideEffectFree
    public final String toString() {
        return this.toString(this.atypeFactory.checker.hasOption("printAllQualifiers"));
    }

    @SideEffectFree
    public String toString(boolean invisible) {
        return AnnotatedTypeMirror.formatAnnotationString(this.getAnnotations(), invisible) + this.actualType;
    }

    @SideEffectFree
    public String toStringDebug() {
        return this.toString(true) + " " + this.getClass().getSimpleName();
    }

    public AnnotatedTypeMirror getErased() {
        return this;
    }

    public abstract AnnotatedTypeMirror getCopy(boolean var1);

    protected static AnnotatedDeclaredType createTypeOfObject(AnnotatedTypeFactory atypeFactory) {
        AnnotatedDeclaredType objectType = atypeFactory.fromElement(atypeFactory.elements.getTypeElement(Object.class.getCanonicalName()));
        return objectType;
    }

    public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
        return this.substitute(mappings, false);
    }

    public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
        if (mappings.containsKey(this)) {
            return mappings.get(this).getCopy(true);
        }
        return this.getCopy(true);
    }

    public List<? extends AnnotatedTypeMirror> directSuperTypes() {
        return this.directSuperTypes(this);
    }

    protected final List<AnnotatedDeclaredType> directSuperTypes(AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.setSuperTypeFinder(type.atypeFactory);
        List<AnnotatedDeclaredType> supertypes = superTypeFinder.visitDeclared(type, null);
        this.atypeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    private final List<? extends AnnotatedTypeMirror> directSuperTypes(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror.setSuperTypeFinder(type.atypeFactory);
        List supertypes = (List)superTypeFinder.visit(type, null);
        this.atypeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    private static void setSuperTypeFinder(AnnotatedTypeFactory factory) {
        if (superTypeFinder == null || superTypeFinder.atypeFactory != factory) {
            superTypeFinder = new SuperTypeFinder(factory);
        }
        if (replacer == null) {
            replacer = new Replacer(factory.types);
        }
    }

    private static void fixupBoundAnnotationsImpl(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror lowerBound, AnnotatedTypeMirror upperBound, Collection<AnnotationMirror> allAnnotations, AnnotationMirror top, AnnotationMirror lAnno, AnnotationMirror uAnno) {
        if (lAnno == null) {
            AnnotationMirror a = qualifierHierarchy.getAnnotationInHierarchy(allAnnotations, top);
            if (a != null) {
                lowerBound.replaceAnnotation(a);
                return;
            }
            lAnno = qualifierHierarchy.getBottomAnnotation(top);
            lowerBound.replaceAnnotation(lAnno);
        }
        if (uAnno != null && !qualifierHierarchy.isSubtype(lAnno, uAnno)) {
            if (qualifierHierarchy.isSubtype(uAnno, lAnno)) {
                lowerBound.replaceAnnotation(uAnno);
            } else {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.fixupBoundAnnotations: default annotation on lower bound ( " + lAnno + ") is inconsistent with explicit upper bound: " + upperBound);
            }
        }
    }

    private static class Replacer
    extends AnnotatedTypeScanner<Void, Map<TypeParameterElement, AnnotatedTypeMirror>> {
        final Types types;

        public Replacer(Types types) {
            this.types = types;
        }

        @Override
        public Void visitDeclared(AnnotatedDeclaredType type, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
            ArrayList<AnnotatedTypeMirror> args = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror arg : type.getTypeArguments()) {
                Element elem = this.types.asElement(arg.getUnderlyingType());
                if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                    AnnotatedTypeMirror other = mapping.get(elem);
                    other.replaceAnnotations(arg.annotations);
                    args.add(other);
                    continue;
                }
                args.add(arg);
            }
            type.setTypeArguments(args);
            return (Void)super.visitDeclared(type, mapping);
        }

        @Override
        public Void visitArray(AnnotatedArrayType type, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
            AnnotatedTypeMirror comptype = type.getComponentType();
            Element elem = this.types.asElement(comptype.getUnderlyingType());
            if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                AnnotatedTypeMirror other = mapping.get(elem);
                other.replaceAnnotations(comptype.annotations);
                type.setComponentType(other);
            }
            return (Void)super.visitArray(type, mapping);
        }
    }

    private static class SuperTypeFinder
    extends SimpleAnnotatedTypeVisitor<List<? extends AnnotatedTypeMirror>, Void> {
        private final Types types;
        private final AnnotatedTypeFactory atypeFactory;

        SuperTypeFinder(AnnotatedTypeFactory atypeFactory) {
            this.atypeFactory = atypeFactory;
            this.types = atypeFactory.types;
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror t, Void p) {
            return new ArrayList<AnnotatedTypeMirror>();
        }

        @Override
        public List<AnnotatedTypeMirror> visitPrimitive(AnnotatedPrimitiveType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            TypeElement boxed = this.types.boxedClass(type.getUnderlyingType());
            AnnotatedDeclaredType boxedType = this.atypeFactory.getAnnotatedType(boxed);
            boxedType.replaceAnnotations(annotations);
            superTypes.add(boxedType);
            TypeKind superPrimitiveType = null;
            if (type.getKind() != TypeKind.BOOLEAN) {
                if (type.getKind() == TypeKind.BYTE) {
                    superPrimitiveType = TypeKind.SHORT;
                } else if (type.getKind() == TypeKind.CHAR) {
                    superPrimitiveType = TypeKind.INT;
                } else if (type.getKind() != TypeKind.DOUBLE) {
                    if (type.getKind() == TypeKind.FLOAT) {
                        superPrimitiveType = TypeKind.DOUBLE;
                    } else if (type.getKind() == TypeKind.INT) {
                        superPrimitiveType = TypeKind.LONG;
                    } else if (type.getKind() == TypeKind.LONG) {
                        superPrimitiveType = TypeKind.FLOAT;
                    } else if (type.getKind() == TypeKind.SHORT) {
                        superPrimitiveType = TypeKind.INT;
                    } else assert (false) : "Forgot the primitive " + type;
                }
            }
            if (superPrimitiveType != null) {
                AnnotatedPrimitiveType superPrimitive = (AnnotatedPrimitiveType)this.atypeFactory.toAnnotatedType(this.types.getPrimitiveType(superPrimitiveType), false);
                superPrimitive.addAnnotations(annotations);
                superTypes.add(superPrimitive);
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedDeclaredType> visitDeclared(AnnotatedDeclaredType type, Void p) {
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            TypeElement typeElement = (TypeElement)type.getUnderlyingType().asElement();
            HashMap<TypeParameterElement, AnnotatedTypeMirror> mapping = new HashMap<TypeParameterElement, AnnotatedTypeMirror>();
            for (int i = 0; i < typeElement.getTypeParameters().size() && i < type.getTypeArguments().size(); ++i) {
                mapping.put(typeElement.getTypeParameters().get(i), type.getTypeArguments().get(i));
            }
            ClassTree classTree = this.atypeFactory.trees.getTree(typeElement);
            if (classTree != null) {
                supertypes.addAll(this.supertypesFromTree(type, classTree));
            } else {
                supertypes.addAll(this.supertypesFromElement(type, typeElement));
            }
            for (AnnotatedDeclaredType dt : supertypes) {
                replacer.visit(dt, mapping);
            }
            return supertypes;
        }

        private List<AnnotatedDeclaredType> supertypesFromElement(AnnotatedDeclaredType type, TypeElement typeElement) {
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            if (typeElement.getKind() == ElementKind.ENUM) {
                DeclaredType dt = (DeclaredType)typeElement.getSuperclass();
                AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(dt, false);
                List<AnnotatedTypeMirror> tas = annotatedDeclaredType.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type.getUnderlyingType())) continue;
                    t.addAnnotations(type.getAnnotations());
                    newtas.add(t);
                }
                annotatedDeclaredType.setTypeArguments(newtas);
                supertypes.add(annotatedDeclaredType);
            } else if (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
                DeclaredType superClass = (DeclaredType)typeElement.getSuperclass();
                AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(superClass, false);
                supertypes.add(annotatedDeclaredType);
            } else if (!ElementUtils.isObject(typeElement)) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                AnnotatedDeclaredType ast = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(typeMirror, false);
                supertypes.add(ast);
            }
            TypeFromElement.annotateSupers(supertypes, typeElement);
            if (type.wasRaw()) {
                for (AnnotatedDeclaredType annotatedDeclaredType : supertypes) {
                    annotatedDeclaredType.setWasRaw();
                }
            }
            return supertypes;
        }

        private List<AnnotatedDeclaredType> supertypesFromTree(AnnotatedDeclaredType type, ClassTree classTree) {
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            if (classTree.getExtendsClause() != null) {
                AnnotatedDeclaredType adt2 = (AnnotatedDeclaredType)this.atypeFactory.fromTypeTree(classTree.getExtendsClause());
                supertypes.add(adt2);
            } else if (!ElementUtils.isObject(TreeUtils.elementFromDeclaration(classTree))) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.atypeFactory));
            }
            for (Tree tree : classTree.getImplementsClause()) {
                AnnotatedDeclaredType adt3 = (AnnotatedDeclaredType)this.atypeFactory.getAnnotatedTypeFromTypeTree(tree);
                supertypes.add(adt3);
            }
            TypeElement elem = TreeUtils.elementFromDeclaration(classTree);
            if (elem.getKind() == ElementKind.ENUM) {
                DeclaredType declaredType = (DeclaredType)elem.getSuperclass();
                AnnotatedDeclaredType adt = (AnnotatedDeclaredType)this.atypeFactory.toAnnotatedType(declaredType, false);
                List<AnnotatedTypeMirror> tas = adt.getTypeArguments();
                ArrayList<AnnotatedTypeMirror> newtas = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror t : tas) {
                    if (!this.atypeFactory.types.isSameType(t.getUnderlyingType(), type.getUnderlyingType())) continue;
                    t.addAnnotations(type.getAnnotations());
                    newtas.add(t);
                }
                adt.setTypeArguments(newtas);
                supertypes.add(adt);
            }
            if (type.wasRaw()) {
                for (AnnotatedDeclaredType adt : supertypes) {
                    adt.setWasRaw();
                }
            }
            return supertypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedArrayType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            Elements elements = this.atypeFactory.elements;
            AnnotatedDeclaredType objectType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Object"));
            objectType.addAnnotations(annotations);
            superTypes.add(objectType);
            AnnotatedDeclaredType cloneableType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Cloneable"));
            cloneableType.addAnnotations(annotations);
            superTypes.add(cloneableType);
            AnnotatedDeclaredType serializableType = this.atypeFactory.getAnnotatedType(elements.getTypeElement("java.io.Serializable"));
            serializableType.addAnnotations(annotations);
            superTypes.add(serializableType);
            if (type.getComponentType() instanceof AnnotatedReferenceType) {
                for (AnnotatedTypeMirror annotatedTypeMirror : type.getComponentType().directSuperTypes()) {
                    ArrayType arrType = this.atypeFactory.types.getArrayType(annotatedTypeMirror.getUnderlyingType());
                    AnnotatedArrayType aarrType = (AnnotatedArrayType)this.atypeFactory.toAnnotatedType(arrType, false);
                    aarrType.setComponentType(annotatedTypeMirror);
                    aarrType.addAnnotations(annotations);
                    superTypes.add(aarrType);
                }
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeVariable type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            if (type.getEffectiveUpperBound() != null) {
                superTypes.add(AnnotatedTypes.deepCopy(type.getEffectiveUpperBound()));
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedWildcardType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            if (type.getEffectiveExtendsBound() != null) {
                superTypes.add(AnnotatedTypes.deepCopy(type.getEffectiveExtendsBound()));
            }
            return superTypes;
        }
    }

    public static class AnnotatedUnionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> alternatives;

        private AnnotatedUnionType(UnionType type, AnnotatedTypeFactory atypeFactory) {
            super(type, atypeFactory);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedDeclaredType adt : this.getAlternatives()) {
                if (!isFirst) {
                    sb.append(" | ");
                }
                sb.append(adt.toString(printInvisible));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Override
        public AnnotatedUnionType getCopy(boolean copyAnnotations) {
            AnnotatedUnionType type = new AnnotatedUnionType((UnionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            type.alternatives = this.alternatives;
            return type;
        }

        public List<AnnotatedDeclaredType> getAlternatives() {
            if (this.alternatives == null) {
                List<? extends TypeMirror> ualts = ((UnionType)this.actualType).getAlternatives();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ualts.size());
                for (TypeMirror typeMirror : ualts) {
                    res.add((AnnotatedDeclaredType)AnnotatedUnionType.createType(typeMirror, this.atypeFactory, false));
                }
                this.alternatives = Collections.unmodifiableList(res);
            }
            return this.alternatives;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedUnionType type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type);
            if (this.alternatives != null) {
                ArrayList<AnnotatedDeclaredType> alternatives = new ArrayList<AnnotatedDeclaredType>();
                for (AnnotatedDeclaredType t : this.getAlternatives()) {
                    alternatives.add((AnnotatedDeclaredType)t.substitute(newMappings, forDeepCopy));
                }
                type.alternatives = alternatives;
            }
            return type;
        }
    }

    public static class AnnotatedIntersectionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> supertypes;

        private AnnotatedIntersectionType(IntersectionType type, AnnotatedTypeFactory atypeFactory) {
            super(type, atypeFactory);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedDeclaredType adt : this.directSuperTypes()) {
                if (!isFirst) {
                    sb.append(" & ");
                }
                sb.append(adt.toString(printInvisible));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }

        @Override
        public AnnotatedIntersectionType getCopy(boolean copyAnnotations) {
            AnnotatedIntersectionType type = new AnnotatedIntersectionType((IntersectionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            type.supertypes = this.supertypes;
            return type;
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                List<? extends TypeMirror> ubounds = ((IntersectionType)this.actualType).getBounds();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ubounds.size());
                for (TypeMirror typeMirror : ubounds) {
                    res.add((AnnotatedDeclaredType)AnnotatedIntersectionType.createType(typeMirror, this.atypeFactory, false));
                }
                this.supertypes = Collections.unmodifiableList(res);
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes);
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedIntersectionType type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type);
            if (this.supertypes != null) {
                ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
                for (AnnotatedDeclaredType t : this.directSuperTypes()) {
                    supertypes.add((AnnotatedDeclaredType)t.substitute(newMappings, forDeepCopy));
                }
                type.supertypes = supertypes;
            }
            return type;
        }
    }

    public static class AnnotatedWildcardType
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror superBound;
        private AnnotatedTypeMirror extendsBound;
        boolean isPrintingBound = false;
        private boolean typeArgHack = false;

        private AnnotatedWildcardType(WildcardType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        void setSuperBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.superBound = type;
        }

        public AnnotatedTypeMirror getSuperBoundField() {
            return this.superBound;
        }

        public AnnotatedTypeMirror getSuperBound() {
            if (this.superBound == null && ((WildcardType)this.actualType).getSuperBound() != null) {
                AnnotatedTypeMirror annosupertype = AnnotatedWildcardType.createType(((WildcardType)this.actualType).getSuperBound(), this.atypeFactory, false);
                this.setSuperBound(annosupertype);
                this.fixupBoundAnnotations();
            }
            return this.superBound;
        }

        public AnnotatedTypeMirror getEffectiveSuperBound() {
            AnnotatedTypeMirror spb = this.getSuperBound();
            if (spb == null) {
                return null;
            }
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(spb);
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        void setExtendsBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.extendsBound = type;
        }

        public AnnotatedTypeMirror getExtendsBoundField() {
            return this.extendsBound;
        }

        public AnnotatedTypeMirror getExtendsBound() {
            if (this.extendsBound == null) {
                TypeMirror extType = ((WildcardType)this.actualType).getExtendsBound();
                if (extType == null) {
                    extType = TypesUtils.wildUpperBound(this.atypeFactory.processingEnv, this.actualType);
                }
                AnnotatedTypeMirror annoexttype = AnnotatedWildcardType.createType(extType, this.atypeFactory, false);
                this.setExtendsBound(annoexttype);
                this.fixupBoundAnnotations();
            }
            return this.extendsBound;
        }

        private void fixupBoundAnnotations() {
        }

        public AnnotatedTypeMirror getEffectiveExtendsBound() {
            if (this.typeArgHack) {
                AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(((AnnotatedTypeVariable)this.getExtendsBound()).getUpperBound());
                effbnd.replaceAnnotations(this.annotations);
                return effbnd;
            }
            AnnotatedTypeMirror effbnd = AnnotatedTypes.deepCopy(this.getExtendsBound());
            effbnd.replaceAnnotations(this.annotations);
            return effbnd;
        }

        public Set<AnnotationMirror> getEffectiveExtendsBoundAnnotations() {
            Set<AnnotationMirror> result = this.annotations;
            if (result.isEmpty()) {
                AnnotatedTypeMirror ub = this.getExtendsBound();
                if (ub != null) {
                    return ub.getEffectiveAnnotations();
                }
                return Collections.unmodifiableSet(result);
            }
            result = AnnotationUtils.createAnnotationSet();
            result.addAll(this.annotations);
            Set<Object> boundAnnotations = Collections.emptySet();
            AnnotatedTypeMirror ub = this.getExtendsBound();
            if (ub != null) {
                boundAnnotations = ub.getEffectiveAnnotations();
            }
            Iterator iterator = boundAnnotations.iterator();
            while (iterator.hasNext()) {
                QualifierHierarchy qualHierarchy = this.atypeFactory.qualHierarchy;
                AnnotationMirror boundAnnotation = (AnnotationMirror)iterator.next();
                AnnotationMirror top = qualHierarchy.getTopAnnotation(boundAnnotation);
                if (qualHierarchy.getAnnotationInHierarchy(result, top) != null) continue;
                result.add(boundAnnotation);
            }
            return Collections.unmodifiableSet(result);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public WildcardType getUnderlyingType() {
            return (WildcardType)this.actualType;
        }

        @Override
        public AnnotatedWildcardType getCopy(boolean copyAnnotations) {
            AnnotatedWildcardType type = new AnnotatedWildcardType((WildcardType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            type.setExtendsBound(this.getExtendsBound());
            type.setSuperBound(this.getSuperBound());
            type.typeArgHack = this.typeArgHack;
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedWildcardType type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMapping.put(this, type);
            if (this.extendsBound != null) {
                type.setExtendsBound(this.extendsBound.substitute(newMapping, forDeepCopy));
            }
            if (this.superBound != null) {
                type.setSuperBound(this.superBound.substitute(newMapping, forDeepCopy));
            }
            if (type.getExtendsBound() != null && type.getSuperBound() != null && AnnotatedTypes.areSame(type.getExtendsBound(), type.getSuperBound())) {
                return type.getExtendsBound();
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getEffectiveExtendsBound().getErased();
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            sb.append(AnnotatedWildcardType.formatAnnotationString(this.annotations, printInvisible));
            sb.append("?");
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getSuperBoundField() != null && this.getSuperBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getSuperBoundField().toString(printInvisible));
                    }
                    if (this.getExtendsBoundField() != null && this.getExtendsBoundField().getKind() != TypeKind.NONE) {
                        sb.append(" extends ");
                        sb.append(this.getExtendsBoundField().toString(printInvisible));
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        void setTypeArgHack() {
            this.typeArgHack = true;
        }

        boolean isTypeArgHack() {
            return this.typeArgHack;
        }
    }

    public static class AnnotatedPrimitiveType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedPrimitiveType(PrimitiveType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public PrimitiveType getUnderlyingType() {
            return (PrimitiveType)this.actualType;
        }

        @Override
        public AnnotatedPrimitiveType getCopy(boolean copyAnnotations) {
            AnnotatedPrimitiveType type = new AnnotatedPrimitiveType((PrimitiveType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            return this.getCopy(true);
        }
    }

    public static class AnnotatedNullType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedNullType(NullType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public NullType getUnderlyingType() {
            return (NullType)this.actualType;
        }

        @Override
        public AnnotatedNullType getCopy(boolean copyAnnotations) {
            AnnotatedNullType type = new AnnotatedNullType((NullType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            return this.getCopy(true);
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            if (printInvisible) {
                return AnnotatedNullType.formatAnnotationString(this.getAnnotations(), printInvisible) + "null";
            }
            return "null";
        }
    }

    public static class AnnotatedNoType
    extends AnnotatedTypeMirror {
        private AnnotatedNoType(NoType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public NoType getUnderlyingType() {
            return (NoType)this.actualType;
        }

        @Override
        public AnnotatedNoType getCopy(boolean copyAnnotations) {
            AnnotatedNoType type = new AnnotatedNoType((NoType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            return this.getCopy(true);
        }
    }

    public static class AnnotatedTypeVariable
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private AnnotatedTypeMirror lowerBound;
        private AnnotatedTypeMirror upperBound;
        private boolean declaration;
        private boolean inUpperBounds = false;
        boolean isPrintingBound = false;

        private AnnotatedTypeVariable(TypeVariable type, AnnotatedTypeFactory factory, boolean declaration) {
            super(type, factory);
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(boolean declaration) {
            this.declaration = declaration;
        }

        @Override
        public AnnotatedTypeVariable asUse() {
            if (!this.isDeclaration()) {
                return this;
            }
            AnnotatedTypeVariable result = this.getCopy(true);
            result.declaration = false;
            return result;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public TypeVariable getUnderlyingType() {
            return (TypeVariable)this.actualType;
        }

        void setLowerBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.lowerBound = type;
        }

        public AnnotatedTypeMirror getLowerBoundField() {
            return this.lowerBound;
        }

        public AnnotatedTypeMirror getLowerBound() {
            if (this.lowerBound == null && ((TypeVariable)this.actualType).getLowerBound() != null) {
                this.setLowerBound(AnnotatedTypeVariable.createType(((TypeVariable)this.actualType).getLowerBound(), this.atypeFactory, false));
                this.fixupBoundAnnotations();
            }
            return this.lowerBound;
        }

        public AnnotatedTypeMirror getEffectiveLowerBound() {
            AnnotatedTypeVariable thisUse = this.getCopy(true);
            thisUse.declaration = false;
            AnnotatedTypeVariable thisDecl = this.getCopy(true);
            thisDecl.declaration = true;
            thisDecl.clearAnnotations();
            return thisUse.substitute(Collections.singletonMap(thisDecl, this.getLowerBound()));
        }

        private void fixupBoundAnnotations() {
            if (!this.annotations.isEmpty() && this.upperBound != null) {
                this.upperBound = this.upperBound.getCopy(true);
                this.upperBound.replaceAnnotations(this.annotations);
            }
            if (this.upperBound == null || this.upperBound.getAnnotations().isEmpty()) {
                // empty if block
            }
            if (((TypeVariable)this.actualType).getLowerBound() instanceof NullType && this.lowerBound != null && this.upperBound != null) {
                Set<AnnotationMirror> lAnnos = this.lowerBound.getEffectiveAnnotations();
                Set<AnnotationMirror> uAnnos = this.upperBound.getEffectiveAnnotations();
                QualifierHierarchy qualifierHierarchy = this.atypeFactory.getQualifierHierarchy();
                for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
                    AnnotationMirror lAnno = qualifierHierarchy.getAnnotationInHierarchy(lAnnos, annotationMirror);
                    AnnotationMirror uAnno = qualifierHierarchy.getAnnotationInHierarchy(uAnnos, annotationMirror);
                    AnnotatedTypeMirror.fixupBoundAnnotationsImpl(qualifierHierarchy, this.lowerBound, this.upperBound, this.annotations, annotationMirror, lAnno, uAnno);
                }
            }
        }

        void setUpperBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.upperBound = type;
        }

        public AnnotatedTypeMirror getUpperBoundField() {
            return this.upperBound;
        }

        public AnnotatedTypeMirror getUpperBound() {
            if (this.upperBound == null && ((TypeVariable)this.actualType).getUpperBound() != null) {
                this.setUpperBound(AnnotatedTypeVariable.createType(((TypeVariable)this.actualType).getUpperBound(), this.atypeFactory, false));
                this.fixupBoundAnnotations();
            }
            return this.upperBound;
        }

        public AnnotatedTypeMirror getEffectiveUpperBound() {
            AnnotatedTypeVariable thisUse = this.getCopy(true);
            thisUse.declaration = false;
            AnnotatedTypeVariable thisDecl = this.getCopy(true);
            thisDecl.declaration = true;
            thisDecl.clearAnnotations();
            return thisUse.substitute(Collections.singletonMap(thisDecl, this.getUpperBound()));
        }

        public AnnotatedTypeParameterBounds getBounds() {
            return new AnnotatedTypeParameterBounds(this.getUpperBound(), this.getLowerBound());
        }

        public AnnotatedTypeParameterBounds getBoundFields() {
            return new AnnotatedTypeParameterBounds(this.getUpperBoundField(), this.getLowerBoundField());
        }

        public AnnotatedTypeParameterBounds getEffectiveBounds() {
            return new AnnotatedTypeParameterBounds(this.getEffectiveUpperBound(), this.getEffectiveLowerBound());
        }

        @Override
        public AnnotatedTypeVariable getCopy(boolean copyAnnotations) {
            AnnotatedTypeVariable type = new AnnotatedTypeVariable((TypeVariable)this.actualType, this.atypeFactory, this.declaration);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            if (!this.inUpperBounds) {
                this.inUpperBounds = true;
                type.inUpperBounds = true;
                type.setUpperBound(this.getUpperBound());
                this.inUpperBounds = false;
                type.inUpperBounds = false;
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getEffectiveUpperBound().getErased();
        }

        private static <K extends AnnotatedTypeMirror, V extends AnnotatedTypeMirror> V mapGetHelper(Map<K, V> mappings, AnnotatedTypeVariable key, boolean forDeepCopy) {
            for (Map.Entry<K, V> entry : mappings.entrySet()) {
                AnnotatedTypeMirror possible = (AnnotatedTypeMirror)entry.getKey();
                AnnotatedTypeMirror possValue = (AnnotatedTypeMirror)entry.getValue();
                if (!(possible instanceof AnnotatedTypeVariable)) continue;
                AnnotatedTypeVariable other = (AnnotatedTypeVariable)possible;
                Element oElt = other.getUnderlyingType().asElement();
                if (!key.getUnderlyingType().asElement().equals(oElt)) continue;
                AnnotatedTypeMirror found = possValue.getCopy(false);
                found.addAnnotations(possValue.getAnnotations());
                if (!forDeepCopy) {
                    key.atypeFactory.postTypeVarSubstitution((AnnotatedTypeVariable)possible, key, found);
                }
                return (V)found;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            AnnotatedTypeMirror found = AnnotatedTypeVariable.mapGetHelper(mappings, this, forDeepCopy);
            if (found != null) {
                return found;
            }
            AnnotatedTypeVariable type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type);
            if (this.lowerBound != null) {
                type.setLowerBound(this.lowerBound.substitute(newMappings, forDeepCopy));
            }
            if (this.upperBound != null) {
                type.setUpperBound(this.upperBound.substitute(newMappings, forDeepCopy));
            }
            return type;
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            if (this.declaration) {
                sb.append("/*DECL*/ ");
            }
            sb.append(AnnotatedTypeVariable.formatAnnotationString(this.annotations, printInvisible));
            sb.append(this.actualType);
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getLowerBoundField() != null && this.getLowerBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getLowerBoundField().toString(printInvisible));
                    }
                    if (this.getUpperBoundField() != null && this.getUpperBoundField().getKind() != TypeKind.NULL) {
                        sb.append(" extends ");
                        sb.append(this.getUpperBoundField().toString(printInvisible));
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        @Override
        @Pure
        public int hashCode() {
            return this.getUnderlyingType().hashCode();
        }
    }

    public static class AnnotatedArrayType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final ArrayType actualType;
        private AnnotatedTypeMirror componentType;

        private AnnotatedArrayType(ArrayType type, AnnotatedTypeFactory factory) {
            super(type, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        public ArrayType getUnderlyingType() {
            return this.actualType;
        }

        public void setComponentType(AnnotatedTypeMirror type) {
            this.componentType = type;
        }

        public AnnotatedTypeMirror getComponentType() {
            if (this.componentType == null) {
                this.setComponentType(AnnotatedArrayType.createType(this.actualType.getComponentType(), this.atypeFactory, false));
            }
            return this.componentType;
        }

        @Override
        public AnnotatedArrayType getCopy(boolean copyAnnotations) {
            AnnotatedArrayType type = new AnnotatedArrayType(this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            type.setComponentType(this.getComponentType());
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedArrayType type = this.getCopy(true);
            AnnotatedTypeMirror c = this.getComponentType();
            AnnotatedTypeMirror cs = c.substitute(mappings, forDeepCopy);
            type.setComponentType(cs);
            return type;
        }

        @Override
        public AnnotatedArrayType getErased() {
            AnnotatedArrayType at = this.getCopy(true);
            AnnotatedTypeMirror ct = at.getComponentType().getErased();
            at.setComponentType(ct);
            return at;
        }

        public String toStringAsCanonical(boolean printInvisible) {
            AnnotatedTypeMirror component;
            StringBuilder sb = new StringBuilder();
            AnnotatedArrayType array = this;
            while (true) {
                component = array.getComponentType();
                if (array.getAnnotations().size() > 0) {
                    sb.append(' ');
                    sb.append(AnnotatedArrayType.formatAnnotationString(array.getAnnotations(), printInvisible));
                }
                sb.append("[]");
                if (!(component instanceof AnnotatedArrayType)) break;
                array = (AnnotatedArrayType)component;
            }
            sb.insert(0, component.toString(printInvisible));
            return sb.toString();
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            return this.toStringAsCanonical(printInvisible);
        }
    }

    public static class AnnotatedExecutableType
    extends AnnotatedTypeMirror {
        private final ExecutableType actualType;
        private ExecutableElement element;
        private final List<AnnotatedTypeMirror> paramTypes = new ArrayList<AnnotatedTypeMirror>();
        private AnnotatedDeclaredType receiverType;
        private AnnotatedTypeMirror returnType;
        private final List<AnnotatedTypeMirror> throwsTypes = new ArrayList<AnnotatedTypeMirror>();
        private final List<AnnotatedTypeVariable> typeVarTypes = new ArrayList<AnnotatedTypeVariable>();

        private AnnotatedExecutableType(ExecutableType type, AnnotatedTypeFactory factory) {
            super(type, factory);
            this.actualType = type;
        }

        public boolean isVarArgs() {
            return this.element.isVarArgs();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public ExecutableType getUnderlyingType() {
            return this.actualType;
        }

        void setParameterTypes(List<? extends AnnotatedTypeMirror> params) {
            this.paramTypes.clear();
            this.paramTypes.addAll(params);
        }

        public List<AnnotatedTypeMirror> getParameterTypes() {
            if (this.paramTypes.isEmpty() && !this.actualType.getParameterTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getParameterTypes()) {
                    this.paramTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, false));
                }
            }
            return Collections.unmodifiableList(this.paramTypes);
        }

        void setReturnType(AnnotatedTypeMirror returnType) {
            this.returnType = returnType;
        }

        public AnnotatedTypeMirror getReturnType() {
            if (this.returnType == null && this.element != null && this.actualType.getReturnType() != null) {
                TypeMirror aret = this.actualType.getReturnType();
                if (((Symbol.MethodSymbol)this.element).isConstructor()) {
                    aret = this.element.getEnclosingElement().asType();
                }
                this.returnType = AnnotatedExecutableType.createType(aret, this.atypeFactory, false);
            }
            return this.returnType;
        }

        void setReceiverType(AnnotatedDeclaredType receiverType) {
            this.receiverType = receiverType;
        }

        public @Nullable AnnotatedDeclaredType getReceiverType() {
            if (!(this.receiverType != null || ElementUtils.isStatic(this.getElement()) || this.getElement().getKind() == ElementKind.CONSTRUCTOR && this.getElement().getEnclosingElement().getSimpleName().toString().equals("Array") && this.getElement().getEnclosingElement().getEnclosingElement().asType().getKind() == TypeKind.NONE || this.getElement().getKind() == ElementKind.CONSTRUCTOR && this.getElement().getEnclosingElement().getEnclosingElement().getKind() == ElementKind.PACKAGE)) {
                TypeElement encl = ElementUtils.enclosingClass(this.getElement());
                if (this.getElement().getKind() == ElementKind.CONSTRUCTOR) {
                    encl = ElementUtils.enclosingClass(encl.getEnclosingElement());
                }
                AnnotatedTypeMirror type = AnnotatedExecutableType.createType(encl.asType(), this.atypeFactory, false);
                assert (type instanceof AnnotatedDeclaredType);
                this.receiverType = (AnnotatedDeclaredType)type;
            }
            return this.receiverType;
        }

        void setThrownTypes(List<? extends AnnotatedTypeMirror> thrownTypes) {
            this.throwsTypes.clear();
            this.throwsTypes.addAll(thrownTypes);
        }

        public List<AnnotatedTypeMirror> getThrownTypes() {
            if (this.throwsTypes.isEmpty() && !this.actualType.getThrownTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getThrownTypes()) {
                    this.throwsTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, false));
                }
            }
            return Collections.unmodifiableList(this.throwsTypes);
        }

        void setTypeVariables(List<AnnotatedTypeVariable> types) {
            this.typeVarTypes.clear();
            this.typeVarTypes.addAll(types);
        }

        public List<AnnotatedTypeVariable> getTypeVariables() {
            if (this.typeVarTypes.isEmpty() && !this.actualType.getTypeVariables().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getTypeVariables()) {
                    this.typeVarTypes.add((AnnotatedTypeVariable)AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, true));
                }
            }
            return Collections.unmodifiableList(this.typeVarTypes);
        }

        @Override
        public AnnotatedExecutableType getCopy(boolean copyAnnotations) {
            AnnotatedExecutableType type = new AnnotatedExecutableType(this.getUnderlyingType(), this.atypeFactory);
            type.setElement(this.getElement());
            type.setParameterTypes(this.getParameterTypes());
            type.setReceiverType(this.getReceiverType());
            type.setReturnType(this.getReturnType());
            type.setThrownTypes(this.getThrownTypes());
            type.setTypeVariables(this.getTypeVariables());
            return type;
        }

        public @NonNull ExecutableElement getElement() {
            return this.element;
        }

        public void setElement(@NonNull ExecutableElement elem) {
            this.element = elem;
        }

        @Override
        public AnnotatedExecutableType getErased() {
            Types types = this.atypeFactory.types;
            AnnotatedExecutableType type = new AnnotatedExecutableType((ExecutableType)types.erasure(this.getUnderlyingType()), this.atypeFactory);
            type.setElement(this.getElement());
            type.setParameterTypes(this.erasureList(this.getParameterTypes()));
            if (this.getReceiverType() != null) {
                type.setReceiverType(this.getReceiverType().getErased());
            } else {
                type.setReceiverType(null);
            }
            type.setReturnType(this.getReturnType().getErased());
            type.setThrownTypes(this.erasureList(this.getThrownTypes()));
            return type;
        }

        private List<AnnotatedTypeMirror> erasureList(List<? extends AnnotatedTypeMirror> lst) {
            ArrayList<AnnotatedTypeMirror> erased = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : lst) {
                erased.add(annotatedTypeMirror.getErased());
            }
            return erased;
        }

        @Override
        public AnnotatedExecutableType substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            AnnotatedExecutableType type = this.getCopy(true);
            ArrayList<AnnotatedTypeMirror> params = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : this.getParameterTypes()) {
                params.add(annotatedTypeMirror.substitute(mappings, forDeepCopy));
            }
            type.setParameterTypes(params);
            if (this.getReceiverType() != null) {
                type.setReceiverType((AnnotatedDeclaredType)this.getReceiverType().substitute(mappings, forDeepCopy));
            }
            type.setReturnType(this.getReturnType().substitute(mappings, forDeepCopy));
            ArrayList<AnnotatedTypeMirror> throwns = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : this.getThrownTypes()) {
                throwns.add(annotatedTypeMirror.substitute(mappings, forDeepCopy));
            }
            type.setThrownTypes(throwns);
            ArrayList<AnnotatedTypeVariable> mtvs = new ArrayList<AnnotatedTypeVariable>();
            for (AnnotatedTypeVariable annotatedTypeVariable : this.getTypeVariables()) {
                AnnotatedTypeVariable newtv = AnnotatedTypes.deepCopy(annotatedTypeVariable);
                AnnotatedTypeMirror bnd = newtv.getUpperBoundField();
                if (bnd != null) {
                    bnd = bnd.substitute(mappings, forDeepCopy);
                    newtv.setUpperBound(bnd);
                }
                if ((bnd = newtv.getLowerBoundField()) != null) {
                    bnd = bnd.substitute(mappings, forDeepCopy);
                    newtv.setLowerBound(bnd);
                }
                mtvs.add(newtv);
            }
            type.setTypeVariables(mtvs);
            return type;
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            StringBuilder sb = new StringBuilder();
            if (!this.getTypeVariables().isEmpty()) {
                sb.append('<');
                for (AnnotatedTypeVariable atv : this.getTypeVariables()) {
                    sb.append(atv.toString(printInvisible));
                }
                sb.append("> ");
            }
            if (this.getReturnType() != null) {
                sb.append(this.getReturnType().toString(printInvisible));
            } else {
                sb.append("<UNKNOWNRETURN>");
            }
            sb.append(' ');
            if (this.element != null) {
                sb.append(this.element.getSimpleName());
            } else {
                sb.append("METHOD");
            }
            sb.append('(');
            AnnotatedDeclaredType rcv = this.getReceiverType();
            if (rcv != null) {
                sb.append(rcv.toString(printInvisible));
                sb.append(" this");
            }
            if (!this.getParameterTypes().isEmpty()) {
                int p = 0;
                for (AnnotatedTypeMirror atm : this.getParameterTypes()) {
                    if (rcv != null || p > 0) {
                        sb.append(", ");
                    }
                    sb.append(atm.toString(printInvisible));
                    sb.append(" p");
                    sb.append(p++);
                }
            }
            sb.append(')');
            if (!this.getThrownTypes().isEmpty()) {
                sb.append(" throws ");
                for (AnnotatedTypeMirror atm : this.getThrownTypes()) {
                    sb.append(atm.toString(printInvisible));
                }
            }
            return sb.toString();
        }
    }

    public static class AnnotatedDeclaredType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        protected List<AnnotatedTypeMirror> typeArgs;
        private boolean wasRaw;
        protected AnnotatedDeclaredType enclosingType;
        protected List<AnnotatedDeclaredType> supertypes = null;
        private boolean declaration;

        private AnnotatedDeclaredType(DeclaredType type, AnnotatedTypeFactory atypeFactory, boolean declaration) {
            super(type, atypeFactory);
            TypeElement typeelem = (TypeElement)type.asElement();
            DeclaredType declty = (DeclaredType)typeelem.asType();
            this.wasRaw = !declty.getTypeArguments().isEmpty() && type.getTypeArguments().isEmpty();
            TypeMirror encl = type.getEnclosingType();
            if (encl.getKind() == TypeKind.DECLARED) {
                this.enclosingType = (AnnotatedDeclaredType)AnnotatedDeclaredType.createType(encl, atypeFactory, true);
            } else if (encl.getKind() != TypeKind.NONE) {
                ErrorReporter.errorAbort("AnnotatedDeclaredType: unsupported enclosing type: " + type.getEnclosingType() + " (" + (Object)((Object)encl.getKind()) + ")");
            }
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return this.declaration;
        }

        @Override
        public AnnotatedDeclaredType asUse() {
            if (!this.isDeclaration()) {
                return this;
            }
            AnnotatedDeclaredType result = this.getCopy(true);
            result.declaration = false;
            ArrayList<AnnotatedTypeVariable> newArgs = new ArrayList<AnnotatedTypeVariable>();
            for (AnnotatedTypeMirror arg : result.getTypeArguments()) {
                AnnotatedTypeVariable paramDecl = (AnnotatedTypeVariable)arg;
                assert (paramDecl.isDeclaration());
                newArgs.add(paramDecl.asUse());
            }
            result.setTypeArguments(newArgs);
            return result;
        }

        @Override
        @SideEffectFree
        public String toString(boolean printInvisible) {
            Element typeElt;
            String smpl;
            StringBuilder sb = new StringBuilder();
            if (this.declaration) {
                sb.append("/*DECL*/ ");
            }
            if ((smpl = (typeElt = this.getUnderlyingType().asElement()).getSimpleName().toString()).isEmpty()) {
                smpl = typeElt.toString();
            }
            sb.append(AnnotatedDeclaredType.formatAnnotationString(this.getAnnotations(), printInvisible));
            sb.append(smpl);
            if (!this.getTypeArguments().isEmpty()) {
                sb.append("<");
                boolean isFirst = true;
                for (AnnotatedTypeMirror typeArg : this.getTypeArguments()) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(typeArg.toString(printInvisible));
                    isFirst = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }

        public void setTypeArguments(List<? extends AnnotatedTypeMirror> ts) {
            if (ts == null || ts.isEmpty()) {
                this.typeArgs = Collections.emptyList();
            } else if (this.isDeclaration()) {
                this.typeArgs = Collections.unmodifiableList(ts);
            } else {
                ArrayList<AnnotatedTypeMirror> uses = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror annotatedTypeMirror : ts) {
                    uses.add(annotatedTypeMirror.asUse());
                }
                this.typeArgs = Collections.unmodifiableList(uses);
            }
        }

        public List<AnnotatedTypeMirror> getTypeArguments() {
            if (this.typeArgs == null) {
                this.typeArgs = new ArrayList<AnnotatedTypeMirror>();
                if (!((DeclaredType)this.actualType).getTypeArguments().isEmpty()) {
                    for (TypeMirror typeMirror : ((DeclaredType)this.actualType).getTypeArguments()) {
                        this.typeArgs.add(AnnotatedDeclaredType.createType(typeMirror, this.atypeFactory, this.declaration));
                    }
                }
                this.typeArgs = Collections.unmodifiableList(this.typeArgs);
            }
            return this.typeArgs;
        }

        public boolean wasRaw() {
            return this.wasRaw;
        }

        private void setWasRaw() {
            this.wasRaw = true;
        }

        @Override
        public DeclaredType getUnderlyingType() {
            return (DeclaredType)this.actualType;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes);
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                this.supertypes = Collections.unmodifiableList(this.directSuperTypes(this));
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        @Override
        public AnnotatedDeclaredType getCopy(boolean copyAnnotations) {
            AnnotatedDeclaredType type = new AnnotatedDeclaredType(this.getUnderlyingType(), this.atypeFactory, this.declaration);
            if (copyAnnotations) {
                type.addAnnotations(this.annotations);
            }
            type.setEnclosingType(this.getEnclosingType());
            type.setTypeArguments(this.getTypeArguments());
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings, boolean forDeepCopy) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedDeclaredType type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type);
            ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror t : this.getTypeArguments()) {
                typeArgs.add(t.substitute(newMappings, forDeepCopy));
            }
            type.setTypeArguments(typeArgs);
            return type;
        }

        @Override
        public AnnotatedDeclaredType getErased() {
            if (!this.getTypeArguments().isEmpty()) {
                Types types = this.atypeFactory.types;
                AnnotatedDeclaredType rType = (AnnotatedDeclaredType)AnnotatedTypeMirror.createType(types.erasure(this.actualType), this.atypeFactory, this.declaration);
                rType.addAnnotations(this.getAnnotations());
                rType.setTypeArguments(Collections.emptyList());
                return rType.getErased();
            }
            if (this.getEnclosingType() != null && this.getEnclosingType().getKind() != TypeKind.NONE) {
                AnnotatedDeclaredType rType = this.getCopy(true);
                AnnotatedDeclaredType et = this.getEnclosingType();
                rType.setEnclosingType(et.getErased());
                return rType;
            }
            return this;
        }

        void setEnclosingType(AnnotatedDeclaredType enclosingType) {
            this.enclosingType = enclosingType;
        }

        public AnnotatedDeclaredType getEnclosingType() {
            return this.enclosingType;
        }
    }

    public static interface AnnotatedReferenceType {
    }
}

