/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypesUtils;

public final class TreeUtils {
    private static final Set<Tree.Kind> classTreeKinds = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    private static final Set<Tree.Kind> typeTreeKinds = EnumSet.of(Tree.Kind.PRIMITIVE_TYPE, new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.TYPE_PARAMETER, Tree.Kind.ARRAY_TYPE, Tree.Kind.UNBOUNDED_WILDCARD, Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.ANNOTATED_TYPE});

    private TreeUtils() {
        throw new AssertionError((Object)"Class TreeUtils cannot be instantiated.");
    }

    public static boolean isConstructor(MethodTree tree) {
        return tree.getName().contentEquals("<init>");
    }

    public static boolean isSuperCall(MethodInvocationTree tree) {
        ExpressionTree mst = tree.getMethodSelect();
        assert (mst != null);
        if (mst.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)mst).getName().contentEquals("super");
        }
        if (mst.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree selectTree = (MemberSelectTree)mst;
            if (selectTree.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((IdentifierTree)selectTree.getExpression()).getName().contentEquals("super");
        }
        return false;
    }

    public static boolean isSelfAccess(ExpressionTree tree) {
        ExpressionTree tr = TreeUtils.skipParens(tree);
        if (tr.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return false;
        }
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            tr = ((MethodInvocationTree)tree).getMethodSelect();
        }
        if ((tr = TreeUtils.skipParens(tr)).getKind() == Tree.Kind.TYPE_CAST) {
            tr = ((TypeCastTree)tr).getExpression();
        }
        if ((tr = TreeUtils.skipParens(tr)).getKind() == Tree.Kind.IDENTIFIER) {
            return true;
        }
        if (tr.getKind() == Tree.Kind.MEMBER_SELECT && (tr = ((MemberSelectTree)tr).getExpression()).getKind() == Tree.Kind.IDENTIFIER) {
            Name ident = ((IdentifierTree)tr).getName();
            return ident.contentEquals("this") || ident.contentEquals("super");
        }
        return false;
    }

    public static Tree enclosingOfKind(TreePath path, Tree.Kind kind) {
        return TreeUtils.enclosingOfKind(path, EnumSet.of(kind));
    }

    public static Tree enclosingOfKind(TreePath path, Set<Tree.Kind> kinds) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            assert (leaf != null);
            if (!kinds.contains((Object)leaf.getKind())) continue;
            return leaf;
        }
        return null;
    }

    public static TreePath pathTillClass(TreePath path) {
        return TreeUtils.pathTillOfKind(path, TreeUtils.classTreeKinds());
    }

    public static TreePath pathTillOfKind(TreePath path, Tree.Kind kind) {
        return TreeUtils.pathTillOfKind(path, EnumSet.of(kind));
    }

    public static TreePath pathTillOfKind(TreePath path, Set<Tree.Kind> kinds) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            assert (leaf != null);
            if (!kinds.contains((Object)leaf.getKind())) continue;
            return p;
        }
        return null;
    }

    public static <T extends Tree> T enclosingOfClass(TreePath path, Class<T> treeClass) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            if (!treeClass.isInstance(leaf)) continue;
            return (T)((Tree)treeClass.cast(leaf));
        }
        return null;
    }

    public static ClassTree enclosingClass(TreePath path) {
        return (ClassTree)TreeUtils.enclosingOfKind(path, TreeUtils.classTreeKinds());
    }

    public static VariableTree enclosingVariable(TreePath path) {
        return (VariableTree)TreeUtils.enclosingOfKind(path, Tree.Kind.VARIABLE);
    }

    public static MethodTree enclosingMethod(TreePath path) {
        return (MethodTree)TreeUtils.enclosingOfKind(path, Tree.Kind.METHOD);
    }

    public static BlockTree enclosingTopLevelBlock(TreePath path) {
        for (TreePath parpath = path.getParentPath(); parpath != null && parpath.getLeaf().getKind() != Tree.Kind.CLASS; parpath = parpath.getParentPath()) {
            path = parpath;
        }
        if (path.getLeaf().getKind() == Tree.Kind.BLOCK) {
            return (BlockTree)path.getLeaf();
        }
        return null;
    }

    public static ExpressionTree skipParens(ExpressionTree tree) {
        ExpressionTree t = tree;
        while (t.getKind() == Tree.Kind.PARENTHESIZED) {
            t = ((ParenthesizedTree)t).getExpression();
        }
        return t;
    }

    public static Tree getAssignmentContext(TreePath treePath) {
        TreePath path = treePath.getParentPath();
        if (path == null) {
            return null;
        }
        Tree node = path.getLeaf();
        if (node instanceof AssignmentTree || node instanceof CompoundAssignmentTree || node instanceof MethodInvocationTree || node instanceof NewArrayTree || node instanceof NewClassTree || node instanceof ReturnTree || node instanceof VariableTree) {
            return node;
        }
        return null;
    }

    public static final TypeElement elementFromDeclaration(ClassTree node) {
        TypeElement elt = (TypeElement)InternalUtils.symbol(node);
        return elt;
    }

    public static final ExecutableElement elementFromDeclaration(MethodTree node) {
        ExecutableElement elt = (ExecutableElement)InternalUtils.symbol(node);
        return elt;
    }

    public static final VariableElement elementFromDeclaration(VariableTree node) {
        VariableElement elt = (VariableElement)InternalUtils.symbol(node);
        return elt;
    }

    public static final Element elementFromUse(ExpressionTree node) {
        return InternalUtils.symbol(node);
    }

    public static final ExecutableElement elementFromUse(MethodInvocationTree node) {
        return (ExecutableElement)TreeUtils.elementFromUse((ExpressionTree)node);
    }

    public static final ExecutableElement elementFromUse(NewClassTree node) {
        return (ExecutableElement)TreeUtils.elementFromUse((ExpressionTree)node);
    }

    public static final boolean isUseOfElement(ExpressionTree node) {
        node = TreeUtils.skipParens(node);
        switch (node.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: 
            case NEW_CLASS: {
                return true;
            }
        }
        return false;
    }

    public static final Name methodName(MethodInvocationTree node) {
        ExpressionTree expr = node.getMethodSelect();
        if (expr.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)expr).getName();
        }
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getIdentifier();
        }
        ErrorReporter.errorAbort("TreeUtils.methodName: cannot be here: " + node);
        return null;
    }

    public static final boolean containsThisConstructorInvocation(MethodTree node) {
        if (!TreeUtils.isConstructor(node) || node.getBody().getStatements().isEmpty()) {
            return false;
        }
        StatementTree st = node.getBody().getStatements().get(0);
        if (!(st instanceof ExpressionStatementTree) || !(((ExpressionStatementTree)st).getExpression() instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)st).getExpression();
        return "this".contentEquals(TreeUtils.methodName(invocation));
    }

    public static final Tree firstStatement(Tree tree) {
        BlockTree block;
        Tree first = tree.getKind() == Tree.Kind.BLOCK ? ((block = (BlockTree)tree).getStatements().isEmpty() ? block : (Tree)block.getStatements().iterator().next()) : tree;
        return first;
    }

    public static boolean hasExplicitConstructor(ClassTree node) {
        TypeElement elem = TreeUtils.elementFromDeclaration(node);
        for (ExecutableElement ee : ElementFilter.constructorsIn(elem.getEnclosedElements())) {
            Symbol.MethodSymbol ms = (Symbol.MethodSymbol)ee;
            long mod = ms.flags();
            if ((mod & 0x1000L) != 0L) continue;
            return true;
        }
        return false;
    }

    public static final boolean isDiamondTree(Tree tree) {
        switch (tree.getKind()) {
            case ANNOTATED_TYPE: {
                return TreeUtils.isDiamondTree(((AnnotatedTypeTree)tree).getUnderlyingType());
            }
            case PARAMETERIZED_TYPE: {
                return ((ParameterizedTypeTree)tree).getTypeArguments().isEmpty();
            }
            case NEW_CLASS: {
                return TreeUtils.isDiamondTree(((NewClassTree)tree).getIdentifier());
            }
        }
        return false;
    }

    public static final boolean isStringConcatenation(Tree tree) {
        return tree.getKind() == Tree.Kind.PLUS && TypesUtils.isString(InternalUtils.typeOf(tree));
    }

    public static final boolean isStringCompoundConcatenation(CompoundAssignmentTree tree) {
        return tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT && TypesUtils.isString(InternalUtils.typeOf(tree));
    }

    public static boolean isCompileTimeString(ExpressionTree node) {
        ExpressionTree tree = TreeUtils.skipParens(node);
        if (tree instanceof LiteralTree) {
            return true;
        }
        if (TreeUtils.isUseOfElement(tree)) {
            Element elt = TreeUtils.elementFromUse(tree);
            return ElementUtils.isCompileTimeConstant(elt);
        }
        if (TreeUtils.isStringConcatenation(tree)) {
            BinaryTree binOp = (BinaryTree)tree;
            return TreeUtils.isCompileTimeString(binOp.getLeftOperand()) && TreeUtils.isCompileTimeString(binOp.getRightOperand());
        }
        return false;
    }

    public static ExpressionTree getReceiverTree(ExpressionTree expression) {
        ExpressionTree receiver = TreeUtils.skipParens(expression);
        if (receiver.getKind() != Tree.Kind.METHOD_INVOCATION && receiver.getKind() != Tree.Kind.MEMBER_SELECT && receiver.getKind() != Tree.Kind.IDENTIFIER && receiver.getKind() != Tree.Kind.ARRAY_ACCESS) {
            return null;
        }
        if (receiver.getKind() == Tree.Kind.METHOD_INVOCATION) {
            if ((receiver = ((MethodInvocationTree)receiver).getMethodSelect()).getKind() == Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
                receiver = ((MemberSelectTree)receiver).getExpression();
            }
        } else {
            if (receiver.getKind() == Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (receiver.getKind() == Tree.Kind.ARRAY_ACCESS) {
                return TreeUtils.skipParens(((ArrayAccessTree)receiver).getExpression());
            }
            if (receiver.getKind() == Tree.Kind.MEMBER_SELECT && (receiver = ((MemberSelectTree)receiver).getExpression()) instanceof PrimitiveTypeTree) {
                return null;
            }
        }
        return TreeUtils.skipParens(receiver);
    }

    public static Set<Tree.Kind> classTreeKinds() {
        return classTreeKinds;
    }

    public static boolean isClassTree(Tree tree) {
        return TreeUtils.classTreeKinds().contains((Object)tree.getKind());
    }

    public static Set<Tree.Kind> typeTreeKinds() {
        return typeTreeKinds;
    }

    public static boolean isTypeTree(Tree tree) {
        return TreeUtils.typeTreeKinds().contains((Object)tree.getKind());
    }

    public static boolean isMethodInvocation(Tree tree, ExecutableElement method, ProcessingEnvironment env) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methInvok = (MethodInvocationTree)tree;
        ExecutableElement invoked = TreeUtils.elementFromUse(methInvok);
        return TreeUtils.isMethod(invoked, method, env);
    }

    private static boolean isMethod(ExecutableElement questioned, ExecutableElement method, ProcessingEnvironment env) {
        return questioned.equals(method) || env.getElementUtils().overrides(questioned, method, (TypeElement)questioned.getEnclosingElement());
    }

    public static ExecutableElement getMethod(String typeName, String methodName, int params, ProcessingEnvironment env) {
        TypeElement mapElt = env.getElementUtils().getTypeElement(typeName);
        for (ExecutableElement exec : ElementFilter.methodsIn(mapElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != params) continue;
            return exec;
        }
        ErrorReporter.errorAbort("TreeUtils.getMethod: shouldn't be here!");
        return null;
    }

    public static boolean isFieldAccess(Tree tree) {
        if (tree.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            Element el = TreeUtils.elementFromUse(memberSelect);
            return el.getKind().isField();
        }
        if (tree.getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
            IdentifierTree ident = (IdentifierTree)tree;
            Element el = TreeUtils.elementFromUse(ident);
            return el.getKind().isField() && !ident.getName().contentEquals("this") && !ident.getName().contentEquals("super");
        }
        return false;
    }

    public static String getFieldName(Tree tree) {
        assert (TreeUtils.isFieldAccess(tree));
        if (tree.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean isMethodAccess(Tree tree) {
        if (tree.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            Element el = TreeUtils.elementFromUse(memberSelect);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        if (tree.getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
            IdentifierTree ident = (IdentifierTree)tree;
            if (ident.getName().contentEquals("super") || ident.getName().contentEquals("this")) {
                return true;
            }
            Element el = TreeUtils.elementFromUse(ident);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        return false;
    }

    public static String getMethodName(Tree tree) {
        assert (TreeUtils.isMethodAccess(tree));
        if (tree.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean canHaveTypeAnnotation(Tree tree) {
        return ((JCTree)tree).type != null;
    }

    public static boolean isSpecificFieldAccess(Tree tree, VariableElement var) {
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memSel = (MemberSelectTree)tree;
            Element field = TreeUtils.elementFromUse(memSel);
            return field.equals(var);
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)tree;
            Element field = TreeUtils.elementFromUse(idTree);
            return field.equals(var);
        }
        return false;
    }

    public static VariableElement getField(String typeName, String fieldName, ProcessingEnvironment env) {
        TypeElement mapElt = env.getElementUtils().getTypeElement(typeName);
        for (VariableElement var : ElementFilter.fieldsIn(mapElt.getEnclosedElements())) {
            if (!var.getSimpleName().contentEquals(fieldName)) continue;
            return var;
        }
        ErrorReporter.errorAbort("TreeUtils.getField: shouldn't be here!");
        return null;
    }

    public static boolean isExpressionTree(Tree tree) {
        return tree instanceof ExpressionTree;
    }

    public static boolean isEnumSuper(MethodInvocationTree node) {
        ExecutableElement ex = TreeUtils.elementFromUse(node);
        Name name = ElementUtils.getQualifiedClassName(ex);
        boolean correctClass = "java.lang.Enum".contentEquals(name);
        boolean correctMethod = "<init>".contentEquals(ex.getSimpleName());
        return correctClass && correctMethod;
    }

    public static boolean isTypeDeclaration(Tree node) {
        switch (node.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case TYPE_PARAMETER: {
                return true;
            }
        }
        return false;
    }
}

