/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.framework.util.CheckerMain;

public class CheckerDevelMain
extends CheckerMain {
    private static final String PROP_PREFIX = "CheckerDevelMain";
    private static final String BINARY_PROP = "CheckerDevelMain.binary";
    private static final String CP_PROP = "CheckerDevelMain.cp";
    private static final String COMPILE_BCP_PROP = "CheckerDevelMain.compile.bcp";
    private static final String RUNTIME_BCP_PROP = "CheckerDevelMain.runtime.bcp";
    private static final String VERBOSE_PROP = "CheckerDevelMain.verbose";

    public static void main(String[] args) {
        String cp = System.getProperty(CP_PROP);
        String runtimeBcp = System.getProperty(RUNTIME_BCP_PROP);
        String compileBcp = System.getProperty(COMPILE_BCP_PROP);
        String binDir = System.getProperty(BINARY_PROP);
        String verbose = System.getProperty(VERBOSE_PROP);
        if (verbose != null && verbose.equalsIgnoreCase("TRUE")) {
            System.out.print("CheckerDevelMain:\nPrepended to classpath:     " + cp + "\n" + "Prepended to compile bootclasspath: " + compileBcp + "\n" + "Prepended to runtime bootclasspath: " + runtimeBcp + "\n" + "Binary Dir:                 " + binDir + "\n");
        }
        assert (binDir != null) : "CheckerDevelMain.binary must specify a binary directory in which checker.jar, javac.jar, etc... are usually built";
        assert (cp != null) : "CheckerDevelMain.cp must specify a path entry to prepend to the CLASSPATH";
        assert (runtimeBcp != null) : "CheckerDevelMain.runtime.bcp must specify a path entry to prepend to the Java bootclasspath when running Javac";
        assert (compileBcp != null) : "CheckerDevelMain.compile.bcp must specify a path entry to prepend to the compiler bootclasspath";
        File checkersLoc = new File(binDir, "checker.jar");
        CheckerDevelMain program = new CheckerDevelMain(checkersLoc, args);
        int exitStatus = program.invokeCompiler();
        System.exit(exitStatus);
    }

    public CheckerDevelMain(File searchPath, String[] args) {
        super(searchPath, args);
    }

    @Override
    public void assertValidState() {
    }

    @Override
    protected List<String> createRuntimeBootclasspath(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(RUNTIME_BCP_PROP, new ArrayList<String>(), new String[0]);
    }

    @Override
    public void addMainArgs(List<String> args) {
        args.add("com.sun.tools.javac.Main");
    }

    @Override
    protected List<String> createCompilationBootclasspath(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(COMPILE_BCP_PROP, super.createCompilationBootclasspath(argsList), new String[0]);
    }

    @Override
    protected List<String> createCpOpts(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(CP_PROP, super.createCpOpts(argsList), new String[0]);
    }

    private static List<String> prependPathOpts(String pathProp, List<String> pathOpts, String ... otherPaths) {
        String cp = System.getProperty(pathProp);
        ArrayList<String> newPathOpts = new ArrayList<String>();
        if (!cp.trim().isEmpty()) {
            newPathOpts.addAll(Arrays.asList(cp.split(File.pathSeparator)));
        }
        newPathOpts.addAll(Arrays.asList(otherPaths));
        newPathOpts.addAll(pathOpts);
        return newPathOpts;
    }
}

