/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public abstract class CFAbstractTransfer<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>, T extends CFAbstractTransfer<V, S, T>>
extends AbstractNodeVisitor<TransferResult<V, S>, TransferInput<V, S>>
implements TransferFunction<V, S> {
    protected CFAbstractAnalysis<V, S, T> analysis;
    protected final boolean sequentialSemantics;
    private S fixedInitialStore = null;

    public CFAbstractTransfer(CFAbstractAnalysis<V, S, T> analysis) {
        this.analysis = analysis;
        this.sequentialSemantics = !analysis.checker.hasOption("concurrentSemantics");
    }

    protected V finishValue(V value, S store) {
        return value;
    }

    protected V finishValue(V value, S thenStore, S elseStore) {
        return value;
    }

    protected V getValueFromFactory(Tree tree, Node node) {
        GenericAnnotatedTypeFactory factory = this.analysis.atypeFactory;
        Tree preTree = this.analysis.getCurrentTree();
        Pair<Tree, AnnotatedTypeMirror> preCtxt = factory.getVisitorState().getAssignmentContext();
        this.analysis.setCurrentTree(tree);
        if (node != null && node.getAssignmentContext() != null) {
            boolean oldFlow = factory.getUseFlow();
            factory.setUseFlow(false);
            Element element = node.getAssignmentContext().getElementForType();
            if (element != null) {
                AnnotatedTypeMirror assCtxt = factory.getAnnotatedType(element);
                if (assCtxt instanceof AnnotatedTypeMirror.AnnotatedExecutableType) {
                    assCtxt = ((AnnotatedTypeMirror.AnnotatedExecutableType)assCtxt).getReturnType();
                }
                factory.getVisitorState().setAssignmentContext(Pair.of(node.getAssignmentContext().getContextTree(), assCtxt));
            }
            factory.setUseFlow(oldFlow);
        }
        AnnotatedTypeMirror at = factory.getAnnotatedType(tree);
        this.analysis.setCurrentTree(preTree);
        factory.getVisitorState().setAssignmentContext(preCtxt);
        return this.analysis.createAbstractValue(at);
    }

    protected V getValueWithSameAnnotations(TypeMirror type, V annotatedValue) {
        if (annotatedValue == null) {
            return null;
        }
        GenericAnnotatedTypeFactory factory = this.analysis.atypeFactory;
        AnnotatedTypeMirror at = factory.toAnnotatedType(type, false);
        at.replaceAnnotations(((CFAbstractValue)annotatedValue).getType().getAnnotations());
        return this.analysis.createAbstractValue(at);
    }

    public void setFixedInitialStore(S s2) {
        this.fixedInitialStore = s2;
    }

    @Override
    public S initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        if (this.fixedInitialStore != null) {
            return this.fixedInitialStore;
        }
        S info = this.analysis.createEmptyStore(this.sequentialSemantics);
        if (underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            GenericAnnotatedTypeFactory<V, S, T, CFAbstractAnalysis<V, S, T>> factory = this.analysis.getTypeFactory();
            for (LocalVariableNode p : parameters) {
                AnnotatedTypeMirror anno = factory.getAnnotatedType(p.getElement());
                ((CFAbstractStore)info).initializeMethodParameter(p, this.analysis.createAbstractValue(anno));
            }
            UnderlyingAST.CFGMethod method = (UnderlyingAST.CFGMethod)underlyingAST;
            MethodTree methodTree = method.getMethod();
            ExecutableElement methodElem = TreeUtils.elementFromDeclaration(methodTree);
            this.addInformationFromPreconditions(info, factory, method, methodTree, methodElem);
            ClassTree classTree = method.getClassTree();
            TypeMirror classType = InternalUtils.typeOf(classTree);
            List<Pair<VariableElement, V>> fieldValues = this.analysis.getFieldValues();
            boolean isNotFullyInitializedReceiver = this.isNotFullyInitializedReceiver(methodTree);
            for (Pair<VariableElement, V> pair : fieldValues) {
                VariableElement element = (VariableElement)pair.first;
                CFAbstractValue value = (CFAbstractValue)pair.second;
                if (!ElementUtils.isFinal(element) && !TreeUtils.isConstructor(methodTree)) continue;
                TypeMirror fieldType = ElementUtils.getType(element);
                FlowExpressions.Receiver receiver = ElementUtils.isStatic(element) ? new FlowExpressions.ClassName(classType) : new FlowExpressions.ThisReference(classType);
                FlowExpressions.FieldAccess field = new FlowExpressions.FieldAccess(receiver, fieldType, element);
                ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)field, (CFAbstractValue)value);
            }
            for (Tree tree : classTree.getMembers()) {
                if (!(tree instanceof VariableTree)) continue;
                VariableTree vt = (VariableTree)tree;
                VariableElement element = TreeUtils.elementFromDeclaration(vt);
                AnnotatedTypeMirror type = factory.getAnnotatedType(element);
                TypeMirror fieldType = ElementUtils.getType(element);
                FlowExpressions.Receiver receiver = ElementUtils.isStatic(element) ? new FlowExpressions.ClassName(classType) : new FlowExpressions.ThisReference(classType);
                CFAbstractValue value = this.analysis.createAbstractValue(type);
                if (value == null) continue;
                if (isNotFullyInitializedReceiver) {
                    boolean found = false;
                    for (Pair<VariableElement, V> fieldValue : fieldValues) {
                        if (!((VariableElement)fieldValue.first).equals(element)) continue;
                        value = value.leastUpperBound((CFAbstractValue)((CFAbstractValue)fieldValue.second));
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                FlowExpressions.FieldAccess field = new FlowExpressions.FieldAccess(receiver, fieldType, element);
                ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)field, value);
            }
            block4: for (Map.Entry entry : this.analysis.atypeFactory.getFinalLocalValues().entrySet()) {
                Element enclosingMethodOfVariableDeclaration;
                Element elem = (Element)entry.getKey();
                for (enclosingMethodOfVariableDeclaration = elem.getEnclosingElement(); enclosingMethodOfVariableDeclaration != null && enclosingMethodOfVariableDeclaration.getKind() != ElementKind.METHOD && enclosingMethodOfVariableDeclaration.getKind() != ElementKind.CONSTRUCTOR; enclosingMethodOfVariableDeclaration = enclosingMethodOfVariableDeclaration.getEnclosingElement()) {
                }
                if (enclosingMethodOfVariableDeclaration == null) continue;
                for (Element enclosingMethodOfCurrentMethod = methodElem.getEnclosingElement(); enclosingMethodOfCurrentMethod != null; enclosingMethodOfCurrentMethod = enclosingMethodOfCurrentMethod.getEnclosingElement()) {
                    if (!enclosingMethodOfVariableDeclaration.equals(enclosingMethodOfCurrentMethod)) continue;
                    FlowExpressions.LocalVariable l = new FlowExpressions.LocalVariable(elem);
                    ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)l, (CFAbstractValue)((CFAbstractValue)entry.getValue()));
                    continue block4;
                }
            }
        }
        return info;
    }

    protected boolean isNotFullyInitializedReceiver(MethodTree methodTree) {
        return TreeUtils.isConstructor(methodTree);
    }

    protected void addInformationFromPreconditions(S info, AnnotatedTypeFactory factory, UnderlyingAST.CFGMethod method, MethodTree methodTree, ExecutableElement methodElement) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, String>> preconditions = contracts.getPreconditions(methodElement);
        for (Pair<String, String> p : preconditions) {
            String expression = (String)p.first;
            AnnotationMirror annotation = AnnotationUtils.fromName(this.analysis.getTypeFactory().getElementUtils(), (CharSequence)p.second);
            if (!this.analysis.getTypeFactory().isSupportedQualifier(annotation)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(methodTree, method.getClassTree(), this.analysis.getTypeFactory());
            }
            FlowExpressions.Receiver expr = null;
            try {
                expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.analysis.atypeFactory.getPath(methodTree));
                ((CFAbstractStore)info).insertValue(expr, annotation);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.analysis.checker.report(e.getResult(), methodTree);
            }
        }
    }

    @Override
    public TransferResult<V, S> visitNode(Node n, TransferInput<V, S> in) {
        V value = null;
        Tree tree = n.getTree();
        if (tree != null && TreeUtils.canHaveTypeAnnotation(tree)) {
            value = this.getValueFromFactory(tree, n);
        }
        if (in.containsTwoStores()) {
            CFAbstractStore thenStore = (CFAbstractStore)in.getThenStore();
            CFAbstractStore elseStore = (CFAbstractStore)in.getElseStore();
            return new ConditionalTransferResult<Object, CFAbstractStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(value, info), info);
    }

    @Override
    public TransferResult<V, S> visitClassName(ClassNameNode n, TransferInput<V, S> in) {
        V value = null;
        Tree tree = n.getTree();
        if (tree != null && TreeUtils.canHaveTypeAnnotation(tree)) {
            GenericAnnotatedTypeFactory factory = this.analysis.atypeFactory;
            this.analysis.setCurrentTree(tree);
            AnnotatedTypeMirror at = factory.getAnnotatedTypeFromTypeTree(tree);
            this.analysis.setCurrentTree(null);
            value = this.analysis.createAbstractValue(at);
        }
        if (in.containsTwoStores()) {
            CFAbstractStore thenStore = (CFAbstractStore)in.getThenStore();
            CFAbstractStore elseStore = (CFAbstractStore)in.getElseStore();
            return new ConditionalTransferResult<Object, CFAbstractStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(value, info), info);
    }

    @Override
    public TransferResult<V, S> visitFieldAccess(FieldAccessNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        Object storeValue = store.getValue(n);
        V factoryValue = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(factoryValue, storeValue);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitArrayAccess(ArrayAccessNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        Object storeValue = store.getValue(n);
        V factoryValue = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(factoryValue, storeValue);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitLocalVariable(LocalVariableNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        Object valueFromStore = store.getValue(n);
        V valueFromFactory = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(valueFromFactory, valueFromStore);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitTernaryExpression(TernaryExpressionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitTernaryExpression(n, p);
        CFAbstractStore store = (CFAbstractStore)result.getRegularStore();
        CFAbstractValue thenValue = (CFAbstractValue)p.getValueOfSubNode(n.getThenOperand());
        CFAbstractValue elseValue = (CFAbstractValue)p.getValueOfSubNode(n.getElseOperand());
        CFAbstractValue resultValue = null;
        if (thenValue != null && elseValue != null) {
            resultValue = thenValue.leastUpperBound(elseValue);
        }
        return new RegularTransferResult<CFAbstractValue, CFAbstractStore>(this.finishValue(resultValue, store), store);
    }

    @Override
    public TransferResult<V, S> visitConditionalNot(ConditionalNotNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitConditionalNot(n, p);
        CFAbstractStore thenStore = (CFAbstractStore)result.getThenStore();
        CFAbstractStore elseStore = (CFAbstractStore)result.getElseStore();
        return new ConditionalTransferResult(result.getResultValue(), elseStore, thenStore);
    }

    @Override
    public TransferResult<V, S> visitEqualTo(EqualToNode n, TransferInput<V, S> p) {
        TransferResult<CFAbstractValue, S> res = (TransferResult<CFAbstractValue, S>)super.visitEqualTo(n, p);
        Node leftN = n.getLeftOperand();
        Node rightN = n.getRightOperand();
        CFAbstractValue leftV = (CFAbstractValue)p.getValueOfSubNode(leftN);
        CFAbstractValue rightV = (CFAbstractValue)p.getValueOfSubNode(rightN);
        res = this.strengthenAnnotationOfEqualTo(res, leftN, rightN, leftV, rightV, false);
        res = this.strengthenAnnotationOfEqualTo(res, rightN, leftN, rightV, leftV, false);
        return res;
    }

    @Override
    public TransferResult<V, S> visitNotEqual(NotEqualNode n, TransferInput<V, S> p) {
        TransferResult<CFAbstractValue, S> res = (TransferResult<CFAbstractValue, S>)super.visitNotEqual(n, p);
        Node leftN = n.getLeftOperand();
        Node rightN = n.getRightOperand();
        CFAbstractValue leftV = (CFAbstractValue)p.getValueOfSubNode(leftN);
        CFAbstractValue rightV = (CFAbstractValue)p.getValueOfSubNode(rightN);
        res = this.strengthenAnnotationOfEqualTo(res, leftN, rightN, leftV, rightV, true);
        res = this.strengthenAnnotationOfEqualTo(res, rightN, leftN, rightV, leftV, true);
        return res;
    }

    protected TransferResult<V, S> strengthenAnnotationOfEqualTo(TransferResult<V, S> res, Node firstNode, Node secondNode, V firstValue, V secondValue, boolean notEqualTo) {
        if (firstValue != null && !((CFAbstractValue)firstValue).equals(secondValue)) {
            List<Node> secondParts = this.splitAssignments(secondNode);
            for (Node secondPart : secondParts) {
                FlowExpressions.Receiver secondInternal = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), secondPart);
                if (!CFAbstractStore.canInsertReceiver(secondInternal)) continue;
                CFAbstractStore thenStore = (CFAbstractStore)res.getThenStore();
                CFAbstractStore elseStore = (CFAbstractStore)res.getElseStore();
                if (notEqualTo) {
                    elseStore.insertValue(secondInternal, firstValue);
                } else {
                    thenStore.insertValue(secondInternal, firstValue);
                }
                return new ConditionalTransferResult<V, CFAbstractStore>(res.getResultValue(), thenStore, elseStore);
            }
        }
        return res;
    }

    protected List<Node> splitAssignments(Node node) {
        if (node instanceof AssignmentNode) {
            ArrayList<Node> result = new ArrayList<Node>();
            AssignmentNode a = (AssignmentNode)node;
            result.add(a.getTarget());
            result.addAll(this.splitAssignments(a.getExpression()));
            return result;
        }
        return Collections.singletonList(node);
    }

    @Override
    public TransferResult<V, S> visitAssignment(AssignmentNode n, TransferInput<V, S> in) {
        Node lhs = n.getTarget();
        Node rhs = n.getExpression();
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        CFAbstractValue rhsValue = (CFAbstractValue)in.getValueOfSubNode(rhs);
        this.processCommonAssignment(in, lhs, rhs, info, rhsValue);
        return new RegularTransferResult<CFAbstractValue, CFAbstractStore>(this.finishValue(rhsValue, info), info);
    }

    @Override
    public TransferResult<V, S> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<V, S> in) {
        TransferResult result = (TransferResult)super.visitStringConcatenateAssignment(n, in);
        Node lhs = n.getLeftOperand();
        Node rhs = n.getRightOperand();
        CFAbstractStore info = (CFAbstractStore)result.getRegularStore();
        CFAbstractValue rhsValue = (CFAbstractValue)result.getResultValue();
        this.processCommonAssignment(in, lhs, rhs, info, rhsValue);
        return result;
    }

    protected void processCommonAssignment(TransferInput<V, S> in, Node lhs, Node rhs, S info, V rhsValue) {
        ((CFAbstractStore)info).updateForAssignment(lhs, rhsValue);
    }

    @Override
    public TransferResult<V, S> visitMethodInvocation(MethodInvocationNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        ExecutableElement method = n.getTarget().getMethod();
        V factoryValue = null;
        MethodInvocationTree tree = n.getTree();
        if (tree != null) {
            factoryValue = this.getValueFromFactory(tree, n);
        }
        Object storeValue = store.getValue(n);
        V resValue = this.moreSpecificValue(factoryValue, storeValue);
        store.updateForMethodCall(n, this.analysis.atypeFactory, resValue);
        this.processPostconditions(n, store, method, tree);
        CFAbstractStore thenStore = store;
        Store elseStore = thenStore.copy();
        this.processConditionalPostconditions(n, method, tree, thenStore, elseStore);
        return new ConditionalTransferResult<Object, Store>(this.finishValue(resValue, thenStore, elseStore), thenStore, elseStore);
    }

    protected void processPostconditions(MethodInvocationNode n, S store, ExecutableElement methodElement, Tree tree) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        Set<Pair<String, String>> postconditions = contracts.getPostconditions(methodElement);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (Pair<String, String> p : postconditions) {
            String expression = (String)p.first;
            AnnotationMirror anno = AnnotationUtils.fromName(this.analysis.getTypeFactory().getElementUtils(), (CharSequence)p.second);
            if (!this.analysis.getTypeFactory().isSupportedQualifier(anno)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForUse(n, this.analysis.getTypeFactory());
            }
            try {
                FlowExpressions.Receiver r = null;
                String s2 = expression.trim();
                Pattern selfPattern = Pattern.compile("^(this)$");
                Matcher selfMatcher = selfPattern.matcher(s2);
                if (selfMatcher.matches()) {
                    s2 = flowExprContext.receiver.toString();
                    if (flowExprContext.receiver instanceof FlowExpressions.FieldAccess) {
                        FlowExpressions.FieldAccess foo = (FlowExpressions.FieldAccess)flowExprContext.receiver;
                        FlowExpressions.Receiver bar = foo.getReceiver();
                        flowExprContext = flowExprContext.changeReceiver(bar);
                    }
                }
                r = FlowExpressionParseUtil.parse(s2, flowExprContext, this.analysis.atypeFactory.getPath(tree));
                ((CFAbstractStore)store).insertValue(r, anno);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {}
        }
    }

    protected void processConditionalPostconditions(MethodInvocationNode n, ExecutableElement methodElement, Tree tree, S thenStore, S elseStore) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        Set<Pair<String, Pair<Boolean, String>>> conditionalPostconditions = contracts.getConditionalPostconditions(methodElement);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (Pair<String, Pair<Boolean, String>> p : conditionalPostconditions) {
            String expression = (String)p.first;
            AnnotationMirror anno = AnnotationUtils.fromName(this.analysis.getTypeFactory().getElementUtils(), (CharSequence)((Pair)p.second).second);
            boolean result = (Boolean)((Pair)p.second).first;
            if (!this.analysis.getTypeFactory().isSupportedQualifier(anno)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForUse(n, this.analysis.getTypeFactory());
            }
            try {
                FlowExpressions.Receiver r = null;
                String s2 = expression.trim();
                Pattern selfPattern = Pattern.compile("^(this)$");
                Matcher selfMatcher = selfPattern.matcher(s2);
                if (selfMatcher.matches()) {
                    s2 = flowExprContext.receiver.toString();
                    if (flowExprContext.receiver instanceof FlowExpressions.FieldAccess) {
                        flowExprContext = flowExprContext.changeReceiver(((FlowExpressions.FieldAccess)flowExprContext.receiver).getReceiver());
                    }
                }
                r = FlowExpressionParseUtil.parse(s2, flowExprContext, this.analysis.atypeFactory.getPath(tree));
                if (result) {
                    ((CFAbstractStore)thenStore).insertValue(r, anno);
                    continue;
                }
                ((CFAbstractStore)elseStore).insertValue(r, anno);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {}
        }
    }

    @Override
    public TransferResult<V, S> visitCase(CaseNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(null, store), store);
    }

    @Override
    public TransferResult<V, S> visitInstanceOf(InstanceOfNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitInstanceOf(n, p);
        V factoryValue = this.getValueFromFactory(n.getTree().getType(), null);
        CFAbstractValue operandValue = (CFAbstractValue)p.getValueOfSubNode(n.getOperand());
        CFAbstractValue mostPreciseValue = this.moreSpecificValue(factoryValue, operandValue);
        FlowExpressions.Receiver operandInternal = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), n.getOperand());
        if (CFAbstractStore.canInsertReceiver(operandInternal)) {
            CFAbstractStore thenStore = (CFAbstractStore)result.getThenStore();
            CFAbstractStore elseStore = (CFAbstractStore)result.getElseStore();
            thenStore.insertValue(operandInternal, mostPreciseValue);
            return new ConditionalTransferResult(result.getResultValue(), thenStore, elseStore);
        }
        return result;
    }

    public V moreSpecificValue(V value1, V value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return ((CFAbstractValue)value1).mostSpecific(value2, value1);
    }

    @Override
    public TransferResult<V, S> visitVariableDeclaration(VariableDeclarationNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(null, store), store);
    }

    @Override
    public TransferResult<V, S> visitNarrowingConversion(NarrowingConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitNarrowingConversion(n, p);
        CFAbstractValue operandValue = (CFAbstractValue)p.getValueOfSubNode(n.getOperand());
        CFAbstractValue narrowedValue = this.getValueWithSameAnnotations(n.getType(), operandValue);
        result.setResultValue(narrowedValue);
        return result;
    }

    @Override
    public TransferResult<V, S> visitWideningConversion(WideningConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitWideningConversion(n, p);
        CFAbstractValue operandValue = (CFAbstractValue)p.getValueOfSubNode(n.getOperand());
        CFAbstractValue widenedValue = this.getValueWithSameAnnotations(n.getType(), operandValue);
        result.setResultValue(widenedValue);
        return result;
    }

    @Override
    public TransferResult<V, S> visitStringConversion(StringConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitStringConversion(n, p);
        result.setResultValue(p.getValueOfSubNode(n.getOperand()));
        return result;
    }
}

