/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.Operators;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ListTreeAnnotator;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

@TypeQualifiers(value={ArrayLen.class, BoolVal.class, DoubleVal.class, IntVal.class, StringVal.class, BottomVal.class, UnknownVal.class})
public class ValueAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror INTVAL;
    protected final AnnotationMirror DOUBLEVAL;
    protected final AnnotationMirror BOOLVAL;
    protected final AnnotationMirror ARRAYLEN;
    protected final AnnotationMirror STRINGVAL;
    protected final AnnotationMirror BOTTOMVAL;
    protected final AnnotationMirror UNKNOWNVAL;
    protected final AnnotationMirror STATICALLY_EXECUTABLE;
    protected static final Set<javax.lang.model.element.Modifier> PUBLIC_STATIC_FINAL_SET = new HashSet<javax.lang.model.element.Modifier>(3);
    private long t = 0L;
    protected static final int MAX_VALUES = 10;
    protected final List<AnnotationMirror> constantAnnotations;
    protected Set<String> coveredClassStrings;

    public ValueAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.PUBLIC);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.FINAL);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.STATIC);
        this.INTVAL = AnnotationUtils.fromClass(this.elements, IntVal.class);
        this.BOOLVAL = AnnotationUtils.fromClass(this.elements, BoolVal.class);
        this.ARRAYLEN = AnnotationUtils.fromClass(this.elements, ArrayLen.class);
        this.DOUBLEVAL = AnnotationUtils.fromClass(this.elements, DoubleVal.class);
        this.STRINGVAL = AnnotationUtils.fromClass(this.elements, StringVal.class);
        this.BOTTOMVAL = AnnotationUtils.fromClass(this.elements, BottomVal.class);
        this.STATICALLY_EXECUTABLE = AnnotationUtils.fromClass(this.elements, StaticallyExecutable.class);
        this.UNKNOWNVAL = AnnotationUtils.fromClass(this.elements, UnknownVal.class);
        this.constantAnnotations = new ArrayList<AnnotationMirror>(9);
        this.constantAnnotations.add(this.DOUBLEVAL);
        this.constantAnnotations.add(this.INTVAL);
        this.constantAnnotations.add(this.BOOLVAL);
        this.constantAnnotations.add(this.STRINGVAL);
        this.constantAnnotations.add(this.BOTTOMVAL);
        this.constantAnnotations.add(this.ARRAYLEN);
        this.constantAnnotations.add(this.STATICALLY_EXECUTABLE);
        this.constantAnnotations.add(this.UNKNOWNVAL);
        this.coveredClassStrings = new HashSet<String>(19);
        this.coveredClassStrings.add("int");
        this.coveredClassStrings.add("java.lang.Integer");
        this.coveredClassStrings.add("double");
        this.coveredClassStrings.add("java.lang.Double");
        this.coveredClassStrings.add("byte");
        this.coveredClassStrings.add("java.lang.Byte");
        this.coveredClassStrings.add("java.lang.String");
        this.coveredClassStrings.add("char");
        this.coveredClassStrings.add("java.lang.Character");
        this.coveredClassStrings.add("float");
        this.coveredClassStrings.add("java.lang.Float");
        this.coveredClassStrings.add("boolean");
        this.coveredClassStrings.add("java.lang.Boolean");
        this.coveredClassStrings.add("long");
        this.coveredClassStrings.add("java.lang.Long");
        this.coveredClassStrings.add("short");
        this.coveredClassStrings.add("java.lang.Short");
        this.coveredClassStrings.add("byte[]");
        if (this.getClass().equals(ValueAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    public AnnotationMirror createAnnotation(String name, Set<?> values) {
        if (values.size() > 0 && values.size() <= 10) {
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, name);
            ArrayList valuesList = new ArrayList(values);
            builder.setValue((CharSequence)"value", valuesList);
            return builder.build();
        }
        return this.UNKNOWNVAL;
    }

    @Override
    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ValueQualifierHierarchy(factory);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new ValueTreeAnnotator(this));
    }

    @Override
    protected QualifierDefaults createQualifierDefaults() {
        QualifierDefaults defaults = super.createQualifierDefaults();
        defaults.addAbsoluteDefault(this.UNKNOWNVAL, DefaultLocation.OTHERWISE);
        return defaults;
    }

    private boolean isNumberAnnotation(AnnotationMirror anno) {
        return AnnotationUtils.areSameIgnoringValues(anno, this.INTVAL) || AnnotationUtils.areSameIgnoringValues(anno, this.DOUBLEVAL);
    }

    protected class ValueTreeAnnotator
    extends TreeAnnotator {
        public ValueTreeAnnotator(ValueAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
            TreePath path = ValueAnnotatedTypeFactory.this.getPath(tree);
            if (path.getLeaf().getKind() != Tree.Kind.CLASS) {
                List<? extends ExpressionTree> dimensions = tree.getDimensions();
                List<? extends ExpressionTree> initializers = tree.getInitializers();
                if (!dimensions.isEmpty()) {
                    this.handleDimensions(dimensions, (AnnotatedTypeMirror.AnnotatedArrayType)type);
                } else {
                    int length = initializers.size();
                    HashSet<Integer> value = new HashSet<Integer>();
                    if (length == 0) {
                        value.add(length);
                    } else if (length > 0 && !initializers.get(0).getClass().equals(List.class)) {
                        value.add(length);
                    }
                    String typeString = type.getUnderlyingType().toString();
                    if (typeString.equals("byte[]") || typeString.equals("char[]")) {
                        boolean allLiterals = true;
                        char[] chars = new char[initializers.size()];
                        for (int i = 0; i < chars.length && allLiterals; ++i) {
                            ExpressionTree e = initializers.get(i);
                            if (e.getKind() == Tree.Kind.INT_LITERAL) {
                                chars[i] = (char)((Long)((LiteralTree)initializers.get(i)).getValue()).intValue();
                                continue;
                            }
                            allLiterals = false;
                        }
                        if (allLiterals) {
                            HashSet<String> stringFromChars = new HashSet<String>(1);
                            stringFromChars.add(new String(chars));
                            AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringFromChars);
                            type.replaceAnnotation(newQual);
                            return null;
                        }
                    }
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.ArrayLen", value);
                    type.replaceAnnotation(newQual);
                }
            }
            return (Void)super.visitNewArray(tree, type);
        }

        private void handleDimensions(List<? extends ExpressionTree> dimensions, AnnotatedTypeMirror.AnnotatedArrayType type) {
            AnnotationMirror dimType;
            if (dimensions.size() > 1) {
                this.handleDimensions(dimensions.subList(1, dimensions.size()), (AnnotatedTypeMirror.AnnotatedArrayType)type.getComponentType());
            }
            if (AnnotationUtils.areSameIgnoringValues(dimType = ValueAnnotatedTypeFactory.this.getAnnotatedType(dimensions.get(0)).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.INTVAL), ValueAnnotatedTypeFactory.this.INTVAL)) {
                List<Long> longLengths = AnnotationUtils.getElementValueArray(dimType, "value", Long.class, true);
                HashSet<Integer> lengths = new HashSet<Integer>(longLengths.size());
                for (Long l : longLengths) {
                    lengths.add(l.intValue());
                }
                AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.ArrayLen", lengths);
                type.replaceAnnotation(newQual);
            } else {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree, AnnotatedTypeMirror type) {
            if (this.isClassCovered(type)) {
                String castedToString = type.getUnderlyingType().toString();
                this.handleCast(tree.getExpression(), castedToString, type);
            }
            return (Void)super.visitTypeCast(tree, type);
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, AnnotatedTypeMirror type) {
            super.visitAssignment(tree, type);
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (this.isClassCovered(type)) {
                if (tree.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                    HashSet<Boolean> values = new HashSet<Boolean>();
                    values.add((Boolean)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.BoolVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add(Long.valueOf(((Character)tree.getValue()).charValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.DOUBLE_LITERAL) {
                    HashSet<Double> values = new HashSet<Double>();
                    values.add((Double)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.FLOAT_LITERAL) {
                    HashSet<Double> values = new HashSet<Double>();
                    values.add(new Double(((Float)tree.getValue()).floatValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.INT_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add(new Long(((Integer)tree.getValue()).intValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.LONG_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add((Long)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    HashSet<String> values = new HashSet<String>();
                    values.add((String)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
            }
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror type) {
            super.visitUnary(tree, type);
            if (this.isClassCovered(type)) {
                Tree.Kind operation = tree.getKind();
                String finalTypeString = type.getUnderlyingType().toString();
                AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
                if (!this.nonValueAnno(argType)) {
                    Class<?> argClass = this.getTypeValueClass(finalTypeString, tree);
                    this.handleCast(tree.getExpression(), finalTypeString, argType);
                    AnnotationMirror argAnno = this.getValueAnnotation(argType);
                    AnnotationMirror newAnno = this.evaluateUnaryOperator(argAnno, operation.toString(), argClass, tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                        return null;
                    }
                }
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return null;
        }

        private AnnotationMirror evaluateUnaryOperator(AnnotationMirror argAnno, String operation, Class<?> argClass, UnaryTree tree) {
            try {
                Class[] argClasses = new Class[]{argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                List<?> annoValues = AnnotationUtils.getElementValueArray(argAnno, "value", argClass, true);
                ArrayList<Object> results = new ArrayList<Object>(annoValues.size());
                for (Object val : annoValues) {
                    results.add(m3.invoke(null, val));
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.unary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (!this.isClassCovered(type)) {
                return (Void)super.visitBinary(tree, type);
            }
            Tree.Kind operation = tree.getKind();
            String finalTypeString = type.getUnderlyingType().toString();
            AnnotatedTypeMirror lhsType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
            AnnotatedTypeMirror rhsType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
            if (!this.nonValueAnno(lhsType) && !this.nonValueAnno(rhsType)) {
                Class<?> argClass = null;
                AnnotationMirror newAnno = null;
                if (operation != Tree.Kind.EQUAL_TO && operation != Tree.Kind.NOT_EQUAL_TO && operation != Tree.Kind.GREATER_THAN && operation != Tree.Kind.GREATER_THAN_EQUAL && operation != Tree.Kind.LESS_THAN && operation != Tree.Kind.LESS_THAN_EQUAL) {
                    argClass = this.getClass(finalTypeString, tree);
                    this.handleBinaryCast(tree.getLeftOperand(), lhsType, tree.getRightOperand(), rhsType, finalTypeString);
                    newAnno = this.evaluateBinaryOperator(lhsType, rhsType, operation.toString(), argClass, tree);
                } else {
                    if (AnnotationUtils.areSameIgnoringValues(this.getValueAnnotation(lhsType), ValueAnnotatedTypeFactory.this.STRINGVAL)) {
                        argClass = this.getAnnotationValueClass(this.getValueAnnotation(lhsType));
                    } else {
                        argClass = this.getTypeValueClass("double", tree);
                        this.handleBinaryCast(tree.getLeftOperand(), lhsType, tree.getRightOperand(), rhsType, "double");
                    }
                    newAnno = this.evaluateComparison(lhsType, rhsType, operation.toString(), argClass, tree);
                }
                if (newAnno != null) {
                    type.replaceAnnotation(newAnno);
                    return null;
                }
            }
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            return null;
        }

        private void handleBinaryCast(ExpressionTree lhs, AnnotatedTypeMirror lhsType, ExpressionTree rhs, AnnotatedTypeMirror rhsType, String finalTypeString) {
            this.handleCast(lhs, finalTypeString, lhsType);
            this.handleCast(rhs, finalTypeString, rhsType);
        }

        private AnnotationMirror evaluateComparison(AnnotatedTypeMirror lhsType, AnnotatedTypeMirror rhsType, String operation, Class<?> argClass, BinaryTree tree) {
            try {
                Class[] argClasses = new Class[]{argClass, argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                List<?> lhsAnnoValues = AnnotationUtils.getElementValueArray(this.getValueAnnotation(lhsType), "value", argClass, true);
                List<?> rhsAnnoValues = AnnotationUtils.getElementValueArray(this.getValueAnnotation(rhsType), "value", argClass, true);
                ArrayList<Object> results = new ArrayList<Object>(lhsAnnoValues.size() * rhsAnnoValues.size());
                for (Object lhsO : lhsAnnoValues) {
                    for (Object rhsO : rhsAnnoValues) {
                        results.add(m3.invoke(null, lhsO, rhsO));
                    }
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.binary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        private AnnotationMirror evaluateBinaryOperator(AnnotatedTypeMirror lhsType, AnnotatedTypeMirror rhsType, String operation, Class<?> argClass, BinaryTree tree) {
            try {
                Class[] argClasses = new Class[]{argClass, argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                List<Object> lhsAnnoValues = this.getCastedValues(lhsType, argClass, tree);
                List<Object> rhsAnnoValues = this.getCastedValues(rhsType, argClass, tree);
                ArrayList<Object> results = new ArrayList<Object>(lhsAnnoValues.size() * rhsAnnoValues.size());
                for (Object lhsO : lhsAnnoValues) {
                    for (Object rhsO : rhsAnnoValues) {
                        results.add(m3.invoke(null, lhsO, rhsO));
                    }
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.binary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        private boolean methodIsStaticallyExecutable(Element method) {
            return ValueAnnotatedTypeFactory.this.getDeclAnnotation(method, StaticallyExecutable.class) != null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            super.visitMethodInvocation(tree, type);
            if (this.isClassCovered(type) && this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree))) {
                ExpressionTree methodTree = tree.getMethodSelect();
                List<? extends ExpressionTree> argTrees = tree.getArguments();
                ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
                for (Tree tree2 : argTrees) {
                    argTypes.add(ValueAnnotatedTypeFactory.this.getAnnotatedType(tree2));
                }
                boolean known = true;
                for (AnnotatedTypeMirror t : argTypes) {
                    if (!this.nonValueAnno(t)) continue;
                    known = false;
                }
                if (known) {
                    boolean bl = false;
                    AnnotatedTypeMirror recType = null;
                    Method method = null;
                    try {
                        method = this.getMethodObject(tree);
                        boolean bl2 = Modifier.isStatic(method.getModifiers());
                        if (!bl2) {
                            recType = ValueAnnotatedTypeFactory.this.getAnnotatedType(((MemberSelectTree)methodTree).getExpression());
                        }
                        if (bl2 || !this.nonValueAnno(recType)) {
                            AnnotationMirror newAnno;
                            if (!method.isAccessible()) {
                                method.setAccessible(true);
                            }
                            if ((newAnno = this.evaluateMethod(recType, method, argTypes, type, tree)) != null) {
                                type.replaceAnnotation(newAnno);
                                return null;
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("class.find.failed", TreeUtils.elementFromUse(tree).getEnclosingElement()), tree);
                    }
                    catch (NoSuchMethodException e) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.find.failed", ((MemberSelectTree)methodTree).getIdentifier(), argTypes, recType), tree);
                    }
                }
            }
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            return null;
        }

        private Method getMethodObject(MethodInvocationTree tree) throws ClassNotFoundException, NoSuchMethodException {
            ExecutableElement ele = TreeUtils.elementFromUse(tree);
            ele.getEnclosingElement();
            Name clazz = TypesUtils.getQualifiedName((DeclaredType)ele.getEnclosingElement().asType());
            List<? extends VariableElement> paramEles = ele.getParameters();
            ArrayList paramClzz = new ArrayList();
            for (Element element : paramEles) {
                TypeMirror pType = ElementUtils.getType(element);
                if (pType.getKind() == TypeKind.ARRAY) {
                    ArrayType pArrayType = (ArrayType)pType;
                    String par = TypesUtils.getQualifiedName((DeclaredType)pArrayType.getComponentType()).toString();
                    if (par.equals("java.lang.Object")) {
                        paramClzz.add(Object[].class);
                        continue;
                    }
                    if (!par.equals("java.lang.String")) continue;
                    paramClzz.add(String[].class);
                    continue;
                }
                String paramClass = ElementUtils.getType(element).toString();
                if (paramClass.contains("java")) {
                    paramClzz.add(Class.forName(paramClass));
                    continue;
                }
                paramClzz.add(this.getClass(paramClass, tree));
            }
            Class<?> clzz = Class.forName(clazz.toString());
            Method method = clzz.getMethod(ele.getSimpleName().toString(), paramClzz.toArray(new Class[0]));
            return method;
        }

        private AnnotationMirror evaluateMethod(AnnotatedTypeMirror recType, Method method, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror retType, MethodInvocationTree tree) {
            List<Object> recValues = null;
            if (!Modifier.isStatic(method.getModifiers())) {
                recValues = this.getCastedValues(recType, tree);
            }
            ArrayDeque<List<Object>> allArgValues = this.getAllArgumentAnnotationValues(argTypes, tree);
            ArrayDeque<Object> specificArgValues = new ArrayDeque<Object>();
            ArrayList<Object> results = new ArrayList<Object>();
            this.evaluateMethodHelper(allArgValues, specificArgValues, recValues, method, results, tree);
            return this.resultAnnotationHandler(retType, results, (Tree)tree);
        }

        private void evaluateMethodHelper(ArrayDeque<List<Object>> argArrayDeque, ArrayDeque<Object> values, List<Object> receiverValues, Method method, List<Object> results, MethodInvocationTree tree) {
            block10: {
                if (argArrayDeque.size() == 0) {
                    try {
                        if (receiverValues != null) {
                            for (Object o : receiverValues) {
                                if (values.size() > 0) {
                                    results.add(method.invoke(o, values.toArray()));
                                    continue;
                                }
                                results.add(method.invoke(o, new Object[0]));
                            }
                            break block10;
                        }
                        if (values.size() > 0) {
                            results.add(method.invoke(null, values.toArray()));
                            break block10;
                        }
                        results.add(method.invoke(null, new Object[0]));
                    }
                    catch (InvocationTargetException e) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.evaluation.exception", method, e.getTargetException().toString()), tree);
                        results = new ArrayList<Object>();
                    }
                    catch (ReflectiveOperationException e) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.evaluation.failed", method), tree);
                        results = new ArrayList<Object>();
                    }
                } else {
                    List<Object> argValues = argArrayDeque.pop();
                    for (Object o : argValues) {
                        values.push(o);
                        this.evaluateMethodHelper(argArrayDeque, values, receiverValues, method, results, tree);
                        values.pop();
                    }
                }
            }
        }

        @Override
        public Void visitNewClass(NewClassTree tree, AnnotatedTypeMirror type) {
            super.visitNewClass(tree, type);
            if (this.isClassCovered(type)) {
                List<? extends ExpressionTree> argTrees = tree.getArguments();
                ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
                for (ExpressionTree expressionTree : argTrees) {
                    argTypes.add(ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree));
                }
                boolean known = true;
                for (AnnotatedTypeMirror t : argTypes) {
                    if (!this.nonValueAnno(t)) continue;
                    known = false;
                    break;
                }
                if (known) {
                    try {
                        Class<?>[] classArray = this.getClassList(argTypes, tree);
                        Class<?> recClass = Class.forName(type.getUnderlyingType().toString());
                        Constructor<?> constructor = recClass.getConstructor(classArray);
                        AnnotationMirror newAnno = this.evaluateNewClass(constructor, argTypes, type, tree);
                        if (newAnno != null) {
                            type.replaceAnnotation(newAnno);
                            return null;
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("constructor.evaluation.failed", type.getUnderlyingType(), argTypes), tree);
                    }
                }
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return null;
        }

        private AnnotationMirror evaluateNewClass(Constructor<?> constructor, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror retType, NewClassTree tree) {
            ArrayDeque<List<Object>> allArgValues = this.getAllArgumentAnnotationValues(argTypes, tree);
            ArrayDeque<Object> specificArgValues = new ArrayDeque<Object>();
            ArrayList<Object> results = new ArrayList<Object>();
            this.evaluateNewClassHelper(allArgValues, specificArgValues, constructor, results, tree);
            return this.resultAnnotationHandler(retType, results, (Tree)tree);
        }

        private void evaluateNewClassHelper(ArrayDeque<List<Object>> argArrayDeque, ArrayDeque<Object> values, Constructor<?> constructor, List<Object> results, NewClassTree tree) {
            block6: {
                if (argArrayDeque.size() == 0) {
                    try {
                        if (values.size() > 0) {
                            results.add(constructor.newInstance(values.toArray()));
                            break block6;
                        }
                        results.add(constructor.newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        ValueAnnotatedTypeFactory.this.checker.report(Result.warning("constructor.invocation.failed", new Object[0]), tree);
                        results = new ArrayList<Object>();
                    }
                } else {
                    List<Object> argValues = argArrayDeque.pop();
                    for (Object o : argValues) {
                        values.push(o);
                        this.evaluateNewClassHelper(argArrayDeque, values, constructor, results, tree);
                        values.pop();
                    }
                }
            }
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            super.visitMemberSelect(tree, type);
            AnnotatedTypeMirror receiverType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            Element elem = TreeUtils.elementFromUse(tree);
            if (AnnotationUtils.areSameIgnoringValues(this.getValueAnnotation(receiverType), ValueAnnotatedTypeFactory.this.ARRAYLEN) && tree.getIdentifier().contentEquals("length")) {
                type.replaceAnnotation(this.handleArrayLength(receiverType));
            }
            if (this.isClassCovered(elem.asType())) {
                if (ElementUtils.isCompileTimeConstant(elem)) {
                    ArrayList<Object> value = new ArrayList<Object>(1);
                    value.add(((VariableElement)elem).getConstantValue());
                    AnnotationMirror newAnno = this.resultAnnotationHandler(elem.asType(), value, (Tree)tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                    } else {
                        type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
                    }
                } else if (elem.getKind() == ElementKind.FIELD && ElementUtils.isStatic(elem) && ElementUtils.isFinal(elem) && !tree.getIdentifier().toString().equals("class")) {
                    TypeMirror retType = elem.asType();
                    AnnotationMirror newAnno = this.evaluateStaticFieldAccess(tree.getIdentifier(), retType, tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                    }
                }
            }
            return null;
        }

        private AnnotationMirror handleArrayLength(AnnotatedTypeMirror receiverType) {
            AnnotationMirror recAnno = this.getValueAnnotation(receiverType);
            if (AnnotationUtils.areSameIgnoringValues(recAnno, ValueAnnotatedTypeFactory.this.ARRAYLEN)) {
                HashSet<Long> lengthValues = new HashSet<Long>(AnnotationUtils.getElementValueArray(recAnno, "value", Long.class, true));
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", lengthValues);
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }

        private AnnotationMirror evaluateStaticFieldAccess(Name fieldName, TypeMirror retType, MemberSelectTree tree) {
            String clzzname = "";
            try {
                Element e = InternalUtils.symbol(tree.getExpression());
                if (e == null) {
                    return null;
                }
                clzzname = ElementUtils.getQualifiedClassName(e).toString();
                Class<?> recClass = Class.forName(clzzname);
                Field field = recClass.getField(fieldName.toString());
                ArrayList<Object> result = new ArrayList<Object>(1);
                result.add(field.get(recClass));
                return this.resultAnnotationHandler(retType, result, (Tree)tree);
            }
            catch (ClassNotFoundException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("class.find.failed", clzzname), tree);
                return null;
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("field.access.failed", fieldName, clzzname), tree);
                return null;
            }
        }

        private boolean isClassCovered(AnnotatedTypeMirror type) {
            return this.isClassCovered(type.getUnderlyingType());
        }

        private boolean isClassCovered(TypeMirror type) {
            return ValueAnnotatedTypeFactory.this.coveredClassStrings.contains(type.toString());
        }

        private Class<?> getClass(String stringType, Tree tree) {
            switch (stringType) {
                case "int": 
                case "java.lang.Integer": {
                    return Integer.TYPE;
                }
                case "long": 
                case "java.lang.Long": {
                    return Long.TYPE;
                }
                case "short": 
                case "java.lang.Short": {
                    return Short.TYPE;
                }
                case "byte": 
                case "java.lang.Byte": {
                    return Byte.TYPE;
                }
                case "char": 
                case "java.lang.Character": {
                    return Character.TYPE;
                }
                case "double": 
                case "java.lang.Double": {
                    return Double.TYPE;
                }
                case "float": 
                case "java.lang.Float": {
                    return Float.TYPE;
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    return Boolean.TYPE;
                }
                case "byte[]": {
                    return byte[].class;
                }
            }
            try {
                return Class.forName(stringType);
            }
            catch (ClassNotFoundException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.failure("class.find.failed", stringType), tree);
                return Object.class;
            }
        }

        private Class<?> getAnnotationValueClass(AnnotationMirror anno) {
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.INTVAL)) {
                return Long.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.DOUBLEVAL)) {
                return Double.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.BOOLVAL)) {
                return Boolean.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.STRINGVAL)) {
                return String.class;
            }
            return null;
        }

        private Class<?> getTypeValueClass(String stringType, Tree tree) {
            switch (stringType) {
                case "int": 
                case "java.lang.Integer": {
                    return Long.class;
                }
                case "long": 
                case "java.lang.Long": {
                    return Long.class;
                }
                case "short": 
                case "java.lang.Short": {
                    return Long.class;
                }
                case "byte": 
                case "java.lang.Byte": {
                    return Long.class;
                }
                case "char": 
                case "java.lang.Character": {
                    return Long.class;
                }
                case "double": 
                case "java.lang.Double": {
                    return Double.class;
                }
                case "float": 
                case "java.lang.Float": {
                    return Float.class;
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    return Boolean.class;
                }
                case "byte[]": {
                    return String.class;
                }
            }
            try {
                return Class.forName(stringType);
            }
            catch (ClassNotFoundException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.failure("class.find.failed", stringType), tree);
                return Object.class;
            }
        }

        private Class<?>[] getClassList(List<AnnotatedTypeMirror> typeList, Tree tree) {
            Class[] classList = new Class[typeList.size()];
            for (int i = 0; i < typeList.size(); ++i) {
                classList[i] = this.getClass(typeList.get(i).getUnderlyingType().toString(), tree);
            }
            return classList;
        }

        private List<Object> getCastedValues(AnnotatedTypeMirror typeMirror, Tree tree) {
            return this.getCastedValues(typeMirror, this.getClass(typeMirror.getUnderlyingType().toString(), tree), tree);
        }

        private List<Object> getCastedValues(AnnotatedTypeMirror typeMirror, Class<?> underlyingType, Tree tree) {
            if (!this.nonValueAnno(typeMirror)) {
                Class<?> annoValueClass = this.getAnnotationValueClass(this.getValueAnnotation(typeMirror));
                List<Object> tempValues = AnnotationUtils.getElementValueArray(this.getValueAnnotation(typeMirror), "value", annoValueClass, true);
                this.fixAnnotationValueObjectType(tempValues, annoValueClass, underlyingType);
                return tempValues;
            }
            return null;
        }

        private ArrayDeque<List<Object>> getAllArgumentAnnotationValues(List<AnnotatedTypeMirror> argTypes, Tree tree) {
            ArrayDeque<List<Object>> allArgValues = new ArrayDeque<List<Object>>();
            for (AnnotatedTypeMirror a : argTypes) {
                allArgValues.push(this.getCastedValues(a, tree));
            }
            return allArgValues;
        }

        private void fixAnnotationValueObjectType(List<Object> listToFix, Class<?> origClass, Class<?> newClass) {
            int i;
            if (origClass == Long.class || origClass == Double.class) {
                if (newClass == Integer.class || newClass == Integer.TYPE) {
                    for (i = 0; i < listToFix.size(); ++i) {
                        listToFix.set(i, new Integer(((Long)listToFix.get(i)).intValue()));
                    }
                } else if (newClass == Short.class || newClass == Short.TYPE) {
                    for (i = 0; i < listToFix.size(); ++i) {
                        listToFix.set(i, new Short(((Long)listToFix.get(i)).shortValue()));
                    }
                } else if (newClass == Byte.class || newClass == Byte.TYPE) {
                    for (i = 0; i < listToFix.size(); ++i) {
                        listToFix.set(i, new Byte(((Long)listToFix.get(i)).byteValue()));
                    }
                } else if (newClass == Float.class || newClass == Float.TYPE) {
                    for (i = 0; i < listToFix.size(); ++i) {
                        listToFix.set(i, new Float(((Double)listToFix.get(i)).floatValue()));
                    }
                } else if (newClass == Character.class || newClass == Character.TYPE) {
                    for (i = 0; i < listToFix.size(); ++i) {
                        listToFix.set(i, new Character((char)((Number)listToFix.get(i)).intValue()));
                    }
                }
            }
            if (origClass == String.class && newClass == byte[].class) {
                for (i = 0; i < listToFix.size(); ++i) {
                    listToFix.set(i, ((String)listToFix.get(i)).getBytes());
                }
            }
        }

        private AnnotationMirror resultAnnotationHandler(AnnotatedTypeMirror resultType, List<Object> results, Tree tree) {
            return this.resultAnnotationHandler(this.getClass(resultType.getUnderlyingType().toString(), tree), results);
        }

        private AnnotationMirror resultAnnotationHandler(TypeMirror resultType, List<Object> results, Tree tree) {
            return this.resultAnnotationHandler(this.getClass(resultType.toString(), tree), results);
        }

        private AnnotationMirror resultAnnotationHandler(Class<?> resultClass, List<Object> results) {
            results.remove(null);
            if (results.size() == 0) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (resultClass == Boolean.class || resultClass == Boolean.TYPE) {
                HashSet<Boolean> boolVals = new HashSet<Boolean>(results.size());
                for (Object o : results) {
                    boolVals.add((Boolean)o);
                }
                AnnotationMirror newAnno = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.BoolVal", boolVals);
                return newAnno;
            }
            if (resultClass == Double.class || resultClass == Double.TYPE) {
                HashSet<Double> doubleVals = new HashSet<Double>(results.size());
                for (Object o : results) {
                    doubleVals.add((Double)o);
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", doubleVals);
            }
            if (resultClass == Float.class || resultClass == Float.TYPE) {
                HashSet<Double> floatVals = new HashSet<Double>(results.size());
                for (Object o : results) {
                    floatVals.add(new Double(((Float)o).floatValue()));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", floatVals);
            }
            if (resultClass == Integer.class || resultClass == Integer.TYPE || resultClass == Long.class || resultClass == Long.TYPE || resultClass == Short.class || resultClass == Short.TYPE || resultClass == Byte.class || resultClass == Byte.TYPE) {
                HashSet<Long> intVals = new HashSet<Long>(results.size());
                for (Object o : results) {
                    intVals.add(((Number)o).longValue());
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", intVals);
            }
            if (resultClass == Character.TYPE || resultClass == Character.class) {
                HashSet<Long> intVals = new HashSet<Long>(results.size());
                for (Object o : results) {
                    intVals.add(new Long(((Character)o).charValue()));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", intVals);
            }
            if (resultClass == String.class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    stringVals.add((String)o);
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringVals);
            }
            if (resultClass == byte[].class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    stringVals.add(new String((byte[])o));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringVals);
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }

        private void handleCast(ExpressionTree tree, String castTypeString, AnnotatedTypeMirror alteredType) {
            AnnotatedTypeMirror treeType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree);
            if (!this.nonValueAnno(treeType)) {
                AnnotationMirror treeAnno = this.getValueAnnotation(treeType);
                String anno = "org.checkerframework.common.value.qual.";
                if (!castTypeString.equals("boolean")) {
                    if (castTypeString.equals("java.lang.String")) {
                        HashSet<String> newValues = new HashSet<String>();
                        List<Object> valuesToCast = AnnotationUtils.getElementValueArray(treeAnno, "value", Object.class, true);
                        for (Object o : valuesToCast) {
                            newValues.add(o.toString());
                        }
                        anno = anno + "StringVal";
                        alteredType.replaceAnnotation(ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues));
                    } else {
                        List<Number> valuesToCast = AnnotationUtils.getElementValueArray(treeAnno, "value", Number.class, true);
                        HashSet<Number> newValues = new HashSet<Number>();
                        if (castTypeString.equals("double")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Double(n.doubleValue()));
                            }
                            anno = anno + "DoubleVal";
                        } else if (castTypeString.equals("int")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Long(n.intValue()));
                            }
                            anno = anno + "IntVal";
                        } else if (castTypeString.equals("long")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Long(n.longValue()));
                            }
                            anno = anno + "IntVal";
                        } else if (castTypeString.equals("float")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Double(n.floatValue()));
                            }
                            anno = anno + "DoubleVal";
                        } else if (castTypeString.equals("short")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Long(n.shortValue()));
                            }
                            anno = anno + "IntVal";
                        } else if (castTypeString.equals("byte")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Long(n.byteValue()));
                            }
                            anno = anno + "IntVal";
                        } else if (castTypeString.equals("char")) {
                            for (Number n : valuesToCast) {
                                newValues.add(new Long(n.intValue()));
                            }
                            anno = anno + "IntVal";
                        }
                        alteredType.replaceAnnotation(ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues));
                    }
                }
            }
        }

        private AnnotationMirror getValueAnnotation(AnnotatedTypeMirror atm) {
            AnnotationMirror anno = atm.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno == null) {
                anno = atm.getEffectiveAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return anno;
        }

        private boolean nonValueAnno(AnnotatedTypeMirror mirror) {
            return AnnotationUtils.areSameIgnoringValues(this.getValueAnnotation(mirror), ValueAnnotatedTypeFactory.this.UNKNOWNVAL) || AnnotationUtils.areSameIgnoringValues(mirror.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.ARRAYLEN), ValueAnnotatedTypeFactory.this.ARRAYLEN);
        }
    }

    private final class ValueQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public ValueQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            AnnotationMirror lower;
            AnnotationMirror higher;
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<Object> a1Values = AnnotationUtils.getElementValueArray(a1, "value", Object.class, true);
                List<Object> a2Values = AnnotationUtils.getElementValueArray(a2, "value", Object.class, true);
                HashSet<Object> newValues = new HashSet<Object>(a1Values.size() + a2Values.size());
                newValues.addAll(a1Values);
                newValues.addAll(a2Values);
                return ValueAnnotatedTypeFactory.this.createAnnotation(a1.getAnnotationType().toString(), newValues);
            }
            if (!ValueAnnotatedTypeFactory.this.isNumberAnnotation(a1) || !ValueAnnotatedTypeFactory.this.isNumberAnnotation(a2)) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (AnnotationUtils.areSameIgnoringValues(a2, ValueAnnotatedTypeFactory.this.DOUBLEVAL)) {
                higher = a2;
                lower = a1;
            } else {
                higher = a1;
                lower = a2;
            }
            String anno = "org.checkerframework.common.value.qual.";
            List<Number> valuesToCast = AnnotationUtils.getElementValueArray(lower, "value", Number.class, true);
            HashSet<Object> newValues = new HashSet<Object>(AnnotationUtils.getElementValueArray(higher, "value", Object.class, true));
            for (Number n : valuesToCast) {
                newValues.add(new Double(n.doubleValue()));
            }
            anno = anno + "DoubleVal";
            return ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (System.currentTimeMillis() > ValueAnnotatedTypeFactory.this.t + 1000L) {
                ValueAnnotatedTypeFactory.this.t = System.currentTimeMillis();
            }
            if (AnnotationUtils.areSame(rhs, lhs)) {
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                List<Object> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Object.class, true);
                List<Object> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Object.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ValueAnnotatedTypeFactory.this.DOUBLEVAL) && AnnotationUtils.areSameIgnoringValues(rhs, ValueAnnotatedTypeFactory.this.INTVAL)) {
                List<Long> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Long.class, true);
                List<Double> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Double.class, true);
                boolean same = false;
                for (Long rhsLong : rhsValues) {
                    for (Double lhsDbl : lhsValues) {
                        if (lhsDbl.doubleValue() != rhsLong.doubleValue()) continue;
                        same = true;
                        break;
                    }
                    if (same) continue;
                    return false;
                }
                return same;
            }
            for (AnnotationMirror anno : ValueAnnotatedTypeFactory.this.constantAnnotations) {
                if (AnnotationUtils.areSameIgnoringValues(lhs, anno)) {
                    lhs = anno;
                }
                if (!AnnotationUtils.areSameIgnoringValues(rhs, anno)) continue;
                rhs = anno;
            }
            return super.isSubtype(rhs, lhs);
        }
    }
}

