/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class KeyForVisitor
extends BaseTypeVisitor<KeyForAnnotatedTypeFactory> {
    public KeyForVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    private AnnotationMirror getKeyForAnnotationMirrorWithValue(ArrayList<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(((KeyForAnnotatedTypeFactory)this.atypeFactory).getProcessingEnv(), KeyFor.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    private void canonicalizeKeyForValues(AnnotatedTypeMirror atm, FlowExpressionParseUtil.FlowExpressionContext flowExprContext, TreePath path, Tree t) {
        AnnotationMirror anno;
        FlowExpressions.Receiver varTypeReceiver = null;
        CFAbstractStore store = null;
        boolean unknownReceiver = false;
        if (flowExprContext.receiver.containsUnknown()) {
            store = (CFAbstractStore)((KeyForAnnotatedTypeFactory)this.atypeFactory).getStoreBefore(t);
            unknownReceiver = true;
        }
        if ((anno = atm.getAnnotation(KeyFor.class)) != null) {
            boolean valuesChanged = false;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = anno.getElementValues();
            ArrayList<String> newValues = new ArrayList<String>();
            for (AnnotationValue annotationValue : values.values()) {
                List v = (List)annotationValue.getValue();
                for (Object c : v) {
                    Object val;
                    String s2 = c.toString();
                    s2 = s2.substring(1, s2.length() - 1);
                    boolean localVariableFound = false;
                    if (unknownReceiver && (val = store.getValueOfLocalVariableByName(s2)) != null) {
                        newValues.add(s2);
                        localVariableFound = true;
                    }
                    if (localVariableFound) continue;
                    try {
                        varTypeReceiver = FlowExpressionParseUtil.parse(s2, flowExprContext, path);
                    }
                    catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                        // empty catch block
                    }
                    if (unknownReceiver && (varTypeReceiver == null || varTypeReceiver.containsUnknown())) {
                        try {
                            varTypeReceiver = FlowExpressionParseUtil.parse("this." + s2, flowExprContext, path);
                        }
                        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                            // empty catch block
                        }
                    }
                    if (varTypeReceiver != null) {
                        String newValue = varTypeReceiver.toString();
                        newValues.add(newValue);
                        if (newValue.equals(s2)) continue;
                        valuesChanged = true;
                        continue;
                    }
                    newValues.add(s2);
                }
            }
            if (valuesChanged) {
                atm.replaceAnnotation(this.getKeyForAnnotationMirrorWithValue(newValues));
            }
        }
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, String errorKey, boolean isLocalVariableAssignement) {
        TreePath path = this.getCurrentPath();
        Tree t = path.getLeaf();
        Node node = ((KeyForAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(t);
        if (node != null) {
            FlowExpressions.Receiver r = FlowExpressions.internalReprOf(this.atypeFactory, node);
            FlowExpressionParseUtil.FlowExpressionContext flowExprContext = new FlowExpressionParseUtil.FlowExpressionContext(r, null, this.atypeFactory);
            this.canonicalizeKeyForValues(varType, flowExprContext, path, t);
            this.canonicalizeKeyForValues(valueType, flowExprContext, path, t);
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey, isLocalVariableAssignement);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new KeyForTypeValidator(this.checker, this, this.atypeFactory);
    }

    private static final class KeyForTypeValidator
    extends BaseTypeValidator {
        public KeyForTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor, atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree p) {
            AnnotationMirror kf = type.getAnnotation(KeyFor.class);
            if (kf != null) {
                ModifiersTree mt;
                List<String> maps = AnnotationUtils.getElementValueArray(kf, "value", String.class, false);
                boolean inStatic = false;
                if (p.getKind() == Tree.Kind.VARIABLE && (mt = ((VariableTree)p).getModifiers()).getFlags().contains((Object)Modifier.STATIC)) {
                    inStatic = true;
                }
                for (String map : maps) {
                    if (map.equals("this")) {
                        if (!inStatic) continue;
                        this.checker.report(Result.failure("keyfor.type.invalid", type.getAnnotations(), type.toString()), p);
                        continue;
                    }
                    if (!map.matches("#(\\d+)")) continue;
                }
            }
            if (type.isAnnotatedInHierarchy(((KeyForAnnotatedTypeFactory)this.atypeFactory).KEYFOR)) {
                return super.visitDeclared(type, p);
            }
            return null;
        }
    }
}

