/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.TypeMirrorConverter;

class QualifierHierarchyAdapter<Q> {
    private QualifierHierarchy<Q> underlying;
    private TypeMirrorConverter<Q> converter;

    public QualifierHierarchyAdapter(QualifierHierarchy<Q> underlying, TypeMirrorConverter<Q> converter) {
        this.underlying = underlying;
        this.converter = converter;
    }

    public Implementation createImplementation(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
        return new Implementation(f);
    }

    public class Implementation
    extends MultiGraphQualifierHierarchy {
        public Implementation(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f);
        }

        @Override
        public int getWidth() {
            return 1;
        }

        @Override
        protected Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newBottoms = AnnotationUtils.createAnnotationSet();
            newBottoms.add(this.getBottomAnnotation(null));
            return newBottoms;
        }

        @Override
        protected Set<AnnotationMirror> findTops(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newTops = AnnotationUtils.createAnnotationSet();
            newTops.add(this.getTopAnnotation(null));
            return newTops;
        }

        @Override
        public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.getBottom());
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.getTop());
        }

        @Override
        public AnnotationMirror getAnnotationInHierarchy(Collection<? extends AnnotationMirror> annos, AnnotationMirror top) {
            for (AnnotationMirror annotationMirror : annos) {
                if (!QualifierHierarchyAdapter.this.converter.isKey(annotationMirror)) continue;
                return annotationMirror;
            }
            return null;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (!QualifierHierarchyAdapter.this.converter.isKey(rhs) || !QualifierHierarchyAdapter.this.converter.isKey(lhs)) {
                return false;
            }
            Object rhsQual = QualifierHierarchyAdapter.this.converter.getQualifier(rhs);
            Object lhsQual = QualifierHierarchyAdapter.this.converter.getQualifier(lhs);
            return QualifierHierarchyAdapter.this.underlying.isSubtype(rhsQual, lhsQual);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            Object q1 = QualifierHierarchyAdapter.this.converter.getQualifier(a1);
            Object q2 = QualifierHierarchyAdapter.this.converter.getQualifier(a2);
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.leastUpperBound(q1, q2));
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            Object q1 = QualifierHierarchyAdapter.this.converter.getQualifier(a1);
            Object q2 = QualifierHierarchyAdapter.this.converter.getQualifier(a2);
            return QualifierHierarchyAdapter.this.converter.getAnnotation(QualifierHierarchyAdapter.this.underlying.greatestLowerBound(q1, q2));
        }

        public Set<AnnotationMirror> getTypeQualifiers() {
            HashSet<AnnotationMirror> names = new HashSet<AnnotationMirror>();
            names.add(QualifierHierarchyAdapter.this.converter.getBlankKeyAnnotation());
            return names;
        }
    }
}

