/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.qual.ImplicitFor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;

public class ImplicitsTreeAnnotator
extends TreeAnnotator {
    private final Map<Tree.Kind, Set<AnnotationMirror>> treeKinds = new EnumMap<Tree.Kind, Set<AnnotationMirror>>(Tree.Kind.class);
    private final Map<Class<?>, Set<AnnotationMirror>> treeClasses = new HashMap();
    private final Map<Pattern, Set<AnnotationMirror>> stringPatterns = new IdentityHashMap<Pattern, Set<AnnotationMirror>>();
    protected final QualifierHierarchy qualHierarchy;

    public ImplicitsTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
        super(atypeFactory);
        this.qualHierarchy = atypeFactory.getQualifierHierarchy();
        Set<Class<? extends Annotation>> quals = atypeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            ImplicitFor implicit = qual.getAnnotation(ImplicitFor.class);
            if (implicit == null) continue;
            AnnotationMirror theQual = AnnotationUtils.fromClass(atypeFactory.elements, qual);
            for (Class<? extends Tree> clazz : implicit.treeClasses()) {
                this.addTreeClass(clazz, theQual);
            }
            for (Tree.Kind kind : implicit.trees()) {
                this.addTreeKind(kind, theQual);
            }
            for (String string : implicit.stringPatterns()) {
                this.addStringPattern(string, theQual);
            }
        }
    }

    public void addTreeClass(Class<? extends Tree> treeClass, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.treeClasses, treeClass, theQual);
        if (!res) {
            ErrorReporter.errorAbort("PropagationTreeAnnotator: invalid update of map " + this.treeClasses + " at " + treeClass + " with " + theQual);
        }
    }

    public void addTreeKind(Tree.Kind treeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.treeKinds, treeKind, theQual);
        if (!res) {
            ErrorReporter.errorAbort("PropagationTreeAnnotator: invalid update of treeKinds " + this.treeKinds + " at " + (Object)((Object)treeKind) + " with " + theQual);
        }
    }

    public void addStringPattern(String pattern, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.stringPatterns, Pattern.compile(pattern), theQual);
        if (!res) {
            ErrorReporter.errorAbort("PropagationTreeAnnotator: invalid update of stringPatterns " + this.stringPatterns + " at " + pattern + " with " + theQual);
        }
    }

    @Override
    public Void defaultAction(Tree tree, AnnotatedTypeMirror type) {
        if (tree == null || type == null) {
            return null;
        }
        if (this.treeKinds.containsKey((Object)tree.getKind())) {
            Set<AnnotationMirror> fnd = this.treeKinds.get((Object)tree.getKind());
            type.addMissingAnnotations(fnd);
        } else if (!this.treeClasses.isEmpty()) {
            Class<?> t = tree.getClass();
            if (this.treeClasses.containsKey(t)) {
                Set<AnnotationMirror> fnd = this.treeClasses.get(t);
                type.addMissingAnnotations(fnd);
            }
            for (Class<?> c : t.getInterfaces()) {
                if (!this.treeClasses.containsKey(c)) continue;
                Set<AnnotationMirror> fnd = this.treeClasses.get(c);
                type.addMissingAnnotations(fnd);
                this.treeClasses.put(t, this.treeClasses.get(c));
            }
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
        if (!this.stringPatterns.isEmpty() && tree.getKind() == Tree.Kind.STRING_LITERAL) {
            Set<AnnotationMirror> res = null;
            String string = (String)tree.getValue();
            for (Pattern pattern : this.stringPatterns.keySet()) {
                if (!pattern.matcher(string).matches()) continue;
                if (res == null) {
                    res = this.stringPatterns.get(pattern);
                    continue;
                }
                Set<AnnotationMirror> newres = this.stringPatterns.get(pattern);
                res = this.qualHierarchy.greatestLowerBounds(res, newres);
            }
            if (res != null) {
                type.addAnnotations(res);
            }
        }
        return (Void)super.visitLiteral(tree, type);
    }
}

