/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.source.SupportedLintOptions;
import org.checkerframework.framework.source.SupportedOptions;
import org.checkerframework.framework.source.SuppressWarningsKeys;
import org.checkerframework.framework.util.CFContext;
import org.checkerframework.javacutil.AbstractTypeProcessor;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorHandler;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

@SupportedOptions(value={"skipUses", "onlyUses", "skipDefs", "onlyDefs", "suppressWarnings", "showSuppressWarningKeys", "assumeSideEffectFree", "ignoreRawTypeArguments", "enablePurity", "invariantArrays", "checkCastElementType", "warns", "lint", "suggestPureMethods", "assumeAssertionsAreEnabled", "assumeAssertionsAreDisabled", "concurrentSemantics", "stubs", "stubWarnIfNotFound", "printAllQualifiers", "detailedmsgtext", "printErrorStack", "nomsgtext", "ignorejdkastub", "nocheckjdk", "stubDebug", "filenames", "showchecks", "flowdotdir", "verbosecfg", "resourceStats"})
public abstract class SourceChecker
extends AbstractTypeProcessor
implements ErrorHandler,
CFContext {
    protected static final String MSGS_FILE = "messages.properties";
    protected Properties messages;
    protected Messager messager;
    protected Trees trees;
    protected CompilationUnitTree currentRoot;
    protected TreePath currentPath;
    protected SourceVisitor<?, ?> visitor;
    private String[] suppressWarnings;
    private Pattern skipUsesPattern;
    private Pattern onlyUsesPattern;
    private Pattern skipDefsPattern;
    private Pattern onlyDefsPattern;
    private Set<String> supportedLints;
    private Set<String> activeLints;
    private Map<String, String> activeOptions;
    private static final String OPTION_SEPARATOR = "_";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator").intern();
    private boolean warnedAboutSourceLevel = false;
    int errsOnLastExit = 0;
    public static final String DETAILS_SEPARATOR = " $$ ";

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    void setProcessingEnvironment(ProcessingEnvironment env) {
        this.processingEnv = env;
    }

    public CFContext getContext() {
        return this;
    }

    @Override
    public SourceChecker getChecker() {
        return this;
    }

    @Override
    public Elements getElementUtils() {
        return this.getProcessingEnvironment().getElementUtils();
    }

    @Override
    public Types getTypeUtils() {
        return this.getProcessingEnvironment().getTypeUtils();
    }

    @Override
    public SourceVisitor<?, ?> getVisitor() {
        return this.visitor;
    }

    protected abstract SourceVisitor<?, ?> createSourceVisitor();

    public Properties getMessages() {
        if (this.messages != null) {
            return this.messages;
        }
        this.messages = new Properties();
        Stack checkers = new Stack();
        for (Class<?> currClass = this.getClass(); currClass != SourceChecker.class; currClass = currClass.getSuperclass()) {
            checkers.push(currClass);
        }
        checkers.push(SourceChecker.class);
        while (!checkers.empty()) {
            this.messages.putAll((Map<?, ?>)this.getProperties((Class)checkers.pop(), MSGS_FILE));
        }
        return this.messages;
    }

    private Pattern getSkipPattern(String patternName, Map<String, String> options) {
        return this.getPattern(patternName, options, "\\]'\"\\]");
    }

    private Pattern getOnlyPattern(String patternName, Map<String, String> options) {
        return this.getPattern(patternName, options, ".");
    }

    private Pattern getPattern(String patternName, Map<String, String> options, String defaultPattern) {
        String pattern = "";
        if (options.containsKey(patternName)) {
            pattern = options.get(patternName);
        } else if (System.getProperty("checkers." + patternName) != null) {
            pattern = System.getProperty("checkers." + patternName);
        } else if (System.getenv(patternName) != null) {
            pattern = System.getenv(patternName);
        }
        if (pattern.indexOf("/") != -1) {
            this.message(Diagnostic.Kind.WARNING, "The " + patternName + " property contains \"/\", which will never match a class name: " + pattern, new Object[0]);
        }
        if (pattern.equals("")) {
            pattern = defaultPattern;
        }
        return Pattern.compile(pattern);
    }

    private Pattern getSkipUsesPattern(Map<String, String> options) {
        return this.getSkipPattern("skipUses", options);
    }

    private Pattern getOnlyUsesPattern(Map<String, String> options) {
        return this.getOnlyPattern("onlyUses", options);
    }

    private Pattern getSkipDefsPattern(Map<String, String> options) {
        return this.getSkipPattern("skipDefs", options);
    }

    private Pattern getOnlyDefsPattern(Map<String, String> options) {
        return this.getOnlyPattern("onlyDefs", options);
    }

    private Set<String> createActiveLints(Map<String, String> options) {
        if (!options.containsKey("lint")) {
            return Collections.emptySet();
        }
        String lintString = options.get("lint");
        if (lintString == null) {
            return Collections.singleton("all");
        }
        HashSet<String> activeLint = new HashSet<String>();
        for (String s2 : lintString.split(",")) {
            if (!(this.getSupportedLintOptions().contains(s2) || s2.charAt(0) == '-' && this.getSupportedLintOptions().contains(s2.substring(1)) || s2.equals("all") || s2.equals("none"))) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Unsupported lint option: " + s2 + "; All options: " + this.getSupportedLintOptions());
            }
            activeLint.add(s2);
            if (!s2.equals("none")) continue;
            activeLint.add("-all");
        }
        return Collections.unmodifiableSet(activeLint);
    }

    private Map<String, String> createActiveOptions(Map<String, String> options) {
        if (options.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> activeOpts = new HashMap<String, String>();
        block4: for (Map.Entry<String, String> opt : options.entrySet()) {
            String key = opt.getKey();
            String value = opt.getValue();
            String[] split = key.split(OPTION_SEPARATOR);
            switch (split.length) {
                case 1: {
                    activeOpts.put(key, value);
                    break;
                }
                case 2: {
                    Class<?> clazz = this.getClass();
                    do {
                        if (clazz.getCanonicalName().equals(split[0]) || clazz.getSimpleName().equals(split[0])) {
                            activeOpts.put(split[1], value);
                        }
                        if ((clazz = clazz.getSuperclass()) == null) continue block4;
                    } while (!clazz.getName().equals(AbstractTypeProcessor.class.getCanonicalName()));
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("Invalid option name: " + key + " At most one separator " + OPTION_SEPARATOR + " expected, but found " + split.length);
                }
            }
        }
        return Collections.unmodifiableMap(activeOpts);
    }

    private String[] createSuppressWarnings(Map<String, String> options) {
        if (!options.containsKey("suppressWarnings")) {
            return null;
        }
        String swString = options.get("suppressWarnings");
        if (swString == null) {
            return null;
        }
        return swString.split(",");
    }

    @Override
    public void errorAbort(String msg) {
        throw new CheckerError(msg, new Throwable(), false);
    }

    @Override
    public void errorAbort(String msg, Throwable cause) {
        throw new CheckerError(msg, cause, false);
    }

    public void userErrorAbort(String msg) {
        throw new CheckerError(msg, new Throwable(), true);
    }

    private void logCheckerError(CheckerError ce) {
        StringBuilder msg = new StringBuilder(ce.getMessage());
        if ((this.processingEnv == null || this.processingEnv.getOptions() == null || this.processingEnv.getOptions().containsKey("printErrorStack")) && ce.getCause() != null) {
            if (this.currentRoot != null && this.currentRoot.getSourceFile() != null) {
                msg.append("\nCompilation unit: " + this.currentRoot.getSourceFile().getName());
            }
            msg.append("\nException: " + ce.getCause().toString() + "; " + this.formatStackTrace(ce.getCause().getStackTrace()));
            for (Throwable cause = ce.getCause().getCause(); cause != null; cause = cause.getCause()) {
                msg.append("\nUnderlying Exception: " + cause.toString() + "; " + this.formatStackTrace(cause.getStackTrace()));
            }
        } else if (ce.userError) {
            msg.append('.');
        } else {
            msg.append("; invoke the compiler with -AprintErrorStack to see the stack trace.");
        }
        if (this.messager == null) {
            this.messager = this.processingEnv.getMessager();
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    @Override
    public void typeProcessingStart() {
        try {
            super.typeProcessingStart();
            this.initChecker();
            if (this.messager == null) {
                this.messager = this.processingEnv.getMessager();
                this.messager.printMessage(Diagnostic.Kind.WARNING, "You have forgotten to call super.initChecker in your subclass of SourceChecker, " + this.getClass() + "! Please ensure your checker is properly initialized.");
            }
            if (this.shouldAddShutdownHook()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SourceChecker.this.shutdownHook();
                    }
                });
            }
        }
        catch (CheckerError ce) {
            this.logCheckerError(ce);
        }
        catch (Throwable t) {
            this.logCheckerError(this.wrapThrowableAsCheckerError("SourceChecker.typeProcessingStart", t, null));
        }
    }

    public void initChecker() {
        Trees trees = Trees.instance(this.processingEnv);
        assert (trees != null);
        this.trees = trees;
        this.messager = this.processingEnv.getMessager();
        this.messages = this.getMessages();
        this.visitor = this.createSourceVisitor();
    }

    protected boolean shouldAddShutdownHook() {
        return this.getOptions().containsKey("resourceStats");
    }

    protected void shutdownHook() {
        if (this.getOptions().containsKey("resourceStats")) {
            this.printStats();
        }
    }

    protected void printStats() {
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPool : memoryPools) {
            System.out.println("Memory pool " + memoryPool.getName() + " statistics");
            System.out.println("  Pool type: " + (Object)((Object)memoryPool.getType()));
            System.out.println("  Peak usage: " + memoryPool.getPeakUsage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void typeProcess(TypeElement e, TreePath p) {
        if (e == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Refusing to process empty TypeElement");
            return;
        }
        if (p == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Refusing to process empty TreePath in TypeElement: " + e);
            return;
        }
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Source source = Source.instance(context);
        if (!this.warnedAboutSourceLevel && !source.allowTypeAnnotations()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "-source " + source.name + " does not support type annotations");
            this.warnedAboutSourceLevel = true;
        }
        Log log = Log.instance(context);
        if (log.nerrors > this.errsOnLastExit) {
            this.errsOnLastExit = log.nerrors;
            return;
        }
        this.currentRoot = p.getCompilationUnit();
        this.currentPath = p;
        try {
            this.visitor.visit(this.currentRoot, p, null);
        }
        catch (CheckerError ce) {
            this.logCheckerError(ce);
        }
        catch (Throwable t) {
            this.logCheckerError(this.wrapThrowableAsCheckerError("SourceChecker.typeProcess", t, p));
        }
        finally {
            this.errsOnLastExit = log.nerrors;
        }
    }

    private CheckerError wrapThrowableAsCheckerError(String where, Throwable t, TreePath p) {
        return new CheckerError(where + ": unexpected Throwable (" + t.getClass().getSimpleName() + ")" + (p == null ? "" : " while processing " + p.getCompilationUnit().getSourceFile().getName()) + (t.getMessage() == null ? "" : "; message: " + t.getMessage()), t, false);
    }

    protected String formatStackTrace(StackTraceElement[] stackTrace) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        if (stackTrace.length == 0) {
            sb.append("no stack trace available.");
        } else {
            sb.append("Stack trace: ");
        }
        for (StackTraceElement ste : stackTrace) {
            if (!first) {
                sb.append("\n");
            }
            first = false;
            sb.append(ste.toString());
        }
        return sb.toString();
    }

    protected String fullMessageOf(String messageKey, String defValue) {
        String key = messageKey;
        while (!this.messages.containsKey(key)) {
            int dot = key.indexOf(46);
            if (dot < 0) {
                return defValue;
            }
            key = key.substring(dot + 1);
        }
        return this.messages.getProperty(key);
    }

    public void message(Diagnostic.Kind kind, Object source, String msgKey, Object ... args) {
        String messageText;
        String fmtString;
        assert (this.messages != null) : "null messages";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                args[i] = this.messages.getProperty(args[i].toString(), args[i].toString());
            }
        }
        if (kind == Diagnostic.Kind.NOTE) {
            System.err.println("(NOTE) " + String.format(msgKey, args));
            return;
        }
        String defaultFormat = String.format("(%s)", msgKey);
        if (this.processingEnv.getOptions() != null && this.processingEnv.getOptions().containsKey("nomsgtext")) {
            fmtString = defaultFormat;
        } else if (this.processingEnv.getOptions() != null && this.processingEnv.getOptions().containsKey("detailedmsgtext")) {
            StringBuilder sb = new StringBuilder();
            sb.append(defaultFormat);
            sb.append(DETAILS_SEPARATOR);
            if (args != null) {
                sb.append(args.length);
                sb.append(DETAILS_SEPARATOR);
                for (Object arg : args) {
                    sb.append(arg);
                    sb.append(DETAILS_SEPARATOR);
                }
            } else {
                sb.append(0);
                sb.append(DETAILS_SEPARATOR);
            }
            Tree tree = source instanceof Element ? this.trees.getTree((Element)source) : (source instanceof Tree ? (Tree)source : null);
            sb.append(this.treeToFilePositionString(tree, this.currentRoot, this.processingEnv));
            sb.append(DETAILS_SEPARATOR);
            sb.append(this.fullMessageOf(msgKey, defaultFormat));
            fmtString = sb.toString();
        } else {
            String suppressing = this.processingEnv.getOptions().containsKey("showSuppressWarningKeys") ? String.format("[%s:%s] ", this.getSuppressWarningsKeys(), msgKey) : String.format("[%s] ", msgKey);
            fmtString = suppressing + this.fullMessageOf(msgKey, defaultFormat);
        }
        try {
            messageText = String.format(fmtString, args);
        }
        catch (Exception e) {
            messageText = "Invalid format string: \"" + fmtString + "\" args: " + Arrays.toString(args);
        }
        if (LINE_SEPARATOR != "\n") {
            messageText = messageText.replaceAll("\n", LINE_SEPARATOR);
        }
        if (source instanceof Element) {
            this.messager.printMessage(kind, messageText, (Element)source);
        } else if (source instanceof Tree) {
            Trees.instance(this.processingEnv).printMessage(kind, messageText, (Tree)source, this.currentRoot);
        } else {
            ErrorReporter.errorAbort("invalid position source: " + source.getClass().getName());
        }
    }

    public void message(Diagnostic.Kind kind, String msg, Object ... args) {
        if (this.messager != null) {
            this.messager.printMessage(kind, String.format(msg, args));
        } else {
            System.err.println((Object)((Object)kind) + ": " + String.format(msg, args));
        }
    }

    public String treeToFilePositionString(Tree tree, CompilationUnitTree currentRoot, ProcessingEnvironment processingEnv) {
        if (tree == null) {
            return null;
        }
        SourcePositions sourcePositions = this.trees.getSourcePositions();
        long start = sourcePositions.getStartPosition(currentRoot, tree);
        long end = sourcePositions.getEndPosition(currentRoot, tree);
        return "( " + start + ", " + end + " )";
    }

    private boolean checkSuppressWarnings(SuppressWarnings anno, String err) {
        String[] userSwKeys;
        Collection<String> checkerSwKeys = this.getSuppressWarningsKeys();
        if (checkerSwKeys.isEmpty()) {
            return false;
        }
        String[] stringArray = userSwKeys = anno == null ? null : anno.value();
        if (this.suppressWarnings == null) {
            this.suppressWarnings = this.createSuppressWarnings(this.getOptions());
        }
        String[] cmdLineSwKeys = this.suppressWarnings;
        return this.checkSuppressWarnings(userSwKeys, err) || this.checkSuppressWarnings(cmdLineSwKeys, err);
    }

    private boolean checkSuppressWarnings(String[] userSwKeys, String err) {
        if (userSwKeys == null) {
            return false;
        }
        Collection<String> checkerSwKeys = this.getSuppressWarningsKeys();
        for (String suppressWarningValue : userSwKeys) {
            for (String checkerKey : checkerSwKeys) {
                if (suppressWarningValue.equalsIgnoreCase(checkerKey)) {
                    return true;
                }
                String expected = checkerKey + ":" + err;
                if (!expected.toLowerCase().contains(suppressWarningValue.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldSuppressWarnings(Tree tree, String err) {
        Collection<String> checkerKeys = this.getSuppressWarningsKeys();
        if (checkerKeys.isEmpty()) {
            return false;
        }
        TreePath path = this.trees.getPath(this.currentRoot, tree);
        if (path == null) {
            return false;
        }
        VariableTree var = TreeUtils.enclosingVariable(path);
        if (var != null && this.shouldSuppressWarnings(InternalUtils.symbol(var), err)) {
            return true;
        }
        MethodTree method = TreeUtils.enclosingMethod(path);
        if (method != null && this.shouldSuppressWarnings(InternalUtils.symbol(method), err)) {
            return true;
        }
        ClassTree cls = TreeUtils.enclosingClass(path);
        return cls != null && this.shouldSuppressWarnings(InternalUtils.symbol(cls), err);
    }

    private boolean shouldSuppressWarnings(Element elt, String err) {
        if (elt == null) {
            return false;
        }
        return this.checkSuppressWarnings(elt.getAnnotation(SuppressWarnings.class), err) || this.shouldSuppressWarnings(elt.getEnclosingElement(), err);
    }

    public void report(Result r, Object src) {
        String err = r.getMessageKeys().iterator().next();
        if (src instanceof Tree && this.shouldSuppressWarnings((Tree)src, err)) {
            return;
        }
        if (src instanceof Element && this.shouldSuppressWarnings((Element)src, err)) {
            return;
        }
        if (r.isSuccess()) {
            return;
        }
        for (Result.DiagMessage msg : r.getDiagMessages()) {
            if (r.isFailure()) {
                this.message(this.hasOption("warns") ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.ERROR, src, msg.getMessageKey(), msg.getArgs());
                continue;
            }
            if (r.isWarning()) {
                this.message(Diagnostic.Kind.MANDATORY_WARNING, src, msg.getMessageKey(), msg.getArgs());
                continue;
            }
            this.message(Diagnostic.Kind.NOTE, src, msg.getMessageKey(), msg.getArgs());
        }
    }

    public final boolean getLintOption(String name) {
        return this.getLintOption(name, false);
    }

    public final boolean getLintOption(String name, boolean def) {
        if (!this.getSupportedLintOptions().contains(name)) {
            ErrorReporter.errorAbort("Illegal lint option: " + name);
        }
        if (this.activeLints == null) {
            this.activeLints = this.createActiveLints(this.processingEnv.getOptions());
        }
        if (this.activeLints.isEmpty()) {
            return def;
        }
        String tofind = name;
        while (tofind != null) {
            if (this.activeLints.contains(tofind)) {
                return true;
            }
            if (this.activeLints.contains(String.format("-%s", tofind))) {
                return false;
            }
            tofind = this.parentOfOption(tofind);
        }
        return def;
    }

    protected final void setLintOption(String name, boolean val) {
        if (!this.getSupportedLintOptions().contains(name)) {
            ErrorReporter.errorAbort("Illegal lint option: " + name);
        }
        HashSet<String> newlints = new HashSet<String>();
        newlints.addAll(this.activeLints);
        if (val) {
            newlints.add(name);
        } else {
            newlints.add(String.format("-%s", name));
        }
        this.activeLints = Collections.unmodifiableSet(newlints);
    }

    private String parentOfOption(String name) {
        if (name.equals("all")) {
            return null;
        }
        if (name.contains(":")) {
            return name.substring(0, name.lastIndexOf(58));
        }
        return "all";
    }

    public Set<String> getSupportedLintOptions() {
        if (this.supportedLints == null) {
            this.supportedLints = this.createSupportedLintOptions();
        }
        return this.supportedLints;
    }

    protected Set<String> createSupportedLintOptions() {
        SupportedLintOptions sl = this.getClass().getAnnotation(SupportedLintOptions.class);
        if (sl == null) {
            return Collections.emptySet();
        }
        String[] slValue = sl.value();
        assert (slValue != null);
        String[] lintArray = slValue;
        HashSet<String> lintSet = new HashSet<String>(lintArray.length);
        for (String s2 : lintArray) {
            lintSet.add(s2);
        }
        return Collections.unmodifiableSet(lintSet);
    }

    protected void setSupportedLintOptions(Set<String> newlints) {
        this.supportedLints = newlints;
    }

    protected void addOptions(Map<String, String> moreopts) {
        HashMap<String, String> activeOpts = new HashMap<String, String>(this.getOptions());
        activeOpts.putAll(moreopts);
        this.activeOptions = Collections.unmodifiableMap(activeOpts);
    }

    public final String getOption(String name) {
        return this.getOption(name, null);
    }

    public Map<String, String> getOptions() {
        if (this.activeOptions == null) {
            this.activeOptions = this.createActiveOptions(this.processingEnv.getOptions());
        }
        return this.activeOptions;
    }

    public final boolean hasOption(String name) {
        return this.getOptions().containsKey(name);
    }

    public final String getOption(String name, String def) {
        if (!this.getSupportedOptions().contains(name)) {
            ErrorReporter.errorAbort("Illegal option: " + name);
        }
        if (this.activeOptions == null) {
            this.activeOptions = this.createActiveOptions(this.processingEnv.getOptions());
        }
        if (this.activeOptions.isEmpty()) {
            return def;
        }
        if (this.activeOptions.containsKey(name)) {
            return this.activeOptions.get(name);
        }
        return def;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.addAll(super.getSupportedOptions());
        Class<?> clazz = this.getClass();
        LinkedList clazzPrefixes = new LinkedList();
        do {
            clazzPrefixes.add(clazz);
            SupportedOptions so = clazz.getAnnotation(SupportedOptions.class);
            if (so == null) continue;
            options.addAll(this.expandCFOptions(clazzPrefixes, so.value()));
        } while ((clazz = clazz.getSuperclass()) != null && !clazz.getName().equals(AbstractTypeProcessor.class.getCanonicalName()));
        return Collections.unmodifiableSet(options);
    }

    protected Collection<String> expandCFOptions(List<? extends Class<?>> clazzPrefixes, String[] options) {
        HashSet<String> res = new HashSet<String>();
        for (String option : options) {
            res.add(option);
            for (Class<?> clazz : clazzPrefixes) {
                res.add(clazz.getCanonicalName() + OPTION_SEPARATOR + option);
                res.add(clazz.getSimpleName() + OPTION_SEPARATOR + option);
            }
        }
        return res;
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes supported = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (supported != null) {
            ErrorReporter.errorAbort("@SupportedAnnotationTypes should not be written on any checker; supported annotation types are inherited from SourceChecker.");
        }
        return Collections.singleton("*");
    }

    public Collection<String> getSuppressWarningsKeys() {
        return this.getStandardSuppressWarningsKeys();
    }

    protected final Collection<String> getStandardSuppressWarningsKeys() {
        SuppressWarningsKeys annotation = this.getClass().getAnnotation(SuppressWarningsKeys.class);
        if (annotation != null) {
            return Arrays.asList(annotation.value());
        }
        String className = this.getClass().getSimpleName();
        int indexOfChecker = className.lastIndexOf("Checker");
        if (indexOfChecker == -1) {
            indexOfChecker = className.lastIndexOf("Subchecker");
        }
        String key = indexOfChecker == -1 ? className : className.substring(0, indexOfChecker);
        return Collections.singleton(key.trim().toLowerCase());
    }

    public final boolean shouldSkipUses(Element element) {
        if (element == null) {
            return false;
        }
        TypeElement typeElement = ElementUtils.enclosingClass(element);
        String name = typeElement.toString();
        return this.shouldSkipUses(name);
    }

    public final boolean shouldSkipUses(String typeName) {
        if (this.skipUsesPattern == null) {
            this.skipUsesPattern = this.getSkipUsesPattern(this.getOptions());
        }
        if (this.onlyUsesPattern == null) {
            this.onlyUsesPattern = this.getOnlyUsesPattern(this.getOptions());
        }
        return this.skipUsesPattern.matcher(typeName).find() || !this.onlyUsesPattern.matcher(typeName).find();
    }

    public final boolean shouldSkipDefs(ClassTree node) {
        String qualifiedName = InternalUtils.typeOf(node).toString();
        if (this.skipDefsPattern == null) {
            this.skipDefsPattern = this.getSkipDefsPattern(this.getOptions());
        }
        if (this.onlyDefsPattern == null) {
            this.onlyDefsPattern = this.getOnlyDefsPattern(this.getOptions());
        }
        return this.skipDefsPattern.matcher(qualifiedName).find() || !this.onlyDefsPattern.matcher(qualifiedName).find();
    }

    public final boolean shouldSkipDefs(ClassTree cls, MethodTree meth) {
        return this.shouldSkipDefs(cls);
    }

    protected Properties getProperties(Class<?> cls, String filePath) {
        Properties prop = new Properties();
        try {
            InputStream base = cls.getResourceAsStream(filePath);
            if (base == null) {
                return prop;
            }
            prop.load(base);
        }
        catch (IOException e) {
            this.message(Diagnostic.Kind.WARNING, "Couldn't parse properties file: " + filePath, new Object[0]);
        }
        return prop;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static class CheckerError
    extends RuntimeException {
        public final boolean userError;

        public CheckerError(String msg, Throwable cause, boolean userError) {
            super(msg, cause);
            this.userError = userError;
        }
    }
}

