/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util.debug;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor6;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AbstractTypeProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"checker"})
public class SignaturePrinter
extends AbstractTypeProcessor {
    private SourceChecker checker;
    private static final String CHECKER_ARG = "-Achecker=";

    private void init(ProcessingEnvironment env, String checkerName) {
        if (checkerName != null) {
            try {
                Class<?> checkerClass = Class.forName(checkerName);
                Constructor<?> cons = checkerClass.getConstructor(new Class[0]);
                this.checker = (SourceChecker)cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.checker = new SourceChecker(){

                @Override
                protected SourceVisitor<?, ?> createSourceVisitor() {
                    return null;
                }
            };
        }
        this.checker.init(env);
    }

    @Override
    public void typeProcessingStart() {
        super.typeProcessingStart();
        String checkerName = this.processingEnv.getOptions().get("checker");
        this.init(this.processingEnv, checkerName);
    }

    @Override
    public void typeProcess(TypeElement element, TreePath p) {
    }

    public static void printUsage() {
        System.out.println("   Usage: java SignaturePrinter [-Achecker=<checkerName>] classname");
    }

    public static void main(String[] args) {
        if (!(args.length == 1 && !args[0].startsWith(CHECKER_ARG) || args.length == 2 && args[0].startsWith(CHECKER_ARG))) {
            SignaturePrinter.printUsage();
            return;
        }
        String checkerName = "";
        if (args[0].startsWith(CHECKER_ARG)) {
            checkerName = args[0].substring(CHECKER_ARG.length());
        }
        Context context = new Context();
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        SignaturePrinter printer = new SignaturePrinter();
        printer.init(env, checkerName);
        String className = args[args.length - 1];
        Symbol.ClassSymbol elem = env.getElementUtils().getTypeElement(className);
        if (elem == null) {
            System.err.println("Couldn't find class: " + className);
            return;
        }
        printer.typeProcess(elem, null);
    }

    static class ElementPrinter
    extends AbstractElementVisitor6<Void, Void> {
        private static final String INDENTION = "    ";
        private final PrintStream out;
        private String indent = "";
        private final AnnotatedTypeFactory factory;

        public ElementPrinter(AnnotatedTypeFactory factory, PrintStream out) {
            this.factory = factory;
            this.out = out;
        }

        public void printTypeParams(List<? extends AnnotatedTypeMirror.AnnotatedTypeVariable> params) {
            if (params.isEmpty()) {
                return;
            }
            this.out.print("<");
            boolean isntFirst = false;
            for (AnnotatedTypeMirror annotatedTypeMirror : params) {
                if (isntFirst) {
                    this.out.print(", ");
                }
                isntFirst = true;
                this.out.print(annotatedTypeMirror);
            }
            this.out.print("> ");
        }

        public void printParameters(AnnotatedTypeMirror.AnnotatedExecutableType type) {
            ExecutableElement elem = type.getElement();
            this.out.print("(");
            for (int i = 0; i < type.getParameterTypes().size(); ++i) {
                if (i != 0) {
                    this.out.print(", ");
                }
                this.printVariable(type.getParameterTypes().get(i), elem.getParameters().get(i).getSimpleName());
            }
            this.out.print(")");
        }

        public void printThrows(AnnotatedTypeMirror.AnnotatedExecutableType type) {
            if (type.getThrownTypes().isEmpty()) {
                return;
            }
            this.out.print(" throws ");
            boolean isntFirst = false;
            for (AnnotatedTypeMirror thrown : type.getThrownTypes()) {
                if (isntFirst) {
                    this.out.print(", ");
                }
                isntFirst = true;
                this.out.print(thrown);
            }
        }

        public void printVariable(AnnotatedTypeMirror type, Name name, boolean isVarArg) {
            this.out.print(type);
            if (isVarArg) {
                this.out.println("...");
            }
            this.out.print(' ');
            this.out.print(name);
        }

        public void printVariable(AnnotatedTypeMirror type, Name name) {
            this.printVariable(type, name, false);
        }

        public void printType(AnnotatedTypeMirror type) {
            this.out.print(type);
            this.out.print(' ');
        }

        public void printName(CharSequence name) {
            this.out.print(name);
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            this.out.print(this.indent);
            AnnotatedTypeMirror.AnnotatedExecutableType type = this.factory.getAnnotatedType(e);
            this.printTypeParams(type.getTypeVariables());
            if (e.getKind() != ElementKind.CONSTRUCTOR) {
                this.printType(type.getReturnType());
            }
            this.printName(e.getSimpleName());
            this.printParameters(type);
            this.printThrows(type);
            this.out.println(';');
            return null;
        }

        @Override
        public Void visitPackage(PackageElement e, Void p) {
            throw new IllegalArgumentException("Cannot process packages");
        }

        private String typeIdentifier(TypeElement e) {
            switch (e.getKind()) {
                case INTERFACE: {
                    return "interface";
                }
                case CLASS: {
                    return "class";
                }
                case ANNOTATION_TYPE: {
                    return "@interface";
                }
                case ENUM: {
                    return "enum";
                }
            }
            throw new IllegalArgumentException("Not a type element: " + (Object)((Object)e.getKind()));
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            String prevIndent = this.indent;
            this.out.print(this.indent);
            this.out.print(this.typeIdentifier(e));
            this.out.print(' ');
            this.out.print(e.getSimpleName());
            this.out.print(' ');
            AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.factory.getAnnotatedType(e);
            this.printSupers(dt);
            this.out.println("{");
            this.indent = this.indent + INDENTION;
            for (Element element : e.getEnclosedElements()) {
                this.visit(element);
            }
            this.indent = prevIndent;
            this.out.print(this.indent);
            this.out.println("}");
            return null;
        }

        private void printSupers(AnnotatedTypeMirror.AnnotatedDeclaredType dt) {
            if (dt.directSuperTypes().isEmpty()) {
                return;
            }
            this.out.print("extends ");
            boolean isntFirst = false;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : dt.directSuperTypes()) {
                if (isntFirst) {
                    this.out.print(", ");
                }
                isntFirst = true;
                this.out.print(st);
            }
            this.out.print(' ');
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Void p) {
            throw new IllegalStateException("Shouldn't visit any type parameters");
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            if (!e.getKind().isField()) {
                throw new IllegalStateException("can only process fields, received " + (Object)((Object)e.getKind()));
            }
            this.out.print(this.indent);
            AnnotatedTypeMirror type = this.factory.getAnnotatedType(e);
            this.printVariable(type, e.getSimpleName());
            this.out.println(';');
            return null;
        }
    }
}

