/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.util.PurityChecker;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.Unused;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.VisitorState;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class BaseTypeVisitor<Factory extends GenericAnnotatedTypeFactory<?, ?, ?, ?>>
extends SourceVisitor<Void, Void> {
    protected final BaseTypeChecker checker;
    protected final Factory atypeFactory;
    protected final SourcePositions positions;
    protected final VisitorState visitorState;
    protected final ContractsUtils contractsUtils;
    private final AnnotatedTypeMirror.AnnotatedDeclaredType vectorType;
    protected final BaseTypeValidator typeValidator;
    private static boolean checkedJDK = false;

    public BaseTypeVisitor(BaseTypeChecker checker) {
        super(checker);
        this.checker = checker;
        this.atypeFactory = this.createTypeFactory();
        this.contractsUtils = ContractsUtils.getInstance(this.atypeFactory);
        this.positions = this.trees.getSourcePositions();
        this.visitorState = ((AnnotatedTypeFactory)this.atypeFactory).getVisitorState();
        this.typeValidator = this.createTypeValidator();
        this.vectorType = ((AnnotatedTypeFactory)this.atypeFactory).fromElement(this.elements.getTypeElement("java.util.Vector"));
    }

    protected Factory createTypeFactory() {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "AnnotatedTypeFactory").replace("Subchecker", "AnnotatedTypeFactory");
            AnnotatedTypeFactory result = (AnnotatedTypeFactory)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class}, new Object[]{this.checker});
            if (result == null) continue;
            return (Factory)((GenericAnnotatedTypeFactory)result);
        }
        return (Factory)new BaseAnnotatedTypeFactory(this.checker);
    }

    public final Factory getTypeFactory() {
        return this.atypeFactory;
    }

    @Override
    public Void visit(CompilationUnitTree root, TreePath path, Void p) {
        ((GenericAnnotatedTypeFactory)this.atypeFactory).setRoot(root);
        return (Void)super.visit(root, path, p);
    }

    @Override
    public Void scan(Tree tree, Void p) {
        if (tree != null && this.getCurrentPath() != null) {
            this.visitorState.setPath(new TreePath(this.getCurrentPath(), tree));
        }
        return (Void)super.scan(tree, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClass(ClassTree node, Void p) {
        if (this.checker.shouldSkipDefs(node)) {
            return null;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType preACT = this.visitorState.getClassType();
        ClassTree preCT = this.visitorState.getClassTree();
        AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setClassType(((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node));
        this.visitorState.setClassTree(node);
        this.visitorState.setMethodReceiver(null);
        this.visitorState.setMethodTree(null);
        this.visitorState.setAssignmentContext(null);
        try {
            List<? extends Tree> impls;
            Tree ext;
            if (!TreeUtils.hasExplicitConstructor(node)) {
                this.checkDefaultConstructor(node);
            }
            if ((ext = node.getExtendsClause()) != null) {
                this.validateTypeOf(ext);
            }
            if ((impls = node.getImplementsClause()) != null) {
                for (Tree tree : impls) {
                    this.validateTypeOf(tree);
                }
            }
            Void void_ = (Void)super.visitClass(node, p);
            return void_;
        }
        finally {
            this.visitorState.setClassType(preACT);
            this.visitorState.setClassTree(preCT);
            this.visitorState.setMethodReceiver(preAMT);
            this.visitorState.setMethodTree(preMT);
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    protected void checkDefaultConstructor(ClassTree node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = AnnotatedTypes.deepCopy(((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node));
        AnnotatedTypeMirror.AnnotatedDeclaredType preMRT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        this.visitorState.setMethodReceiver(methodType.getReceiverType());
        this.visitorState.setMethodTree(node);
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration(node);
        try {
            if (InternalUtils.isAnonymousConstructor(node)) {
                Void void_ = null;
                return void_;
            }
            boolean anyPurityAnnotation = PurityUtils.hasPurityAnnotation(this.atypeFactory, node);
            boolean bl = this.checker.hasOption("suggestPureMethods");
            boolean enablePurity = this.checker.hasOption("enablePurity");
            if (enablePurity && (anyPurityAnnotation || bl)) {
                PurityChecker.PurityResult r;
                List<Pure.Kind> kinds = PurityUtils.getPurityKinds(this.atypeFactory, node);
                boolean isDeterministic = kinds.contains((Object)Pure.Kind.DETERMINISTIC);
                if (isDeterministic) {
                    if (TreeUtils.isConstructor(node)) {
                        this.checker.report(Result.warning("purity.deterministic.constructor", new Object[0]), node);
                    } else if (InternalUtils.typeOf(node.getReturnType()).getKind() == TypeKind.VOID) {
                        this.checker.report(Result.warning("purity.deterministic.void.method", new Object[0]), node);
                    }
                }
                if (!(r = PurityChecker.checkPurity(node.getBody(), this.atypeFactory, this.checker.hasOption("assumeSideEffectFree"))).isPure(kinds)) {
                    this.reportPurityErrors(r, node, kinds);
                }
                if (bl) {
                    HashSet<Pure.Kind> additionalKinds = new HashSet<Pure.Kind>(r.getTypes());
                    additionalKinds.removeAll(kinds);
                    if (TreeUtils.isConstructor(node)) {
                        additionalKinds.remove((Object)Pure.Kind.DETERMINISTIC);
                    }
                    if (!additionalKinds.isEmpty()) {
                        if (additionalKinds.size() == 2) {
                            this.checker.report(Result.warning("purity.more.pure", node.getName()), node);
                        } else if (additionalKinds.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                            this.checker.report(Result.warning("purity.more.sideeffectfree", node.getName()), node);
                        } else if (additionalKinds.contains((Object)Pure.Kind.DETERMINISTIC)) {
                            this.checker.report(Result.warning("purity.more.deterministic", node.getName()), node);
                        } else assert (false) : "BaseTypeVisitor reached undesirable state";
                    }
                }
            }
            this.validateTypeOf(node);
            for (ExpressionTree expressionTree : node.getThrows()) {
                this.validateTypeOf(expressionTree);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType = (AnnotatedTypeMirror.AnnotatedDeclaredType)((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(methodElement.getEnclosingElement());
            Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> map = AnnotatedTypes.overriddenMethods(this.elements, this.atypeFactory, methodElement);
            for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : map.entrySet()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType = pair.getKey();
                AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod = AnnotatedTypes.asMemberOf(this.types, this.atypeFactory, (AnnotatedTypeMirror)overriddenType, pair.getValue());
                this.checkOverride(node, enclosingType, overriddenMethod, overriddenType, p);
            }
            Void void_ = (Void)super.visitMethod(node, p);
            return void_;
        }
        finally {
            boolean bl = methodElement.getModifiers().contains((Object)Modifier.ABSTRACT);
            if (!bl) {
                this.checkPostconditions(node, methodElement);
                this.checkConditionalPostconditions(node, methodElement);
            }
            this.checkPreconditionsConsistency(node, methodElement);
            this.checkPostconditionsConsistency(node, methodElement);
            this.checkConditionalPostconditionsConsistency(node, methodElement);
            this.visitorState.setMethodReceiver(preMRT);
            this.visitorState.setMethodTree(preMT);
        }
    }

    protected void reportPurityErrors(PurityChecker.PurityResult result, MethodTree node, Collection<Pure.Kind> expectedTypes) {
        assert (!result.isPure(expectedTypes));
        EnumSet<Pure.Kind> t = EnumSet.copyOf(expectedTypes);
        t.removeAll(result.getTypes());
        if (t.contains((Object)Pure.Kind.DETERMINISTIC) || t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
            String msg;
            String msgPrefix = "purity.not.deterministic.not.sideeffectfree.";
            if (!t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                msgPrefix = "purity.not.deterministic.";
            } else if (!t.contains((Object)Pure.Kind.DETERMINISTIC)) {
                msgPrefix = "purity.not.sideeffectfree.";
            }
            for (Pair<Tree, String> r : result.getNotBothReasons()) {
                msg = msgPrefix + (String)r.second;
                this.checker.report(Result.failure(msg, new Object[0]), r.first);
            }
            if (t.contains((Object)Pure.Kind.SIDE_EFFECT_FREE)) {
                for (Pair<Tree, String> r : result.getNotSeFreeReasons()) {
                    msg = "purity.not.sideeffectfree." + (String)r.second;
                    this.checker.report(Result.failure(msg, new Object[0]), r.first);
                }
            }
            if (t.contains((Object)Pure.Kind.DETERMINISTIC)) {
                for (Pair<Tree, String> r : result.getNotDetReasons()) {
                    msg = "purity.not.deterministic." + (String)r.second;
                    this.checker.report(Result.failure(msg, new Object[0]), r.first);
                }
            }
        }
    }

    protected void checkPostconditions(MethodTree node, ExecutableElement methodElement) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, String>> postconditions = this.contractsUtils.getPostconditions(methodElement);
        for (Pair<String, String> p : postconditions) {
            String expression = (String)p.first;
            AnnotationMirror annotation = AnnotationUtils.fromName(this.elements, (CharSequence)p.second);
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, this.getCurrentPath(), this.atypeFactory);
            }
            FlowExpressions.Receiver expr = null;
            try {
                Object value;
                AnnotationMirror inferredAnno;
                expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
                Object exitStore = ((GenericAnnotatedTypeFactory)this.atypeFactory).getRegularExitStore(node);
                if (exitStore == null || this.checkContract(expr, annotation, inferredAnno = (value = ((CFAbstractStore)exitStore).getValue(expr)) == null ? null : ((CFAbstractValue)value).getType().getAnnotationInHierarchy(annotation), (CFAbstractStore<?, ?>)exitStore)) continue;
                this.checker.report(Result.failure("contracts.postcondition.not.satisfied", expr.toString()), node);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), node);
            }
        }
    }

    protected void checkPostconditionsConsistency(MethodTree node, ExecutableElement methodElement) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, String>> postconditions = this.contractsUtils.getPostconditions(methodElement);
        for (Pair<String, String> p : postconditions) {
            String expression = (String)p.first;
            AnnotationMirror annotation = AnnotationUtils.fromName(this.elements, (CharSequence)p.second);
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, this.getCurrentPath(), this.atypeFactory);
            }
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            try {
                FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                continue;
            }
            this.checkFlowExprParameters(methodElement, expression);
        }
    }

    protected void checkConditionalPostconditions(MethodTree node, ExecutableElement methodElement) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, Pair<Boolean, String>>> conditionalPostconditions = this.contractsUtils.getConditionalPostconditions(methodElement);
        for (Pair<String, Pair<Boolean, String>> p : conditionalPostconditions) {
            String expression = (String)p.first;
            boolean result = (Boolean)((Pair)p.second).first;
            AnnotationMirror annotation = AnnotationUtils.fromName(this.elements, (CharSequence)((Pair)p.second).second);
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, this.getCurrentPath(), this.atypeFactory);
            }
            FlowExpressions.Receiver expr = null;
            try {
                expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
                boolean booleanReturnType = TypesUtils.isBooleanType(InternalUtils.typeOf(node.getReturnType()));
                if (!booleanReturnType) {
                    this.checker.report(Result.failure("contracts.conditional.postcondition.invalid.returntype", new Object[0]), node);
                    continue;
                }
                List returnStatements = ((GenericAnnotatedTypeFactory)this.atypeFactory).getReturnStatementStores(node);
                Iterator iterator = returnStatements.iterator();
                while (iterator.hasNext()) {
                    AnnotationMirror inferredAnno;
                    Pair rt;
                    Pair r = rt = iterator.next();
                    ReturnNode returnStmt = (ReturnNode)r.first;
                    if (r.second == null) continue;
                    Node retValNode = returnStmt.getResult();
                    Boolean retVal = retValNode instanceof BooleanLiteralNode ? ((BooleanLiteralNode)retValNode).getValue() : null;
                    CFAbstractStore exitStore = result ? (CFAbstractStore)((TransferResult)r.second).getThenStore() : (CFAbstractStore)((TransferResult)r.second).getElseStore();
                    Object value = exitStore.getValue(expr);
                    if (retVal != null && retVal != result || this.checkContract(expr, annotation, inferredAnno = value == null ? null : ((CFAbstractValue)value).getType().getAnnotationInHierarchy(annotation), exitStore)) continue;
                    this.checker.report(Result.failure("contracts.conditional.postcondition.not.satisfied", expr.toString()), returnStmt.getTree());
                }
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), node);
            }
        }
    }

    protected void checkConditionalPostconditionsConsistency(MethodTree node, ExecutableElement methodElement) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, Pair<Boolean, String>>> conditionalPostconditions = this.contractsUtils.getConditionalPostconditions(methodElement);
        for (Pair<String, Pair<Boolean, String>> p : conditionalPostconditions) {
            String expression = (String)p.first;
            AnnotationMirror annotation = AnnotationUtils.fromName(this.elements, (CharSequence)((Pair)p.second).second);
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, this.getCurrentPath(), this.atypeFactory);
            }
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            try {
                FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                continue;
            }
            this.checkFlowExprParameters(methodElement, expression);
        }
    }

    protected void checkFlowExprParameters(ExecutableElement method, String stringExpr) {
        List<Integer> parameterIndices = FlowExpressionParseUtil.parameterIndices(stringExpr);
        for (Integer idx : parameterIndices) {
            VariableElement parameter = method.getParameters().get(idx - 1);
            if (ElementUtils.isEffectivelyFinal(parameter)) continue;
            this.checker.report(Result.failure("flowexpr.parameter.not.final", "#" + idx, stringExpr), method);
        }
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, Void p) {
        this.validateTypeOf(node);
        for (Tree tree : node.getBounds()) {
            this.validateTypeOf(tree);
        }
        return (Void)super.visitTypeParameter(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariable(VariableTree node, Void p) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setAssignmentContext(Pair.of(node, ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node)));
        try {
            boolean valid = this.validateTypeOf(node);
            if (valid && node.getInitializer() != null) {
                this.commonAssignmentCheck(node, node.getInitializer(), "assignment.type.incompatible");
            }
            Void void_ = (Void)super.visitVariable(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        this.visitorState.setAssignmentContext(Pair.of(node.getVariable(), ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getVariable())));
        try {
            this.commonAssignmentCheck(node.getVariable(), node.getExpression(), "assignment.type.incompatible");
            Void void_ = (Void)super.visitAssignment(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
        AnnotatedTypeMirror var = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getVariable());
        AnnotatedTypeMirror iterableType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror iteratedType = AnnotatedTypes.getIteratedType(this.checker.getProcessingEnvironment(), this.atypeFactory, iterableType);
        boolean valid = this.validateTypeOf(node.getVariable());
        if (valid) {
            this.commonAssignmentCheck(var, iteratedType, node.getExpression(), "enhancedfor.type.incompatible", true);
        }
        return (Void)super.visitEnhancedForLoop(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ExecutableElement invokedMethodElement;
        if (TreeUtils.isEnumSuper(node)) {
            return (Void)super.visitMethodInvocation(node, p);
        }
        if (this.shouldSkipUses(node)) {
            return (Void)super.visitMethodInvocation(node, p);
        }
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = ((GenericAnnotatedTypeFactory)this.atypeFactory).methodFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        List typeargs = (List)mfuPair.second;
        ArrayList<AnnotatedTypeParameterBounds> paramBounds = new ArrayList<AnnotatedTypeParameterBounds>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable param : invokedMethod.getTypeVariables()) {
            paramBounds.add(param.getBounds());
        }
        this.checkTypeArguments(node, paramBounds, typeargs, node.getTypeArguments());
        List<AnnotatedTypeMirror> params = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, node.getArguments());
        this.checkArguments(params, node.getArguments());
        if (this.isVectorCopyInto(invokedMethod)) {
            this.typeCheckVectorCopyIntoArgument(node, params);
        }
        if (!ElementUtils.isStatic(invokedMethodElement = invokedMethod.getElement()) && !TreeUtils.isSuperCall(node)) {
            this.checkMethodInvocability(invokedMethod, node);
        }
        this.checkPreconditions(node, invokedMethodElement, true);
        this.scan((Tree)node.getMethodSelect(), p);
        return null;
    }

    protected void checkPreconditions(Tree tree, Element invokedElement, boolean methodCall) {
        this.checkPreconditions(tree, invokedElement, methodCall, null);
    }

    protected void checkPreconditions(Tree tree, Element invokedElement, boolean methodCall, Set<Pair<String, String>> additionalPreconditions) {
        Set<Pair<String, String>> preconditions = this.contractsUtils.getPreconditions(invokedElement);
        if (additionalPreconditions != null) {
            preconditions.addAll(additionalPreconditions);
        }
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (Pair<String, String> p : preconditions) {
            String expression = (String)p.first;
            AnnotationMirror anno = AnnotationUtils.fromName(this.elements, (CharSequence)p.second);
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(anno)) {
                return;
            }
            if (flowExprContext == null) {
                Node nodeNode = ((GenericAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(tree);
                if (methodCall) {
                    flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForUse((MethodInvocationNode)nodeNode, this.atypeFactory);
                } else if (nodeNode instanceof FieldAccessNode) {
                    FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(this.atypeFactory, ((FieldAccessNode)nodeNode).getReceiver());
                    flowExprContext = new FlowExpressionParseUtil.FlowExpressionContext(internalReceiver, null, (AnnotatedTypeFactory)this.atypeFactory);
                } else if (nodeNode instanceof LocalVariableNode) {
                    ClassTree enclosingClass = TreeUtils.enclosingClass(this.getCurrentPath());
                    TypeElement classElem = TreeUtils.elementFromDeclaration(enclosingClass);
                    ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(classElem.asType());
                    FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(this.atypeFactory, receiver);
                    flowExprContext = new FlowExpressionParseUtil.FlowExpressionContext(internalReceiver, null, (AnnotatedTypeFactory)this.atypeFactory);
                }
            }
            if (flowExprContext == null) continue;
            FlowExpressions.Receiver expr = null;
            try {
                AnnotationMirror inferredAnno;
                Object value;
                Object store = ((GenericAnnotatedTypeFactory)this.atypeFactory).getStoreBefore(tree);
                String s2 = expression.trim();
                Pattern selfPattern = Pattern.compile("^(this)$");
                Matcher selfMatcher = selfPattern.matcher(s2);
                if (selfMatcher.matches()) {
                    s2 = flowExprContext.receiver.toString();
                }
                if ((value = ((CFAbstractStore)store).getValueOfLocalVariableByName(s2)) == null) {
                    expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
                    value = ((CFAbstractStore)store).getValue(expr);
                }
                AnnotationMirror annotationMirror = inferredAnno = value == null ? null : ((CFAbstractValue)value).getType().getAnnotationInHierarchy(anno);
                if (this.skipContractCheck(tree, expr, flowExprContext) || this.checkContract(expr, anno, inferredAnno, (CFAbstractStore<?, ?>)store)) continue;
                this.checker.report(Result.failure(methodCall ? "contracts.precondition.not.satisfied" : "contracts.precondition.not.satisfied.field", tree.toString(), expr == null ? expression : expr.toString()), tree);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {}
        }
    }

    protected boolean skipContractCheck(Tree tree, FlowExpressions.Receiver expr, FlowExpressionParseUtil.FlowExpressionContext flowExprContext) {
        return false;
    }

    protected void checkPreconditionsConsistency(MethodTree node, ExecutableElement methodElement) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<Pair<String, String>> preconditions = this.contractsUtils.getPreconditions(methodElement);
        for (Pair<String, String> p : preconditions) {
            String expression = (String)p.first;
            AnnotationMirror anno = AnnotationUtils.fromName(this.elements, (CharSequence)p.second);
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(node, this.getCurrentPath(), this.atypeFactory);
            }
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(anno)) {
                return;
            }
            try {
                FlowExpressionParseUtil.parse(expression, flowExprContext, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                continue;
            }
            this.checkFlowExprParameters(methodElement, expression);
        }
    }

    protected boolean checkContract(FlowExpressions.Receiver expr, AnnotationMirror necessaryAnnotation, AnnotationMirror inferredAnnotation, CFAbstractStore<?, ?> store) {
        return inferredAnnotation != null && ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(inferredAnnotation, necessaryAnnotation);
    }

    protected boolean isVectorCopyInto(AnnotatedTypeMirror.AnnotatedExecutableType method) {
        ExecutableElement elt = method.getElement();
        return elt.getSimpleName().contentEquals("copyInto") && elt.getParameters().size() == 1;
    }

    protected void typeCheckVectorCopyIntoArgument(MethodInvocationTree node, List<? extends AnnotatedTypeMirror> params) {
        assert (params.size() == 1) : "invalid no. of parameters " + params + " found for method invocation " + node;
        assert (node.getArguments().size() == 1) : "invalid no. of arguments in method invocation " + node;
        AnnotatedTypeMirror passed = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getArguments().get(0));
        AnnotatedTypeMirror.AnnotatedArrayType passedAsArray = (AnnotatedTypeMirror.AnnotatedArrayType)passed;
        AnnotatedTypeMirror receiver = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverAsVector = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(this.checker.getProcessingEnvironment().getTypeUtils(), this.atypeFactory, receiver, this.vectorType);
        if (receiverAsVector == null || receiverAsVector.getTypeArguments().isEmpty()) {
            return;
        }
        this.commonAssignmentCheck(passedAsArray.getComponentType(), receiverAsVector.getTypeArguments().get(0), node.getArguments().get(0), "vector.copyinto.type.incompatible", false);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        if (this.checker.shouldSkipUses(InternalUtils.constructor(node))) {
            return (Void)super.visitNewClass(node, p);
        }
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> fromUse = ((GenericAnnotatedTypeFactory)this.atypeFactory).constructorFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = (AnnotatedTypeMirror.AnnotatedExecutableType)fromUse.first;
        List typeargs = (List)fromUse.second;
        List<? extends ExpressionTree> passedArguments = node.getArguments();
        List<AnnotatedTypeMirror> params = AnnotatedTypes.expandVarArgs(this.atypeFactory, constructor, passedArguments);
        this.checkArguments(params, passedArguments);
        ArrayList<AnnotatedTypeParameterBounds> paramBounds = new ArrayList<AnnotatedTypeParameterBounds>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable param : constructor.getTypeVariables()) {
            paramBounds.add(param.getBounds());
        }
        this.checkTypeArguments(node, paramBounds, typeargs, node.getTypeArguments());
        boolean valid = this.validateTypeOf(node);
        if (valid) {
            AnnotatedTypeMirror.AnnotatedDeclaredType dt = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
            this.checkConstructorInvocation(dt, constructor, node);
        }
        return (Void)super.visitNewClass(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        if (node.getExpression() == null) {
            return (Void)super.visitReturn(node, p);
        }
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getCurrentPath());
            boolean valid = this.validateTypeOf(enclosingMethod);
            if (valid) {
                AnnotatedTypeMirror ret = ((AnnotatedTypeFactory)this.atypeFactory).getMethodReturnType(enclosingMethod, node);
                this.visitorState.setAssignmentContext(Pair.of(node, ret));
                this.commonAssignmentCheck(ret, node.getExpression(), "return.type.incompatible", false);
            }
            Void void_ = (Void)super.visitReturn(node, p);
            return void_;
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAnnotation(AnnotationTree node, Void p) {
        List<? extends ExpressionTree> args = node.getArguments();
        if (args.isEmpty()) {
            return null;
        }
        Symbol anno = TreeInfo.symbol((JCTree)node.getAnnotationType());
        if (((Object)anno).toString().equals(DefaultQualifier.class.getName()) || ((Object)anno).toString().equals(SuppressWarnings.class.getName())) {
            return null;
        }
        HashMap<String, AnnotatedTypeMirror> annoTypes = new HashMap<String, AnnotatedTypeMirror>();
        for (Element element : ElementFilter.methodsIn(anno.getEnclosedElements())) {
            AnnotatedTypeMirror.AnnotatedExecutableType exeatm = (AnnotatedTypeMirror.AnnotatedExecutableType)((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(element);
            AnnotatedTypeMirror retty = exeatm.getReturnType();
            annoTypes.put(element.getSimpleName().toString(), retty);
        }
        for (ExpressionTree expressionTree : args) {
            if (!(expressionTree instanceof AssignmentTree)) continue;
            AssignmentTree at = (AssignmentTree)expressionTree;
            if (at.getExpression().getKind() == Tree.Kind.ANNOTATION) {
                this.visitAnnotation((AnnotationTree)at.getExpression(), p);
                continue;
            }
            if (at.getExpression().getKind() == Tree.Kind.NEW_ARRAY) {
                NewArrayTree nat = (NewArrayTree)at.getExpression();
                boolean isAnno = false;
                for (ExpressionTree expressionTree2 : nat.getInitializers()) {
                    if (expressionTree2.getKind() != Tree.Kind.ANNOTATION) continue;
                    this.visitAnnotation((AnnotationTree)expressionTree2, p);
                    isAnno = true;
                }
                if (isAnno) continue;
            }
            AnnotatedTypeMirror expected = (AnnotatedTypeMirror)annoTypes.get(at.getVariable().toString());
            Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
            ExpressionTree var = at.getVariable();
            assert (var instanceof IdentifierTree) : "Expected IdentifierTree as context. Found: " + var;
            AnnotatedTypeMirror annotatedTypeMirror = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(var);
            assert (annotatedTypeMirror instanceof AnnotatedTypeMirror.AnnotatedExecutableType) : "Expected AnnotatedExecutableType as context. Found: " + annotatedTypeMirror;
            AnnotatedTypeMirror newctx = ((AnnotatedTypeMirror.AnnotatedExecutableType)annotatedTypeMirror).getReturnType();
            this.visitorState.setAssignmentContext(Pair.of(null, newctx));
            try {
                AnnotatedTypeMirror actual = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(at.getExpression());
                if (expected.getKind() != TypeKind.ARRAY) {
                    this.commonAssignmentCheck(expected, actual, at.getExpression(), "annotation.type.incompatible", false);
                    continue;
                }
                if (actual.getKind() == TypeKind.ARRAY) {
                    this.commonAssignmentCheck(expected, actual, at.getExpression(), "annotation.type.incompatible", false);
                    continue;
                }
                this.commonAssignmentCheck(((AnnotatedTypeMirror.AnnotatedArrayType)expected).getComponentType(), actual, at.getExpression(), "annotation.type.incompatible", false);
            }
            finally {
                this.visitorState.setAssignmentContext(preAssCtxt);
            }
        }
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        AnnotatedTypeMirror cond = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        Pair<Tree, AnnotatedTypeMirror> ctx = this.visitorState.getAssignmentContext();
        Tree assignmentContext = ctx == null ? null : (Tree)ctx.first;
        boolean isLocalVariableAssignment = false;
        if (assignmentContext != null) {
            if (assignmentContext instanceof VariableTree) {
                boolean bl = isLocalVariableAssignment = assignmentContext instanceof IdentifierTree && !TreeUtils.isFieldAccess(assignmentContext);
            }
            if (assignmentContext instanceof VariableTree) {
                isLocalVariableAssignment = TreeUtils.enclosingMethod(this.getCurrentPath()) != null;
            }
        }
        this.commonAssignmentCheck(cond, node.getTrueExpression(), "conditional.type.incompatible", isLocalVariableAssignment);
        this.commonAssignmentCheck(cond, node.getFalseExpression(), "conditional.type.incompatible", isLocalVariableAssignment);
        return (Void)super.visitConditionalExpression(node, p);
    }

    @Override
    public Void visitUnary(UnaryTree node, Void p) {
        if (node.getKind() == Tree.Kind.PREFIX_DECREMENT || node.getKind() == Tree.Kind.PREFIX_INCREMENT || node.getKind() == Tree.Kind.POSTFIX_DECREMENT || node.getKind() == Tree.Kind.POSTFIX_INCREMENT) {
            AnnotatedTypeMirror type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
            this.checkAssignability(type, node.getExpression());
        }
        return (Void)super.visitUnary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        this.commonAssignmentCheck(node.getVariable(), node.getExpression(), "compound.assignment.type.incompatible");
        return (Void)super.visitCompoundAssignment(node, p);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        boolean valid = this.validateTypeOf(node);
        if (valid && node.getType() != null && node.getInitializers() != null) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
            this.checkArrayInitialization(arrayType.getComponentType(), node.getInitializers());
        }
        return (Void)super.visitNewArray(node, p);
    }

    @Override
    public final Void visitParameterizedType(ParameterizedTypeTree node, Void p) {
        return null;
    }

    protected void checkTypecastRedundancy(TypeCastTree node, Void p) {
        AnnotatedTypeMirror exprType;
        if (!this.checker.getLintOption("cast:redundant", false)) {
            return;
        }
        AnnotatedTypeMirror castType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        if (AnnotatedTypes.areSame(castType, exprType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression()))) {
            this.checker.report(Result.warning("cast.redundant", castType), node);
        }
    }

    protected void checkTypecastSafety(TypeCastTree node, Void p) {
        if (!this.checker.getLintOption("cast:unsafe", true)) {
            return;
        }
        boolean isSubtype = false;
        AnnotatedTypeMirror castType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node);
        if (castType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType castDeclared = (AnnotatedTypeMirror.AnnotatedDeclaredType)castType;
            AnnotatedTypeMirror.AnnotatedDeclaredType elementType = ((AnnotatedTypeFactory)this.atypeFactory).fromElement((TypeElement)castDeclared.getUnderlyingType().asElement());
            if (AnnotationUtils.areSame(castDeclared.getAnnotations(), elementType.getAnnotations())) {
                isSubtype = true;
            }
        }
        AnnotatedTypeMirror exprType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node.getExpression());
        if (!isSubtype) {
            if (this.checker.hasOption("checkCastElementType")) {
                AnnotatedTypeMirror newCastType = castType.getKind() == TypeKind.TYPEVAR ? ((AnnotatedTypeMirror.AnnotatedTypeVariable)castType).getEffectiveUpperBound() : castType;
                AnnotatedTypeMirror newExprType = exprType.getKind() == TypeKind.TYPEVAR ? ((AnnotatedTypeMirror.AnnotatedTypeVariable)exprType).getEffectiveUpperBound() : exprType;
                isSubtype = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(newExprType, newCastType);
                if (isSubtype) {
                    int exprSize;
                    int castSize;
                    if (newCastType.getKind() == TypeKind.ARRAY && newExprType.getKind() != TypeKind.ARRAY) {
                        isSubtype = false;
                    } else if (newCastType.getKind() == TypeKind.DECLARED && newExprType.getKind() == TypeKind.DECLARED && (castSize = ((AnnotatedTypeMirror.AnnotatedDeclaredType)newCastType).getTypeArguments().size()) != (exprSize = ((AnnotatedTypeMirror.AnnotatedDeclaredType)newExprType).getTypeArguments().size())) {
                        isSubtype = false;
                    }
                }
            } else {
                isSubtype = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(exprType.getEffectiveAnnotations(), castType.getEffectiveAnnotations());
            }
        }
        if (!isSubtype) {
            this.checker.report(Result.warning("cast.unsafe", exprType, castType), node);
        }
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        boolean valid;
        boolean bl = valid = this.validateTypeOf(node) && this.validateTypeOf(node.getExpression());
        if (valid) {
            this.checkTypecastSafety(node, p);
            this.checkTypecastRedundancy(node, p);
        }
        return (Void)super.visitTypeCast(node, p);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void p) {
        this.validateTypeOf(node.getType());
        return (Void)super.visitInstanceOf(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            this.visitorState.setAssignmentContext(null);
            this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getIndex(), p);
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
        return null;
    }

    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, String errorKey) {
        if (!this.validateTypeOf(varTree)) {
            return;
        }
        AnnotatedTypeMirror var = ((GenericAnnotatedTypeFactory)this.atypeFactory).getDefaultedAnnotatedType(varTree, valueExp);
        assert (var != null) : "no variable found for tree: " + varTree;
        this.checkAssignability(var, varTree);
        boolean isLocalVariableAssignment = false;
        if (varTree instanceof AssignmentTree) {
            ExpressionTree rhs = ((AssignmentTree)varTree).getVariable();
            boolean bl = isLocalVariableAssignment = rhs instanceof IdentifierTree && !TreeUtils.isFieldAccess(rhs);
        }
        if (varTree instanceof VariableTree) {
            isLocalVariableAssignment = TreeUtils.enclosingMethod(this.getCurrentPath()) != null;
        }
        this.commonAssignmentCheck(var, valueExp, errorKey, isLocalVariableAssignment);
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, String errorKey, boolean isLocalVariableAssignement) {
        if (this.shouldSkipUses(valueExp)) {
            return;
        }
        if (varType.getKind() == TypeKind.ARRAY && valueExp instanceof NewArrayTree && ((NewArrayTree)valueExp).getType() == null) {
            AnnotatedTypeMirror compType = ((AnnotatedTypeMirror.AnnotatedArrayType)varType).getComponentType();
            NewArrayTree arrayTree = (NewArrayTree)valueExp;
            assert (arrayTree.getInitializers() != null) : "array initializers are not expected to be null in: " + valueExp;
            this.checkArrayInitialization(compType, arrayTree.getInitializers());
        }
        if (!this.validateTypeOf(valueExp)) {
            return;
        }
        AnnotatedTypeMirror valueType = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(valueExp);
        assert (valueType != null) : "null type for expression: " + valueExp;
        this.commonAssignmentCheck(varType, valueType, valueExp, errorKey, isLocalVariableAssignement);
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, String errorKey, boolean isLocalVariableAssignement) {
        boolean success;
        String varTypeString;
        String valueTypeString = valueType.toString();
        if (valueTypeString.equals(varTypeString = varType.toString())) {
            valueTypeString = valueType.toString(true);
            varTypeString = varType.toString(true);
        }
        if (isLocalVariableAssignement && varType.getKind() == TypeKind.TYPEVAR && varType.getAnnotations().isEmpty()) {
            return;
        }
        if (this.checker.hasOption("showchecks")) {
            long valuePos = this.positions.getStartPosition(this.root, valueTree);
            System.out.printf(" %s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{"About to test whether actual is a subtype of expected", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, valueTree.getKind(), valueTree, valueType.getKind(), valueTypeString, varType.getKind(), varTypeString});
        }
        if (success = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType)) {
            for (Class<Annotation> mono : ((GenericAnnotatedTypeFactory)this.atypeFactory).getSupportedMonotonicTypeQualifiers()) {
                if (!valueType.hasAnnotation(mono) || !varType.hasAnnotation(mono)) continue;
                this.checker.report(Result.failure("monotonic.type.incompatible", mono.getCanonicalName(), mono.getCanonicalName(), valueType.toString()), valueTree);
                return;
            }
        }
        if (this.checker.hasOption("showchecks")) {
            long valuePos = this.positions.getStartPosition(this.root, valueTree);
            System.out.printf(" %s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{success ? "success: actual is subtype of expected" : "FAILURE: actual is not subtype of expected", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, valueTree.getKind(), valueTree, valueType.getKind(), valueTypeString, varType.getKind(), varTypeString});
        }
        if (!success) {
            this.checker.report(Result.failure(errorKey, valueTypeString, varTypeString), valueTree);
        }
    }

    protected void checkArrayInitialization(AnnotatedTypeMirror type, List<? extends ExpressionTree> initializers) {
        for (ExpressionTree expressionTree : initializers) {
            this.commonAssignmentCheck(type, expressionTree, "array.initializer.type.incompatible", false);
        }
    }

    protected void checkTypeArguments(Tree toptree, List<? extends AnnotatedTypeParameterBounds> paramBounds, List<? extends AnnotatedTypeMirror> typeargs, List<? extends Tree> typeargTrees) {
        if (paramBounds.isEmpty()) {
            return;
        }
        assert (paramBounds.size() == typeargs.size()) : "BaseTypeVisitor.checkTypeArguments: mismatch between type arguments: " + typeargs + " and type parameter bounds" + paramBounds;
        Iterator<? extends AnnotatedTypeParameterBounds> boundsIter = paramBounds.iterator();
        Iterator<? extends AnnotatedTypeMirror> argIter = typeargs.iterator();
        while (boundsIter.hasNext()) {
            AnnotatedTypeParameterBounds bounds = boundsIter.next();
            AnnotatedTypeMirror typearg = argIter.next();
            if (typearg.getKind() == TypeKind.WILDCARD) continue;
            if (typeargTrees == null || typeargTrees.isEmpty()) {
                this.commonAssignmentCheck(bounds.getUpperBound(), typearg, toptree, "type.argument.type.incompatible", false);
            } else {
                this.commonAssignmentCheck(bounds.getUpperBound(), typearg, typeargTrees.get(typeargs.indexOf(typearg)), "type.argument.type.incompatible", false);
            }
            if (((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(bounds.getLowerBound(), typearg)) continue;
            if (typeargTrees == null || typeargTrees.isEmpty()) {
                this.checker.report(Result.failure("type.argument.type.incompatible", typearg, bounds), toptree);
                continue;
            }
            this.checker.report(Result.failure("type.argument.type.incompatible", typearg, bounds), typeargTrees.get(typeargs.indexOf(typearg)));
        }
    }

    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        if (method.getReceiverType() == null) {
            return;
        }
        if (method.getElement().getKind() == ElementKind.CONSTRUCTOR) {
            return;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = method.getReceiverType().getErased();
        AnnotatedTypeMirror treeReceiver = ((AnnotatedTypeMirror)methodReceiver).getCopy(false);
        AnnotatedTypeMirror rcv = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        treeReceiver.addAnnotations(rcv.getEffectiveAnnotations());
        if (!((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(treeReceiver, methodReceiver)) {
            this.checker.report(Result.failure("method.invocation.invalid", TreeUtils.elementFromUse(node), treeReceiver.toString(), methodReceiver.toString()), node);
        }
    }

    protected boolean checkConstructorInvocation(AnnotatedTypeMirror.AnnotatedDeclaredType dt, AnnotatedTypeMirror.AnnotatedExecutableType constructor, Tree src) {
        boolean b;
        AnnotatedTypeMirror.AnnotatedDeclaredType ret = (AnnotatedTypeMirror.AnnotatedDeclaredType)constructor.getReturnType();
        boolean bl = b = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(dt, ret) || ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(ret, dt);
        if (!b) {
            this.checker.report(Result.failure("constructor.invocation.invalid", constructor.toString(), dt, ret), src);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkArguments(List<? extends AnnotatedTypeMirror> requiredArgs, List<? extends ExpressionTree> passedArgs) {
        assert (requiredArgs.size() == passedArgs.size()) : "mismatch between required args (" + requiredArgs + ") and passed args (" + passedArgs + ")";
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
        try {
            for (int i = 0; i < requiredArgs.size(); ++i) {
                this.visitorState.setAssignmentContext(Pair.of(null, requiredArgs.get(i)));
                this.commonAssignmentCheck(requiredArgs.get(i), passedArgs.get(i), "argument.type.incompatible", false);
                this.scan((Tree)passedArgs.get(i), null);
            }
        }
        finally {
            this.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        if (this.checker.shouldSkipUses(overriddenType.getUnderlyingType().asElement())) {
            return true;
        }
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        boolean result = true;
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        String overriderMeth = overrider.toString();
        String overriderTyp = enclosingType.getUnderlyingType().asElement().toString();
        String overriddenMeth = overridden.toString();
        String overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
        if (overrider.getReturnType().getKind() != TypeKind.VOID) {
            boolean success = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(overrider.getReturnType(), overridden.getReturnType());
            if (this.checker.hasOption("showchecks")) {
                long valuePos = this.positions.getStartPosition(this.root, overriderTree.getReturnType());
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (return type %s)%n   overridden: %s %s (return type %s)%n", success ? "success: overriding return type is subtype of overridden" : "FAILURE: overriding return type is not subtype of overridden", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, overriderMeth, overriderTyp, overrider.getReturnType().toString(), overriddenMeth, overriddenTyp, overridden.getReturnType().toString());
            }
            if (!success) {
                this.checker.report(Result.failure("override.return.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overrider.getReturnType().toString(), overridden.getReturnType().toString()), overriderTree.getReturnType());
                result = false;
            }
        }
        List<AnnotatedTypeMirror> overriderParams = overrider.getParameterTypes();
        List<AnnotatedTypeMirror> overriddenParams = overridden.getParameterTypes();
        for (int i = 0; i < overriderParams.size(); ++i) {
            boolean success = ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(overriddenParams.get(i), overriderParams.get(i));
            if (this.checker.hasOption("showchecks")) {
                long valuePos = this.positions.getStartPosition(this.root, overriderTree.getParameters().get(i));
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (parameter %d type %s)%n   overridden: %s %s (parameter %d type %s)%n", success ? "success: overridden parameter type is subtype of overriding" : "FAILURE: overridden parameter type is not subtype of overriding", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, overriderMeth, overriderTyp, i, overriderParams.get(i).toString(), overriddenMeth, overriddenTyp, i, overriddenParams.get(i).toString());
            }
            if (success) continue;
            this.checker.report(Result.failure("override.param.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overriderParams.get(i).toString(), overriddenParams.get(i).toString()), overriderTree.getParameters().get(i));
            result = false;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType overriddenReceiver = overrider.getReceiverType().getErased().getCopy(false);
        overriddenReceiver.addAnnotations(overridden.getReceiverType().getAnnotations());
        if (!((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(overriddenReceiver, overrider.getReceiverType().getErased())) {
            this.checker.report(Result.failure("override.receiver.invalid", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overrider.getReceiverType(), overridden.getReceiverType()), overriderTree);
            result = false;
        }
        ContractsUtils contracts = ContractsUtils.getInstance(this.atypeFactory);
        Set<Pair<String, String>> superPost = contracts.getPostconditions(overridden.getElement());
        Set<Pair<String, String>> subPost = contracts.getPostconditions(overrider.getElement());
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> superPost2 = this.resolveContracts(superPost, overridden);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> subPost2 = this.resolveContracts(subPost, overrider);
        this.checkContractsSubset(overriderTyp, overriddenTyp, superPost2, subPost2, "contracts.postcondition.override.invalid");
        Set<Pair<String, String>> superPre = contracts.getPreconditions(overridden.getElement());
        Set<Pair<String, String>> subPre = contracts.getPreconditions(overrider.getElement());
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> superPre2 = this.resolveContracts(superPre, overridden);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> subPre2 = this.resolveContracts(subPre, overrider);
        this.checkContractsSubset(overriderTyp, overriddenTyp, subPre2, superPre2, "contracts.precondition.override.invalid");
        Set superCPost = contracts.getConditionalPostconditions(overridden.getElement());
        Set subCPost = contracts.getConditionalPostconditions(overrider.getElement());
        Set<Pair<String, String>> superCPostTrue = this.filterConditionalPostconditions(superCPost, true);
        Set<Pair<String, String>> subCPostTrue = this.filterConditionalPostconditions(subCPost, true);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> superCPostTrue2 = this.resolveContracts(superCPostTrue, overridden);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> subCPostTrue2 = this.resolveContracts(subCPostTrue, overrider);
        this.checkContractsSubset(overriderTyp, overriddenTyp, superCPostTrue2, subCPostTrue2, "contracts.conditional.postcondition.true.override.invalid");
        Set<Pair<String, String>> superCPostFalse = this.filterConditionalPostconditions(superCPost, false);
        Set<Pair<String, String>> subCPostFalse = this.filterConditionalPostconditions(subCPost, false);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> superCPostFalse2 = this.resolveContracts(superCPostFalse, overridden);
        Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> subCPostFalse2 = this.resolveContracts(subCPostFalse, overrider);
        this.checkContractsSubset(overriderTyp, overriddenTyp, superCPostFalse2, subCPostFalse2, "contracts.conditional.postcondition.false.override.invalid");
        HashSet<Pure.Kind> superPurity = new HashSet<Pure.Kind>(PurityUtils.getPurityKinds(this.atypeFactory, overridden.getElement()));
        HashSet<Pure.Kind> subPurity = new HashSet<Pure.Kind>(PurityUtils.getPurityKinds(this.atypeFactory, overrider.getElement()));
        if (!subPurity.containsAll(superPurity)) {
            this.checker.report(Result.failure("purity.invalid.overriding", overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, subPurity, superPurity), overriderTree);
        }
        return result;
    }

    private <T, S> Set<Pair<T, S>> filterConditionalPostconditions(Set<Pair<T, Pair<Boolean, S>>> conditionalPostconditions, boolean b) {
        HashSet<Pair<T, S>> result = new HashSet<Pair<T, S>>();
        for (Pair<T, Pair<Boolean, S>> p : conditionalPostconditions) {
            if ((Boolean)((Pair)p.second).first != b) continue;
            result.add(Pair.of(p.first, ((Pair)p.second).second));
        }
        return result;
    }

    private void checkContractsSubset(String subCl, String superCl, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> mustSubset, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> set, String messageKey) {
        for (Pair<FlowExpressions.Receiver, AnnotationMirror> a : mustSubset) {
            boolean found = false;
            for (Pair<FlowExpressions.Receiver, AnnotationMirror> b : set) {
                QualifierHierarchy qualifierHierarchy;
                if (!((FlowExpressions.Receiver)a.first).equals(b.first) || !(qualifierHierarchy = ((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy()).isSubtype((AnnotationMirror)a.second, (AnnotationMirror)b.second)) continue;
                found = true;
                break;
            }
            if (found) continue;
            MethodTree method = this.visitorState.getMethodTree();
            this.checker.report(Result.failure(messageKey, a.first, method.getName().toString(), subCl, superCl), method);
        }
    }

    private Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> resolveContracts(Set<Pair<String, String>> contractSet, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>> result = new HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>>();
        MethodTree methodTree = this.visitorState.getMethodTree();
        TreePath path = ((AnnotatedTypeFactory)this.atypeFactory).getPath(methodTree);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (Pair<String, String> p : contractSet) {
            String expression = (String)p.first;
            AnnotationMirror annotation = AnnotationUtils.fromName(((AnnotatedTypeFactory)this.atypeFactory).getElementUtils(), (CharSequence)p.second);
            if (!((AnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForDeclaration(methodTree, method.getReceiverType().getUnderlyingType(), this.atypeFactory);
            }
            try {
                FlowExpressions.Receiver expr = FlowExpressionParseUtil.parse(expression, flowExprContext, path);
                result.add(Pair.of(expr, annotation));
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {}
        }
        return result;
    }

    protected void checkAssignability(AnnotatedTypeMirror varType, Tree varTree) {
        AnnotatedTypeMirror rcvType;
        if (TreeUtils.isExpressionTree(varTree) && !this.isAssignable(varType, rcvType = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType((ExpressionTree)varTree), varTree)) {
            this.checker.report(Result.failure("assignability.invalid", InternalUtils.symbol(varTree), rcvType), varTree);
        }
    }

    protected boolean isAssignable(AnnotatedTypeMirror varType, AnnotatedTypeMirror receiverType, Tree variable) {
        return true;
    }

    protected MemberSelectTree enclosingMemberSelect() {
        TreePath path = this.getCurrentPath();
        assert (path.getLeaf().getKind() == Tree.Kind.IDENTIFIER) : "expected identifier, found: " + path.getLeaf();
        if (path.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            return (MemberSelectTree)path.getParentPath().getLeaf();
        }
        return null;
    }

    protected Tree enclosingStatement(Tree tree) {
        TreePath path;
        for (path = this.getCurrentPath(); path != null && path.getLeaf() != tree; path = path.getParentPath()) {
        }
        if (path != null) {
            return path.getParentPath().getLeaf();
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        this.checkAccess(node, p);
        return (Void)super.visitIdentifier(node, p);
    }

    protected void checkAccess(IdentifierTree node, Void p) {
        Element elem;
        ExpressionTree tree;
        MemberSelectTree memberSel = this.enclosingMemberSelect();
        this.checkPreconditions(node, TreeUtils.elementFromUse(node), false);
        if (memberSel == null) {
            tree = node;
            elem = TreeUtils.elementFromUse(node);
        } else {
            tree = memberSel;
            elem = TreeUtils.elementFromUse(memberSel);
        }
        if (elem == null || !elem.getKind().isField()) {
            return;
        }
        AnnotatedTypeMirror receiver = ((AnnotatedTypeFactory)this.atypeFactory).getReceiverType(tree);
        this.checkPreconditions(tree, elem, false);
        if (!this.isAccessAllowed(elem, receiver, tree)) {
            this.checker.report(Result.failure("unallowed.access", elem, receiver), node);
        }
    }

    protected boolean isAccessAllowed(Element field, AnnotatedTypeMirror receiver, ExpressionTree accessTree) {
        AnnotationMirror unused = ((AnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(field, Unused.class);
        if (unused == null) {
            return true;
        }
        Name when = AnnotationUtils.getElementValueClassName(unused, "when", false);
        if (receiver.getAnnotation(when) == null) {
            return true;
        }
        Tree tree = this.enclosingStatement(accessTree);
        return tree != null && tree.getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)tree).getVariable() == accessTree && ((AssignmentTree)tree).getExpression().getKind() == Tree.Kind.NULL_LITERAL;
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return ((AnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(useType.getErased(), declarationType.getErased());
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Tree tree) {
        return true;
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedArrayType type, Tree tree) {
        return true;
    }

    public boolean validateTypeOf(Tree tree) {
        AnnotatedTypeMirror type;
        switch (tree.getKind()) {
            case PRIMITIVE_TYPE: 
            case PARAMETERIZED_TYPE: 
            case TYPE_PARAMETER: 
            case ARRAY_TYPE: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case ANNOTATED_TYPE: {
                type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedTypeFromTypeTree(tree);
                break;
            }
            case METHOD: {
                type = ((AnnotatedTypeFactory)this.atypeFactory).getMethodReturnType((MethodTree)tree);
                if (type != null && type.getKind() != TypeKind.VOID) break;
                return true;
            }
            default: {
                type = ((AnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree);
            }
        }
        if (!AnnotatedTypes.isValidType(((AnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy(), type)) {
            this.checker.report(Result.failure("type.invalid", type.getAnnotations(), type.toString()), tree);
            return false;
        }
        return this.typeValidator.isValid(type, tree);
    }

    protected BaseTypeValidator createTypeValidator() {
        return new BaseTypeValidator(this.checker, this, (AnnotatedTypeFactory)this.atypeFactory);
    }

    protected final boolean shouldSkipUses(ExpressionTree exprTree) {
        Element elm = InternalUtils.symbol(exprTree);
        return this.checker.shouldSkipUses(elm);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        Void r = (Void)this.scan(node.getPackageAnnotations(), p);
        r = this.reduce(this.scan(node.getTypeDecls(), p), r);
        return r;
    }

    protected void checkForAnnotatedJdk() {
        if (checkedJDK) {
            return;
        }
        checkedJDK = true;
        if (this.checker.hasOption("nocheckjdk")) {
            return;
        }
        TypeElement objectTE = this.elements.getTypeElement("java.lang.Object");
        List<? extends Element> members = this.elements.getAllMembers(objectTE);
        for (Element element : members) {
            if (!element.toString().equals("equals(java.lang.Object)")) continue;
            ExecutableElement m3 = (ExecutableElement)element;
            boolean foundNN = false;
            for (Attribute.TypeCompound tc : ((Symbol)((Object)m3)).getRawTypeAttributes()) {
                if (tc.position.type != TargetType.METHOD_FORMAL_PARAMETER || tc.position.parameter_index != 0 || !tc.type.toString().equals("org.checkerframework.checker.nullness.qual.Nullable")) continue;
                foundNN = true;
            }
            if (foundNN) continue;
            String jdkJarName = PluginUtil.getJdkJarName();
            this.checker.message(Diagnostic.Kind.WARNING, "You do not seem to be using the distributed annotated JDK.  To fix the" + System.getProperty("line.separator") + "problem, supply this argument (first, fill in the \"...\") when you run javac:" + System.getProperty("line.separator") + "  -Xbootclasspath/p:.../checker/dist/" + jdkJarName, new Object[0]);
        }
    }
}

