/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.qual.ImplicitFor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public class TreeAnnotator
extends SimpleTreeVisitor<Void, AnnotatedTypeMirror> {
    private final Map<Tree.Kind, Set<AnnotationMirror>> treeKinds = new EnumMap<Tree.Kind, Set<AnnotationMirror>>(Tree.Kind.class);
    private final Map<Class<?>, Set<AnnotationMirror>> treeClasses = new HashMap();
    private final Map<Pattern, Set<AnnotationMirror>> stringPatterns = new IdentityHashMap<Pattern, Set<AnnotationMirror>>();
    private final QualifierHierarchy qualHierarchy;
    protected final AnnotatedTypeFactory atypeFactory;

    public TreeAnnotator(AnnotatedTypeFactory atypeFactory) {
        this.qualHierarchy = atypeFactory.getQualifierHierarchy();
        this.atypeFactory = atypeFactory;
        Set<Class<? extends Annotation>> quals = atypeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            ImplicitFor implicit = qual.getAnnotation(ImplicitFor.class);
            if (implicit == null) continue;
            AnnotationMirror theQual = AnnotationUtils.fromClass(atypeFactory.elements, qual);
            for (Class<? extends Tree> clazz : implicit.treeClasses()) {
                this.addTreeClass(clazz, theQual);
            }
            for (Tree.Kind kind : implicit.trees()) {
                this.addTreeKind(kind, theQual);
            }
            for (String string : implicit.stringPatterns()) {
                this.addStringPattern(string, theQual);
            }
        }
    }

    public void addTreeClass(Class<? extends Tree> treeClass, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.treeClasses, treeClass, theQual);
        if (!res) {
            ErrorReporter.errorAbort("TreeAnnotator: invalid update of map " + this.treeClasses + " at " + treeClass + " with " + theQual);
        }
    }

    public void addTreeKind(Tree.Kind treeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.treeKinds, treeKind, theQual);
        if (!res) {
            ErrorReporter.errorAbort("TreeAnnotator: invalid update of treeKinds " + this.treeKinds + " at " + (Object)((Object)treeKind) + " with " + theQual);
        }
    }

    public void addStringPattern(String pattern, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.stringPatterns, Pattern.compile(pattern), theQual);
        if (!res) {
            ErrorReporter.errorAbort("TreeAnnotator: invalid update of stringPatterns " + this.stringPatterns + " at " + pattern + " with " + theQual);
        }
    }

    @Override
    public Void defaultAction(Tree tree, AnnotatedTypeMirror type) {
        if (tree == null || type == null) {
            return null;
        }
        if (this.treeKinds.containsKey((Object)tree.getKind())) {
            Set<AnnotationMirror> fnd = this.treeKinds.get((Object)tree.getKind());
            type.addMissingAnnotations(fnd);
        } else if (!this.treeClasses.isEmpty()) {
            Class<?> t = tree.getClass();
            if (this.treeClasses.containsKey(t)) {
                Set<AnnotationMirror> fnd = this.treeClasses.get(t);
                type.addMissingAnnotations(fnd);
            }
            for (Class<?> c : t.getInterfaces()) {
                if (!this.treeClasses.containsKey(c)) continue;
                Set<AnnotationMirror> fnd = this.treeClasses.get(c);
                type.addMissingAnnotations(fnd);
                this.treeClasses.put(t, this.treeClasses.get(c));
            }
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
        if (!this.stringPatterns.isEmpty() && tree.getKind() == Tree.Kind.STRING_LITERAL) {
            Set<AnnotationMirror> res = null;
            String string = (String)tree.getValue();
            for (Pattern pattern : this.stringPatterns.keySet()) {
                if (!pattern.matcher(string).matches()) continue;
                if (res == null) {
                    res = this.stringPatterns.get(pattern);
                    continue;
                }
                Set<AnnotationMirror> newres = this.stringPatterns.get(pattern);
                res = this.qualHierarchy.greatestLowerBounds(res, newres);
            }
            if (res != null) {
                type.addAnnotations(res);
            }
        }
        return (Void)super.visitLiteral(tree, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
        void var6_11;
        assert (type.getKind() == TypeKind.ARRAY) : "TreeAnnotator.visitNewArray: should be an array type";
        AnnotatedTypeMirror componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
        Set<AnnotationMirror> prev = null;
        if (tree.getInitializers() != null && tree.getInitializers().size() != 0) {
            for (ExpressionTree expressionTree : tree.getInitializers()) {
                AnnotatedTypeMirror iniType = this.atypeFactory.getAnnotatedType(expressionTree);
                Set<AnnotationMirror> annos = iniType.getAnnotations();
                prev = prev == null ? annos : this.qualHierarchy.leastUpperBounds(prev, annos);
            }
        } else {
            prev = componentType.getAnnotations();
        }
        assert (prev != null) : "TreeAnnotator.visitNewArray: violated assumption about qualifiers";
        Pair<Tree, AnnotatedTypeMirror> context = this.atypeFactory.getVisitorState().getAssignmentContext();
        if (context != null && context.second != null && context.second instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            AnnotatedTypeMirror contextComponentType = ((AnnotatedTypeMirror.AnnotatedArrayType)((AnnotatedTypeMirror)context.second)).getComponentType();
            boolean prevIsSubtype = true;
            for (AnnotationMirror am : prev) {
                if (!contextComponentType.isAnnotatedInHierarchy(am) || this.qualHierarchy.isSubtype(am, contextComponentType.getAnnotationInHierarchy(am))) continue;
                prevIsSubtype = false;
            }
            if (contextComponentType.getKind() == componentType.getKind() && (prev.isEmpty() || !contextComponentType.getAnnotations().isEmpty() && prevIsSubtype)) {
                Set<AnnotationMirror> set = contextComponentType.getAnnotations();
            } else {
                Set<AnnotationMirror> set = prev;
            }
        } else {
            Set<AnnotationMirror> set = prev;
        }
        componentType.addMissingAnnotations((Iterable<? extends AnnotationMirror>)var6_11);
        return (Void)super.visitNewArray(tree, type);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rhs = this.atypeFactory.getAnnotatedType(node.getExpression());
        AnnotatedTypeMirror lhs = this.atypeFactory.getAnnotatedType(node.getVariable());
        Set<? extends AnnotationMirror> lubs = this.qualHierarchy.leastUpperBounds(rhs.getAnnotations(), lhs.getAnnotations());
        type.addMissingAnnotations(lubs);
        return (Void)super.visitCompoundAssignment(node, type);
    }

    @Override
    public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror a = this.atypeFactory.getAnnotatedType(node.getLeftOperand());
        AnnotatedTypeMirror b = this.atypeFactory.getAnnotatedType(node.getRightOperand());
        Set<? extends AnnotationMirror> lubs = this.qualHierarchy.leastUpperBounds(a.getEffectiveAnnotations(), b.getEffectiveAnnotations());
        type.addMissingAnnotations(lubs);
        return (Void)super.visitBinary(node, type);
    }

    @Override
    public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror exp = this.atypeFactory.getAnnotatedType(node.getExpression());
        type.addMissingAnnotations(exp.getAnnotations());
        return (Void)super.visitUnary(node, type);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror exprType = this.atypeFactory.getAnnotatedType(node.getExpression());
        if (type.getKind() == TypeKind.TYPEVAR) {
            if (exprType.getKind() == TypeKind.TYPEVAR) {
                type.addMissingAnnotations(exprType.getAnnotations());
            }
        } else {
            type.addMissingAnnotations(exprType.getEffectiveAnnotations());
        }
        return (Void)super.visitTypeCast(node, type);
    }
}

