/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.oigj;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.checker.oigj.OIGJMutabilityBottom;
import org.checkerframework.checker.oigj.qual.AssignsFields;
import org.checkerframework.checker.oigj.qual.I;
import org.checkerframework.checker.oigj.qual.Immutable;
import org.checkerframework.checker.oigj.qual.Mutable;
import org.checkerframework.checker.oigj.qual.ReadOnly;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.type.TypeAnnotator;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.type.visitor.SimpleAnnotatedTypeVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ImmutabilityAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror READONLY;
    protected final AnnotationMirror MUTABLE;
    protected final AnnotationMirror IMMUTABLE;
    protected final AnnotationMirror I;
    protected final AnnotationMirror BOTTOM_QUAL;
    protected final AnnotationMirror ASSIGNS_FIELDS;
    protected static final String IMMUTABILITY_KEY = "value";

    public ImmutabilityAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.READONLY = AnnotationUtils.fromClass(this.elements, ReadOnly.class);
        this.MUTABLE = AnnotationUtils.fromClass(this.elements, Mutable.class);
        this.IMMUTABLE = AnnotationUtils.fromClass(this.elements, Immutable.class);
        this.I = AnnotationUtils.fromClass(this.elements, I.class);
        this.ASSIGNS_FIELDS = AnnotationUtils.fromClass(this.elements, AssignsFields.class);
        this.BOTTOM_QUAL = AnnotationUtils.fromClass(this.elements, OIGJMutabilityBottom.class);
        this.postInit();
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new IGJTreePreAnnotator(this);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new IGJTypePostAnnotator(this);
    }

    @Override
    public void postProcessClassTree(ClassTree tree) {
    }

    @Override
    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(ExpressionTree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType receiver = super.getImplicitReceiverType(tree);
        if (receiver != null && !this.isMostEnclosingThisDeref(tree)) {
            receiver.replaceAnnotation(this.READONLY);
        }
        return receiver;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType act = this.getCurrentClassType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.isWithinConstructor(tree) ? (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType(this.visitorState.getMethodTree()).getReturnType() : this.getCurrentMethodReceiver(tree);
        if (methodReceiver == null) {
            return act;
        }
        if (this.isWithinConstructor(tree) && !methodReceiver.hasEffectiveAnnotation(this.MUTABLE)) {
            methodReceiver.replaceAnnotation(this.ASSIGNS_FIELDS);
        }
        if (methodReceiver.hasEffectiveAnnotation(this.MUTABLE) || methodReceiver.hasEffectiveAnnotation(this.IMMUTABLE)) {
            return methodReceiver;
        }
        if (act.hasAnnotationRelaxed(this.I) || act.hasEffectiveAnnotation(this.IMMUTABLE)) {
            if (methodReceiver.hasEffectiveAnnotation(this.ASSIGNS_FIELDS)) {
                act.replaceAnnotation(this.ASSIGNS_FIELDS);
            }
            return act;
        }
        return methodReceiver;
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        Map templateMapping = (Map)new ImmutabilityTemplateCollector().visit(type);
        new ImmutabilityResolver().visit(supertypes, templateMapping);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            this.typeAnnotator.visit(annotatedTypeMirror, null);
        }
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror elementType, AnnotatedTypeMirror owner, Element element) {
        this.resolveImmutabilityTypeVar(elementType, owner);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType type = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        if (TreeUtils.isEnumSuper(tree)) {
            return mfuPair;
        }
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this, type, tree.getArguments());
        List<AnnotatedTypeMirror> arguments = AnnotatedTypes.getAnnotatedTypes(this, requiredArgs, tree.getArguments());
        Map<String, AnnotationMirror> matchingMapping = collector.visit(arguments, requiredArgs);
        if (!matchingMapping.isEmpty()) {
            new ImmutabilityResolver().visit(type, matchingMapping);
        }
        Map fromReceiver = (Map)collector.visit(this.getReceiverType(tree));
        final Map<String, AnnotationMirror> mapping = collector.reduce(matchingMapping, fromReceiver);
        new AnnotatedTypeScanner<Void, Void>(){

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
                AnnotationMirror anno;
                if (type.hasAnnotationRelaxed(ImmutabilityAnnotatedTypeFactory.this.I) && !mapping.containsValue(anno = type.getAnnotation(I.class))) {
                    type.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                }
                return (Void)super.visitDeclared(type, p);
            }
        }.visit(type);
        return mfuPair;
    }

    private boolean resolveImmutabilityTypeVar(AnnotatedTypeMirror type, AnnotatedTypeMirror ... provided) {
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        Map<String, AnnotationMirror> templateMapping = Collections.emptyMap();
        for (AnnotatedTypeMirror pt : provided) {
            templateMapping = collector.reduce(templateMapping, (Map)collector.visit(pt));
        }
        if (templateMapping.isEmpty()) {
            return false;
        }
        new ImmutabilityResolver().visit(type, templateMapping);
        return true;
    }

    private AnnotationMirror getImmutabilityAnnotation(AnnotatedTypeMirror type) {
        if (type.hasAnnotationRelaxed(this.I)) {
            return type.getAnnotation(I.class);
        }
        if (this.hasImmutabilityAnnotation(type)) {
            return type.getAnnotationInHierarchy(this.READONLY);
        }
        return null;
    }

    private boolean hasImmutabilityAnnotation(AnnotatedTypeMirror type) {
        return type.isAnnotatedInHierarchy(this.READONLY);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ImmutabilityQualifierHierarchy(factory);
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new OIGJImmutabilityTypeHierarchy(this.checker, this.getQualifierHierarchy());
    }

    static {
        FLOW_BY_DEFAULT = true;
    }

    private final class ImmutabilityQualifierHierarchy
    extends GraphQualifierHierarchy {
        public ImmutabilityQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
        }

        @Override
        public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
            if (lhs.isEmpty() || rhs.isEmpty()) {
                ErrorReporter.errorAbort("GraphQualifierHierarchy: Empty annotations in lhs: " + lhs + " or rhs: " + rhs);
            }
            for (AnnotationMirror annotationMirror : lhs) {
                for (AnnotationMirror annotationMirror2 : rhs) {
                    if (!this.isSubtype(annotationMirror2, annotationMirror)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private final class OIGJImmutabilityTypeHierarchy
    extends TypeHierarchy {
        public OIGJImmutabilityTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy) {
            super(checker, qualifierHierarchy);
        }

        @Override
        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (this.ignoreRawTypeArguments(rhs, lhs)) {
                return true;
            }
            if (lhs.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE)) {
                return super.isSubtypeTypeArguments(rhs, lhs);
            }
            if (!lhs.getTypeArguments().isEmpty() && !rhs.getTypeArguments().isEmpty()) {
                assert (lhs.getTypeArguments().size() == rhs.getTypeArguments().size());
                for (int i = 0; i < lhs.getTypeArguments().size(); ++i) {
                    if (this.isSubtype(rhs.getTypeArguments().get(i), lhs.getTypeArguments().get(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private class ImmutabilityTemplateCollector
    extends SimpleAnnotatedTypeVisitor<Map<String, AnnotationMirror>, AnnotatedTypeMirror> {
        private final Set<TypeVariable> typeVar = new HashSet<TypeVariable>();

        private ImmutabilityTemplateCollector() {
        }

        public Map<String, AnnotationMirror> reduce(Map<String, AnnotationMirror> r1, Map<String, AnnotationMirror> r2) {
            HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (r1 != null) {
                result.putAll(r1);
            }
            if (r2 != null) {
                for (String key : r2.keySet()) {
                    if (!result.containsKey(key)) {
                        result.put(key, r2.get(key));
                        continue;
                    }
                    if (AnnotationUtils.areSame((AnnotationMirror)result.get(key), r2.get(key))) continue;
                    result.put(key, ImmutabilityAnnotatedTypeFactory.this.READONLY);
                }
            }
            return result;
        }

        public Map<String, AnnotationMirror> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result = this.reduce(result, (Map)this.visit(type, actualType));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                TypeElement elem = (TypeElement)type.getUnderlyingType().asElement();
                actualType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(elem);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (actualType.getKind() != type.getKind()) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type.getKind());
            type = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type, actualType);
            if (type == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (dcType.hasAnnotationRelaxed(ImmutabilityAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(dcType), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true);
                AnnotationMirror immutability = ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type);
                if (immutability != null && !immutability.equals(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result.put(immutableString, immutability);
                }
            }
            if (type != dcType && !type.wasRaw() && !dcType.wasRaw()) {
                result = this.reduce(result, this.visit(type.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return (Map)this.visit(type.getComponentType(), null);
            }
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (type.getKind() != actualType.getKind()) {
                return (Map)this.visit(type, null);
            }
            assert (type.getKind() == actualType.getKind());
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (arType.hasAnnotationRelaxed(ImmutabilityAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(arType), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true);
                AnnotationMirror immutability = ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type);
                assert (immutability != null);
                if (!type.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result.put(immutableString, immutability);
                }
            }
            result = this.reduce(result, (Map)this.visit(type.getComponentType(), arType.getComponentType()));
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror typeSuper;
            if (actualType == null) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound() != null) {
                actualType = ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound();
            }
            if ((typeSuper = this.findType(type, actualType)).getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            assert (type.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
            this.typeVar.add(type.getUnderlyingType());
            Map result = (Map)this.visit(type.getUpperBound(), tvType.getUpperBound());
            this.typeVar.remove(type.getUnderlyingType());
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = this.findType(type, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            if (typeSuper.getKind() != actualType.getKind()) {
                return Collections.emptyMap();
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (type.getExtendsBound() != null && wcType.getExtendsBound() != null) {
                return (Map)this.visit(type.getExtendsBound(), wcType.getExtendsBound());
            }
            if (type.getSuperBound() != null && wcType.getSuperBound() != null) {
                return (Map)this.visit(type.getSuperBound(), wcType.getSuperBound());
            }
            return new HashMap<String, AnnotationMirror>();
        }

        private AnnotatedTypeMirror findType(AnnotatedTypeMirror type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror result = AnnotatedTypes.asSuper(ImmutabilityAnnotatedTypeFactory.this.types, ImmutabilityAnnotatedTypeFactory.this, type, actualType);
            return result != null ? result : type;
        }
    }

    private class ImmutabilityResolver
    extends AnnotatedTypeScanner<Void, Map<String, AnnotationMirror>> {
        private ImmutabilityResolver() {
        }

        public void visit(Iterable<? extends AnnotatedTypeMirror> types, Map<String, AnnotationMirror> templateMapping) {
            if (templateMapping != null && !templateMapping.isEmpty()) {
                for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                    this.visit(annotatedTypeMirror, templateMapping);
                }
            }
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Map<String, AnnotationMirror> p) {
            String immutableString;
            if (type.hasAnnotationRelaxed(ImmutabilityAnnotatedTypeFactory.this.I) && p.containsKey(immutableString = AnnotationUtils.getElementValue(ImmutabilityAnnotatedTypeFactory.this.getImmutabilityAnnotation(type), ImmutabilityAnnotatedTypeFactory.IMMUTABILITY_KEY, String.class, true))) {
                type.replaceAnnotation(p.get(immutableString));
            }
            return (Void)super.visitDeclared(type, p);
        }
    }

    private class IGJTreePreAnnotator
    extends TreeAnnotator {
        public IGJTreePreAnnotator(ImmutabilityAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror ct = ImmutabilityAnnotatedTypeFactory.this.fromElement(((AnnotatedTypeMirror.AnnotatedDeclaredType)p).getUnderlyingType().asElement());
                if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(ct) || ct.hasAnnotationRelaxed(ImmutabilityAnnotatedTypeFactory.this.I)) {
                    AnnotatedTypeMirror.AnnotatedExecutableType con = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(TreeUtils.elementFromUse(node));
                    if (con.getReceiverType() != null && con.getReceiverType().hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                        p.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE);
                    } else {
                        p.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                    }
                } else {
                    p.addAnnotations(ct.getAnnotations());
                }
            }
            return null;
        }

        @Override
        public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror p) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror castedType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                p.addAnnotations(castedType.getAnnotations());
            }
            return null;
        }
    }

    private class IGJTypePostAnnotator
    extends TypeAnnotator {
        public IGJTypePostAnnotator(ImmutabilityAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
            if (!ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                TypeElement element = (TypeElement)type.getUnderlyingType().asElement();
                AnnotatedTypeMirror.AnnotatedDeclaredType elementType = ImmutabilityAnnotatedTypeFactory.this.fromElement(element);
                if (TypesUtils.isBoxedPrimitive(type.getUnderlyingType()) || element.getQualifiedName().contentEquals("java.lang.String") || ElementUtils.isObject(element)) {
                    type.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else if (elementType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                    type.addAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE);
                }
            }
            return (Void)super.visitDeclared(type, p);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void p) {
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = type.getElement().getKind() == ElementKind.CONSTRUCTOR ? (AnnotatedTypeMirror.AnnotatedDeclaredType)type.getReturnType() : type.getReceiverType();
            if (receiver != null && ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(receiver)) {
                return super.visitExecutable(type, p);
            }
            TypeElement ownerElement = ElementUtils.enclosingClass(type.getElement());
            AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = ImmutabilityAnnotatedTypeFactory.this.getAnnotatedType(ownerElement);
            if (type.getElement().getKind() == ElementKind.CONSTRUCTOR) {
                if (ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE) || ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL)) {
                    receiver.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                } else {
                    receiver.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.ASSIGNS_FIELDS);
                }
            } else if (receiver != null) {
                if (ElementUtils.isObject(ownerElement) || ownerType.hasEffectiveAnnotation(ImmutabilityAnnotatedTypeFactory.this.IMMUTABLE)) {
                    receiver.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else {
                    receiver.replaceAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return super.visitExecutable(type, p);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void p) {
            if (type.getUpperBoundField() != null && !ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getUpperBound()) && TypesUtils.isObject(type.getUnderlyingType())) {
                type.getUpperBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitTypeVariable(type, p);
        }

        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Void p) {
            if (type.getExtendsBound() != null && !ImmutabilityAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getExtendsBound()) && TypesUtils.isObject(type.getUnderlyingType())) {
                type.getExtendsBound().addAnnotation(ImmutabilityAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitWildcard(type, p);
        }
    }
}

