/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.lock.LockAnalysis;
import org.checkerframework.checker.lock.LockChecker;
import org.checkerframework.checker.lock.LockStore;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LockTransfer
extends CFAbstractTransfer<CFValue, LockStore, LockTransfer> {
    protected LockAnalysis analysis;
    protected LockChecker checker;
    protected final AnnotationMirror LOCKHELD;
    protected final AnnotationMirror LOCKPOSSIBLYHELD;

    public LockTransfer(LockAnalysis analysis, LockChecker checker) {
        super(analysis);
        this.analysis = analysis;
        this.checker = checker;
        this.LOCKHELD = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), LockHeld.class);
        this.LOCKPOSSIBLYHELD = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), LockPossiblyHeld.class);
    }

    protected void makeLockHeld(LockStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node);
        store.insertValue(internalRepr, this.LOCKHELD);
    }

    protected void makeLockPossiblyHeld(LockStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node);
        store.insertExactValue(internalRepr, this.LOCKPOSSIBLYHELD);
    }

    protected void makeLockHeld(TransferResult<CFValue, LockStore> result, Node node) {
        if (result.containsTwoStores()) {
            this.makeLockHeld(result.getThenStore(), node);
            this.makeLockHeld(result.getElseStore(), node);
        } else {
            this.makeLockHeld(result.getRegularStore(), node);
        }
    }

    protected void makeLockPossiblyHeld(TransferResult<CFValue, LockStore> result, Node node) {
        if (result.containsTwoStores()) {
            this.makeLockPossiblyHeld(result.getThenStore(), node);
            this.makeLockPossiblyHeld(result.getElseStore(), node);
        } else {
            this.makeLockPossiblyHeld(result.getRegularStore(), node);
        }
    }

    @Override
    public LockStore initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        UnderlyingAST.CFGMethod method;
        MethodTree methodTree;
        ExecutableElement methodElement;
        LockStore store = (LockStore)super.initialStore(underlyingAST, (List)parameters);
        if (underlyingAST.getKind() == UnderlyingAST.Kind.METHOD && ((methodElement = TreeUtils.elementFromDeclaration(methodTree = (method = (UnderlyingAST.CFGMethod)underlyingAST).getMethod())).getModifiers().contains((Object)Modifier.SYNCHRONIZED) || methodElement.getKind() == ElementKind.CONSTRUCTOR)) {
            ClassTree classTree = method.getClassTree();
            TypeMirror classType = InternalUtils.typeOf(classTree);
            store.insertThisValue(this.LOCKHELD, classType);
        }
        return store;
    }

    @Override
    public TransferResult<CFValue, LockStore> visitSynchronized(SynchronizedNode n, TransferInput<CFValue, LockStore> p) {
        TransferResult result = (TransferResult)super.visitSynchronized(n, p);
        if (n.getIsStartOfBlock()) {
            this.makeLockHeld(result, n.getExpression());
        } else {
            this.makeLockPossiblyHeld(result, n.getExpression());
        }
        return result;
    }
}

