/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.stubparser.ast.type;

import java.util.List;
import org.checkerframework.stubparser.ast.expr.AnnotationExpr;
import org.checkerframework.stubparser.ast.type.Type;
import org.checkerframework.stubparser.ast.visitor.GenericVisitor;
import org.checkerframework.stubparser.ast.visitor.VoidVisitor;

public final class ReferenceType
extends Type {
    private Type type;
    private int arrayCount;
    private List<List<AnnotationExpr>> arrayAnnotations;

    public ReferenceType() {
    }

    public ReferenceType(Type type) {
        this.type = type;
    }

    public ReferenceType(Type type, int n) {
        this.type = type;
        this.arrayCount = n;
    }

    public ReferenceType(int n, int n2, int n3, int n4, Type type, int n5, List<List<AnnotationExpr>> list) {
        super(n, n2, n3, n4);
        this.type = type;
        this.arrayCount = n5;
        this.arrayAnnotations = list;
        assert (n5 == list.size());
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> genericVisitor, A a) {
        return genericVisitor.visit(this, a);
    }

    @Override
    public <A> void accept(VoidVisitor<A> voidVisitor, A a) {
        voidVisitor.visit(this, a);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<List<AnnotationExpr>> getArrayAnnotations() {
        return this.arrayAnnotations;
    }

    public List<AnnotationExpr> getAnnotationsAtLevel(int n) {
        if (n == -1) {
            return this.type.getAnnotations();
        }
        return this.arrayAnnotations.get(n);
    }

    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int n) {
        this.arrayCount = n;
    }

    public void setArrayAnnotations(List<List<AnnotationExpr>> list) {
        this.arrayAnnotations = list;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

