/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.base;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.IdentityHashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.qualframework.base.AdapterQualifiedTypes;
import org.checkerframework.qualframework.base.AnnotationConverter;
import org.checkerframework.qualframework.base.DefaultTypeHierarchy;
import org.checkerframework.qualframework.base.QualifiedTypeFactory;
import org.checkerframework.qualframework.base.QualifiedTypeFactoryAdapter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.QualifiedTypeParameterBounds;
import org.checkerframework.qualframework.base.QualifiedTypes;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.TreeAnnotator;
import org.checkerframework.qualframework.base.TypeAnnotator;
import org.checkerframework.qualframework.base.TypeHierarchy;
import org.checkerframework.qualframework.base.dataflow.QualAnalysis;
import org.checkerframework.qualframework.base.dataflow.QualValue;
import org.checkerframework.qualframework.util.ExtendedParameterDeclaration;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;
import org.checkerframework.qualframework.util.WrappedAnnotatedTypeMirror;

public abstract class DefaultQualifiedTypeFactory<Q>
implements QualifiedTypeFactory<Q> {
    private IdentityHashMap<ExtendedParameterDeclaration, QualifiedTypeParameterBounds<Q>> paramBoundsMap = new IdentityHashMap();
    private QualifiedTypes<Q> qualifiedTypes;
    private QualifierHierarchy<Q> qualifierHierarchy;
    private TypeHierarchy<Q> typeHierarchy;
    private AnnotationConverter<Q> annotationConverter;
    private TreeAnnotator<Q> treeAnnotator;
    private TypeAnnotator<Q> typeAnnotator;
    private QualifiedTypeFactoryAdapter<Q> adapter;
    private QualifierContext<Q> context;

    public DefaultQualifiedTypeFactory(QualifierContext<Q> context) {
        this.context = context;
    }

    @Override
    public final QualifiedTypeMirror<Q> getQualifiedType(Element element) {
        return this.adapter.superGetAnnotatedType(element);
    }

    @Override
    public final QualifiedTypeMirror<Q> getQualifiedType(Tree tree) {
        return this.adapter.superGetAnnotatedType(tree);
    }

    @Override
    public final QualifiedTypeMirror<Q> getQualifiedTypeFromTypeTree(Tree typeTree) {
        return this.adapter.superGetAnnotatedTypeFromTypeTree(typeTree);
    }

    @Override
    public final QualifiedTypeParameterBounds<Q> getQualifiedTypeParameterBounds(ExtendedParameterDeclaration etm) {
        if (!this.paramBoundsMap.containsKey(etm)) {
            QualifiedTypeParameterBounds<Q> bounds = this.computeQualifiedTypeParameterBounds(etm);
            this.paramBoundsMap.put(etm, bounds);
        }
        return this.paramBoundsMap.get(etm);
    }

    protected QualifiedTypeParameterBounds<Q> computeQualifiedTypeParameterBounds(ExtendedParameterDeclaration etm) {
        TypeAnnotator<Q> annotator = this.getTypeAnnotator();
        WrappedAnnotatedTypeMirror.WrappedAnnotatedTypeVariable watv = (WrappedAnnotatedTypeMirror.WrappedAnnotatedTypeVariable)etm;
        WrappedAnnotatedTypeMirror rawUpper = WrappedAnnotatedTypeMirror.wrap(watv.unwrap().getUpperBound());
        WrappedAnnotatedTypeMirror rawLower = WrappedAnnotatedTypeMirror.wrap(watv.unwrap().getLowerBound());
        QualifiedTypeMirror<Q> upper = annotator.visit(rawUpper, null);
        QualifiedTypeMirror<Q> lower = annotator.visit(rawLower, null);
        return new QualifiedTypeParameterBounds<Q>(upper, lower);
    }

    TreeAnnotator<Q> getTreeAnnotator() {
        if (this.treeAnnotator == null) {
            this.treeAnnotator = this.createTreeAnnotator();
        }
        return this.treeAnnotator;
    }

    protected TreeAnnotator<Q> createTreeAnnotator() {
        return new TreeAnnotator();
    }

    TypeAnnotator<Q> getTypeAnnotator() {
        if (this.typeAnnotator == null) {
            this.typeAnnotator = this.createTypeAnnotator();
        }
        return this.typeAnnotator;
    }

    protected TypeAnnotator<Q> createTypeAnnotator() {
        return new TypeAnnotator<Q>(this.context, this.getAnnotationConverter(), this.getQualifierHierarchy().getTop());
    }

    @Override
    public final QualifiedTypes<Q> getQualifiedTypes() {
        if (this.qualifiedTypes == null) {
            this.qualifiedTypes = this.createQualifiedTypes();
        }
        return this.qualifiedTypes;
    }

    protected QualifiedTypes<Q> createQualifiedTypes() {
        return new AdapterQualifiedTypes<Q>(this.adapter);
    }

    @Override
    public QualifierHierarchy<Q> getQualifierHierarchy() {
        if (this.qualifierHierarchy == null) {
            this.qualifierHierarchy = this.createQualifierHierarchy();
        }
        return this.qualifierHierarchy;
    }

    protected abstract QualifierHierarchy<Q> createQualifierHierarchy();

    @Override
    public TypeHierarchy<Q> getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = this.createTypeHierarchy(this.getQualifierHierarchy());
        }
        return this.typeHierarchy;
    }

    protected TypeHierarchy<Q> createTypeHierarchy(QualifierHierarchy<Q> qualifierHierarchy) {
        return new DefaultTypeHierarchy<Q>(qualifierHierarchy);
    }

    public AnnotationConverter<Q> getAnnotationConverter() {
        if (this.annotationConverter == null) {
            this.annotationConverter = this.createAnnotationConverter();
        }
        return this.annotationConverter;
    }

    protected abstract AnnotationConverter<Q> createAnnotationConverter();

    @Override
    public List<QualifiedTypeMirror<Q>> postDirectSuperTypes(QualifiedTypeMirror<Q> subtype, List<? extends QualifiedTypeMirror<Q>> supertypes) {
        return this.adapter.superPostDirectSuperTypes(subtype, supertypes);
    }

    @Override
    public QualifiedTypeMirror<Q> postAsMemberOf(QualifiedTypeMirror<Q> memberType, QualifiedTypeMirror<Q> receiverType, Element memberElement) {
        return this.adapter.superPostAsMemberOf(memberType, receiverType, memberElement);
    }

    @Override
    public Pair<QualifiedTypeMirror.QualifiedExecutableType<Q>, List<QualifiedTypeMirror<Q>>> methodFromUse(MethodInvocationTree tree) {
        return this.adapter.superMethodFromUse(tree);
    }

    @Override
    public Pair<QualifiedTypeMirror.QualifiedExecutableType<Q>, List<QualifiedTypeMirror<Q>>> methodFromUse(ExpressionTree tree, ExecutableElement methodElt, QualifiedTypeMirror<Q> receiverType) {
        return this.adapter.superMethodFromUse(tree, methodElt, receiverType);
    }

    @Override
    public Pair<QualifiedTypeMirror.QualifiedExecutableType<Q>, List<QualifiedTypeMirror<Q>>> constructorFromUse(NewClassTree tree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QualifiedTypeMirror<Q> postTypeVarSubstitution(QualifiedTypeMirror.QualifiedParameterDeclaration<Q> varDecl, QualifiedTypeMirror.QualifiedTypeVariable<Q> varUse, QualifiedTypeMirror<Q> value) {
        return this.adapter.superPostTypeVarSubstitution(varDecl, varUse, value);
    }

    @Override
    public QualAnalysis<Q> createFlowAnalysis(List<Pair<VariableElement, QualValue<Q>>> fieldValues) {
        return new QualAnalysis<Q>(this.getContext());
    }

    public QualifierContext<Q> getContext() {
        return this.context;
    }

    void setAdapter(QualifiedTypeFactoryAdapter<Q> adapter) {
        this.adapter = adapter;
    }

    @Override
    public TreePath getPath(Tree node) {
        return this.adapter.getPath(node);
    }

    @Override
    public QualifiedTypeMirror<Q> getReceiverType(ExpressionTree expression) {
        return this.adapter.getCheckerAdapter().getTypeMirrorConverter().getQualifiedType(this.adapter.getReceiverType(expression));
    }

    @Override
    public ExtendedTypeMirror getDecoratedElement(Element element) {
        return WrappedAnnotatedTypeMirror.wrap(this.adapter.fromElement(element));
    }
}

