/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class Resolver {
    private final Resolve resolve;
    private final Names names;
    private final Trees trees;
    private final Log log;
    private final Method FIND_METHOD;
    private final Method FIND_VAR;
    private final Method FIND_IDENT_IN_TYPE;
    private final Method FIND_IDENT_IN_PACKAGE;
    private final Method FIND_TYPE;

    public Resolver(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.resolve = Resolve.instance(context);
        this.names = Names.instance(context);
        this.trees = Trees.instance(env);
        this.log = Log.instance(context);
        try {
            this.FIND_METHOD = Resolve.class.getDeclaredMethod("findMethod", Env.class, Type.class, Name.class, List.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            this.FIND_METHOD.setAccessible(true);
            this.FIND_VAR = Resolve.class.getDeclaredMethod("findVar", Env.class, Name.class);
            this.FIND_VAR.setAccessible(true);
            this.FIND_IDENT_IN_TYPE = Resolve.class.getDeclaredMethod("findIdentInType", Env.class, Type.class, Name.class, Integer.TYPE);
            this.FIND_IDENT_IN_TYPE.setAccessible(true);
            this.FIND_IDENT_IN_PACKAGE = Resolve.class.getDeclaredMethod("findIdentInPackage", Env.class, Symbol.TypeSymbol.class, Name.class, Integer.TYPE);
            this.FIND_IDENT_IN_PACKAGE.setAccessible(true);
            this.FIND_TYPE = Resolve.class.getDeclaredMethod("findType", Env.class, Name.class);
            this.FIND_TYPE.setAccessible(true);
        }
        catch (Exception e) {
            AssertionError err = new AssertionError((Object)"Compiler 'Resolve' class doesn't contain required 'find' method");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableElement findField(String name, TypeMirror type, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            JavacScope scope = (JavacScope)this.trees.getScope(path);
            Env<AttrContext> env = scope.getEnv();
            Symbol res = this.wrapInvocation(this.FIND_IDENT_IN_TYPE, env, type, this.names.fromString(name), 4);
            if (res.getKind() == ElementKind.FIELD) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableElement findLocalVariable(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            JavacScope scope = (JavacScope)this.trees.getScope(path);
            Env<AttrContext> env = scope.getEnv();
            Symbol res = this.wrapInvocation(this.FIND_VAR, env, this.names.fromString(name));
            if (res.getKind() == ElementKind.LOCAL_VARIABLE) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element findClass(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            JavacScope scope = (JavacScope)this.trees.getScope(path);
            Env<AttrContext> env = scope.getEnv();
            Symbol symbol = this.wrapInvocation(this.FIND_TYPE, env, this.names.fromString(name));
            return symbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    public Element findMethod(String methodName, TypeMirror receiverType, TreePath path, java.util.List<TypeMirror> argumentTypes) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            JavacScope scope = (JavacScope)this.trees.getScope(path);
            Env<AttrContext> env = scope.getEnv();
            Type site = (Type)receiverType;
            Name name = this.names.fromString(methodName);
            List<Type> argtypes = List.nil();
            for (TypeMirror a : argumentTypes) {
                argtypes = argtypes.append((Type)a);
            }
            List typeargtypes = List.nil();
            boolean allowBoxing = true;
            boolean useVarargs = false;
            boolean operator = true;
            try {
                Object methodContext = this.buildMethodContext();
                Object oldContext = this.getField(this.resolve, "currentResolutionContext");
                this.setField(this.resolve, "currentResolutionContext", methodContext);
                Symbol result = this.wrapInvocation(this.FIND_METHOD, env, site, name, argtypes, typeargtypes, allowBoxing, useVarargs, operator);
                this.setField(this.resolve, "currentResolutionContext", oldContext);
                Symbol symbol = result;
                return symbol;
            }
            catch (Throwable t) {
                AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
                ((Throwable)((Object)err)).initCause(t);
                throw err;
            }
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Object buildMethodContext() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Class<?> methCtxClss = Class.forName("com.sun.tools.javac.comp.Resolve$MethodResolutionContext");
        Constructor<?> constructor = methCtxClss.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object methodContext = constructor.newInstance(this.resolve);
        this.setField(methodContext, "attrMode", (Object)DeferredAttr.AttrMode.CHECK);
        List phases = (List)this.getField(this.resolve, "methodResolutionSteps");
        this.setField(methodContext, "step", phases.get(1));
        return methodContext;
    }

    private void setField(Object receiver, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(receiver, value);
    }

    private Object getField(Object receiver, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(receiver);
    }

    private Symbol wrapInvocation(Method method, Object ... args) {
        try {
            return (Symbol)method.invoke((Object)this.resolve, args);
        }
        catch (IllegalAccessException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        catch (IllegalArgumentException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        catch (InvocationTargetException e) {
            AssertionError err = new AssertionError((Object)"Unexpected Reflection error");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
    }
}

