/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.cfg.CFGDOTVisualizer;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public abstract class CFAbstractAnalysis<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>, T extends CFAbstractTransfer<V, S, T>>
extends Analysis<V, S, T> {
    protected final QualifierHierarchy qualifierHierarchy;
    protected final TypeHierarchy typeHierarchy;
    protected final GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> atypeFactory;
    protected final SourceChecker checker;
    protected final List<Pair<VariableElement, V>> fieldValues;

    public CFAbstractAnalysis(BaseTypeChecker checker, GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> factory, List<Pair<VariableElement, V>> fieldValues) {
        super(checker.getProcessingEnvironment());
        this.qualifierHierarchy = factory.getQualifierHierarchy();
        this.typeHierarchy = factory.getTypeHierarchy();
        this.atypeFactory = factory;
        this.checker = checker;
        this.transferFunction = this.createTransferFunction();
        this.fieldValues = fieldValues;
    }

    public List<Pair<VariableElement, V>> getFieldValues() {
        return this.fieldValues;
    }

    public T createTransferFunction() {
        return this.atypeFactory.createFlowTransferFunction(this);
    }

    public abstract S createEmptyStore(boolean var1);

    public abstract S createCopiedStore(S var1);

    public abstract @Nullable V createAbstractValue(AnnotatedTypeMirror var1);

    public CFValue defaultCreateAbstractValue(CFAbstractAnalysis<CFValue, ?, ?> analysis, AnnotatedTypeMirror type) {
        if (!AnnotatedTypes.isValidType(this.qualifierHierarchy, type)) {
            return null;
        }
        return new CFValue(analysis, type);
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    public GenericAnnotatedTypeFactory<V, S, T, ? extends CFAbstractAnalysis<V, S, T>> getTypeFactory() {
        return this.atypeFactory;
    }

    public void outputToDotFile(String outputFile, boolean verbose) {
        String s2 = CFGDOTVisualizer.visualize(this.cfg, this.cfg.getEntryBlock(), this, verbose);
        try {
            FileWriter fstream = new FileWriter(outputFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(s2);
            out.close();
        }
        catch (IOException e) {
            ErrorReporter.errorAbort("Error creating dot file: " + outputFile + "; ensure the path is valid", e);
        }
    }

    public V createSingleAnnotationValue(AnnotationMirror anno, TypeMirror underlyingType) {
        AnnotatedTypeMirror type = AnnotatedTypeMirror.createType(underlyingType, this.getTypeFactory(), false);
        Set<? extends AnnotationMirror> tops = this.getTypeFactory().getQualifierHierarchy().getTopAnnotations();
        this.makeTop(type, tops);
        type.replaceAnnotation(anno);
        return this.createAbstractValue(type);
    }

    private void makeTop(AnnotatedTypeMirror type, Set<? extends AnnotationMirror> tops) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType a = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            this.makeTop(a.getComponentType(), tops);
        } else if (kind == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable a = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
            this.makeTop(a.getUpperBound(), tops);
        } else if (kind == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType a = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
            this.makeTop(a.getExtendsBound(), tops);
        }
        if (kind != TypeKind.TYPEVAR && kind != TypeKind.WILDCARD) {
            type.addAnnotations(tops);
        }
    }

    public <W extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> W getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        return (W)this.atypeFactory.getTypeFactoryOfSubchecker(checkerClass);
    }
}

