/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.basetype;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class BaseTypeValidator
extends AnnotatedTypeScanner<Void, Tree> {
    protected boolean isValid = true;
    protected final BaseTypeChecker checker;
    protected final BaseTypeVisitor<?> visitor;
    protected final AnnotatedTypeFactory atypeFactory;

    public BaseTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
        this.checker = checker;
        this.visitor = visitor;
        this.atypeFactory = atypeFactory;
    }

    public boolean isValid(AnnotatedTypeMirror type, Tree tree) {
        this.isValid = true;
        this.visit(type, tree);
        return this.isValid;
    }

    protected void reportValidityResult(@CompilerMessageKey String errorType, AnnotatedTypeMirror type, Tree p) {
        this.checker.report(Result.failure(errorType, type.getAnnotations(), type.toString()), p);
        this.isValid = false;
    }

    protected void reportError(AnnotatedTypeMirror type, Tree p) {
        this.reportValidityResult("type.invalid", type, p);
    }

    @Override
    public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType elemType;
        if (this.visitedNodes.containsKey(type)) {
            return (Void)this.visitedNodes.get(type);
        }
        boolean skipChecks = this.checker.shouldSkipUses(type.getUnderlyingType().asElement());
        if (!skipChecks && !this.visitor.isValidUse(elemType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedType(type.getUnderlyingType().asElement()), type, tree)) {
            this.reportError(type, tree);
        }
        Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> p = this.extractParameterizedTypeTree(tree, type);
        ParameterizedTypeTree typeArgTree = (ParameterizedTypeTree)p.first;
        type = (AnnotatedTypeMirror.AnnotatedDeclaredType)p.second;
        if (typeArgTree == null) {
            return (Void)super.visitDeclared(type, tree);
        }
        this.visitedNodes.put(type, null);
        this.visitParameterizedType(type, typeArgTree);
        List<AnnotatedTypeMirror> tatypes = type.getTypeArguments();
        if (tatypes == null) {
            return null;
        }
        int numTypeArgs = typeArgTree.getTypeArguments().size();
        if (numTypeArgs != 0) {
            assert (tatypes.size() <= numTypeArgs || skipChecks) : "size mismatch for type arguments: " + type + " and " + typeArgTree;
            for (int i = 0; i < tatypes.size(); ++i) {
                this.scan(tatypes.get(i), typeArgTree.getTypeArguments().get(i));
            }
        }
        return null;
    }

    private Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> extractParameterizedTypeTree(Tree tree, AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        ParameterizedTypeTree typeargtree = null;
        switch (tree.getKind()) {
            case VARIABLE: {
                Tree lt = ((VariableTree)tree).getType();
                if (!(lt instanceof ParameterizedTypeTree)) break;
                typeargtree = (ParameterizedTypeTree)lt;
                break;
            }
            case PARAMETERIZED_TYPE: {
                typeargtree = (ParameterizedTypeTree)tree;
                break;
            }
            case NEW_CLASS: {
                NewClassTree nct = (NewClassTree)tree;
                ExpressionTree nctid = nct.getIdentifier();
                if (nctid.getKind() != Tree.Kind.PARAMETERIZED_TYPE) break;
                typeargtree = (ParameterizedTypeTree)((Object)nctid);
                type = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.atypeFactory.getAnnotatedType(typeargtree);
                break;
            }
            case ANNOTATED_TYPE: {
                AnnotatedTypeTree tr = (AnnotatedTypeTree)tree;
                ExpressionTree undtr = tr.getUnderlyingType();
                if (undtr instanceof ParameterizedTypeTree) {
                    typeargtree = (ParameterizedTypeTree)((Object)undtr);
                    break;
                }
                if (undtr instanceof IdentifierTree) break;
                Pair<ParameterizedTypeTree, AnnotatedTypeMirror.AnnotatedDeclaredType> p = this.extractParameterizedTypeTree(undtr, type);
                typeargtree = (ParameterizedTypeTree)p.first;
                type = (AnnotatedTypeMirror.AnnotatedDeclaredType)p.second;
                break;
            }
            case IDENTIFIER: 
            case ARRAY_TYPE: 
            case NEW_ARRAY: 
            case MEMBER_SELECT: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case TYPE_PARAMETER: {
                break;
            }
        }
        return Pair.of(typeargtree, type);
    }

    @Override
    public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Tree tree) {
        if (this.checker.shouldSkipUses(type.getUnderlyingType().toString())) {
            return (Void)super.visitPrimitive(type, tree);
        }
        if (!this.visitor.isValidUse(type, tree)) {
            this.reportError(type, tree);
        }
        return (Void)super.visitPrimitive(type, tree);
    }

    @Override
    public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Tree tree) {
        AnnotatedTypeMirror comp = type;
        while ((comp = ((AnnotatedTypeMirror.AnnotatedArrayType)comp).getComponentType()).getKind() == TypeKind.ARRAY) {
        }
        if (comp != null && comp.getKind() == TypeKind.DECLARED && this.checker.shouldSkipUses(((AnnotatedTypeMirror.AnnotatedDeclaredType)comp).getUnderlyingType().asElement())) {
            return (Void)super.visitArray(type, tree);
        }
        if (!this.visitor.isValidUse(type, tree)) {
            this.reportError(type, tree);
        }
        return (Void)super.visitArray(type, tree);
    }

    protected Void visitParameterizedType(AnnotatedTypeMirror.AnnotatedDeclaredType type, ParameterizedTypeTree tree) {
        if (TreeUtils.isDiamondTree(tree)) {
            return null;
        }
        TypeElement element = (TypeElement)type.getUnderlyingType().asElement();
        if (this.checker.shouldSkipUses(element)) {
            return null;
        }
        List<AnnotatedTypeParameterBounds> bounds = this.atypeFactory.typeVariablesFromUse(type, element);
        this.visitor.checkTypeArguments(tree, bounds, type.getTypeArguments(), tree.getTypeArguments());
        return null;
    }

    @Override
    public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Tree tree) {
        if (this.visitedNodes.containsKey(type)) {
            return (Void)this.visitedNodes.get(type);
        }
        Set<AnnotationMirror> onVar = type.getAnnotations();
        if (!onVar.isEmpty()) {
            Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
            for (AnnotationMirror aOnVar : onVar) {
                AnnotationMirror top = this.atypeFactory.getQualifierHierarchy().getTopAnnotation(aOnVar);
                if (seenTops.contains(top)) {
                    this.reportError(type, tree);
                }
                seenTops.add(top);
            }
            if (type.getLowerBoundField() != null) {
                AnnotatedTypeMirror lower = type.getLowerBoundField();
                for (AnnotationMirror aOnVar : onVar) {
                    if (!lower.isAnnotatedInHierarchy(aOnVar) || this.atypeFactory.getQualifierHierarchy().isSubtype(lower.getAnnotationInHierarchy(aOnVar), aOnVar)) continue;
                    this.reportError(type, tree);
                }
                lower.replaceAnnotations(onVar);
            }
        }
        return (Void)super.visitTypeVariable(type, tree);
    }

    @Override
    public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Tree tree) {
        if (this.visitedNodes.containsKey(type)) {
            return (Void)this.visitedNodes.get(type);
        }
        Set<AnnotationMirror> onVar = type.getAnnotations();
        if (!onVar.isEmpty()) {
            Set<AnnotationMirror> seenTops = AnnotationUtils.createAnnotationSet();
            for (AnnotationMirror aOnVar : onVar) {
                AnnotationMirror top = this.atypeFactory.getQualifierHierarchy().getTopAnnotation(aOnVar);
                if (seenTops.contains(top)) {
                    this.reportError(type, tree);
                }
                seenTops.add(top);
            }
            if (type.getSuperBoundField() != null) {
                AnnotatedTypeMirror lower = type.getSuperBoundField();
                for (AnnotationMirror aOnVar : onVar) {
                    if (!lower.isAnnotatedInHierarchy(aOnVar) || this.atypeFactory.getQualifierHierarchy().isSubtype(lower.getAnnotationInHierarchy(aOnVar), aOnVar)) continue;
                    this.reportError(type, tree);
                }
                lower.replaceAnnotations(onVar);
            }
        }
        return (Void)super.visitWildcard(type, tree);
    }
}

