/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForSubchecker;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.TypesUtils;

public class KeyForTransfer
extends CFAbstractTransfer<CFValue, CFStore, KeyForTransfer> {
    protected KeyForAnalysis analysis;
    protected KeyForSubchecker checker;

    public KeyForTransfer(KeyForAnalysis analysis, KeyForSubchecker checker) {
        super(analysis);
        this.analysis = analysis;
        this.checker = checker;
    }

    private AnnotationMirror getKeyForAnnotationMirrorWithValue(String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        AnnotationBuilder builder = new AnnotationBuilder(this.analysis.getTypeFactory().getProcessingEnv(), KeyFor.class);
        builder.setValue((CharSequence)"value", values);
        return builder.build();
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        String methodName = node.getTarget().getMethod().toString();
        boolean containsKey = methodName.startsWith("containsKey(");
        boolean put = methodName.startsWith("put(");
        if (containsKey || put) {
            Types types = this.analysis.getTypes();
            TypeMirror mapInterfaceTypeMirror = types.erasure(TypesUtils.typeFromClass(types, this.analysis.getEnv().getElementUtils(), Map.class));
            TypeMirror receiverType = types.erasure(node.getTarget().getReceiver().getType());
            if (types.isSubtype(receiverType, mapInterfaceTypeMirror)) {
                FlowExpressionParseUtil.FlowExpressionContext flowExprContext = FlowExpressionParseUtil.buildFlowExprContextForUse(node, this.checker);
                String mapName = flowExprContext.receiver.toString();
                FlowExpressions.Receiver keyReceiver = flowExprContext.arguments.get(0);
                AnnotationMirror am = this.getKeyForAnnotationMirrorWithValue(mapName);
                if (containsKey) {
                    ConditionalTransferResult conditionalResult = (ConditionalTransferResult)result;
                    ((CFStore)conditionalResult.getThenStore()).insertValue(keyReceiver, am);
                } else if (put) {
                    result.getThenStore().insertValue(keyReceiver, am);
                    result.getElseStore().insertValue(keyReceiver, am);
                }
            }
        }
        return result;
    }
}

