/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.nullness.KeyForAnalysis;
import org.checkerframework.checker.nullness.KeyForTransfer;
import org.checkerframework.checker.nullness.compatqual.KeyForDecl;
import org.checkerframework.checker.nullness.compatqual.KeyForType;
import org.checkerframework.checker.nullness.qual.Covariant;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

@TypeQualifiers(value={KeyFor.class, UnknownKeyFor.class, KeyForBottom.class})
public class KeyForAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, CFStore, KeyForTransfer, KeyForAnalysis> {
    protected final AnnotationMirror UNKNOWN;
    protected final AnnotationMirror KEYFOR;
    private static final Pattern parameterPtn = Pattern.compile("#(\\d+)");

    public KeyForAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, true);
        this.KEYFOR = AnnotationUtils.fromClass(this.elements, KeyFor.class);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, UnknownKeyFor.class);
        this.postInit();
        this.defaults.addAbsoluteDefault(this.UNKNOWN, DefaultLocation.ALL);
        this.addAliasedAnnotation(KeyForDecl.class, this.KEYFOR);
        this.addAliasedAnnotation(KeyForType.class, this.KEYFOR);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree call) {
        assert (call != null);
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(call);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        List<AnnotatedTypeMirror> params = method.getParameterTypes();
        for (AnnotatedTypeMirror param : params) {
            AnnotatedTypeMirror subst = this.substituteCall(call, param);
            mappings.put(param, subst);
        }
        AnnotatedTypeMirror returnType = method.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror subst = this.substituteCall(call, returnType);
            mappings.put(returnType, subst);
        }
        method = (AnnotatedTypeMirror.AnnotatedExecutableType)method.substitute(mappings);
        return Pair.of(method, mfuPair.second);
    }

    private String receiver(MethodInvocationTree node) {
        ExpressionTree sel = node.getMethodSelect();
        if (sel.getKind() == Tree.Kind.IDENTIFIER) {
            return "";
        }
        if (sel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)sel).getExpression().toString();
        }
        ErrorReporter.errorAbort("KeyForAnnotatedTypeFactory.receiver: cannot be here");
        return null;
    }

    private AnnotatedTypeMirror substituteCall(MethodInvocationTree call, AnnotatedTypeMirror inType) {
        AnnotatedTypeMirror outType = inType.getCopy(true);
        AnnotationMirror anno = inType.getAnnotation(KeyFor.class);
        if (anno != null) {
            List<String> inMaps = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            ArrayList<Object> outMaps = new ArrayList<Object>();
            String receiver = this.receiver(call);
            for (String inMapName : inMaps) {
                if (parameterPtn.matcher(inMapName).matches()) {
                    int param = Integer.valueOf(inMapName.substring(1));
                    if (param <= 0 || param > call.getArguments().size()) continue;
                    String res = call.getArguments().get(param - 1).toString();
                    outMaps.add(res);
                    continue;
                }
                if (inMapName.equals("this")) {
                    outMaps.add(receiver);
                    continue;
                }
                outMaps.add(inMapName);
            }
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, KeyFor.class);
            builder.setValue((CharSequence)"value", outMaps);
            AnnotationMirror newAnno = builder.build();
            outType.removeAnnotation(KeyFor.class);
            outType.addAnnotation(newAnno);
        }
        if (outType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)outType;
            HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror typeArgument : declaredType.getTypeArguments()) {
                AnnotatedTypeMirror substTypeArgument = this.substituteCall(call, typeArgument);
                mapping.put(typeArgument, substTypeArgument);
            }
            outType = declaredType.substitute(mapping);
        } else if (outType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)outType;
            AnnotatedTypeMirror elemType = arrayType.getComponentType();
            AnnotatedTypeMirror substElemType = this.substituteCall(call, elemType);
            arrayType.setComponentType(substElemType);
        } else if (outType.getKind().isPrimitive() || outType.getKind() == TypeKind.WILDCARD || outType.getKind() == TypeKind.TYPEVAR) {
            // empty if block
        }
        return outType;
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new KeyForTypeHierarchy(this.checker, this.getQualifierHierarchy());
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new KeyForQualifierHierarchy(factory);
    }

    private final class KeyForQualifierHierarchy
    extends GraphQualifierHierarchy {
        public KeyForQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory, null);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR) && AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                return AnnotationUtils.areSame(lhs, rhs);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                lhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, KeyForAnnotatedTypeFactory.this.KEYFOR)) {
                rhs = KeyForAnnotatedTypeFactory.this.KEYFOR;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class KeyForTypeHierarchy
    extends TypeHierarchy {
        public KeyForTypeHierarchy(BaseTypeChecker checker, QualifierHierarchy qualifierHierarchy) {
            super(checker, qualifierHierarchy);
        }

        @Override
        public final boolean isSubtype(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
            if (lhs.getKind() == TypeKind.TYPEVAR && rhs.getKind() == TypeKind.TYPEVAR && lhs.getAnnotations().isEmpty()) {
                return true;
            }
            if (rhs.hasAnnotation(KeyForBottom.class)) {
                return true;
            }
            return super.isSubtype(rhs, lhs);
        }

        @Override
        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (this.ignoreRawTypeArguments(rhs, lhs)) {
                return true;
            }
            List<AnnotatedTypeMirror> rhsTypeArgs = rhs.getTypeArguments();
            List<AnnotatedTypeMirror> lhsTypeArgs = lhs.getTypeArguments();
            if (rhsTypeArgs.isEmpty() || lhsTypeArgs.isEmpty()) {
                return true;
            }
            TypeElement lhsElem = (TypeElement)lhs.getUnderlyingType().asElement();
            int[] covarVals = null;
            if (lhsElem.getAnnotation(Covariant.class) != null) {
                covarVals = lhsElem.getAnnotation(Covariant.class).value();
            }
            if (lhsTypeArgs.size() != rhsTypeArgs.size()) {
                return true;
            }
            for (int i = 0; i < lhsTypeArgs.size(); ++i) {
                boolean covar = false;
                if (covarVals != null) {
                    for (int cvv = 0; cvv < covarVals.length; ++cvv) {
                        if (covarVals[cvv] != i) continue;
                        covar = true;
                    }
                }
                if (covar) {
                    if (this.isSubtype(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
                    return this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i));
                }
                if (this.isSubtypeAsTypeArgument(rhsTypeArgs.get(i), lhsTypeArgs.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

