/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.experimental.regex_qual_poly;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.experimental.regex_qual.Regex;
import org.checkerframework.framework.source.Result;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.qualframework.base.CheckerAdapter;
import org.checkerframework.qualframework.base.QualifiedTypeMirror;
import org.checkerframework.qualframework.base.TypecheckVisitorAdapter;
import org.checkerframework.qualframework.poly.QualParams;

public class RegexTypecheckVisitor
extends TypecheckVisitorAdapter<QualParams<Regex>> {
    private final ExecutableElement matchResultEnd;
    private final ExecutableElement matchResultGroup;
    private final ExecutableElement matchResultStart;
    private final ExecutableElement patternCompile;
    private final VariableElement patternLiteral;

    public RegexTypecheckVisitor(CheckerAdapter<QualParams<Regex>> checker) {
        super(checker);
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.matchResultEnd = TreeUtils.getMethod("java.util.regex.MatchResult", "end", 1, env);
        this.matchResultGroup = TreeUtils.getMethod("java.util.regex.MatchResult", "group", 1, env);
        this.matchResultStart = TreeUtils.getMethod("java.util.regex.MatchResult", "start", 1, env);
        this.patternCompile = TreeUtils.getMethod("java.util.regex.Pattern", "compile", 2, env);
        this.patternLiteral = TreeUtils.getField("java.util.regex.Pattern", "LITERAL", env);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        if (TreeUtils.isMethodInvocation(node, this.patternCompile, env)) {
            MemberSelectTree memSelect;
            ExpressionTree flagParam = node.getArguments().get(1);
            if (flagParam.getKind() == Tree.Kind.MEMBER_SELECT && TreeUtils.isSpecificFieldAccess(memSelect = (MemberSelectTree)flagParam, this.patternLiteral)) {
                Void r = (Void)this.scan(node.getTypeArguments(), p);
                r = this.reduce(this.scan((Tree)node.getMethodSelect(), p), r);
                r = this.reduce(this.scan(node.getArguments(), p), r);
                return r;
            }
        } else if (TreeUtils.isMethodInvocation(node, this.matchResultEnd, env) || TreeUtils.isMethodInvocation(node, this.matchResultGroup, env) || TreeUtils.isMethodInvocation(node, this.matchResultStart, env)) {
            ExpressionTree group = node.getArguments().get(0);
            if (group.getKind() == Tree.Kind.INT_LITERAL) {
                LiteralTree literal = (LiteralTree)group;
                int paramGroups = (Integer)literal.getValue();
                ExpressionTree receiver = TreeUtils.getReceiverTree(node);
                int annoGroups = 0;
                QualifiedTypeMirror receiverType = this.context.getTypeFactory().getQualifiedType(receiver);
                Regex regex = (Regex)((QualParams)receiverType.getQualifier()).getPrimary().getMaximum();
                if (!(paramGroups <= 0 || regex.isRegexVal() && ((Regex.RegexVal)regex).getCount() >= paramGroups)) {
                    this.checker.report(Result.failure("group.count.invalid", paramGroups, annoGroups, receiver), group);
                }
            } else {
                this.checker.report(Result.warning("group.count.unknown", new Object[0]), group);
            }
        }
        return super.visitMethodInvocation(node, p);
    }
}

