/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.TypeAnnotator;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterAnnotationConverter;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.util.ExtendedDeclaredType;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class QualifierParameterTypeAnnotator<Q>
extends TypeAnnotator<QualParams<Q>> {
    private QualifierHierarchy<Wildcard<Q>> containmentHierarchy;

    public QualifierParameterTypeAnnotator(QualifierContext<QualParams<Q>> qualContext, QualifierParameterAnnotationConverter<Q> annotationConverter, QualifierHierarchy<Wildcard<Q>> containmentHierarchy) {
        super(qualContext, annotationConverter, new QualParams());
        this.containmentHierarchy = containmentHierarchy;
    }

    public QualifierHierarchy<Wildcard<Q>> getContainmentHierarchy() {
        return this.containmentHierarchy;
    }

    @Override
    public QualifierParameterAnnotationConverter<Q> getAnnotationConverter() {
        return (QualifierParameterAnnotationConverter)super.getAnnotationConverter();
    }

    @Override
    protected QualParams<Q> getQualifier(ExtendedTypeMirror type) {
        QualParams result = (QualParams)super.getQualifier(type);
        Set<Object> names = null;
        switch (type.getKind()) {
            case DECLARED: {
                names = this.getAnnotationConverter().getDeclaredParameters(((ExtendedDeclaredType)type).asElement(), this.qualContext.getTypeFactory().getDecoratedElement(((ExtendedDeclaredType)type).asElement()));
                break;
            }
            case EXECUTABLE: {
                names = this.getAnnotationConverter().getDeclaredParameters(((ExtendedExecutableType)type).asElement(), this.qualContext.getTypeFactory().getDecoratedElement(((ExtendedDeclaredType)type).asElement()));
                break;
            }
            case VOID: 
            case PACKAGE: 
            case NONE: 
            case TYPEVAR: 
            case ARRAY: {
                names = Collections.emptySet();
                break;
            }
            case INTERSECTION: 
            case UNION: 
            case NULL: 
            case WILDCARD: {
                names = Collections.emptySet();
                break;
            }
            default: {
                if (type.getKind().isPrimitive()) {
                    names = Collections.emptySet();
                    break;
                }
                throw new IllegalArgumentException("unexpected type kind: " + (Object)((Object)type.getKind()));
            }
        }
        if (names.isEmpty()) {
            return result;
        }
        HashMap newParams = new HashMap(result);
        for (String name : names) {
            if (newParams.containsKey(name)) continue;
            newParams.put(name, this.containmentHierarchy.getTop());
        }
        return new QualParams(newParams, result.getPrimary());
    }
}

