/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.Operators;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.DefaultLocation;
import org.checkerframework.framework.qual.TypeQualifiers;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.type.TypeAnnotator;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

@TypeQualifiers(value={ArrayLen.class, BoolVal.class, DoubleVal.class, IntVal.class, StringVal.class, BottomVal.class, UnknownVal.class})
public class ValueAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror INTVAL;
    protected final AnnotationMirror DOUBLEVAL;
    protected final AnnotationMirror BOOLVAL;
    protected final AnnotationMirror ARRAYLEN;
    protected final AnnotationMirror STRINGVAL;
    protected final AnnotationMirror BOTTOMVAL;
    protected final AnnotationMirror UNKNOWNVAL;
    protected final AnnotationMirror STATICALLY_EXECUTABLE;
    protected static final Set<javax.lang.model.element.Modifier> PUBLIC_STATIC_FINAL_SET = new HashSet<javax.lang.model.element.Modifier>(3);
    private long t = 0L;
    protected static final int MAX_VALUES = 10;
    protected final List<AnnotationMirror> constantAnnotations;
    protected Set<String> coveredClassStrings;
    private final Map<Tree, AnnotatedTypeMirror> propTreeCache = ValueAnnotatedTypeFactory.createLRUCache(200);
    private boolean reportWarnings = true;

    public ValueAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.PUBLIC);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.FINAL);
        PUBLIC_STATIC_FINAL_SET.add(javax.lang.model.element.Modifier.STATIC);
        this.INTVAL = AnnotationUtils.fromClass(this.elements, IntVal.class);
        this.BOOLVAL = AnnotationUtils.fromClass(this.elements, BoolVal.class);
        this.ARRAYLEN = AnnotationUtils.fromClass(this.elements, ArrayLen.class);
        this.DOUBLEVAL = AnnotationUtils.fromClass(this.elements, DoubleVal.class);
        this.STRINGVAL = AnnotationUtils.fromClass(this.elements, StringVal.class);
        this.BOTTOMVAL = AnnotationUtils.fromClass(this.elements, BottomVal.class);
        this.STATICALLY_EXECUTABLE = AnnotationUtils.fromClass(this.elements, StaticallyExecutable.class);
        this.UNKNOWNVAL = AnnotationUtils.fromClass(this.elements, UnknownVal.class);
        this.constantAnnotations = new ArrayList<AnnotationMirror>(9);
        this.constantAnnotations.add(this.DOUBLEVAL);
        this.constantAnnotations.add(this.INTVAL);
        this.constantAnnotations.add(this.BOOLVAL);
        this.constantAnnotations.add(this.STRINGVAL);
        this.constantAnnotations.add(this.BOTTOMVAL);
        this.constantAnnotations.add(this.ARRAYLEN);
        this.constantAnnotations.add(this.STATICALLY_EXECUTABLE);
        this.constantAnnotations.add(this.UNKNOWNVAL);
        this.coveredClassStrings = new HashSet<String>(19);
        this.coveredClassStrings.add("int");
        this.coveredClassStrings.add("java.lang.Integer");
        this.coveredClassStrings.add("double");
        this.coveredClassStrings.add("java.lang.Double");
        this.coveredClassStrings.add("byte");
        this.coveredClassStrings.add("java.lang.Byte");
        this.coveredClassStrings.add("java.lang.String");
        this.coveredClassStrings.add("char");
        this.coveredClassStrings.add("java.lang.Character");
        this.coveredClassStrings.add("float");
        this.coveredClassStrings.add("java.lang.Float");
        this.coveredClassStrings.add("boolean");
        this.coveredClassStrings.add("java.lang.Boolean");
        this.coveredClassStrings.add("long");
        this.coveredClassStrings.add("java.lang.Long");
        this.coveredClassStrings.add("short");
        this.coveredClassStrings.add("java.lang.Short");
        this.coveredClassStrings.add("byte[]");
        if (this.getClass().equals(ValueAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    public void disableWarnings() {
        this.reportWarnings = false;
    }

    public void enableWarnings() {
        this.reportWarnings = true;
    }

    @Override
    public CFTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        return new CFTransfer(analysis);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        if (this.propTreeCache.containsKey(tree)) {
            return AnnotatedTypes.deepCopy(this.propTreeCache.get(tree));
        }
        AnnotatedTypeMirror anno = super.getAnnotatedType(tree);
        if (tree instanceof JCTree.JCBinary || tree instanceof JCTree.JCUnary) {
            this.propTreeCache.put(tree, AnnotatedTypes.deepCopy(anno));
        }
        return anno;
    }

    public AnnotationMirror createAnnotation(String name, Set<?> values) {
        if (values.size() > 0 && values.size() <= 10) {
            AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, name);
            ArrayList valuesList = new ArrayList(values);
            builder.setValue((CharSequence)"value", valuesList);
            return builder.build();
        }
        return this.UNKNOWNVAL;
    }

    public AnnotationMirror createAnnotation(Class<? extends Annotation> name, Set<?> values) {
        return this.createAnnotation(name.getCanonicalName(), values);
    }

    @Override
    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new ValueQualifierHierarchy(factory);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ValueTypeAnnotator(this);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ValueTreeAnnotator(this);
    }

    @Override
    protected QualifierDefaults createQualifierDefaults() {
        QualifierDefaults defaults = super.createQualifierDefaults();
        defaults.addAbsoluteDefault(this.UNKNOWNVAL, DefaultLocation.OTHERWISE);
        return defaults;
    }

    private boolean isNumberAnnotation(AnnotationMirror anno) {
        return AnnotationUtils.areSameIgnoringValues(anno, this.INTVAL) || AnnotationUtils.areSameIgnoringValues(anno, this.DOUBLEVAL);
    }

    protected class ValueTreeAnnotator
    extends TreeAnnotator {
        public ValueTreeAnnotator(ValueAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
            TreePath path = ValueAnnotatedTypeFactory.this.getPath(tree);
            if (path.getLeaf().getKind() != Tree.Kind.CLASS) {
                List<? extends ExpressionTree> dimensions = tree.getDimensions();
                List<? extends ExpressionTree> initializers = tree.getInitializers();
                if (!dimensions.isEmpty()) {
                    this.handleDimensions(dimensions, (AnnotatedTypeMirror.AnnotatedArrayType)type);
                } else {
                    int length = initializers.size();
                    HashSet<Integer> value = new HashSet<Integer>();
                    if (length == 0) {
                        value.add(length);
                    } else if (length > 0 && !initializers.get(0).getClass().equals(List.class)) {
                        value.add(length);
                    }
                    Class<?> clazz = this.getClass(type, (Tree)tree);
                    String stringVal = null;
                    if (clazz.equals(byte[].class)) {
                        stringVal = this.getByteArrayStringVal(initializers);
                    } else if (clazz.equals(char[].class)) {
                        stringVal = this.getCharArrayStringVal(initializers);
                    }
                    if (stringVal != null) {
                        HashSet<String> stringFromChars = new HashSet<String>(1);
                        stringFromChars.add(stringVal);
                        AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringFromChars);
                        type.replaceAnnotation(newQual);
                        return null;
                    }
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.ArrayLen", value);
                    type.replaceAnnotation(newQual);
                }
            }
            return (Void)super.visitNewArray(tree, type);
        }

        private String getByteArrayStringVal(List<? extends ExpressionTree> initializers) {
            boolean allLiterals = true;
            byte[] bytes = new byte[initializers.size()];
            int i = 0;
            for (ExpressionTree expressionTree : initializers) {
                if (expressionTree.getKind() == Tree.Kind.INT_LITERAL) {
                    bytes[i] = (byte)((Integer)((LiteralTree)expressionTree).getValue()).intValue();
                } else if (expressionTree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    bytes[i] = (byte)((Character)((LiteralTree)expressionTree).getValue()).charValue();
                } else {
                    allLiterals = false;
                }
                ++i;
            }
            if (allLiterals) {
                return new String(bytes);
            }
            return null;
        }

        private String getCharArrayStringVal(List<? extends ExpressionTree> initializers) {
            boolean allLiterals = true;
            String stringVal = "";
            for (ExpressionTree expressionTree : initializers) {
                char charVal;
                if (expressionTree.getKind() == Tree.Kind.INT_LITERAL) {
                    charVal = (char)((Integer)((LiteralTree)expressionTree).getValue()).intValue();
                    stringVal = stringVal + charVal;
                    continue;
                }
                if (expressionTree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    charVal = ((Character)((LiteralTree)expressionTree).getValue()).charValue();
                    stringVal = stringVal + charVal;
                    continue;
                }
                allLiterals = false;
            }
            if (allLiterals) {
                return stringVal;
            }
            return null;
        }

        private void handleDimensions(List<? extends ExpressionTree> dimensions, AnnotatedTypeMirror.AnnotatedArrayType type) {
            AnnotationMirror dimType;
            if (dimensions.size() > 1) {
                this.handleDimensions(dimensions.subList(1, dimensions.size()), (AnnotatedTypeMirror.AnnotatedArrayType)type.getComponentType());
            }
            if (AnnotationUtils.areSameIgnoringValues(dimType = ValueAnnotatedTypeFactory.this.getAnnotatedType(dimensions.get(0)).getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.INTVAL), ValueAnnotatedTypeFactory.this.INTVAL)) {
                List<Long> longLengths = AnnotationUtils.getElementValueArray(dimType, "value", Long.class, true);
                HashSet<Integer> lengths = new HashSet<Integer>(longLengths.size());
                for (Long l : longLengths) {
                    lengths.add(l.intValue());
                }
                AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.ArrayLen", lengths);
                type.replaceAnnotation(newQual);
            } else {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
        }

        @Override
        public Void visitTypeCast(TypeCastTree tree, AnnotatedTypeMirror type) {
            if (this.isClassCovered(type)) {
                this.handleCast(tree.getExpression(), this.getClass(type, tree.getType()), type);
            } else if (type.getKind() == TypeKind.ARRAY) {
                this.handleArrayCast(tree, type);
            }
            return (Void)super.visitTypeCast(tree, type);
        }

        private void handleArrayCast(TypeCastTree tree, AnnotatedTypeMirror type) {
            if (tree.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.BOTTOMVAL);
            }
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, AnnotatedTypeMirror type) {
            super.visitAssignment(tree, type);
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (this.isClassCovered(type)) {
                if (tree.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                    HashSet<Boolean> values = new HashSet<Boolean>();
                    values.add((Boolean)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.BoolVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add(Long.valueOf(((Character)tree.getValue()).charValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.DOUBLE_LITERAL) {
                    HashSet<Double> values = new HashSet<Double>();
                    values.add((Double)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.FLOAT_LITERAL) {
                    HashSet<Double> values = new HashSet<Double>();
                    values.add(new Double(((Float)tree.getValue()).floatValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.INT_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add(new Long(((Integer)tree.getValue()).intValue()));
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.LONG_LITERAL) {
                    HashSet<Long> values = new HashSet<Long>();
                    values.add((Long)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    HashSet<String> values = new HashSet<String>();
                    values.add((String)tree.getValue());
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", values);
                    type.replaceAnnotation(newQual);
                    return null;
                }
                if (tree.getKind() == Tree.Kind.NULL_LITERAL) {
                    HashSet<String> values = new HashSet<String>();
                    values.add("null");
                    AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", values);
                    type.replaceAnnotation(newQual);
                }
            }
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror type) {
            super.visitUnary(tree, type);
            if (this.isClassCovered(type)) {
                Tree.Kind operation = tree.getKind();
                AnnotatedTypeMirror argType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
                if (!this.nonValueAnno(argType)) {
                    Class<?> argClass = this.boxPrimatives(this.getClass(type, (Tree)tree));
                    this.handleCast(tree.getExpression(), this.getClass(type, (Tree)tree), argType);
                    AnnotationMirror argAnno = this.getValueAnnotation(argType);
                    AnnotationMirror newAnno = this.evaluateUnaryOperator(argAnno, operation.toString(), argClass, tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                        return null;
                    }
                }
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror p) {
            return (Void)super.visitCompoundAssignment(node, p);
        }

        private AnnotationMirror evaluateUnaryOperator(AnnotationMirror argAnno, String operation, Class<?> argClass, UnaryTree tree) {
            try {
                argClass = this.boxPrimatives(argClass);
                Class[] argClasses = new Class[]{argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                List<?> annoValues = this.getCastedValues(argAnno, argClass, (Tree)tree);
                ArrayList<Object> results = new ArrayList<Object>(annoValues.size());
                for (Object val : annoValues) {
                    results.add(m3.invoke(null, val));
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.unary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (!this.isClassCovered(type)) {
                return (Void)super.visitBinary(tree, type);
            }
            Tree.Kind operation = tree.getKind();
            AnnotatedTypeMirror lhsType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getLeftOperand());
            AnnotatedTypeMirror rhsType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getRightOperand());
            if (!this.nonValueAnno(lhsType) && !this.nonValueAnno(rhsType)) {
                Class<Object> resultClass = null;
                AnnotationMirror newAnno = null;
                if (operation != Tree.Kind.EQUAL_TO && operation != Tree.Kind.NOT_EQUAL_TO && operation != Tree.Kind.GREATER_THAN && operation != Tree.Kind.GREATER_THAN_EQUAL && operation != Tree.Kind.LESS_THAN && operation != Tree.Kind.LESS_THAN_EQUAL) {
                    resultClass = this.getClass(type, (Tree)tree);
                    if (resultClass != String.class) {
                        List<?> lhs = this.getCastedValues(lhsType, resultClass, (Tree)tree);
                        List<?> rhs = this.getCastedValues(rhsType, resultClass, (Tree)tree);
                        newAnno = this.evaluateBinaryOperator(lhs, rhs, operation.toString(), resultClass, tree);
                    } else {
                        List<?> lhs = this.convertToStringVal(this.getCastedValues(lhsType, tree.getLeftOperand()));
                        List<?> rhs = this.convertToStringVal(this.getCastedValues(rhsType, tree.getRightOperand()));
                        newAnno = this.evaluateBinaryOperator(lhs, rhs, operation.toString(), resultClass, tree);
                    }
                } else {
                    if (AnnotationUtils.areSameIgnoringValues(this.getValueAnnotation(lhsType), ValueAnnotatedTypeFactory.this.STRINGVAL)) {
                        resultClass = this.getAnnotationValueClass(this.getValueAnnotation(lhsType));
                    } else if (AnnotationUtils.areSameByClass(this.getValueAnnotation(lhsType), BoolVal.class)) {
                        resultClass = this.getAnnotationValueClass(this.getValueAnnotation(lhsType));
                    } else {
                        resultClass = Double.TYPE;
                        this.handleBinaryCast(tree.getLeftOperand(), lhsType, tree.getRightOperand(), rhsType, Double.TYPE);
                    }
                    newAnno = this.evaluateComparison(lhsType, rhsType, operation.toString(), resultClass, tree);
                }
                if (newAnno != null) {
                    type.replaceAnnotation(newAnno);
                    return null;
                }
            }
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            return null;
        }

        private void handleBinaryCast(ExpressionTree lhs, AnnotatedTypeMirror lhsType, ExpressionTree rhs, AnnotatedTypeMirror rhsType, Class<?> castType) {
            this.handleCast(lhs, castType, lhsType);
            this.handleCast(rhs, castType, rhsType);
        }

        private AnnotationMirror evaluateComparison(AnnotatedTypeMirror lhsType, AnnotatedTypeMirror rhsType, String operation, Class<?> argClass, BinaryTree tree) {
            try {
                argClass = this.boxPrimatives(argClass);
                Class[] argClasses = new Class[]{argClass, argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                List<?> lhsAnnoValues = this.getCastedValues(lhsType, argClass, (Tree)tree);
                List<?> rhsAnnoValues = this.getCastedValues(rhsType, argClass, (Tree)tree);
                ArrayList<Object> results = new ArrayList<Object>(lhsAnnoValues.size() * rhsAnnoValues.size());
                for (Object lhsO : lhsAnnoValues) {
                    for (Object rhsO : rhsAnnoValues) {
                        results.add(m3.invoke(null, lhsO, rhsO));
                    }
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.binary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        private AnnotationMirror evaluateBinaryOperator(List<?> lhsAnnoValues, List<?> rhsAnnoValues, String operation, Class<?> argClass, BinaryTree tree) {
            try {
                argClass = this.boxPrimatives(argClass);
                Class[] argClasses = new Class[]{argClass, argClass};
                Method m3 = Operators.class.getMethod(operation, argClasses);
                ArrayList<Object> results = new ArrayList<Object>(lhsAnnoValues.size() * rhsAnnoValues.size());
                for (Object lhsO : lhsAnnoValues) {
                    for (Object rhsO : rhsAnnoValues) {
                        results.add(m3.invoke(null, lhsO, rhsO));
                    }
                }
                return this.resultAnnotationHandler(m3.getReturnType(), results);
            }
            catch (ReflectiveOperationException e) {
                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("operator.binary.evaluation.failed", operation, argClass), tree);
                return null;
            }
        }

        private boolean methodIsStaticallyExecutable(Element method) {
            return ValueAnnotatedTypeFactory.this.getDeclAnnotation(method, StaticallyExecutable.class) != null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            block14: {
                super.visitMethodInvocation(tree, type);
                if (this.isClassCovered(type) && this.methodIsStaticallyExecutable(TreeUtils.elementFromUse(tree))) {
                    ExpressionTree methodTree = tree.getMethodSelect();
                    List<? extends ExpressionTree> argTrees = tree.getArguments();
                    ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
                    for (Tree tree2 : argTrees) {
                        argTypes.add(ValueAnnotatedTypeFactory.this.getAnnotatedType(tree2));
                    }
                    boolean known = true;
                    for (AnnotatedTypeMirror t : argTypes) {
                        if (!this.nonValueAnno(t)) continue;
                        known = false;
                    }
                    if (known) {
                        boolean bl = false;
                        AnnotatedTypeMirror recType = null;
                        Method method = null;
                        try {
                            method = this.getMethodObject(tree);
                            boolean bl2 = Modifier.isStatic(method.getModifiers());
                            if (!bl2) {
                                recType = ValueAnnotatedTypeFactory.this.getAnnotatedType(((MemberSelectTree)methodTree).getExpression());
                            }
                            if (bl2 || !this.nonValueAnno(recType)) {
                                AnnotationMirror newAnno;
                                if (!method.isAccessible()) {
                                    method.setAccessible(true);
                                }
                                if ((newAnno = this.evaluateMethod(recType, method, argTypes, type, tree)) != null) {
                                    type.replaceAnnotation(newAnno);
                                    return null;
                                }
                            }
                        }
                        catch (ClassNotFoundException | UnsupportedClassVersionError e) {
                            if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                                ValueAnnotatedTypeFactory.this.checker.report(Result.warning("class.find.failed", TreeUtils.elementFromUse(tree).getEnclosingElement()), tree);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            Element classElem = TreeUtils.elementFromUse(tree).getEnclosingElement();
                            if (classElem == null) {
                                if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                                    ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.find.failed", ((MemberSelectTree)methodTree).getIdentifier(), argTypes), tree);
                                }
                            }
                            if (!ValueAnnotatedTypeFactory.this.reportWarnings) break block14;
                            ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.find.failed.in.class", ((MemberSelectTree)methodTree).getIdentifier(), argTypes, classElem), tree);
                        }
                    }
                }
            }
            type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            return null;
        }

        private Method getMethodObject(MethodInvocationTree tree) throws ClassNotFoundException, NoSuchMethodException {
            ExecutableElement ele = TreeUtils.elementFromUse(tree);
            ele.getEnclosingElement();
            Name clazz = TypesUtils.getQualifiedName((DeclaredType)ele.getEnclosingElement().asType());
            List<? extends VariableElement> paramEles = ele.getParameters();
            ArrayList paramClzz = new ArrayList();
            for (Element element : paramEles) {
                TypeMirror pType = ElementUtils.getType(element);
                if (pType.getKind() == TypeKind.ARRAY) {
                    ArrayType pArrayType = (ArrayType)pType;
                    String par = TypesUtils.getQualifiedName((DeclaredType)pArrayType.getComponentType()).toString();
                    if (par.equals("java.lang.Object")) {
                        paramClzz.add(Object[].class);
                        continue;
                    }
                    if (!par.equals("java.lang.String")) continue;
                    paramClzz.add(String[].class);
                    continue;
                }
                String paramClass = ElementUtils.getType(element).toString();
                if (paramClass.contains("java")) {
                    paramClzz.add(Class.forName(paramClass));
                    continue;
                }
                paramClzz.add(this.getClass(ElementUtils.getType(element), (Tree)tree));
            }
            Class<?> clzz = Class.forName(clazz.toString());
            Method method = clzz.getMethod(ele.getSimpleName().toString(), paramClzz.toArray(new Class[0]));
            return method;
        }

        private AnnotationMirror evaluateMethod(AnnotatedTypeMirror recType, Method method, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror retType, MethodInvocationTree tree) {
            List<?> recValues = null;
            if (!Modifier.isStatic(method.getModifiers())) {
                recValues = this.getCastedValues(recType, tree);
            }
            ArrayDeque<List<?>> allArgValues = this.getAllArgumentAnnotationValues(argTypes, tree);
            ArrayDeque<Object> specificArgValues = new ArrayDeque<Object>();
            ArrayList<Object> results = new ArrayList<Object>();
            this.evaluateMethodHelper(allArgValues, specificArgValues, recValues, method, results, tree);
            return this.resultAnnotationHandler(retType, results, (Tree)tree);
        }

        private void evaluateMethodHelper(ArrayDeque<List<?>> argArrayDeque, ArrayDeque<Object> values, List<?> receiverValues, Method method, List<Object> results, MethodInvocationTree tree) {
            block12: {
                if (argArrayDeque.size() == 0) {
                    try {
                        if (receiverValues != null) {
                            for (Object o : receiverValues) {
                                if (values.size() > 0) {
                                    results.add(method.invoke(o, values.toArray()));
                                    continue;
                                }
                                results.add(method.invoke(o, new Object[0]));
                            }
                            break block12;
                        }
                        if (values.size() > 0) {
                            results.add(method.invoke(null, values.toArray()));
                            break block12;
                        }
                        results.add(method.invoke(null, new Object[0]));
                    }
                    catch (InvocationTargetException e) {
                        if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                            ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.evaluation.exception", method, e.getTargetException().toString()), tree);
                        }
                        results = new ArrayList<Object>();
                    }
                    catch (ReflectiveOperationException e) {
                        if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                            ValueAnnotatedTypeFactory.this.checker.report(Result.warning("method.evaluation.failed", method), tree);
                        }
                        results = new ArrayList<Object>();
                    }
                } else {
                    List<?> argValues = argArrayDeque.pop();
                    for (Object o : argValues) {
                        values.push(o);
                        this.evaluateMethodHelper(argArrayDeque, values, receiverValues, method, results, tree);
                        values.pop();
                    }
                }
            }
        }

        @Override
        public Void visitNewClass(NewClassTree tree, AnnotatedTypeMirror type) {
            super.visitNewClass(tree, type);
            if (this.isClassCovered(type)) {
                block7: {
                    List<? extends ExpressionTree> argTrees = tree.getArguments();
                    ArrayList<AnnotatedTypeMirror> argTypes = new ArrayList<AnnotatedTypeMirror>(argTrees.size());
                    for (ExpressionTree expressionTree : argTrees) {
                        argTypes.add(ValueAnnotatedTypeFactory.this.getAnnotatedType(expressionTree));
                    }
                    boolean known = true;
                    for (AnnotatedTypeMirror t : argTypes) {
                        if (!this.nonValueAnno(t)) continue;
                        known = false;
                        break;
                    }
                    if (known) {
                        try {
                            Class<?>[] classArray = this.getParameterTypes(tree);
                            Class<?> recClass = this.boxPrimatives(this.getClass(type, (Tree)tree));
                            Constructor<?> constructor = recClass.getConstructor(classArray);
                            AnnotationMirror newAnno = this.evaluateNewClass(constructor, argTypes, type, tree);
                            if (newAnno != null) {
                                type.replaceAnnotation(newAnno);
                                return null;
                            }
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            if (!ValueAnnotatedTypeFactory.this.reportWarnings) break block7;
                            ValueAnnotatedTypeFactory.this.checker.report(Result.warning("constructor.evaluation.failed", type.getUnderlyingType(), argTypes), tree);
                        }
                    }
                }
                type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return null;
        }

        private Class<?> boxPrimatives(Class<?> type) {
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            return type;
        }

        private Class<?> unboxPrimatives(Class<?> type) {
            if (type == Byte.class) {
                return Byte.TYPE;
            }
            if (type == Short.class) {
                return Short.TYPE;
            }
            if (type == Integer.class) {
                return Integer.TYPE;
            }
            if (type == Long.class) {
                return Long.TYPE;
            }
            if (type == Float.class) {
                return Float.TYPE;
            }
            if (type == Double.class) {
                return Double.TYPE;
            }
            if (type == Character.class) {
                return Character.TYPE;
            }
            if (type == Boolean.class) {
                return Boolean.TYPE;
            }
            return type;
        }

        private AnnotationMirror evaluateNewClass(Constructor<?> constructor, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror retType, NewClassTree tree) {
            ArrayDeque<List<?>> allArgValues = this.getAllArgumentAnnotationValues(argTypes, tree);
            ArrayDeque<Object> specificArgValues = new ArrayDeque<Object>();
            ArrayList<Object> results = new ArrayList<Object>();
            this.evaluateNewClassHelper(allArgValues, specificArgValues, constructor, results, tree);
            return this.resultAnnotationHandler(retType, results, (Tree)tree);
        }

        private void evaluateNewClassHelper(ArrayDeque<List<?>> argArrayDeque, ArrayDeque<Object> values, Constructor<?> constructor, List<Object> results, NewClassTree tree) {
            block7: {
                if (argArrayDeque.size() == 0) {
                    try {
                        if (values.size() > 0) {
                            results.add(constructor.newInstance(values.toArray()));
                            break block7;
                        }
                        results.add(constructor.newInstance(new Object[0]));
                    }
                    catch (ReflectiveOperationException e) {
                        if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                            ValueAnnotatedTypeFactory.this.checker.report(Result.warning("constructor.invocation.failed", new Object[0]), tree);
                        }
                        results = new ArrayList<Object>();
                    }
                } else {
                    List<?> argValues = argArrayDeque.pop();
                    for (Object o : argValues) {
                        values.push(o);
                        this.evaluateNewClassHelper(argArrayDeque, values, constructor, results, tree);
                        values.pop();
                    }
                }
            }
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            super.visitMemberSelect(tree, type);
            AnnotatedTypeMirror receiverType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            Element elem = TreeUtils.elementFromUse(tree);
            if (AnnotationUtils.areSameIgnoringValues(this.getValueAnnotation(receiverType), ValueAnnotatedTypeFactory.this.ARRAYLEN) && tree.getIdentifier().contentEquals("length")) {
                type.replaceAnnotation(this.handleArrayLength(receiverType));
            }
            if (this.isClassCovered(elem.asType())) {
                if (ElementUtils.isCompileTimeConstant(elem)) {
                    ArrayList<Object> value = new ArrayList<Object>(1);
                    value.add(((VariableElement)elem).getConstantValue());
                    AnnotationMirror newAnno = this.resultAnnotationHandler(elem.asType(), value, (Tree)tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                    } else {
                        type.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
                    }
                } else if (elem.getKind() == ElementKind.FIELD && ElementUtils.isStatic(elem) && ElementUtils.isFinal(elem) && !tree.getIdentifier().toString().equals("class")) {
                    TypeMirror retType = elem.asType();
                    AnnotationMirror newAnno = this.evaluateStaticFieldAccess(tree.getIdentifier(), retType, tree);
                    if (newAnno != null) {
                        type.replaceAnnotation(newAnno);
                    }
                }
            }
            return null;
        }

        private AnnotationMirror handleArrayLength(AnnotatedTypeMirror receiverType) {
            AnnotationMirror recAnno = this.getValueAnnotation(receiverType);
            if (AnnotationUtils.areSameIgnoringValues(recAnno, ValueAnnotatedTypeFactory.this.ARRAYLEN)) {
                List<Integer> lengthInts = AnnotationUtils.getElementValueArray(recAnno, "value", Integer.class, true);
                HashSet<Long> lengthValues = new HashSet<Long>();
                for (int i : lengthInts) {
                    lengthValues.add(Long.valueOf(i));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", lengthValues);
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }

        private AnnotationMirror evaluateStaticFieldAccess(Name fieldName, TypeMirror retType, MemberSelectTree tree) {
            String clzzname = "";
            try {
                Element e = InternalUtils.symbol(tree.getExpression());
                if (e == null) {
                    return null;
                }
                clzzname = ElementUtils.getQualifiedClassName(e).toString();
                Class<?> recClass = Class.forName(clzzname);
                Field field = recClass.getField(fieldName.toString());
                ArrayList<Object> result = new ArrayList<Object>(1);
                result.add(field.get(recClass));
                return this.resultAnnotationHandler(retType, result, (Tree)tree);
            }
            catch (ClassNotFoundException | UnsupportedClassVersionError e) {
                if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                    ValueAnnotatedTypeFactory.this.checker.report(Result.warning("class.find.failed", clzzname), tree);
                }
                return null;
            }
            catch (ReflectiveOperationException e) {
                if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                    ValueAnnotatedTypeFactory.this.checker.report(Result.warning("field.access.failed", fieldName, clzzname), tree);
                }
                return null;
            }
        }

        private boolean isClassCovered(AnnotatedTypeMirror type) {
            return this.isClassCovered(type.getUnderlyingType());
        }

        private boolean isClassCovered(TypeMirror type) {
            return ValueAnnotatedTypeFactory.this.coveredClassStrings.contains(type.toString());
        }

        private Class<?> getClass(String stringType, Tree tree) {
            switch (stringType) {
                case "<nulltype>": {
                    return Object.class;
                }
            }
            try {
                return Class.forName(stringType);
            }
            catch (ClassNotFoundException | UnsupportedClassVersionError e) {
                if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                    ValueAnnotatedTypeFactory.this.checker.report(Result.failure("class.find.failed", stringType), tree);
                }
                return Object.class;
            }
        }

        private Class<?> getClass(AnnotatedTypeMirror typeMirror, Tree tree) {
            TypeMirror type = typeMirror.getUnderlyingType();
            return this.getClass(type, tree);
        }

        private Class<?> getClass(TypeMirror type, Tree tree) {
            switch (type.getKind()) {
                case INT: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHAR: {
                    return Character.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case ARRAY: {
                    return this.getArrayType(((ArrayType)type).getComponentType());
                }
                case DECLARED: {
                    String stringType = TypesUtils.getQualifiedName((DeclaredType)type).toString();
                    return this.getClass(stringType, tree);
                }
            }
            return Object.class;
        }

        private Class<?> getArrayType(TypeMirror componentType) {
            switch (componentType.getKind()) {
                case INT: {
                    return int[].class;
                }
                case LONG: {
                    return long[].class;
                }
                case SHORT: {
                    return short[].class;
                }
                case BYTE: {
                    return byte[].class;
                }
                case CHAR: {
                    return char[].class;
                }
                case DOUBLE: {
                    return double[].class;
                }
                case FLOAT: {
                    return float[].class;
                }
                case BOOLEAN: {
                    return boolean[].class;
                }
            }
            return Object[].class;
        }

        private Class<?> getAnnotationValueClass(AnnotationMirror anno) {
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.INTVAL)) {
                return Long.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.DOUBLEVAL)) {
                return Double.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.BOOLVAL)) {
                return Boolean.class;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno, ValueAnnotatedTypeFactory.this.STRINGVAL)) {
                return String.class;
            }
            return null;
        }

        private Class<?>[] getParameterTypes(NewClassTree tree) {
            ExecutableElement e = TreeUtils.elementFromUse(tree);
            Class[] classes = new Class[e.getParameters().size()];
            int i = 0;
            for (Element element : e.getParameters()) {
                classes[i] = this.getClass(ElementUtils.getType(element), (Tree)tree);
                ++i;
            }
            return classes;
        }

        private List<?> getCastedValues(AnnotatedTypeMirror typeMirror, Tree tree) {
            return this.getCastedValues(typeMirror, this.getClass(typeMirror, tree), tree);
        }

        private List<?> getCastedValues(AnnotatedTypeMirror typeMirror, Class<?> castType, Tree tree) {
            AnnotationMirror anno = this.getValueAnnotation(typeMirror);
            return this.getCastedValues(anno, castType, tree);
        }

        private List<?> getCastedValues(AnnotationMirror anno, Class<?> castType, Tree tree) {
            List<?> values = null;
            if (AnnotationUtils.areSameByClass(anno, DoubleVal.class)) {
                values = this.convertDoubleVal(anno, castType);
            } else if (AnnotationUtils.areSameByClass(anno, IntVal.class)) {
                values = this.convertIntVal(anno, castType);
            } else if (AnnotationUtils.areSameByClass(anno, StringVal.class)) {
                values = this.convertStringVal(anno, castType);
            } else if (AnnotationUtils.areSameByClass(anno, BoolVal.class)) {
                values = this.convertBoolVal(anno, castType);
            }
            if (values == null) {
                if (ValueAnnotatedTypeFactory.this.reportWarnings) {
                    ValueAnnotatedTypeFactory.this.checker.report(Result.warning("class.convert.failed", anno, castType), tree);
                }
                values = Collections.EMPTY_LIST;
            }
            return values;
        }

        private List<?> convertToStringVal(List<?> origValues) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Object value : origValues) {
                strings.add(value.toString());
            }
            return strings;
        }

        private List<?> convertBoolVal(AnnotationMirror anno, Class<?> newClass) {
            List<Boolean> bools = AnnotationUtils.getElementValueArray(anno, "value", Boolean.class, true);
            if (newClass == Boolean.class || newClass == Boolean.TYPE) {
                return bools;
            }
            if (newClass == String.class) {
                return this.convertToStringVal(bools);
            }
            return null;
        }

        private List<?> convertStringVal(AnnotationMirror anno, Class<?> newClass) {
            List<String> strings = AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
            if (newClass == String.class) {
                return strings;
            }
            if (newClass == byte[].class) {
                ArrayList<byte[]> bytes = new ArrayList<byte[]>();
                for (String s2 : strings) {
                    bytes.add(s2.getBytes());
                }
                return bytes;
            }
            if (newClass == Object.class && strings.size() == 1 && strings.get(0).equals("null")) {
                return strings;
            }
            return null;
        }

        private List<?> convertIntVal(AnnotationMirror anno, Class<?> newClass) {
            List<Long> longs = AnnotationUtils.getElementValueArray(anno, "value", Long.class, true);
            if (newClass == Long.class || newClass == Long.TYPE) {
                return longs;
            }
            if (newClass == Integer.class || newClass == Integer.TYPE) {
                ArrayList<Integer> ints = new ArrayList<Integer>();
                for (Long l : longs) {
                    ints.add(l.intValue());
                }
                return ints;
            }
            if (newClass == Short.class || newClass == Short.TYPE) {
                ArrayList<Short> shorts = new ArrayList<Short>();
                for (Long l : longs) {
                    shorts.add(l.shortValue());
                }
                return shorts;
            }
            if (newClass == Byte.class || newClass == Byte.TYPE) {
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                for (Long l : longs) {
                    bytes.add(l.byteValue());
                }
                return bytes;
            }
            if (newClass == Character.class || newClass == Character.TYPE) {
                ArrayList<Character> chars = new ArrayList<Character>();
                for (Long l : longs) {
                    chars.add(Character.valueOf((char)l.intValue()));
                }
                return chars;
            }
            if (newClass == Double.class || newClass == Double.TYPE) {
                ArrayList<Double> doubles = new ArrayList<Double>();
                for (Long l : longs) {
                    doubles.add(Double.valueOf(l.intValue()));
                }
                return doubles;
            }
            if (newClass == Float.class || newClass == Float.TYPE) {
                ArrayList<Float> floats = new ArrayList<Float>();
                for (Long l : longs) {
                    floats.add(Float.valueOf(l.intValue()));
                }
                return floats;
            }
            if (newClass == String.class) {
                return this.convertToStringVal(longs);
            }
            return null;
        }

        private List<?> convertDoubleVal(AnnotationMirror anno, Class<?> newClass) {
            List<Double> doubles = AnnotationUtils.getElementValueArray(anno, "value", Double.class, true);
            if (newClass == Double.class || newClass == Double.TYPE) {
                return doubles;
            }
            if (newClass == Float.class || newClass == Float.TYPE) {
                ArrayList<Float> floats = new ArrayList<Float>();
                for (Double d : doubles) {
                    floats.add(Float.valueOf(d.floatValue()));
                }
                return floats;
            }
            if (newClass == String.class) {
                return this.convertToStringVal(doubles);
            }
            return null;
        }

        private ArrayDeque<List<?>> getAllArgumentAnnotationValues(List<AnnotatedTypeMirror> argTypes, Tree tree) {
            ArrayDeque allArgValues = new ArrayDeque();
            for (AnnotatedTypeMirror a : argTypes) {
                allArgValues.push(this.getCastedValues(a, tree));
            }
            return allArgValues;
        }

        private AnnotationMirror resultAnnotationHandler(AnnotatedTypeMirror resultType, List<Object> results, Tree tree) {
            return this.resultAnnotationHandler(this.getClass(resultType, tree), results);
        }

        private AnnotationMirror resultAnnotationHandler(TypeMirror resultType, List<Object> results, Tree tree) {
            return this.resultAnnotationHandler(this.getClass(resultType, tree), results);
        }

        private AnnotationMirror resultAnnotationHandler(Class<?> resultClass, List<Object> results) {
            results.remove(null);
            if (results.size() == 0) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (resultClass == Boolean.class || resultClass == Boolean.TYPE) {
                HashSet<Boolean> boolVals = new HashSet<Boolean>(results.size());
                for (Object o : results) {
                    boolVals.add((Boolean)o);
                }
                AnnotationMirror newAnno = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.BoolVal", boolVals);
                return newAnno;
            }
            if (resultClass == Double.class || resultClass == Double.TYPE) {
                HashSet<Double> doubleVals = new HashSet<Double>(results.size());
                for (Object o : results) {
                    doubleVals.add((Double)o);
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", doubleVals);
            }
            if (resultClass == Float.class || resultClass == Float.TYPE) {
                HashSet<Double> floatVals = new HashSet<Double>(results.size());
                for (Object o : results) {
                    floatVals.add(new Double(((Float)o).floatValue()));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.DoubleVal", floatVals);
            }
            if (resultClass == Integer.class || resultClass == Integer.TYPE || resultClass == Long.class || resultClass == Long.TYPE || resultClass == Short.class || resultClass == Short.TYPE || resultClass == Byte.class || resultClass == Byte.TYPE) {
                HashSet<Long> intVals = new HashSet<Long>(results.size());
                for (Object o : results) {
                    intVals.add(((Number)o).longValue());
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", intVals);
            }
            if (resultClass == Character.TYPE || resultClass == Character.class) {
                HashSet<Long> intVals = new HashSet<Long>(results.size());
                for (Object o : results) {
                    intVals.add(new Long(((Character)o).charValue()));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.IntVal", intVals);
            }
            if (resultClass == String.class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    stringVals.add((String)o);
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringVals);
            }
            if (resultClass == byte[].class) {
                HashSet<String> stringVals = new HashSet<String>(results.size());
                for (Object o : results) {
                    stringVals.add(new String((byte[])o));
                }
                return ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", stringVals);
            }
            return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
        }

        private void handleCast(ExpressionTree tree, Class<?> castType, AnnotatedTypeMirror alteredType) {
            AnnotatedTypeMirror treeType = ValueAnnotatedTypeFactory.this.getAnnotatedType(tree);
            if (!this.nonValueAnno(treeType)) {
                AnnotationMirror treeAnno = this.getValueAnnotation(treeType);
                String anno = "org.checkerframework.common.value.qual.";
                if (castType.equals(String.class)) {
                    HashSet<String> newValues = new HashSet<String>();
                    List<Object> valuesToCast = AnnotationUtils.getElementValueArray(treeAnno, "value", Object.class, true);
                    for (Object o : valuesToCast) {
                        newValues.add(o.toString());
                    }
                    anno = anno + "StringVal";
                    alteredType.replaceAnnotation(ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues));
                } else if (ValueAnnotatedTypeFactory.this.isNumberAnnotation(treeAnno)) {
                    List<Number> valuesToCast = AnnotationUtils.getElementValueArray(treeAnno, "value", Number.class, true);
                    HashSet<Number> newValues = new HashSet<Number>();
                    if (castType.equals(Double.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Double(n.doubleValue()));
                        }
                        anno = anno + "DoubleVal";
                    } else if (castType.equals(Integer.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Long(n.intValue()));
                        }
                        anno = anno + "IntVal";
                    } else if (castType.equals(Long.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Long(n.longValue()));
                        }
                        anno = anno + "IntVal";
                    } else if (castType.equals(Float.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Double(n.floatValue()));
                        }
                        anno = anno + "DoubleVal";
                    } else if (castType.equals(Short.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Long(n.shortValue()));
                        }
                        anno = anno + "IntVal";
                    } else if (castType.equals(Byte.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Long(n.byteValue()));
                        }
                        anno = anno + "IntVal";
                    } else if (castType.equals(Character.TYPE)) {
                        for (Number n : valuesToCast) {
                            newValues.add(new Long(n.intValue()));
                        }
                        anno = anno + "IntVal";
                    }
                    alteredType.replaceAnnotation(ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues));
                } else {
                    alteredType.replaceAnnotation(treeAnno);
                }
            }
        }

        private AnnotationMirror getValueAnnotation(AnnotatedTypeMirror atm) {
            AnnotationMirror anno = atm.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno == null) {
                anno = atm.getEffectiveAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
            return anno;
        }

        private boolean nonValueAnno(AnnotatedTypeMirror mirror) {
            AnnotationMirror valueAnno = this.getValueAnnotation(mirror);
            return AnnotationUtils.areSameIgnoringValues(valueAnno, ValueAnnotatedTypeFactory.this.UNKNOWNVAL) || AnnotationUtils.areSameByClass(valueAnno, BottomVal.class) || AnnotationUtils.areSameIgnoringValues(mirror.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.ARRAYLEN), ValueAnnotatedTypeFactory.this.ARRAYLEN);
        }
    }

    private final class ValueQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public ValueQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            AnnotationMirror lower;
            AnnotationMirror higher;
            if (!AnnotationUtils.areSameIgnoringValues(this.getTopAnnotation(a1), this.getTopAnnotation(a2))) {
                return null;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                List<Object> a1Values = AnnotationUtils.getElementValueArray(a1, "value", Object.class, true);
                List<Object> a2Values = AnnotationUtils.getElementValueArray(a2, "value", Object.class, true);
                HashSet<Object> newValues = new HashSet<Object>(a1Values.size() + a2Values.size());
                newValues.addAll(a1Values);
                newValues.addAll(a2Values);
                return ValueAnnotatedTypeFactory.this.createAnnotation(a1.getAnnotationType().toString(), newValues);
            }
            if (!ValueAnnotatedTypeFactory.this.isNumberAnnotation(a1) || !ValueAnnotatedTypeFactory.this.isNumberAnnotation(a2)) {
                return ValueAnnotatedTypeFactory.this.UNKNOWNVAL;
            }
            if (AnnotationUtils.areSameIgnoringValues(a2, ValueAnnotatedTypeFactory.this.DOUBLEVAL)) {
                higher = a2;
                lower = a1;
            } else {
                higher = a1;
                lower = a2;
            }
            String anno = "org.checkerframework.common.value.qual.";
            List<Number> valuesToCast = AnnotationUtils.getElementValueArray(lower, "value", Number.class, true);
            HashSet<Object> newValues = new HashSet<Object>(AnnotationUtils.getElementValueArray(higher, "value", Object.class, true));
            for (Number n : valuesToCast) {
                newValues.add(new Double(n.doubleValue()));
            }
            anno = anno + "DoubleVal";
            return ValueAnnotatedTypeFactory.this.createAnnotation(anno, newValues);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (System.currentTimeMillis() > ValueAnnotatedTypeFactory.this.t + 1000L) {
                ValueAnnotatedTypeFactory.this.t = System.currentTimeMillis();
            }
            if (AnnotationUtils.areSame(rhs, lhs)) {
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                List<Object> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Object.class, true);
                List<Object> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Object.class, true);
                return lhsValues.containsAll(rhsValues);
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, ValueAnnotatedTypeFactory.this.DOUBLEVAL) && AnnotationUtils.areSameIgnoringValues(rhs, ValueAnnotatedTypeFactory.this.INTVAL)) {
                List<Long> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Long.class, true);
                List<Double> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Double.class, true);
                boolean same = false;
                for (Long rhsLong : rhsValues) {
                    for (Double lhsDbl : lhsValues) {
                        if (lhsDbl.doubleValue() != rhsLong.doubleValue()) continue;
                        same = true;
                        break;
                    }
                    if (same) continue;
                    return false;
                }
                return same;
            }
            for (AnnotationMirror anno : ValueAnnotatedTypeFactory.this.constantAnnotations) {
                if (AnnotationUtils.areSameIgnoringValues(lhs, anno)) {
                    lhs = anno;
                }
                if (!AnnotationUtils.areSameIgnoringValues(rhs, anno)) continue;
                rhs = anno;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class ValueTypeAnnotator
    extends TypeAnnotator {
        public ValueTypeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void p) {
            this.replaceWithUnknownValIfTooManyValues(type);
            return (Void)super.visitPrimitive(type, p);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
            this.replaceWithUnknownValIfTooManyValues(type);
            return (Void)super.visitDeclared(type, p);
        }

        @Override
        public Void visitNull(AnnotatedTypeMirror.AnnotatedNullType type, Void p) {
            HashSet<String> values = new HashSet<String>();
            values.add("null");
            AnnotationMirror newQual = ValueAnnotatedTypeFactory.this.createAnnotation("org.checkerframework.common.value.qual.StringVal", values);
            type.replaceAnnotation(newQual);
            return (Void)super.visitNull(type, p);
        }

        private void replaceWithUnknownValIfTooManyValues(AnnotatedTypeMirror atm) {
            List<Object> values;
            AnnotationMirror anno = atm.getAnnotationInHierarchy(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            if (anno != null && anno.getElementValues().size() > 0 && (values = AnnotationUtils.getElementValueArray(anno, "value", Object.class, false)) != null && values.size() > 10) {
                atm.replaceAnnotation(ValueAnnotatedTypeFactory.this.UNKNOWNVAL);
            }
        }
    }
}

