/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.IllegalFormatException;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.formatter.FormatUtil;
import org.checkerframework.checker.formatter.FormatterAnalysis;
import org.checkerframework.checker.formatter.FormatterTransfer;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.Format;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.InvalidFormat;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.ListTreeAnnotator;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class FormatterAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, CFStore, FormatterTransfer, FormatterAnalysis> {
    private final AnnotationMirror FORMAT;
    private final AnnotationMirror INVALIDFORMAT;
    private final AnnotationMirror FORMATBOTTOM;
    protected final FormatterTreeUtil treeUtil;

    public FormatterAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.FORMAT = AnnotationUtils.fromClass(this.elements, Format.class);
        this.INVALIDFORMAT = AnnotationUtils.fromClass(this.elements, InvalidFormat.class);
        this.FORMATBOTTOM = AnnotationUtils.fromClass(this.elements, FormatBottom.class);
        this.treeUtil = new FormatterTreeUtil(checker);
        this.postInit();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new FormatterQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new FormatterTreeAnnotator(this));
    }

    class FormatterQualifierHierarchy
    extends GraphQualifierHierarchy {
        public FormatterQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, FormatterAnnotatedTypeFactory.this.FORMATBOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.FORMAT) && AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                ConversionCategory[] lhsArgTypes;
                ConversionCategory[] rhsArgTypes = FormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(rhs);
                if (rhsArgTypes.length != (lhsArgTypes = FormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(lhs)).length) {
                    return false;
                }
                for (int i = 0; i < rhsArgTypes.length; ++i) {
                    if (ConversionCategory.isSubsetOf(lhsArgTypes[i], rhsArgTypes[i])) continue;
                    return false;
                }
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                lhs = FormatterAnnotatedTypeFactory.this.FORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                rhs = FormatterAnnotatedTypeFactory.this.FORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.INVALIDFORMAT)) {
                lhs = FormatterAnnotatedTypeFactory.this.INVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.INVALIDFORMAT)) {
                rhs = FormatterAnnotatedTypeFactory.this.INVALIDFORMAT;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class FormatterTreeAnnotator
    extends TreeAnnotator {
        public FormatterTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(FormatterAnnotatedTypeFactory.this.FORMAT)) {
                String format = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    format = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    format = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (format != null) {
                    AnnotationMirror anno;
                    try {
                        ConversionCategory[] cs = FormatUtil.formatParameterCategories(format);
                        anno = FormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(cs);
                    }
                    catch (IllegalFormatException e) {
                        anno = FormatterAnnotatedTypeFactory.this.treeUtil.exceptionToInvalidFormatAnnotation(e);
                    }
                    type.addAnnotation(anno);
                }
            }
            return (Void)super.visitLiteral(tree, type);
        }
    }
}

