/*
 * Decompiled with CFR 0.152.
 */
package ceylon.decimal;

import ceylon.whole.Whole;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import java.math.BigInteger;

@Ceylon(major=8, minor=1)
@Method
final class toBigInteger_ {
    private toBigInteger_() {
    }

    @TypeInfo(value="java.math::BigInteger")
    @NonNull
    static BigInteger toBigInteger(@Name(value="whole") @TypeInfo(value="ceylon.whole::Whole") @NonNull Whole whole) {
        if (whole.getZero()) {
            return (BigInteger)Util.checkNull((Object)BigInteger.ZERO);
        }
        if (whole.getUnit()) {
            return (BigInteger)Util.checkNull((Object)BigInteger.ONE);
        }
        Whole wholeMagnitude = (Whole)whole.getMagnitude();
        BigInteger result = BigInteger.ZERO;
        long shift = 0L;
        while (!wholeMagnitude.getZero()) {
            BigInteger x = ((BigInteger)Util.checkNull((Object)BigInteger.valueOf(wholeMagnitude.getInteger() & 0xFFFFFFFFL))).shiftLeft((int)shift);
            result = ((BigInteger)Util.checkNull((Object)result)).or(x);
            wholeMagnitude = wholeMagnitude.rightArithmeticShift(32L);
            shift += 32L;
        }
        if (whole.getNegative()) {
            result = ((BigInteger)Util.checkNull((Object)result)).negate();
        }
        return (BigInteger)Util.checkNull((Object)result);
    }
}

