/*
 * Decompiled with CFR 0.152.
 */
package caseine.project;

import caseine.Caseine;
import caseine.FileUtils;
import caseine.PythonLauncher;
import caseine.exceptions.PythonFileMissingException;
import caseine.exceptions.TestDirectoryMissingException;
import caseine.exceptions.UnitTestsFileMissingException;
import caseine.project.BadIDEException;
import caseine.project.CaseineCommonProject;
import caseine.project.CaseineProject;
import caseine.project.CaseineProjectAlreadyExistingException;
import caseine.project.FileMissingException;
import caseine.project.MavenProjectException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;

public class CaseinePythonProject
extends CaseineCommonProject
implements CaseineProject {
    public CaseinePythonProject(String projectPath, String vplId, String url, String token, boolean settings) {
        super(projectPath, vplId, url, token, settings);
    }

    @Override
    public CaseineProject.ProjectType getType() {
        return CaseineProject.ProjectType.PYTHON;
    }

    @Override
    public void generate(boolean mvn, int template) throws CaseineProjectAlreadyExistingException, BadIDEException, IOException, TestDirectoryMissingException, FileMissingException, UnitTestsFileMissingException {
        boolean rootWasEmptyFirst;
        if (this.isCaseine()) {
            throw new CaseineProjectAlreadyExistingException("A project already exists in " + this.projectPath);
        }
        File root = new File(this.projectPath);
        if (!root.exists()) {
            root.mkdir();
        }
        FileUtils.copyAZipAndUnZipIt((InputStream)Caseine.class.getResourceAsStream("/python/default/t1.zip"), (File)root, (String)".");
        boolean bl = rootWasEmptyFirst = !Arrays.stream(root.listFiles()).filter(f -> !f.isHidden()).filter(f -> !"vpl_unittest.py".equals(f.getName())).findFirst().isPresent();
        if (rootWasEmptyFirst) {
            this.writeATemplate(root);
        } else {
            try {
                this.checkRoot(root);
            }
            catch (PythonFileMissingException e) {
                throw new FileMissingException(e);
            }
        }
        this.fillCaseine(this.vplId);
        this.fillCaseineProjectFile();
    }

    private void writeATemplate(File root) throws TestDirectoryMissingException {
        File test = new File(root, "test");
        test.mkdirs();
        if (test == null || !test.exists() || !test.isDirectory()) {
            throw new TestDirectoryMissingException("It should have a test directory");
        }
        FileUtils.copyAZipAndUnZipIt((InputStream)PythonLauncher.class.getResourceAsStream("/python-templates/t1.zip"), (File)root, (String)".");
        System.out.println("A python project template was generated because the directory was empty");
        System.out.println("You can use it like this");
        System.out.println("You can change existing and/or add new files");
    }

    private void checkRoot(File root) throws PythonFileMissingException, UnitTestsFileMissingException, TestDirectoryMissingException {
        if (!Arrays.stream(root.listFiles()).filter(f -> f.getName().endsWith(".py")).filter(f -> !f.isHidden()).filter(f -> !"vpl_unittest.py".equals(f.getName())).findAny().isPresent()) {
            throw new PythonFileMissingException("It should have at least one python file in this directory");
        }
        File test = new File(root, "test");
        if (test == null || !test.exists() || !test.isDirectory()) {
            throw new TestDirectoryMissingException("It should have a test directory");
        }
        if (!Arrays.stream(test.listFiles()).filter(f -> f.getName().endsWith(".py")).findAny().isPresent()) {
            throw new UnitTestsFileMissingException("It should have at least one unit test file in test directory");
        }
    }

    @Override
    public void local(ClassLoader cl) throws IOException, ClassNotFoundException, MavenProjectException {
        if (this.vplId.equals("0")) {
            this.vplId = this.getVplId();
        } else {
            this.fillCaseine(this.vplId);
        }
        this.clean();
        try {
            PythonLauncher.launch((String)Paths.get(this.projectPath, new String[0]).toAbsolutePath().toString());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

