/*
 * Decompiled with CFR 0.152.
 */
package caseine.project;

import caseine.Caseine;
import caseine.CleanFolder;
import caseine.FileUtils;
import caseine.exceptions.TestDirectoryMissingException;
import caseine.exceptions.UnitTestsFileMissingException;
import caseine.project.BadIDEException;
import caseine.project.CaseineCommonProject;
import caseine.project.CaseineProjectAlreadyExistingException;
import caseine.project.FileMissingException;
import caseine.project.MavenProjectException;
import caseine.publication.Publisher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CaseineJavaProject
extends CaseineCommonProject {
    private String ide;
    private static final String dotCaseineHeaderComment = "#For settings, see https://moodle.caseine.org/mod/wiki/view.php?pageid=199\n#Writable settings are:\n# - WS.name\n# - WS.shortdescription\n# - WS.intro\n# - WS.introformat\n# - WS.startdate\n# - WS.duedate\n# - WS.maxfiles\n# - WS.maxfilesize\n# - WS.requirednet\n# - WS.password\n# - WS.grade\n# - WS.visiblegrade\n# - WS.usevariations\n# - WS.variationtitle\n# - WS.usableasbase\n# - WS.basedon\n# - WS.run\n# - WS.debug\n# - WS.evaluate\n# - WS.evaluateonsubmission\n# - WS.automaticgrading\n# - WS.usegradefrom\n# - WS.maxexetime\n# - WS.restrictededitor\n# - WS.allowsubmissionviaeditor\n# - WS.forbiddeneditors\n# - WS.example\n# - WS.maxexememory\n# - WS.maxexefilesize\n# - WS.maxexeprocesses\n# - WS.jailservers\n# - WS.worktype\n# - WS.emailteachers\n# - WS.timemodified\n# - WS.freeevaluations\n# - WS.reductionbyevaluation\n# - WS.sebrequired\n# - WS.sebkeys\n# - WS.runscript\n# - WS.debugscript";

    public CaseineJavaProject(String projectPath, String vplId, String ide, String url, String token, boolean settings) {
        super(projectPath, vplId, url, token, settings);
        this.ide = ide;
        this.settings = settings;
    }

    @Override
    public void generate(boolean mvn, int template) throws CaseineProjectAlreadyExistingException, BadIDEException, IOException, TestDirectoryMissingException, FileMissingException, UnitTestsFileMissingException {
        if (this.isCaseine()) {
            throw new CaseineProjectAlreadyExistingException("A project already exists in " + this.projectPath);
        }
        File root = new File(this.projectPath);
        if (!root.exists()) {
            root.mkdir();
        }
        if (template == 1) {
            FileUtils.copyAZipAndUnZipIt((InputStream)Caseine.class.getResourceAsStream("/java/default/project1.zip"), (File)root, (String)".");
        } else if (template == 2) {
            FileUtils.copyAZipAndUnZipIt((InputStream)Caseine.class.getResourceAsStream("/java/default/project2.zip"), (File)root, (String)".");
        } else {
            FileUtils.copyAZipAndUnZipIt((InputStream)Caseine.class.getResourceAsStream("/java/default/project.zip"), (File)root, (String)".");
        }
        if (this.ide != null) {
            try {
                FileUtils.copyAZipAndUnZipIt((InputStream)Caseine.class.getResourceAsStream("/java/" + this.ide + "/project.zip"), (File)root, (String)".");
            }
            catch (Exception e) {
                CleanFolder.clean(root.toPath());
                throw new BadIDEException("ide not supported: " + this.ide);
            }
        }
        this.fillCaseine(this.vplId);
        this.fillCaseineProjectFile();
        if (mvn) {
            String pom = this.projectPath + File.separatorChar + "pom.xml";
            FileUtils.writeAResource((InputStream)Caseine.class.getResourceAsStream("/java/mvn/pom.xml"), (File)new File(pom));
            FileUtils.fillTemplate((String)pom, (String)"${vpl.name}", (String)this.getProjectName());
            String vplId = this.getVplId();
            if (vplId != null && !"<env>".equals(vplId)) {
                FileUtils.fillTemplate((String)pom, (String)"${vpl.id}", (String)vplId);
            }
            if (!this.caseineFile.delete()) {
                log.severe(".caseine file not deleted");
            }
        } else {
            FileUtils.writeAResource((InputStream)Caseine.class.getResourceAsStream("/caseine.vpl.tools.plugin.jar"), (File)new File(this.projectPath + File.separatorChar + "resources" + File.separatorChar + "lib" + File.separatorChar + "caseine.vpl.tools.plugin.jar"));
        }
    }

    @Override
    public void local(ClassLoader cl) throws IOException, ClassNotFoundException, MavenProjectException {
        File casesFile;
        if (this.vplId.equals("0")) {
            this.vplId = this.getVplId();
        } else {
            this.fillCaseine(this.vplId);
        }
        this.clean();
        List jarFiles = vplwsclient.FileUtils.listFiles((String)(this.projectPath + PATH_RESOURCES_LIB));
        URL[] urls = new URL[jarFiles.size() + 1];
        for (int i = 0; i < jarFiles.size(); ++i) {
            urls[i] = ((File)jarFiles.get(i)).toURI().toURL();
        }
        urls[jarFiles.size()] = new File(this.projectPath + CaseineJavaProject.getPATH_BIN() + "classes").toURI().toURL();
        ClassLoader localCL = cl == null ? Caseine.class.getClassLoader() : cl;
        URLClassLoader ucl = new URLClassLoader(urls, localCL);
        Publisher pbsher = new Publisher(new File(this.projectPath + PATH_SRC).toPath(), new File(this.projectPath + PATH_CLASSES).toPath(), new File(this.projectPath + PATH_TEST).toPath(), new File(this.projectPath + PATH_RESOURCES_SRC).toPath(), new File(this.projectPath + PATH_RESOURCES_TEST).toPath(), new File(this.projectPath + CaseineJavaProject.getPATH_OUTPUT()).toPath(), (ClassLoader)ucl);
        try {
            pbsher.publishAll();
            CaseineJavaProject.fillDocCaseineFile(pbsher, this.projectPath);
        }
        catch (ClassNotFoundException cnfe) {
            this.clean();
            throw cnfe;
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("IN " + this.projectPath + "<-->");
        }
        File libEFDirectory = new File(this.projectPath + CaseineJavaProject.getPATH_EXECUTION_FILES() + "lib");
        if (!libEFDirectory.exists()) {
            // empty if block
        }
        libEFDirectory.mkdir();
        InputStream pluginStream = Caseine.class.getResourceAsStream("/caseine.vpl.tools.plugin.jar");
        if (pluginStream != null) {
            FileUtils.writeAResource((InputStream)pluginStream, (File)Paths.get(libEFDirectory.getAbsolutePath(), "caseine.vpl.tools.plugin.jar").toFile());
        } else {
            Files.copy(new FileInputStream(new File(this.projectPath + CaseineJavaProject.getPATH_BIN() + "lib" + File.separatorChar + "caseine.vpl.tools.plugin.jar")), Paths.get(libEFDirectory.getAbsolutePath(), "caseine.vpl.tools.plugin.jar"), new CopyOption[0]);
        }
        File libRFDirectory = new File(this.projectPath + CaseineJavaProject.getPATH_REQUESTED_FILES() + "lib");
        libRFDirectory.mkdir();
        File libResourceDirectory = new File(this.projectPath + PATH_RESOURCES_LIB);
        if (libResourceDirectory.exists()) {
            for (int i = 0; i < jarFiles.size(); ++i) {
                if (((File)jarFiles.get(i)).getName().equals("caseine.vpl.tools.plugin.jar")) {
                    Files.copy(new FileInputStream((File)jarFiles.get(i)), Paths.get(libEFDirectory.getAbsolutePath(), ((File)jarFiles.get(i)).getName()), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Files.copy(new FileInputStream((File)jarFiles.get(i)), Paths.get(libRFDirectory.getAbsolutePath(), ((File)jarFiles.get(i)).getName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        if (!(casesFile = new File(this.projectPath + CaseineJavaProject.getPATH_EXECUTION_FILES() + "vpl_evaluate.cases")).createNewFile()) {
            log.severe("vpl_evaluate.cases cannot be created");
        }
        Iterator iter = pbsher.iterator();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(casesFile));){
            writer.write("JunitFiles = ");
            while (iter.hasNext()) {
                String classes = (String)iter.next();
                System.out.println(classes);
                writer.write(classes + ", ");
            }
            writer.close();
        }
        for (Object p : pbsher.getPathToRemove()) {
            Path toRemove = new File(this.projectPath + CaseineJavaProject.getPATH_REQUESTED_FILES(), p.toString()).toPath();
            Files.deleteIfExists(toRemove);
        }
        String requestedTestPath = this.projectPath + CaseineJavaProject.getPATH_REQUESTED_FILES() + File.separator + "test";
        for (Path p : pbsher.getPathToTest()) {
            Path toTest = new File(this.projectPath + CaseineJavaProject.getPATH_REQUESTED_FILES(), p.toString()).toPath();
            Path toTest2 = new File(requestedTestPath, p.toString()).toPath();
            if (!toTest2.getParent().toFile().exists()) {
                toTest2.getParent().toFile().mkdirs();
            }
            Files.move(toTest, toTest2, new CopyOption[0]);
        }
        String correctedTestPath = this.projectPath + CaseineJavaProject.getPATH_CORRECTED_FILES() + File.separator + "test";
        for (Path p : pbsher.getPathToTest()) {
            Path toTest = new File(this.projectPath + CaseineJavaProject.getPATH_CORRECTED_FILES(), p.toString()).toPath();
            Path toTest2 = new File(correctedTestPath, p.toString()).toPath();
            if (!toTest2.getParent().toFile().exists()) {
                toTest2.getParent().toFile().mkdirs();
            }
            Files.move(toTest, toTest2, new CopyOption[0]);
        }
    }

    public static void fillDocCaseineFile(Publisher pbsher, String projectPath) throws IOException, ClassNotFoundException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(new File(projectPath, ".caseine"));){
            properties.load(inputStream);
            properties.put("WS.grade", "%s".formatted(pbsher.getGrade()));
            properties.put("WS.run", "1");
            properties.put("WS.evaluate", "1");
            properties.put("WS.basedon", pbsher.isGraphical() ? "19024" : "864");
            properties.put("WS.automaticgrading", "1");
            properties.put("WS.maxexetime", pbsher.isGraphical() ? "300" : "32");
            properties.put("WS.maxfiles", "%s".formatted(pbsher.getMaxfiles() + 1));
        }
        catch (Exception ex) {
            System.err.println("Unable to read .caseine");
        }
        try (FileOutputStream outputStream = new FileOutputStream(new File(projectPath, ".caseine"));){
            properties.store(outputStream, dotCaseineHeaderComment);
        }
        catch (Exception ex) {
            System.err.println("Unable to write .caseine");
        }
    }
}

